program Bin2Inc;

uses Windows;

{$APPType CONSOLE}
{$I-}

  function DecToHex(aValue: LongInt): String;
  var
    w: Array[1..2] of Word absolute aValue;
    St: String;

    function HexByte(b: Byte): String;
    const
      Hex: Array[$0..$F] of Char = '0123456789ABCDEF';
    begin
      HexByte := Hex[b shr 4] + Hex[b and $F];
    end;

    function HexWord(w: Word): String;
    begin
      HexWord := HexByte(Hi(w)) + HexByte(Lo(w));
    end;

  begin
    St := HexWord(w[2]) + HexWord(w[1]);
    while (St[1] = '0') and (Length(St) > 1) do
     Delete(St, 1, 1);
    Result := St;
  end;

var
  Source: File;
  Target: TextFile;
  Ch: Char;
  St: String;
  fs, i: Integer;

begin
  WriteLn('Bin2Inc. Copyright (c) 1999, UtilMind Solutions');

  if ParamCount <> 2 then
   begin
    WriteLn('This program converts the binary files to pascal include file.'#13#10);
    WriteLn('USAGE: bin2inc.exe binary.exe binary.inc'#13#10);
    Write('Press "Enter" to continue. . .');
    ReadLn;
   end
  else
   begin
    WriteLn;
    AssignFile(Source, ParamStr(1));
    Reset(Source, 1);
    if IOResult <> 0 then
     begin
      WriteLn('Read error.');
      Halt;
     end;
    fs := FileSize(Source);

    AssignFile(Target, ParamStr(2));
    Rewrite(Target);

    i := 0;
    for fs := 1 to fs do
     begin
      BlockRead(Source, Ch, 1);
      St := DecToHex(Byte(Ch));
      if Length(St) = 1 then Insert('0', St, 1);
      Write(Target, '$' + St + ',');
      inc(i);
      if i = 16 then
       begin
        Write(Target, #13#10);
        i := 0;
       end;
     end;

    CloseFile(Target);
    CloseFile(Source);

    WriteLn(fs, ' bytes done.');
   end;
end.
