{*******************************************************}
{       AutoUpgrader component (Source code) v1.5       }
{       Copyright (c) 1999-2000 UtilMind Solutions      }
{       E-mail: info@utilmind.com,                      }
{       WWW: http://www.utilmind.com                    }
{                                                       }
{  This source code may be used and modified so long as }
{  this copyright notice above remain intact. Selling   }
{  or redistribution this code is expressly forbidden.  }                               
{*******************************************************}


{ Quick notes describing the source of this component

  AutoUpgrade.inc file contains the Upgrader.exe program
  which will delete previous and execute the newest version
  of our application. You can find out the sources of
  Upgrader.exe file in Tools\Upgrader directory in this archive.

  Upgrading proceed in two stages:
   1. Getting the information from info-file -
   2. Downloading the file if the newest version available in
      Upgrade.tmp

  After downloading the newest version we executing the
  upgrader program (Upgrader.exe, stored in AutoUpgrade.inc
  as hex code (for converting the exe-code to hex-source used
  Bin2Inc utility)) and terminating itself.

  Upgrader.exe will:
   1. Delete old version.
   2. Rename downloaded file Upgrade.tmp to the name of newest
      version.
   3. Execute the newest version.
}

unit AutoUpgrade;

interface

uses
  Windows, Messages, SysUtils, Classes, WinInet, WinSock,
  Forms, ShellAPI;

type
  TAUVersionControl = (byDate, byNumber);

  TOnProgressEvent = procedure(Sender: TObject; TotalSize, Readed: Integer) of object;
  TOnDoneEvent = procedure(Sender: TObject; FileSize: Integer) of object;
  TOnUpgradeEvent = procedure(Sender: TObject; UsersServed: Integer; var ShowMessageBox, CanUpgrade: Boolean) of object;

  TAutoUpgrade = class;

  TAutoUpgradeThread = class(TThread)
  private
    FTAutoUpgrade: TAutoUpgrade;
    FTURL: String;

    FTAbort: Boolean;
    FTResult: Boolean;
    FTInfoString: String;
    FTFileSize: Integer;
    FTStage: Byte;

    BytesToRead, BytesReaded: DWord;

    procedure UpdateProgress;
  protected
    procedure Execute; override;
  public
    constructor Create(aInfoURL: String;
                       aAutoUpgrade: TAutoUpgrade;
                       aStage: Byte);
  end;

  TAutoUpgrade = class(TComponent)
  private
    FActive: Boolean;

    FInfoURL,
    FLogin,
    FPassword: String;
    
    FVersionControl: TAUVersionControl;
    FVersionDate: String;
    FVersionDateAutoSet: Boolean;
    FVersionNumber: String;

    FWindowHandle: hWnd;
    FGetInfoStage, FUpgradeStage: TAutoUpgradeThread;

    FError: TNotifyEvent;
    FNoUpdate: TNotifyEvent;
    FProgress: TOnProgressEvent;
    FDone: TOnDoneEvent;
    FUpgrade: TOnUpgradeEvent;

    procedure SetVersionDateAutoSet(Value: Boolean);

    procedure GetInfoStageDone(Sender: TObject);
    procedure UpgradeStageDone(Sender: TObject);
    procedure WndProc(var Msg: TMessage);

    procedure DoUpgrade(FileURL: String);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;

    procedure GetInfo; // ----------
    procedure Abort;
  published
    property Active: Boolean read FActive write FActive;

    property InfoURL: String read FInfoURL write FInfoURL;
    property Login: String read FLogin write FLogin;
    property Password: String read FPassword write FPassword;
    property VersionControl: TAUVersionControl read FVersionControl write FVersionControl;
    property VersionDate: String read FVersionDate write FVersionDate;
    property VersionDateAutoSet: Boolean read FVersionDateAutoSet write SetVersionDateAutoSet;
    property VersionNumber: String read FVersionNumber write FVersionNumber;

    property OnProgress: TOnProgressEvent read FProgress write FProgress;
    property OnDone: TOnDoneEvent read FDone write FDone;
    property OnError: TNotifyEvent read FError write FError;
    property OnNoUpdateAvailable: TNotifyEvent read FNoUpdate write FNoUpdate;

    // since v2.0
    property OnUpgrade: TOnUpgradeEvent read FUpgrade write FUpgrade;
  end;

procedure Register;

implementation

{$I AutoUpgrade.inc}

var
  TempDir: String;

// Function that checks the online status
function IsOnline: Boolean;
var
  Size: Integer;
  PC: Array[0..4] of Char;
  Key: hKey;

 function IsIPPresent: Boolean;
 type
   TaPInAddr = Array[0..10] of PInAddr;
   PaPInAddr = ^TaPInAddr;
 var
   phe: PHostEnt;
   pptr: PaPInAddr;
   Buffer: Array[0..63] of Char;
   I: Integer;
   GInitData: TWSAData;
   IP: String;
 begin
   WSAStartup($101, GInitData);
   Result := False;
   GetHostName(Buffer, SizeOf(Buffer));
   phe := GetHostByName(buffer);
   if phe = nil then Exit;
   pPtr := PaPInAddr(phe^.h_addr_list);
   I := 0;
   while pPtr^[I] <> nil do
    begin
     IP := inet_ntoa(pptr^[I]^);
     Inc(I);
    end;
   WSACleanup;
   Result := (IP <> '') and (IP <> '127.0.0.1');
 end;

begin
  if RegOpenKey(HKEY_LOCAL_MACHINE, 'System\CurrentControlSet\Services\RemoteAccess', Key) = ERROR_SUCCESS then
   begin
    Size := 4;
    if RegQueryValueEx(Key, 'Remote Connection', nil, nil, @PC, @Size) = ERROR_SUCCESS then
     Result := PC[0] = #1
    else
     Result := IsIPPresent;
    RegCloseKey(Key);
   end
  else Result := IsIPPresent;
end;

//  TAutoUpgradeThread
constructor TAutoUpgradeThread.Create(aInfoURL: String;
                                      aAutoUpgrade: TAutoUpgrade;
                                      aStage: Byte);
begin
  FreeOnTerminate := True;
  inherited Create(False);

  FTURL := aInfoURL;
  FTAutoUpgrade := aAutoUpgrade;
  FTStage := aStage;
end;

procedure TAutoUpgradeThread.UpdateProgress;
begin
  FTAutoUpgrade.FProgress(Self, FTFileSize, BytesReaded);
end;

procedure TAutoUpgradeThread.Execute;

  procedure ParseURL(URL: String; var HostName, FileName: String);

    procedure ReplaceChar(c1, c2: Char; var St: String);
    var
      p: Integer;
    begin
      while True do
       begin
        p := Pos(c1, St);
        if p = 0 then Break
        else St[p] := c2;
       end;
    end;

  var
    i: Integer;
  begin
    if Pos('http://', LowerCase(URL)) <> 0 then
      System.Delete(URL, 1, 7);

    i := Pos('/', URL);
    HostName := Copy(URL, 1, i);
    FileName := Copy(URL, i, Length(URL) - i + 1);

    if (Length(HostName) > 0) and (HostName[Length(HostName)] = '/') then
      SetLength(HostName, Length(HostName) - 1);
  end;

label Aborted1, Aborted2, Aborted3, Aborted4, Aborted5;

var
  hSession, hConnect, hRequest: hInternet;
  HostName, FileName: String;
  f: File;
  Buf: Pointer;
  dwBufLen, dwIndex: DWord;
  Data: Array[0..$400] of Char;
  TempStr: String;
begin
  ParseURL(FTURL, HostName, FileName);

  hSession := InternetOpen('AutoUpgrade (www.utilmind.com)',
    INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);

{} if FTAbort then goto Aborted1;

  hConnect := InternetConnect(hSession, PChar(HostName),
    INTERNET_DEFAULT_HTTP_PORT, PChar(FTAutoUpgrade.FLogin), PChar(FTAutoUpgrade.FPassword), INTERNET_SERVICE_HTTP, 0, 0);

{} if FTAbort then goto Aborted2;

  hRequest := HttpOpenRequest(hConnect, 'GET', PChar(FileName), 'HTTP/1.0', nil,
                              nil, INTERNET_FLAG_RELOAD, 0);

{} if FTAbort then goto Aborted3;

  HttpSendRequest(hRequest, nil, 0, nil, 0);

{} if FTAbort then goto Aborted3;

  dwIndex  := 0;
  dwBufLen := 1024;
  GetMem(Buf, dwBufLen);

  FTResult := HttpQueryInfo(hRequest, HTTP_QUERY_CONTENT_LENGTH,
                            Buf, dwBufLen, dwIndex);

{} if FTAbort then goto Aborted4;

  if FTResult or (FTStage = 0) then
   begin
    if FTResult then
     FTFileSize := StrToInt(StrPas(Buf));

    BytesReaded := 0;

    if FTStage = 1 then
     begin
      AssignFile(f, TempDir + 'Upgrade.tmp');
      Rewrite(f, 1);
     end
    else FTInfoString := '';

    while True do
     begin
      {} if FTAbort then goto Aborted5;
      if not InternetReadFile(hRequest, @Data, SizeOf(Data), BytesToRead) then Break
      else
       if BytesToRead = 0 then Break
       else
        begin
         if FTStage = 1 then 
          BlockWrite(f, Data, BytesToRead)
         else
          begin
           TempStr := Data;
           SetLength(TempStr, BytesToRead);
           FTInfoString := FTInfoString + TempStr;
          end;

         inc(BytesReaded, BytesToRead);

         if FTStage = 1 then
          if Assigned(FTAutoUpgrade.FProgress) then
           Synchronize(UpdateProgress);
        end;                            
     end;

    if FTStage = 0 then
     begin
      SetLength(FTInfoString, BytesReaded);     
      FTResult := BytesReaded <> 0
     end 
    else                       
     FTResult := FTFileSize = Integer(BytesReaded);

    Aborted5:
    if FTStage = 1 then CloseFile(f);
   end;

  Aborted4:
  FreeMem(Buf);

  Aborted3:
  InternetCloseHandle(hRequest);
  Aborted2:
  InternetCloseHandle(hConnect);
  Aborted1:
  InternetCloseHandle(hSession);
end;

// AutoUpgrade

constructor TAutoUpgrade.Create(aOwner: TComponent);
var
  i: Integer;
  PC: Array[0..$FF] of Char;
begin
  inherited Create(aOwner);

  // check if we have an owner
  if Assigned(aOwner) then
   begin
    // make sure we are the only one
    i := aOwner.ComponentCount;
    if i <> 0 then
     for i := 0 to i - 1 do
      begin
       if (AOwner.Components[i] is TAutoUpgrade) and
          (AOwner.Components[i] <> Self) then
         raise Exception.Create('We can add ONLY ONE TAutoUpgrade component onto form');
      end;
   end;

{  Deleting the Upgrader.exe if available }
  GetTempPath($FF, PC);
  TempDir := StrPas(PC) + '\';

  DeleteFile(TempDir + 'Upgrader.exe');

  FVersionDate := FormatDateTime('MM"/"DD"/"YYYY', Now);  
  FVersionDateAutoSet := True;
  FActive := True;

  FWindowHandle := AllocateHWnd(WndProc);
  if not (csDesigning in ComponentState) then
   SetTimer(FWindowHandle, 1, 5000, nil);
end;

destructor TAutoUpgrade.Destroy;
begin
  KillTimer(FWindowHandle, 1);
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end;

procedure TAutoUpgrade.GetInfo;
begin
  if not Assigned(FGetInfoStage) then
   begin
    FGetInfoStage := TAutoUpgradeThread.Create(FInfoURL, Self, 0);
    FGetInfoStage.FTAbort := False;
    FGetInfoStage.OnTerminate := GetInfoStageDone;
    while Assigned(FGetInfoStage) do Application.ProcessMessages;
   end
end;

procedure TAutoUpgrade.DoUpgrade(FileURL: String);
begin
  if not Assigned(FUpgradeStage) then
   begin
    FUpgradeStage := TAutoUpgradeThread.Create(FileURL, Self, 1);
    FUpgradeStage.FTAbort := False;
    FUpgradeStage.OnTerminate := UpgradeStageDone;
    while Assigned(FUpgradeStage) do Application.ProcessMessages;
   end
end;

procedure TAutoUpgrade.Abort;
begin
  if Assigned(FGetInfoStage) then
   begin
    FGetInfoStage.FTAbort := True;
    FGetInfoStage.FTResult := True;
   end;
  if Assigned(FUpgradeStage) then
   begin
    FUpgradeStage.FTAbort := True;
    FUpgradeStage.FTResult := True;
   end;
end;

procedure TAutoUpgrade.SetVersionDateAutoSet(Value: Boolean);
begin
  FVersionDateAutoSet := Value;
  if Value and (csDesigning in ComponentState) then
   FVersionDate := FormatDateTime('MM"/"DD"/"YYYY', Now);
end;

procedure TAutoUpgrade.GetInfoStageDone(Sender: TObject);

  function ParseSubStr(SubStrID, Str: String; EndStrChar: Char): String;
  var
    FromS, ToS: Integer;
  begin
    SubStrID := LowerCase(SubStrID);
    FromS := Pos(SubStrID, LowerCase(Str));
    if FromS <> 0 then
     begin
      Delete(Str, 1, FromS + Length(SubStrID) - 1);
      ToS := Pos(EndStrChar, Str);
      Result := Copy(Str, 1, ToS - 1);
     end
    else Result := '';  
  end;

 function CanUpgrade: Boolean;
 var
   ClientDate, ServerDate: String;

   function DateToValue(Date: String): String;
   var
     p1, p2: Integer;
     Year, Month, Day: String;
   begin
     p1 := Pos('/', Date);
     Date[p1] := '\';
     p2 := Pos('/', Date);

     Month := Copy(Date, 1, p1 - 1);
     Day := Copy(Date, p1 + 1, p2 - p1 - 1);
     Year := Copy(Date, p2 + 1, Length(Date) - p2);

     Result := Year + Month + Day;
   end;

 begin
   if FVersionControl = byNumber then
    Result := (ParseSubStr('#version=', FGetInfoStage.FTInfoString, #13) <> FVersionNumber)
   else
    begin
     ServerDate := DateToValue(ParseSubStr('#date=', FGetInfoStage.FTInfoString, #13));
     ClientDate := DateToValue(FVersionDate);
     
     Result := ServerDate > ClientDate;
    end;
 end;

var
  DoCanUpgrade, ShowMessageBox: Boolean;
  UsersServed: Integer;
  Str: String;

begin
  with FGetInfoStage do
   if FTResult and not FTAbort then
    begin
     if (FTInfoString[1] = '#') and CanUpgrade then
      begin
        if Assigned(FUpgrade) then
         begin
          Str := ParseSubStr('#served=', FTInfoString, #10);
          if Str <> '' then
           try
             UsersServed := StrToInt(Str);
           except
             UsersServed := -1;
           end
          else UsersServed := -1;
          
          DoCanUpgrade := True;
          ShowMessageBox := True;
          FUpgrade(Self, UsersServed, ShowMessageBox, DoCanUpgrade);

          if not DoCanUpgrade then
           begin
            FGetInfoStage := nil;
            Exit;
           end;
         end;

        SetForegroundWindow(Application.Handle);
        if not ShowMessageBox or
           (Application.MessageBox(PChar(ParseSubStr('#message=[', FTInfoString, ']')),
                                  PChar(ParseSubStr('#caption=', FTInfoString, #13)),
                                  mb_YesNo or mb_IconQuestion) = id_Yes) then
          if LowerCase(ParseSubStr('#redirect=', FTInfoString, #13)) = 'yes' then
            ShellExecute(GetDesktopWindow, 'open', PChar(ParseSubStr('#url=', FTInfoString, #13)), nil, nil, 0)
          else
           begin
            {$I-}
            ChDir(ExtractFilePath(Application.ExeName));
            {$I+}
            DoUpgrade(ParseSubStr('#url=', FTInfoString, #13));
           end
       end
      else
       if Assigned(FNoUpdate) then FNoUpdate(Self);
    end
   else
    if Assigned(FError) then FError(Self);
  FGetInfoStage := nil;
end;

procedure TAutoUpgrade.UpgradeStageDone(Sender: TObject);
var
  f: File;
  i: Integer;
begin
  with FUpgradeStage do
   if FTResult and not FTAbort and IsOnline then
    begin
     if Assigned(FDone) then FDone(Self, FTFileSize);
     {$I-}
     ChDir(ExtractFilePath(Application.ExeName));
     {$I+}
     AssignFile(f, TempDir + 'Upgrader.exe');
     Rewrite(f, 1);
     BlockWrite(f, Upgrader_Exe, SizeOf(Upgrader_Exe));
     CloseFile(f);

     for i := 1 to Length(FTURL) do
      if FTURL[i] = '/' then FTURL[i] := '\';

     // Three parameters:
     // 1: my Exe-name
     // 2: Upgrade.tmp - it's downloaded file
     // 3: Rename Upgrade.tmp to this name
     WinExec(PChar(TempDir + 'Upgrader.exe ' + ExtractFileName(Application.ExeName) + ' ' +
             TempDir + 'Upgrade.tmp' + ' ' + ExtractFileName(FTURL)), sw_ShowNA);

     Application.Terminate;
    end
   else
    if Assigned(FError) then FError(Self);
  FUpgradeStage := nil;
end;

procedure TAutoUpgrade.WndProc(var Msg: TMessage);
begin
  with Msg do
   if Msg = wm_Timer then
    try
      if IsOnline and FActive then
       begin
        GetInfo;
        KillTimer(FWindowHandle, 1);
       end;
    except
      Application.HandleException(Self);
    end
   else
    Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
end;

procedure Register;
begin
  RegisterComponents('UtilMind', [TAutoUpgrade]);
end;

end.
