#!/usr/bin/perl
##############################################################################
# Auto-Upgrade counter script       Version 1.0                              #
# (c) 2000 UtilMind Solutions       info@utilmind.com                        #
#                                   http://www.utilmind.com                  #
# Created Jan 18, 1999              Last Modified Jan 18, 1999               #
##############################################################################
#  COPYRIGHT NOTICE                                                          #
# Copyright (c) 2000 by UtilMind Solutions. All Rights Reserved.             #
#                                                                            #
# This program is being distributed as server side part of TAutoUpgrade      #
# Delphi component.                                                          #
##############################################################################
#  INSTALLATION TIPS                                                         #
# Put this script to your CGI-BIN directory and chmod it to 755 (executable) #
# Create flat database file (users_served.txt) and chmod it to               #
# 666 (read-write permission) and install it to CGI-BIN too (see $database   #
# variable)                                                                  #
##############################################################################

####################
# Configuration

$database  = "users_served.txt"; # You may set any other name to this flat database

$info_file = "../autoupgrade.info"; # Please specify path to your .info-file

$use_flock = 1; # 1 - yes, 0 - no. Should be used but Win95/98 won't understand it


####################
# Executable

print "Content-Type: text/html\n\n";

open(FILE, $database) || &error("Can't locate database file");
$count = <FILE>;
close(FILE);

$count++; # increasing the counter

open(FILE, ">$database") || &error("Can't update database file");
if ($use_flock eq 1) {
  flock(FILE, 2); # locking write accessing
}
print FILE $count;
if ($use_flock eq 1) {
  flock(FILE, 8); # unlocking
}
close(FILE);


open(FILE, "$info_file") || &error("Can't locate info-file");
@DATA = <FILE>;
close(FILE);

print @DATA;
print "#served=$count\n";


sub error {
  print "Error: $_[0]<br>\n";
  print "Reason: $!";
  exit;
}