//  RTree version 1.1
//  Copyright (C)
//
//  RReport@Confluencia.net
//  All rights reserved
//
// Adquisition , use and distribution of this code is subject to restriction:
//  - You may modify the source code in order to adapt it to your needs.
//  - Redistribution of this ( or a modifed version) source code is prohibited. You may only redistribute compiled versions.
//  - You may not remove this notice from the source code
//  - This notice disclaim all warranties of all material
//

package MSBTree;

import java.awt.*;
import java.util.Vector;
import java.awt.event.*;
import java.io.*;


public class RTreeList extends Panel implements Runnable
{

	// backgound image  
	public java.awt.Image backImage=null;
	private java.awt.Image backImage2=null; // backup
	
	// the two components, draw area and scroll bar
	private treeCanvas drawArea=new treeCanvas();
	Scrollbar Scroll= new Scrollbar(Scrollbar.VERTICAL);
	
	// loaded images
	private Vector ImNames=new Vector(10,5);
	private Vector Images=new Vector(10,5);	
	
    // how to expand?
    public static final int EXPAND_ON_CLICK=0;
    public static final int EXPAND_ON_ENTER=1;
    public int expandOn=EXPAND_ON_CLICK; 
	
	public static final int NO_ANIMATION=0;
	public static final int ANIMATION_FROM_TOP=1;
	public static final int ANIMATION_FROM_BOTTOM=2;
	public static final int ANIMATION_FROM_LEFT=3;
	public static final int ANIMATION_FROM_RIGHT=4;
	
	public static final int LINE_NORMAL=0;
	public static final int LINE_DOTS=1;
	public static final int LINE_DASHED=2;
	
    // line type for the tree
	public int lineType=LINE_DOTS;

	// time to wait before showing the tip
	public int tipDelay=300;
	
	// this is for the shareware version only showCopyright=true will display the link to rreport.8m.com
	private static final boolean showCopyright=false;
	private int copyrightH=0; // space reserved for the copyroght at the bottom of the canvas
	private boolean copyrightSelected=false;
	
	// animation configuration
	private int animation=NO_ANIMATION;
	// speed of the animation
	public int animationDelay=5; // time between two scenes, in miliseconds
	
	// text to show when loading
	public String loadingText="Loading ...";
	
	
	// waiting for a URL to be opened
	private boolean openingURL=false;
	public String openingURLText="Opening URL ..."; // text to show to the user 
	
	public java.awt.Color backColor=java.awt.Color.lightGray;
	public java.awt.Color backColor2=null; // backup, to detect if the back color has been changed
	
	// space reserved for icons left to the text
    public int iconsWidth=16;
	
	// back color of the scroll bar
	public Color scrollColor;
	
	// default values for nodes		 
	java.awt.Image nodeIcon=null;	
	java.awt.Image nodeSelectedIcon=null; // image to show when node is selected
	Color nodeColor=java.awt.Color.black;
	Color nodeSelectedColor=java.awt.Color.black; // color of the font when node is selected
	Color nodeBackColor;
	Color nodeSelectedBackColor;	
	Image nodeBackImage;
	boolean nodeCenterText;
	boolean nodeRaised;	
	Font nodeFont=new java.awt.Font("Arial",Font.PLAIN,12);
	
	// true while the tree is beign created
	private boolean isLoading=true; // when the tree is created it is loading
	// image to show while loading
	public java.awt.Image loadingImage=null;
	// font used to display LOADING text
	public Font loadingFont=new Font("Arial",Font.BOLD,12);
	
	
	// cursor position
	private int cursorX;
	private int cursorY;
	private int cursorBase;	
	
	// tips configuration
	public boolean showTip=false;
	public Font tipFont=new java.awt.Font("Arial",java.awt.Font.PLAIN,10);
	public Color tipColor=java.awt.Color.black;
	public Color tipBorder=java.awt.Color.gray;
	public Color tipBack=java.awt.Color.yellow;	

	
	public RNode Root=new RNode(); // this node will never be displayed, it is for internal use
	public boolean showRoot=true;
	
	// displayed on screen
	Vector displayedNodes=new Vector(10,5);
	
	// lebel tab
	public int levelTab=20;
	public int leftMargin=10;
	public int topMargin=20;
	public java.awt.Color lineColor=java.awt.Color.darkGray;
	public java.awt.Color plusminusboxColor=java.awt.Color.white;
	public boolean drawLine=true;
	public boolean drawPlusMinus=true;
    private RNode currentNode=null;
	
	public Image plusImage;
	public Image minusImage;
	
	public java.applet.Applet parentApplet;
	public String defaultTarget="_top";

	// time when the cursor entered current node
	long enterTime=0;
	long showingTipTime=0;
	
	int currentY=0;
	// size of items in the tree
	public int itemHeight=20;
	public int itemWidth;
	
	// animation internal state
	private boolean inAnimation=false;		
	
	// Javascript events
	public String JSOnEnter="";
	public String JSOnExit="";
	public String JSOnLoad="";
	public String JSOnLoadEnd="";
	public String JSOnExpand="";
	public String JSOnSelect="";
	public String JSOnDblClick="";
	

	// CONSTRUCTOR
	public RTreeList() {
		 Root.expanded=true;
		 Root.level=0;
		 Root.Name="Root";
		 
		 drawArea.parentPanel=this;
		 Scroll.addAdjustmentListener(drawArea);	 
		 
		 this.add("East",Scroll);
		 this.setLayout(new BorderLayout());
		 
		 //this.add("East",Scroll);
		 this.add("Center",drawArea);
		 

		 
	}
	
	// while loading this trext will be displayed
	private void paintLoadingText(Graphics g) {
		
		try{	
		  int iwidth=0;	
		  if (loadingImage!=null) {
			  g.drawImage(loadingImage,20,20,null);
			  iwidth=loadingImage.getWidth(null);
		  }	  
		  
		  g.setFont(loadingFont);
		  if (loadingText!=null) g.drawString(loadingText,iwidth+10+15,20+g.getFontMetrics().getHeight());
		} catch (Exception e)  {}
		
	}
	
	// add child to root
	public void addFirstLevelNode(RNode n) {
		 if ((showCopyright) && (Root.getChildrenNumber()>3)) return;
		 Root.addChild(n);
	}
	
	
	// returns current node from cursor position
	private RNode getCurrentNode(int x, int y) {
		RNode n;
		
		// to which displayed not belongs those coordinates?
		for (int i=0;i<displayedNodes.size();i++) {
		 n=(RNode) displayedNodes.elementAt(i);	
		 if ((n.xPos<=x) && ((n.xPosText+n.wSizeText) >=x) &&(n.yPos<=y) && ((n.yPos+n.hSize) >=y)) {
			  return n;
		 }	  
		}
		
	  return null;	
	}

	// thread's entry point
	public void run() {
		 
		 init();
	}
 	
	// initial display, animation
	private void init()  {
		
	   if (parentApplet!=null)	this.createTreeFromParameters(parentApplet);

	   if (scrollColor!=null) Scroll.setBackground(scrollColor);
	   itemWidth=this.getSize().width;
	   loadNode(Root); // read def. file	
	   this.setBackground(backColor);
		
	   this.paintAll(this.getGraphics());
	   drawArea.paint(drawArea.getGraphics());
	   
	 try { 
				
	   while (inAnimation) {
		   drawArea.paint(drawArea.getGraphics());
			
			// wait miliseconds

			  Thread.sleep(animationDelay);


	   }		
	   
	 Thread.sleep(200);  
	 drawArea.paint(drawArea.getGraphics());
	 
	} catch (Exception e)   {} 
	   
	}
	
	
	private void endLoading() {
		
		
	  if (!isLoading) return;
	  
	  isLoading=false;

	 	// trigger Javascript event
	  if (JSOnLoadEnd.length()>0) {		
		try {
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnLoadEnd,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	  }			
	
	}
	
	private void startLoading() {
		
		
	  if (isLoading) return;
	  
	  isLoading=true;

	 	// trigger Javascript event
	  if (JSOnLoad.length()>0) {
		  try {  
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnLoad,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	  }		
	  
	 
	}
	
	// paint tree
	public void paint(Graphics g) {
		

		
		 int visibleNodes=countNodesToDraw(Root);
		
		 if (!showRoot) visibleNodes--;
		 
		 
		 // calculate size needed to display nodes
		 drawArea.setSize(this.getSize().width,this.getSize().height);

		  if ((visibleNodes*itemHeight)>(drawArea.getSize().height-copyrightH)) {
			  Scroll.setVisible(true);
			 this.add("East",Scroll);
			 this.doLayout();
			 
			 
			 // make canvas for tree bigger and activate scrollbar
			 drawArea.setSize(this.getSize().width-Scroll.getSize().width,(visibleNodes*itemHeight)+copyrightH);
			 Scroll.setMinimum(0);
			 Scroll.setMaximum((visibleNodes*itemHeight)+copyrightH);
			 Scroll.setVisibleAmount(this.getSize().height);
			 Scroll.setUnitIncrement(4);
			 Scroll.setBlockIncrement(this.getSize().height-10);
			 Scroll.setVisible(true);
			 Scroll.setValue(cursorBase);
			 //cursorBase=0;
			 
		  }
		  else {
			 Scroll.setVisible(false);
			 this.remove(Scroll);
			 this.doLayout();	
			 
			 drawArea.setSize(this.getSize().width,this.getSize().height);
			 Scroll.setVisible(false);	
			 cursorBase=0;
	
		  }	 

		// do not show more than possible  
		if ((cursorBase+Scroll.getVisibleAmount())>drawArea.getSize().height) {
				int newBase= drawArea.getSize().height- Scroll.getVisibleAmount();
				if (newBase<0) newBase=0;
			    Scroll.setValue(newBase);
				cursorBase=newBase;
				
		}			  

		 
		 super.paint(g);
		 drawArea.paint(drawArea.getGraphics());
	}
	
	// number of visible nodes
	public int countNodesToDraw(RNode n) {
		int childrenCount=0;
		
		// count visible children
		if (n.expanded) {
			for (int i=0;i<n.getChildrenNumber();i++) 
				 childrenCount=childrenCount+countNodesToDraw(n.getChild(i));
	   }
			
	   return childrenCount+1;		
			
	}
	
	
	// exapnd a node by name
	public void expandNode(String Name,boolean expand) {
		 RNode n=findNode(Root,Name);
		 
		 if (n!=null) {
			   n.expanded=expand;
			   if (n.expanded) 
				     // load node if not loaded 
                     loadNode(n);			   
		 }	 
	}
	
	// force redrawing
	public void refresh() {
		
		drawArea.paint(drawArea.getGraphics());
		this.paint(this.getGraphics());
		
		
	}
	
	
	// clear tree
	public void clear(RNode n) {
		
	   // delete children of children	
	   for (int i=0;i<n.getChildrenNumber();i++) clear(n.getChild(i));	
		
	   // delete children
       n.deleteChildren();	
	   n.childrenDefinitionFile="";
		
	}	
	
	// find a node by name
	public RNode findNode(RNode n,String Name ) {
		int childrenCount=0;
		RNode child;
		
		if (n==null) n=Root;
		
		if (n.Name.toLowerCase().compareTo(Name.toLowerCase())==0) return n;
		
		// count visible children

		for (int i=0;i<n.getChildrenNumber();i++) { 
				  child=findNode(n.getChild(i),Name);
			     if (child!=null) return child;
		}		 

		
		return null;
			
	}	
	
	// load an image, but do not load twice the same one!
	public Image loadImageUrl(String urlAdd) {
		
		if (urlAdd.toUpperCase().compareTo("NULL")==0) return null;
		
	    // try to find the image in the vector
		String name;
		for (int i=0;i<ImNames.size();i++) {
			 name=(String) ImNames.elementAt(i);
			 if (name.compareTo(urlAdd)==0) return (Image) Images.elementAt(i); 
		}
		
		// image not loaded yet, load it
        try{
			java.awt.MediaTracker mt = new java.awt.MediaTracker(this);
						
			// load image
			Image im=null;
			if (parentApplet==null) {
				
			  InputStream in = null; 
              byte[] b = null; 
              int size = 0; 
              in = getClass().getResourceAsStream(urlAdd); 
              if (in!=null){
                 size = in.available(); 
                 b  = new byte[size]; 
                 in.read(b); 

              } 
			  else return null;
			  
			  im=Toolkit.getDefaultToolkit().createImage(b); 
			}
			else { // load from applet
			 String tmpURL=parentApplet.getCodeBase()+urlAdd;
			 System.out.println(tmpURL);
			 im= parentApplet.getImage(new java.net.URL(tmpURL));
			}
			
			mt.addImage(im,0); mt.waitForID(0);
			int Width_im = im.getWidth(null);
			
			Images.addElement(im);
			ImNames.addElement(urlAdd);
			return im;
		}
		catch(Exception e){
		  String err=e.getMessage();
		  System.out.println(err);
		};		
								  
       return null;								  
	
	}
	

 // function to convert a String parameter to a color
 public java.awt.Color convertColor(String c) {
	 if (c.compareTo("NULL")==0) return null;
    if (c.compareTo("RED")==0) return java.awt.Color.red;
    if (c.compareTo("BLACK")==0) return java.awt.Color.black;
    if (c.compareTo("BLUE")==0) return java.awt.Color.blue;
    if (c.compareTo("CYAN")==0) return java.awt.Color.cyan;
    if (c.compareTo("DARKGRAY")==0) return java.awt.Color.darkGray;
    if (c.compareTo("GRAY")==0) return java.awt.Color.gray;
    if (c.compareTo("GREEN")==0) return java.awt.Color.green;
    if (c.compareTo("LIGHTGRAY")==0) return java.awt.Color.lightGray;
    if (c.compareTo("MAGENTA")==0) return java.awt.Color.magenta;
    if (c.compareTo("ORANGE")==0) return java.awt.Color.orange;
    if (c.compareTo("PINK")==0) return java.awt.Color.pink;
    if (c.compareTo("WHITE")==0) return java.awt.Color.white;
    if (c.compareTo("YELLOW")==0) return java.awt.Color.yellow;
    try {
       return java.awt.Color.decode(c);
    } catch (Exception e) {return java.awt.Color.black;}
  }

  // convert an applet parameter to a Font
  public java.awt.Font convertFont(String f) {

    String[] items=convertList(f);

   if (items==null) return null;

    if (items.length<3) return null;

    int s=java.awt.Font.PLAIN;
    if (items[1].compareTo("BOLD")==0) s=java.awt.Font.BOLD;
    if (items[1].compareTo("ITALIC")==0) s=java.awt.Font.ITALIC;

    try {
    return new java.awt.Font(items[0],s,new Integer(items[2]).intValue());
    }
    catch (Exception e) {return null;}

  }	
  
public void drawLineWithStyle(java.awt.Graphics g,int x1,int y1, int x2, int y2,int lineType) {



          if (lineType==LINE_NORMAL) g.drawLine(x1,y1,x2,y2);
          else {
            // draw DASHED or DOTS line

            int segment=2;
			int segmentspace=4;
			if (lineType==LINE_DOTS) {
				  segment=1;
				  segmentspace=2;
			}

            int h=java.lang.Math.abs(y2-y1);
            int w=java.lang.Math.abs(x2-x1);

            double hipo=java.lang.Math.sqrt((h*h)+(w*w));

	        double Cos=w/hipo;
            double Sin=h/hipo;

            int Xslope=1;
            int Yslope=1;
            if (x2<x1) Xslope=-1;
            if (y2<y1) Yslope=-1;


            int subx1=0;
            int suby1=0;
            int subx2=0;
            int suby2=0;
			int subsegment=0;

            // draw line segments
            while (true) {

			  suby2=(int) ((Sin)*(subsegment+segment))*Yslope;
              subx2=(int) ((Cos)*(subsegment+segment))*Xslope;
			  suby1=(int) ((Sin)*(subsegment))*Yslope;
              subx1=(int) ((Cos)*(subsegment))*Xslope;

              if (w<java.lang.Math.abs(subx1)) break;
              if (h<java.lang.Math.abs(suby1)) break;

              if (w<java.lang.Math.abs(subx2)) subx2=w*Xslope;
              if (h<java.lang.Math.abs(suby2)) suby2=h*Yslope;

              g.drawLine(x1+subx1,y1+suby1,x1+subx2,y1+suby2);

              subsegment=subsegment+segment+segmentspace;

            }

          }



       }  
	
  // function to read parameters
private String[] convertList(String items){

   String[] itema=new String[500];
   int itemCount=0;

   // count number of items
   int p=items.indexOf("|");
   while (p>=0) {
      itema[itemCount++]=items.substring(0,p);
      items=items.substring(p+1,items.length());
      p=items.indexOf("|");
   }

   if (items.compareTo("")!=0) itema[itemCount++]=items;

   if (itemCount==0) return null;

   String[] result=new String[itemCount];
   for (int i=0;i<itemCount;i++) result[i]=itema[i];

   return result;

 }

   public void createTreeFromFile(RNode startNode,String sFile) {
	  String fileData=""; 
	  String param="";
	  String value="";
	  RNode currentNode=startNode;
	  
	  // this will displayed a short message that the tree is bweing loaded
	  startLoading();
	  drawArea.paint(drawArea.getGraphics());	
	   
	  
	  if (startNode!=null) startNode.childrenDefinitionLoaded=true;
	   
      // read the file and process the contents line by line
	   try {
		   BufferedReader in=null; 
		  
		  
			// read url  
			  // if there is no ://  then add codebase
			if ( (parentApplet!=null) && (sFile.indexOf(":/")==-1)) sFile=parentApplet.getCodeBase()+sFile;
			System.out.println(parentApplet.getCodeBase());
			System.out.println(parentApplet.getDocumentBase());
		    java.net.URL u =new java.net.URL(sFile);
			//System.out.println("Opening: "+sFile);
			
	        in = new BufferedReader(
				new InputStreamReader(
				u.openStream()));
		  
		  //System.out.println("File opened");

          String inputLine="";
		  while ((inputLine = in.readLine()) != null) {    			
            fileData=fileData+inputLine+((char) 13)+((char) 10);

		  }
		  //System.out.println("File closed");
		  in.close();
	   } catch (Exception e) {
		    String err=e.getMessage();
			System.out.println("Could not open file: "+sFile+" "+e);
	   }
	   
	   
	   // split into lines
	   String line="";
	   int p;
	   int p2;
	   while (fileData.length()>0) {
		
		   p=fileData.indexOf(""+((char) 13)+((char) 10));
		   p2=fileData.indexOf(""+((char) 10));
		   if ((p<=p2) && (p>=0)) {// if line ends with 13 +10
			   line=fileData.substring(0,p);
			   fileData=fileData.substring(p+2,fileData.length());  			   
		   }   

		   if ((p>p2) && (p2>=0)) { // if line ends only with 10
			   line=fileData.substring(0,p2);
			   fileData=fileData.substring(p2+1,fileData.length());  			   
		   }
		   
		   if ((p2==-1) && (p==-1)) {
			   line=fileData;
			   fileData="";   
		   }
		   
		   // process line
		   // split line, parameter=value
		   p=line.indexOf("=");
		   if (p>-1) {
			   param=line.substring(0,p);
			   value=line.substring(p+1,line.length());
			   
			   param=param.toUpperCase();
			   
			   // is this a create node parameter?
		       // create new node
			   if (param.compareTo("CHILD")==0) {
		         currentNode=new RNode(); 
			     currentNode.Name=value;
			     currentNode.color=nodeColor;
			     currentNode.selectedBackColor=nodeSelectedBackColor;
			     currentNode.selectedColor=nodeSelectedColor;
			     currentNode.selectedBackColor=nodeBackColor;	
			     currentNode.icon=nodeIcon;
			     currentNode.expandedIcon=nodeSelectedIcon;
			     currentNode.raisedEffectOnSelection=nodeRaised;
			     currentNode.expanded=false;		
				 currentNode.centerText=nodeCenterText;
				 currentNode.backImage=nodeBackImage;
				 currentNode.font=nodeFont;
				 
				 // add node to parent
				 if (startNode==Root) this.addFirstLevelNode(currentNode);
				 else startNode.addChild(currentNode);
				 
			   } else	   
			     // process normal param
			     processParameter(currentNode,param,value);
			   
			   
		   }
		   
		   
	   }
	   
	   endLoading();
	   
	   
   }

	public void createTreeFromParameters(java.applet.Applet pApplet) {
		
	   startLoading();


	   drawArea.paint(drawArea.getGraphics());	

		
		parentApplet=pApplet;
		
		// parameters for the tree
		processParameter(null,"TREE_ON_ENTER",getStringParam("TREE_ON_ENTER",""));
		processParameter(null,"TREE_ON_EXIT",getStringParam("TREE_ON_EXIT",""));
		processParameter(null,"TREE_ON_LOAD",getStringParam("TREE_ON_LOAD",""));
		processParameter(null,"TREE_ON_LOAD_END",getStringParam("TREE_ON_LOAD_END",""));
		processParameter(null,"TREE_ON_SELECT",getStringParam("TREE_ON_SELECT",""));
		processParameter(null,"TREE_ON_EXPAND",getStringParam("TREE_ON_EXPAND",""));
		processParameter(null,"TREE_ON_DBL_CLICK",getStringParam("TREE_ON_DBL_CLICK",""));
		processParameter(null,"TREE_BORDER",getStringParam("TREE_BORDER",""));
		processParameter(null,"TREE_ANIMATION",getStringParam("TREE_ANIMATION",""));
		processParameter(null,"TREE_EXPAND_MODE",getStringParam("TREE_EXPAND_MODE",""));
		processParameter(null,"TREE_DRAW_PLUS_MINUS",getStringParam("TREE_DRAW_PLUS_MINUS",""));
		processParameter(null,"TREE_TAB",getStringParam("TREE_TAB",""));
		processParameter(null,"TREE_BACK_COLOR",getStringParam("TREE_BACK_COLOR",""));
		processParameter(null,"TREE_LINE_COLOR",getStringParam("TREE_LINE_COLOR",""));
		processParameter(null,"TREE_ITEM_HEIGHT",getStringParam("TREE_ITEM_HEIGHT",""));
		processParameter(null,"TREE_BACK_COLOR",getStringParam("TREE_BACK_COLOR",""));
		processParameter(null,"TREE_BOX_COLOR",getStringParam("TREE_BOX_COLOR",""));
		processParameter(null,"TREE_LEFT_MARGIN",getStringParam("TREE_LEFT_MARGIN",""));
		processParameter(null,"TREE_TOP_MARGIN",getStringParam("TREE_TOP_MARGIN",""));
		processParameter(null,"PLUS_ICON",getStringParam("PLUS_ICON",""));
		processParameter(null,"MINUS_ICON",getStringParam("MINUS_ICON",""));
		processParameter(null,"TREE_TARGET",getStringParam("TREE_TARGET",""));
		processParameter(null,"TREE_TIP_COLOR",getStringParam("TREE_TIP_COLOR",""));
		processParameter(null,"TREE_TIP_BACK_COLOR",getStringParam("TREE_TIP_BACK_COLOR",""));
		processParameter(null,"TREE_TIP_BORDER_COLOR",getStringParam("TREE_TIP_BORDER_COLOR",""));
		processParameter(null,"TREE_TIP_FONT",getStringParam("TREE_TIP_FONT",""));		
		processParameter(null,"TREE_PAGE_BACK_COLOR",getStringParam("TREE_PAGE_BACK_COLOR",""));
		processParameter(null,"TREE_BACK_IMAGE",getStringParam("TREE_BACK_IMAGE",""));
		processParameter(null,"TREE_SCROLL_COLOR",getStringParam("TREE_SCROLL_COLOR",""));
		processParameter(null,"TREE_TIP_DELAY",getStringParam("TREE_TIP_DELAY",""));
		processParameter(null,"TREE_LINE_TYPE",getStringParam("TREE_LINE_TYPE",""));
		processParameter(null,"TREE_DRAW_LINE",getStringParam("TREE_DRAW_LINE",""));
		processParameter(null,"TREE_LOAD_TEXT",getStringParam("TREE_LOAD_TEXT",""));
		processParameter(null,"TREE_OPEN_TEXT",getStringParam("TREE_OPEN_TEXT",""));
		processParameter(null,"TREE_ICON_WIDTH",getStringParam("TREE_ICON_WIDTH",""));
		processParameter(null,"TREE_ANIMATION_DELAY",getStringParam("TREE_ANIMATION_DELAY",""));
		
		processParameter(null,"NODE_COLOR",getStringParam("NODE_COLOR",""));
		processParameter(null,"NODE_RAISED",getStringParam("NODE_RAISED",""));
		processParameter(null,"NODE_SELECTED_COLOR",getStringParam("NODE_SELECTED_COLOR",""));
		processParameter(null,"NODE_BACK_COLOR",getStringParam("NODE_BACK_COLOR",""));
		processParameter(null,"NODE_SELECTED_BACK_COLOR",getStringParam("NODE_BACK_SELECTED_COLOR",""));
		processParameter(null,"NODE_ICON",getStringParam("NODE_ICON",""));
		processParameter(null,"NODE_CENTER_TEXT",getStringParam("NODE_CENTER_TEXT",""));
		processParameter(null,"NODE_BACK_IMAGE",getStringParam("NODE_BACK_IMAGE",""));
		processParameter(null,"NODE_EXPANDED_ICON",getStringParam("NODE_EXPANDED_ICON",""));
		processParameter(null,"NODE_FONT",getStringParam("NODE_FONT",""));
		
	    // create now nodes
        createNode(null);
		
		endLoading();

	}
	
	// create a node and set all properties from parameters
	private void createNode(RNode parent) {
		
	   String pName="";
	   String cName="";
	   int child=1;
	   RNode n;
	   
	   if (parent!=null) pName=parent.Name;
	   else pName="ROOT";
	   
	   if (parent==null) { // this is the root
	    // if show root, then get params for the root
	    if (getStringParam("SHOW_ROOT","").compareTo("Y")==0) 
		    this.showRoot=true;	
	    else this.showRoot=false;
		
		
		this.Root.color=nodeColor;
		this.Root.selectedBackColor=nodeSelectedBackColor;
		this.Root.selectedColor=nodeSelectedColor;
		this.Root.selectedBackColor=nodeBackColor;	
		this.Root.icon=nodeIcon;
		this.Root.expandedIcon=nodeSelectedIcon;	
		this.Root.raisedEffectOnSelection=nodeRaised;
		this.Root.centerText=nodeCenterText;
		this.Root.backImage=nodeBackImage;		
		this.Root.font=nodeFont;		
		createNodeFromParameters(Root,"ROOT");
		
		// if we have a file for the root
		if (this.Root.childrenDefinitionFile.length()>0) loadNode(Root);		
	   }
	   
	   
	   cName=getStringParam(pName+"_"+child,"");
	   while (cName.length()>0) {
		   
		    // create new node
		    n=new RNode(); 
			n.Name=cName;
			n.color=nodeColor;
			n.selectedBackColor=nodeSelectedBackColor;
			n.selectedColor=nodeSelectedColor;
			n.selectedBackColor=nodeBackColor;	
			n.icon=nodeIcon;
			n.expandedIcon=nodeSelectedIcon;
			n.raisedEffectOnSelection=nodeRaised;
			n.centerText=nodeCenterText;
			n.backImage=nodeBackImage;			
			n.expanded=false;
			n.font=nodeFont;
		
		   
			// add to parent
		    if (parent==null) this.addFirstLevelNode(n);
			else parent.addChild(n);
			
			// parameters for this node
			createNodeFromParameters(n,cName);
			
			// create children
			createNode(n);
			
			// next node in the same level
		    child++;
		   	cName=getStringParam(pName+"_"+child,"");
	   }
	   
	
	}
	
	// process parameters refering to current node
	private void createNodeFromParameters(RNode n,String nodeName) {
		
		processParameter(n,"FONT",getStringParam(nodeName+"_FONT",""));
		processParameter(n,"COLOR",getStringParam(nodeName+"_COLOR",""));
		processParameter(n,"SELECTED_COLOR",getStringParam(nodeName+"_SELECTED_COLOR",""));
		processParameter(n,"BACK_COLOR",getStringParam(nodeName+"_BACK_COLOR",""));
		processParameter(n,"BACK_SELECTED_COLOR",getStringParam(nodeName+"_BACK_SELECTED_COLOR",""));
		processParameter(n,"TEXT",getStringParam(nodeName+"_TEXT",""));
		processParameter(n,"LINK",getStringParam(nodeName+"_LINK",""));
		processParameter(n,"ICON",getStringParam(nodeName+"_ICON",""));
		processParameter(n,"EXPANDED_ICON",getStringParam(nodeName+"_EXPANDED_ICON",""));	
		processParameter(n,"RAISED",getStringParam(nodeName+"_RAISED",""));	
		processParameter(n,"BACK_IMAGE",getStringParam(nodeName+"_BACK_IMAGE",""));	
		processParameter(n,"CENTER_TEXT",getStringParam(nodeName+"_CENTER_TEXT",""));	
		processParameter(n,"DATA_FILE",getStringParam(nodeName+"_DATA_FILE",""));	
		processParameter(n,"TIP",getStringParam(nodeName+"_TIP",""));
		processParameter(n,"TARGET",getStringParam(nodeName+"_TARGET",""));
		processParameter(n,"EXPANDED",getStringParam(nodeName+"_EXPANDED",""));
		
	}

 // item list
 private String[] getItemsParameter(String key) {
   String items=getStringParam(key,"");
   return convertList(items);

 }	
	
 // get a aparameter as string
  private String getStringParam(String Param,String def) {

      return this.getParameter(Param, def);
	 

    }


  //Get a parameter value
  private String getParameter(String key, String def) {
    if (parentApplet.getParameter(key) != null) return parentApplet.getParameter(key) ;
    else return def;
  }	

// process a paramter
public void processParameter(RNode currentNode,String ParamName, String ParamValue) {
		
		try {
		
		if (ParamValue.length()==0) return;

		if (ParamName.compareTo("TREE_ANIMATION")==0) {
			if (ParamValue.compareTo("NO")==0) this.animation=NO_ANIMATION;
		    if (ParamValue.compareTo("TOP")==0) this.animation=this.ANIMATION_FROM_TOP;
			if (ParamValue.compareTo("BOTTOM")==0) this.animation=this.ANIMATION_FROM_BOTTOM;
			if (ParamValue.compareTo("LEFT")==0) this.animation=this.ANIMATION_FROM_LEFT;
			if (ParamValue.compareTo("RIGHT")==0) this.animation=this.ANIMATION_FROM_RIGHT;
		}		
		
		if (ParamName.compareTo("TREE_EXPAND_MODE")==0) {
			 if (ParamValue.compareTo("ON_CLICK")==0) this.expandOn=EXPAND_ON_CLICK;
		     if (ParamValue.compareTo("ON_ENTER")==0) this.expandOn=EXPAND_ON_ENTER;
		}	  
		
		
	    if (ParamName.compareTo("TREE_ON_ENTER")==0) this.JSOnEnter=ParamValue;		
		if (ParamName.compareTo("TREE_ON_EXIT")==0) this.JSOnExit=ParamValue;	
		if (ParamName.compareTo("TREE_ON_LOAD")==0) this.JSOnLoad=ParamValue;	
		if (ParamName.compareTo("TREE_ON_LOAD_END")==0) this.JSOnLoadEnd=ParamValue;	
		if (ParamName.compareTo("TREE_ON_DBL_CLICK")==0) this.JSOnDblClick=ParamValue;	
		if (ParamName.compareTo("TREE_ON_SELECT")==0) this.JSOnSelect=ParamValue;
		if (ParamName.compareTo("TREE_ON_EXPAND")==0) this.JSOnExpand=ParamValue;	
		
		if (ParamName.compareTo("TREE_BACK_IMAGE")==0) backImage=loadImageUrl(ParamValue);
	    
	    if (ParamName.compareTo("PLUS_ICON")==0) this.plusImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("MINUS_ICON")==0) this.minusImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("TREE_TARGET")==0) this.defaultTarget=ParamValue;
		
		if (ParamName.compareTo("TREE_LOAD_TEXT")==0) this.loadingText=ParamValue;
		
		if (ParamName.compareTo("TREE_OPEN_TEXT")==0) this.openingURLText=ParamValue;
			
		try {
		if (ParamName.compareTo("TREE_TIP_DELAY")==0) this.tipDelay=new Integer(ParamValue).intValue();
		} catch (Exception e) {}
		
	    if (ParamName.compareTo("TREE_DRAW_LINE")==0) this.drawLine=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("TREE_LINE_TYPE")==0) {
			 if (ParamValue.compareTo("NORMAL")==0) this.lineType=LINE_NORMAL;
			 if (ParamValue.compareTo("DASHED")==0) this.lineType=LINE_DASHED;
			 if (ParamValue.compareTo("DOTS")==0) this.lineType=LINE_DOTS;
		}	 
		
		if (ParamName.compareTo("TREE_DRAW_PLUS_MINUS")==0) this.drawPlusMinus=(ParamValue.compareTo("Y")==0);

		if (ParamName.compareTo("TREE_TAB")==0) this.levelTab=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_ICON_WIDTH")==0) this.iconsWidth=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_ANIMATION_DELAY")==0) this.animationDelay=new Integer(ParamValue).intValue();	
		
		if (ParamName.compareTo("TREE_LEFT_MARGIN")==0) this.leftMargin=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_TOP_MARGIN")==0) this.topMargin=new Integer(ParamValue).intValue();
		
	    if (ParamName.compareTo("TREE_ITEM_HEIGHT")==0) this.itemHeight=new Integer(ParamValue).intValue();	
	
	    if (ParamName.compareTo("TREE_LINE_COLOR")==0) this.lineColor=convertColor(ParamValue);	
		
		if (ParamName.compareTo("TREE_BOX_COLOR")==0) this.plusminusboxColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("TREE_SCROLL_COLOR")==0) this.scrollColor=convertColor(ParamValue);
	
		if (ParamName.compareTo("TREE_BACK_COLOR")==0) this.backColor=convertColor(ParamValue);		
		
		if (ParamName.compareTo("NODE_COLOR")==0) nodeColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_CENTER_TEXT")==0) nodeCenterText=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("NODE_BACK_IMAGE")==0) nodeBackImage=loadImageUrl(ParamValue);

		if (ParamName.compareTo("TREE_TIP_FONT")==0) this.tipFont=convertFont(ParamValue);		
		
		if (ParamName.compareTo("TREE_TIP_COLOR")==0) this.tipColor=convertColor(ParamValue);

		if (ParamName.compareTo("TREE_TIP_BACK_COLOR")==0) this.tipBack=convertColor(ParamValue);
		
		if (ParamName.compareTo("TREE_TIP_BORDER_COLOR")==0) this.tipBorder=convertColor(ParamValue);		
		
		if (ParamName.compareTo("NODE_SELECTED_COLOR")==0) nodeSelectedColor=convertColor(ParamValue);

		if (ParamName.compareTo("NODE_BACK_COLOR")==0) nodeBackColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_BACK_SELECTED_COLOR")==0) nodeSelectedBackColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_ICON")==0) nodeIcon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("NODE_RAISED")==0) nodeRaised=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("NODE_EXPANDED_ICON")==0) nodeSelectedIcon=loadImageUrl(ParamValue);
	
	     if (ParamName.compareTo("NODE_FONT")==0)  nodeFont=convertFont(ParamValue);		
		
		// parameters of the node
		
		if (ParamName.compareTo("FONT")==0)  currentNode.font=convertFont(ParamValue);

		if (ParamName.compareTo("TARGET")==0)  currentNode.target=ParamValue;
		
		if (ParamName.compareTo("TIP")==0)  currentNode.tipText=ParamValue;

		if (ParamName.compareTo("COLOR")==0) currentNode.color=convertColor(ParamValue);
				
		if (ParamName.compareTo("SELECTED_COLOR")==0) currentNode.selectedColor=convertColor(ParamValue);	
		
		if (ParamName.compareTo("BACK_COLOR")==0) currentNode.backColor=convertColor(ParamValue);
					
		if (ParamName.compareTo("BACK_SELECTED_COLOR")==0) currentNode.selectedBackColor=convertColor(ParamValue);
				
		if (ParamName.compareTo("TEXT")==0) currentNode.text=ParamValue;
		
		if (ParamName.compareTo("LINK")==0) currentNode.userValue=ParamValue;
		
		if (ParamName.compareTo("BACK_IMAGE")==0) currentNode.backImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("CENTER_TEXT")==0) currentNode.centerText=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("ICON")==0) currentNode.icon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("DATA_FILE")==0) {
			  currentNode.childrenDefinitionFile=ParamValue;
			  if (currentNode.expanded) loadNode(currentNode); // read also the data file is the node is expanded
		}	  
		
		if (ParamName.compareTo("EXPANDED_ICON")==0) currentNode.expandedIcon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("RAISED")==0) currentNode.raisedEffectOnSelection=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("EXPANDED")==0) {
			  currentNode.expanded=(ParamValue.compareTo("Y")==0);
			  if (currentNode.expanded) loadNode(currentNode);
		}		  
			  
				
		} catch (Exception e) {System.out.println(e.getMessage());}	
	
	}
	
	// load a node's children from teh data file
	private void loadNode(RNode n) {
		
		if (n.expanded) {
			if ((n.childrenDefinitionFile.length()>0)  && (!n.childrenDefinitionLoaded)) {
				createTreeFromFile(n,n.childrenDefinitionFile);
				n.childrenDefinitionLoaded=true;
			}
		}
		
	}
	
	// draw node , its children and the lines that link them
	public void drawNode(java.awt.Graphics g,RNode n,int level,boolean redrawChildren) {
		
		RNode lastChild=null;
		RNode Child;
		int x=levelTab*level+leftMargin; 
		n.level=level; // save this node's level
		int nodeIndex=0;
		
		// this is to avoid the root node being displayed
		if ((level>=1) || (showRoot)) {
		  n.xPos=x;
		  n.yPos=currentY;
		  n.draw(g,x,currentY,itemHeight,itemWidth); // draw here
		  nodeIndex=displayedNodes.size(); // store in vector of displyed nodes
		  currentY=currentY+itemHeight; // move currentY 
		  // add to the list of displayed nodes
		  displayedNodes.addElement(n); }
		else {  
		  n.xPos=leftMargin; // root
		  n.yPos=currentY;	
		  nodeIndex=-1;
		}
		
       if (redrawChildren) {

		// draw children
		if (n.expanded) {
			
			for (int i=0;i<n.getChildrenNumber();i++) {
				 drawNode(g,n.getChild(i),level+1,true);
				 lastChild=n.getChild(i);
			}
		// draw line to my children	
		if (drawLine) {
			// draw a vertical line from my node to the last of my children
			g.setColor(lineColor);
			if (lastChild!=null) {
				drawLineWithStyle(g,n.xPos,n.yPos+n.hSize,n.xPos,lastChild.yPos+(lastChild.hSize/2),lineType);
				// draw a horizontal line from the vertical line to each child
				for (int j=nodeIndex+1;j<displayedNodes.size();j++) {

					Child=(RNode) displayedNodes.elementAt(j);
					 // draw a line to direct children
					 if ((n.level+1)==Child.level) {
						 drawLineWithStyle(g,n.xPos,Child.yPos+(Child.hSize/2),Child.xPos,Child.yPos+(Child.hSize/2),lineType);
					 
					 
					 String plusminus="";
					 
					 if ((drawPlusMinus) && (Child.expanded) && (Child.hasChildren())) plusminus="-";
					 if ((drawPlusMinus) && (!Child.expanded) && (Child.hasChildren())) plusminus="+";
									
					 // draw + or - with images
					 if ((plusminus.compareTo("-")==0) && (minusImage!=null) )  {
						 int recSide=minusImage.getWidth(null);
						 int h=minusImage.getHeight(null);
						 
						 if (h>recSide) recSide=h;
						 int pmX=n.xPos+((levelTab-recSide)/2);
						 int pmY=Child.yPos+((itemHeight-recSide)/2);	
						 
						 g.drawImage(minusImage,pmX,pmY,null); 						 
					 }
					 
					 // draw + or - with images
					 if ((plusminus.compareTo("+")==0) && (plusImage!=null) )  {
						 int recSide=plusImage.getWidth(null);
						 int h=plusImage.getHeight(null);
						 
						 if (h>recSide) recSide=h;
						 int pmX=n.xPos+((levelTab-recSide)/2);
						 int pmY=Child.yPos+((itemHeight-recSide)/2);	
						 
						 g.drawImage(plusImage,pmX,pmY,null); 						 
					 }					 
					 
					 // draw + and - with text
					 if ((plusminus.length()>0) && (minusImage==null) && (plusImage==null)) {
						 g.setFont(new Font("Arial",Font.PLAIN,8));
						 
						 int recSide=(g.getFontMetrics().stringWidth(plusminus));
						 if (g.getFontMetrics().getHeight()>recSide) recSide=g.getFontMetrics().getHeight();
						 
						 int pmX=n.xPos+((levelTab-recSide)/2);
						 int pmY=Child.yPos+((itemHeight-recSide)/2);	 
						 
						 // draw rectangle
						 g.setColor(plusminusboxColor);
						 g.fillRect(pmX,pmY,recSide,recSide);					 

						 // draw border
						 g.setColor(lineColor);
						 g.drawRect(pmX,pmY,recSide,recSide);	
						 
						 int toCenterXtext=(recSide-g.getFontMetrics().stringWidth(plusminus))/2;
						 int toCenterYtext=(recSide-g.getFontMetrics().getHeight())/2;
						 
						 // draw + or -
                          g.drawString(plusminus,pmX+toCenterXtext+1,pmY+g.getFontMetrics().getHeight()+toCenterYtext-2);
						 
						  
					 } // plus minus
					} // level=child.level+1	 
				} // for each child
			} // last child !=null
		 } // draw line
			
		} // redraw children
			
	}
	}		

private void performAction(RNode n) {
	
	
 	// trigger Javascript event
	if (JSOnDblClick.length()>0) {
		
		try {
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);

		Object[] o=new Object[1];
		o[0]=n.Name;
		JS.call(JSOnDblClick,o);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	}	
	
	// open a http
	if ((n.userValue!=null) && (parentApplet!=null)) {
		if (n.userValue instanceof String) {
			String add=""; // address
			String target=""; // target frame
			String val=(String) n.userValue;
			
			int p=val.indexOf("|");
			if (p>-1) {
				add=val.substring(0,p);
				target=val.substring(p+1,val.length());
			}
			else {add=val;
				  target=defaultTarget;
			}
			
			try {
			   // show text to user	
			   openingURL=true;
			   this.paint(this.getGraphics());
			   
			   String urlAdd=add;
			   // if there is no :, I asume it is a relative address, add CodeBase()
			   if (add.indexOf("://")==-1) urlAdd=parentApplet.getCodeBase()+add;
			   
			   if (n.target.length()>0) target=n.target;
			   
			   parentApplet.getAppletContext().showDocument(new java.net.URL(urlAdd),target);
			} catch (Exception e) {}
			
			// remove text
			openingURL=false;
			this.paint(this.getGraphics());			
			
		}
	}
  
}




// canvas classe to draw tree
private class treeCanvas extends Canvas implements AdjustmentListener,MouseMotionListener,MouseListener {

	// animation internal state
	private int xStepAnimation;
	private int currentAnimationx;
	private int yStepAnimation;
	private int currentAnimationy;	
	
	// Images used to store the tree
	private Image treeLayer;
	private Image backLayer;
	private Image finalImage; // combination fo the 2 layers
	
	public RTreeList parentPanel;
	
	public treeCanvas() {
		 this.addMouseMotionListener(this);
		 this.addMouseListener(this);		
	}
	
   // draw the background, repeating the back images as many times as needed	
   private void drawBackImage(java.awt.Graphics g) {
		
	  if (backImage==null) return;	

      int ImageW=backImage.getWidth(null);
      int ImageH=backImage.getHeight(null);

	  if ((ImageW==-1)  || (ImageH==-1)) return;

          for (int j=0;j<this.getSize().width;j=j+ImageW) {
            for (int i=0;i<this.getSize().height;i=i+ImageH) {
               g.drawImage(backImage,j,i,null);
            }
          }


   }	
		
   // show a scene of the initial animation
	private boolean paintAnimationScene(java.awt.Graphics g) {
		
		    if (!inAnimation) return false;
		
			// draw scenes
			if ( (java.lang.Math.abs(currentAnimationx)>java.lang.Math.abs(xStepAnimation)) || (java.lang.Math.abs(currentAnimationy)>java.lang.Math.abs(yStepAnimation))) {
				currentAnimationx=currentAnimationx+xStepAnimation;
				currentAnimationy=currentAnimationy+yStepAnimation;
				
		         // combine to final image
				if (animation==ANIMATION_FROM_TOP) finalImage.getGraphics().drawImage(backLayer,0,currentAnimationy+treeLayer.getHeight(null),null);
				if (animation==ANIMATION_FROM_BOTTOM) finalImage.getGraphics().drawImage(backLayer,0,currentAnimationy-backLayer.getHeight(null),null);
				if (animation==ANIMATION_FROM_LEFT) finalImage.getGraphics().drawImage(backLayer,treeLayer.getWidth(null)+currentAnimationx,0,null);
				if (animation==ANIMATION_FROM_RIGHT) finalImage.getGraphics().drawImage(backLayer,currentAnimationx-backLayer.getWidth(null),0,null);
		        
		        finalImage.getGraphics().drawImage(treeLayer,currentAnimationx,currentAnimationy,null);
		        // draw border
		        //drawBorder(finalImage.getGraphics());
		
		        // draw images in the real graphics
		        g.drawImage(finalImage,0,0,null);				

				
			}
			else inAnimation=false;
			
			return inAnimation;
	
	}
	
	
	// draw the tree
	public void paint(java.awt.Graphics g) {
		boolean firstTime=false; // has the applet been displayed for the first time?
		boolean createImages=false;
		
		
		if (g==null) return;
		
		// just draw message is the tree is loading
		if (isLoading) {paintLoadingText(g);  
						return;
		}		
		
		// if we are in the animation phase paint scene and return
		if (paintAnimationScene(g)) return;
		
		// if we have not created the images yet
		if (treeLayer==null) {
			  createImages=true;
			  firstTime=true;	  
		}	  
		
		// if the canvas has been resized
		if (treeLayer!=null)
			if (this.getSize().height!=treeLayer.getHeight(null)) createImages=true;
		
		// draw back color
		if (createImages) {
		  cursorBase=0;	

		  backLayer=this.createImage(this.getSize().width,this.getSize().height);	

		  // final image
		  finalImage=this.createImage(this.getSize().width,this.getSize().height);
		  
		  // create tree image
		  treeLayer=this.createImage(this.getSize().width,this.getSize().height);
		  

		}
	
		// repaint backgorund
		if ((backColor!=null) && ((backColor!=backColor2)|| (createImages))) {
			
			java.awt.Graphics g1=backLayer.getGraphics();
			g1.setColor(backColor); 
			g1.fillRect(0,0,this.getSize().width,this.getSize().height);
			backColor2=backColor;
		}			
		
		// reload background
		if ((backImage!=backImage2) || (createImages)) {

			drawBackImage(backLayer.getGraphics());
		}	
		
		if ((backImage2!=null) && (backImage==null)) {
			 // there was an image but not any more, delete it
			
			if (backColor!=null) {

			  java.awt.Graphics g1=backLayer.getGraphics();
			  g1.setColor(backColor); 
			  g1.fillRect(0,0,this.getSize().width,this.getSize().height);
			}			
		}
		
		backImage2=backImage; // backup
		
		
		 // print all first level
		currentY=topMargin;
		
		displayedNodes.removeAllElements();
		
		// copy background layer to tree layer
		treeLayer.getGraphics().drawImage(backLayer,0,0,null);
		
		// draw tree in foreground layer
		drawNode(treeLayer.getGraphics(),Root,0,true);
		
		
		
        // show tip
		if (currentNode!=null)
	     if ((showingTipTime!=0) && (currentNode.tipText.length()>0)) {
		   
		   java.awt.Graphics g2=treeLayer.getGraphics();
			 
		   g2.setFont(tipFont);
		   int tipW=g2.getFontMetrics().stringWidth(currentNode.tipText);
		   int tipH=g2.getFontMetrics().getHeight();

		   g2.setColor(tipBack);  // tip background
		   g2.fillRect(cursorX,cursorY+20,tipW+6,tipH+4);		   
		   g2.setColor(tipBorder); // tip border
		   g2.drawRect(cursorX,cursorY+20,tipW+6,tipH+4);
		   g2.setColor(tipColor); // tip text
		   g2.drawString(currentNode.tipText,cursorX+3,cursorY+20+tipH);
		   
	     }	  
		
		// show copyright if not registered
		if ((showCopyright) && (!openingURL)) {
			java.awt.Graphics g2=treeLayer.getGraphics();
		    g2.setFont(new Font("Arial",Font.PLAIN,10));
			
			if (nodeColor!=null) g2.setColor(nodeColor);
			else g2.setColor(java.awt.Color.black);
			
			// blue color in cursor on the text
			copyrightH=g2.getFontMetrics().getHeight()+10;
			if (copyrightSelected) {
				g2.setColor(backColor.brighter());
				if (nodeSelectedColor!=null) g2.setColor(nodeSelectedColor);
			}		

			g2.drawString("Courtesy of http://rreport.8m.com",10,this.getSize().height-(copyrightH/2));
		}
		
		// show text, opening url
		if (openingURL) {
			java.awt.Graphics g2=treeLayer.getGraphics();
		    g2.setFont(new Font("Arial",Font.PLAIN,10));
			if (backColor!=java.awt.Color.black) g2.setColor(java.awt.Color.black);
			else g2.setColor(java.awt.Color.white);

			g2.drawString(openingURLText,10,this.getSize().height-(copyrightH/2));
		}		
		
		
		// make animation the first time the applet is displayed
		if ((animation!=NO_ANIMATION) && (firstTime)) {
			xStepAnimation=1; 
			yStepAnimation=1;
			int startx=(-1)*(this.getSize().width);
			int starty=(-1)*(this.getSize().height);
				
			if (animation==ANIMATION_FROM_TOP) {
				xStepAnimation=0;
				startx=0;
			}
			
			if (animation==ANIMATION_FROM_BOTTOM) {
				yStepAnimation=yStepAnimation*(-1);
				xStepAnimation=0;
				startx=0;
				starty=starty*(-1);
			}
			
			if (animation==ANIMATION_FROM_LEFT) {
				yStepAnimation=0;
				starty=0;
			}
			
			if (animation==ANIMATION_FROM_RIGHT) {
				xStepAnimation=xStepAnimation*(-1);
				yStepAnimation=0;
				starty=0;
				startx=startx*(-1);
			}	
			
			currentAnimationx=startx;
			currentAnimationy=starty;
			
			inAnimation=true;
			return;		
				
		}
		
		
		
		// combine to final image
		if (finalImage!=null) {
		  finalImage.getGraphics().drawImage(backLayer,0,0,null);
		  finalImage.getGraphics().drawImage(treeLayer,0,0,null);
		  // draw border
		  //drawBorder(finalImage.getGraphics());
		
		  // draw images in the real graphics
		  g.drawImage(finalImage,0,0,this.getSize().width,parentPanel.getSize().height,0,cursorBase,this.getSize().width,cursorBase+parentPanel.getSize().height,null);
		}
		
		
	}
	
// mouse events
public void mouseClicked(MouseEvent e) {
   
	boolean textClicked=false;
	
	if (inAnimation) return;

	int i;
	
	cursorX=e.getX();
	cursorY=e.getY()+cursorBase;	
	

	
	try {
	 if ((showCopyright) && (cursorY>(this.getSize().height-copyrightH))) parentApplet.getAppletContext().showDocument(new java.net.URL("http://rreport.8m.com"));
	} catch(Exception e1) {}
	 
	
		RNode n=null;
		
		// to which displayed node belong the coordinates?
		for (i=0;i<displayedNodes.size();i++) {
		  n=(RNode) displayedNodes.elementAt(i);
		  if ((cursorX>=(n.xPos+iconsWidth)) &&(n.yPos<=cursorY) && ((n.yPos+n.hSize) >=cursorY))  {textClicked=true;break;}
		  if (((n.xPos-levelTab)<=cursorX) && (cursorX<(n.xPosText+n.wSizeText)) &&(n.yPos<=cursorY) && ((n.yPos+n.hSize) >=cursorY)) break;
		}
        
		if (i<displayedNodes.size()) {
			
			// run action if clicked on the text
			if (textClicked) performAction(n);

		    // expand if clicked on icon or -/+ or double clikc or one click but there is no action for the item
			if ( (n.hasChildren()) && ( (e.getClickCount()>1) || (!textClicked) || ( (e.getClickCount()==1) && (n.userValue==null) ))) {
			 n.expanded=(!n.expanded);
			 
			 if (n.expanded) {
				  loadNode(n);
				  
	 	       // trigger Javascript event
	          if (JSOnExpand.length()>0) {
		
		        try {
				  netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		          Object[] o=new Object[1];
		          o[0]=n.Name;
		          JS.call(JSOnExpand,null);
		         } catch (Exception e1) {System.out.println(e1.getMessage());}
	           }		  
			 }	  
			 
             // redraw canvas
             parentPanel.paint(parentPanel.getGraphics());
			 this.paint(this.getGraphics());
        }
		}		
       

    
 
	
}

public void mouseEntered(MouseEvent e) {
	
	// trigger Javascript event
	if (JSOnEnter.length()>0) {
		try {		
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnEnter,null);
		} catch (Exception e1) {
			 String err=e1.getMessage();
			 System.out.println(err);
		}
	}

}

public void mouseExited(MouseEvent e) {
	
   // deselect all nodes
   for (int i=0;i<displayedNodes.size();i++) ((RNode) displayedNodes.elementAt(i)).selected=false;

   refresh();

 	// trigger Javascript event
	if (JSOnExit.length()>0) {
		try {		
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnExit,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	}  
   
}

public void mousePressed(MouseEvent e) {
}

public void mouseReleased(MouseEvent e) {
}

// mouse moved
public void mouseDragged(MouseEvent e) {
}
 
public void mouseMoved(MouseEvent e) {
    // change active node
    
	if (inAnimation) return;
	
	RNode tmp;
	boolean deleteTip=false;
	boolean redraw=false;
	boolean resize=false;
	
	cursorX=e.getX();
	cursorY=e.getY()+cursorBase;
	
	RNode n=getCurrentNode(cursorX,cursorY);


	if (n==currentNode) {
		if (n!=null) {	 	
		      // 3/4 second, show tip
              if (((System.currentTimeMillis()-enterTime)>tipDelay) && (showingTipTime==0)) {
			     showingTipTime=System.currentTimeMillis();
				 redraw=true;
			     
		   }	
		   
		}
	}
	
	
	if (n!=currentNode) {
       // deactivate previous node
       if (currentNode!=null) { 
      
	        
           currentNode.selected=false;
           // compress if we are not openning a descendant and EXPAND_ON_ENTER
		   
		   boolean collapse=false;	  
		   
           if ((expandOn==EXPAND_ON_ENTER) && (currentNode!=null))
			   if ((n!=Root) && (currentNode.getChildrenNumber()>0)) collapse=true;
		   
		   if (n!=null)
			   if (n.parent==currentNode) collapse=false;
		   
		   if (collapse) {currentNode.expanded=false;resize=true;}
               
  
       } 
 
	   enterTime=0;
	   showingTipTime=0;
       if (n!=null) { n.selected=true;
		  enterTime=System.currentTimeMillis();
		  
		  
		  // trigger javascript event
	     if (JSOnSelect.length()>0) {

		    try {			 
		    netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		     Object[] o=new Object[1];
		     o[0]=n.Name;
		     JS.call(JSOnSelect,o);
		    } catch (Exception e1) {System.out.println(e1.getMessage());}
	      }			  
		  
          // expand if EXPAND_ON_ENTER
		  if ((expandOn==EXPAND_ON_ENTER) && (n.hasChildren())) {n.expanded=true;
																		 loadNode(n);
																		 resize=true;}
       }

	   currentNode=n; 
	   
       // redraw canvas
       redraw=true;

    }
	
	if  ((showCopyright) && (!copyrightSelected)&&  (cursorY>(this.getSize().height-copyrightH))) {copyrightSelected=true; 
																			redraw=true;}

	if  ((showCopyright) && (copyrightSelected) &&  (cursorY<=(this.getSize().height-copyrightH))) {copyrightSelected=false; 
																			redraw=true;}	
	
	if (redraw) {
		 if (resize) parentPanel.paint(parentPanel.getGraphics());
		 this.paint(this.getGraphics());
	}	 
   
}

 // scroll bar moved
 public void adjustmentValueChanged(AdjustmentEvent e) {
	 
     cursorBase=e.getValue();
	 
	if ((cursorBase+Scroll.getVisibleAmount())>drawArea.getSize().height) { 
	  int newBase= drawArea.getSize().height- Scroll.getVisibleAmount();
	  if (newBase<0) newBase=0;
	  Scroll.setValue(newBase);
	  cursorBase=newBase;	
	} 
	 
	 
	 this.paint(this.getGraphics());
 }
	
	
}

	
}
