//  RTree version 1.1
//  Copyright (C)
//
//  RReport@Confluencia.net
//  All rights reserved
//
// Adquisition , use and distribution of this code is subject to restriction:
//  - You may modify the source code in order to adapt it to your needs.
//  - Redistribution of this ( or a modifed version) source code is prohibited. You may only redistribute compiled versions.
//  - You may not remove this notice from the source code
//  - This notice disclaim all warranties of all material
//

package MSBTree;

import java.awt.*;
import java.applet.*;
import java.util.*;


public class RTreeApplet extends Applet
{
	
	private final static int LEFT_BORDER=0;
    private final static int TOP_BORDER=2;
	private final static int BOTTOM_BORDER=3;
	private final static int RIGHT_BORDER=4;	
	
	// tree
	public RTreeList tree = new RTreeList();
	// canvas used to draw the border
    borderCanvas appBorderLeft=new borderCanvas(LEFT_BORDER);
	borderCanvas appBorderRight=new borderCanvas(RIGHT_BORDER);
	borderCanvas appBorderTop=new borderCanvas(TOP_BORDER);
	borderCanvas appBorderBottom=new borderCanvas(BOTTOM_BORDER);
	
	// border types
    public static final int NO_BORDER=0;
	public static final int BORDER_LINE=1;
	public static final int BORDER_RAISED=2;
	public static final int BORDER_LOWERED=3;
	public static final int BORDER_DOUBLE=4;
	public static final int BORDER_SHADOW=5;
	public static final int BORDER_LINE2=6;	
	
	// size of the border
	private int upperBorder=0;
    private int bottomBorder=0;
	private int leftBorder=0;
	private int rightBorder=0;
	
	// properties related with the border
	public int borderType=BORDER_LINE;
	public Color pageBackColor=java.awt.Color.white;		
	public java.awt.Color borderColor=java.awt.Color.black;	
			
	// FUNCTIONS FOR JAVA SCRIPT
	
	// set a parameter from java script
	public void setParam(String nodeName,String Param,String Value) {
		
	 RNode n=null;	
	 if (nodeName.length()>0) n=tree.findNode(tree.Root,nodeName);
	 
	 tree.processParameter(n,Param.toUpperCase(),Value);
	 
	}
	
	// clear tree
	public void clearTree(String nodeName) {
	 RNode n=null;	
	 
	 if (nodeName.length()>0) n=tree.findNode(tree.Root,nodeName);		
	 
	 if (n==null) n=tree.Root;
	 
	 tree.clear(n);
	 
	 // collapse and expand root to update nodes
	 tree.expandNode(tree.Root.Name,false);
	 tree.expandNode(tree.Root.Name,true);
	 tree.refresh();
	 
	}	

	// load node from file
	public void loadNode(String nodeName,String sFile) {
	
	 // detele before loading new data	
	 clearTree(nodeName);	
		
	 RNode n=null;	
	 if (nodeName.length()>0) n=tree.findNode(tree.Root,nodeName);
	 
	 if (n==null) n=tree.Root;
	 
	 n.childrenDefinitionFile=sFile;
	 tree.createTreeFromFile(n,sFile);
	 // collapse and expand root to update nodes
	 tree.expandNode(tree.Root.Name,false);
	 tree.expandNode(tree.Root.Name,true);
	 tree.refresh();		

	}
	
	// refresh
	public void refreshTree() {
		tree.refresh();
	}	
	
	// END OF FUNCTIONS FOR JAVA SCRIPT
	
	
	public void init() {
		 
		  // set the applet of the tree
		  tree.parentApplet=this;
		
		   // read parameters for the applet itself , border
	 	  String param;
		  param=getStringParam("TREE_PAGE_BACK_COLOR","WHITE");
		  if (param.length()>0) pageBackColor=tree.convertColor(param);	
		  param=getStringParam("TREE_BORDER_COLOR","BLACK");
		  if (param.length()>0) borderColor=tree.convertColor(param);
		  
		  // text and image to show while loading
		  param=getStringParam("TREE_LOADING_TEXT","");
		  if (param.length()>0) tree.loadingText=param;		
		  param=getStringParam("TREE_LOADING_FONT","");
		  if (param.length()>0) tree.loadingFont=tree.convertFont(param);			  
		  param=getStringParam("TREE_LOADING_IMAGE","");
		  if (param.length()>0) tree.loadingImage=tree.loadImageUrl(param);		  
		  
		   param=getStringParam("TREE_BORDER","");
		  if (param.length()>0) {
			 if (param.compareTo("NO")==0) borderType=NO_BORDER;
			 if (param.compareTo("RAISED")==0) borderType=BORDER_RAISED;
			 if (param.compareTo("LINE")==0) borderType=BORDER_LINE;
			 if (param.compareTo("LINE2")==0) borderType=BORDER_LINE2;
			 if (param.compareTo("LOWERED")==0) borderType=BORDER_LOWERED;
			 if (param.compareTo("SHADOW")==0) borderType=BORDER_SHADOW;
			 if (param.compareTo("DOUBLE")==0) borderType=BORDER_DOUBLE;
		  }	 		  
		

		
		  this.setLayout(null);
		   
		  // size of the scroll area depends on the border's size
		  calculateBorderSize();
		  
		  // for canvas bor the border
		  if (leftBorder>0) {
			  appBorderLeft.setBounds(0,upperBorder,leftBorder,this.getSize().height-bottomBorder-upperBorder);
			  this.add(appBorderLeft);
		  }
		  if (rightBorder>0) {
			  appBorderRight.setBounds(this.getSize().width-rightBorder,upperBorder,rightBorder,this.getSize().height-bottomBorder-upperBorder);
			  this.add(appBorderRight);
		  }			  
		  if (upperBorder>0) {
			  appBorderTop.setBounds(0,0,this.getSize().width,upperBorder);
			  this.add(appBorderTop);
		  }
		  if (bottomBorder>0) {
			  appBorderBottom.setBounds(0,this.getSize().height-bottomBorder,this.getSize().width,bottomBorder);
			  this.add(appBorderBottom);
		  }

	  
		  setBorderBackground();
		  
		  tree.setBounds(leftBorder,upperBorder,this.getSize().width-rightBorder-leftBorder,this.getSize().height-upperBorder-bottomBorder);
		  this.add(tree);		  
	 
	}

	
	public void start() {	
		// start tree (this starts the initial animation)
		new Thread(tree).start();
	}
	
	
	private String getStringParam(String Param,String def) {

      return this.getParameter(Param, def);

    }


  //Get a parameter value
  private String getParameter(String key, String def) {
    if (getParameter(key) != null) return getParameter(key) ;
    else return def;
  }	
	
	
	
  // the color of the canvas are used to simulate the border
  public void setBorderBackground() {
	 
     if ((borderType==BORDER_LINE)|| (borderType==BORDER_LINE2)) {
		   appBorderLeft.setBackground(borderColor);
		   appBorderTop.setBackground(borderColor);
		   appBorderBottom.setBackground(borderColor);
		   appBorderRight.setBackground(borderColor);
	   }
	   
	   if (borderType==BORDER_LOWERED)  {
		   
		   appBorderLeft.setBackground(java.awt.Color.darkGray);
		   appBorderTop.setBackground(java.awt.Color.darkGray);
		   appBorderBottom.setBackground(java.awt.Color.white);
		   appBorderRight.setBackground(java.awt.Color.white);
	   }	   
	   
	   if ((borderType==BORDER_RAISED) || (borderType==BORDER_DOUBLE)) {
		   appBorderBottom.setBackground(java.awt.Color.darkGray);
		   appBorderRight.setBackground(java.awt.Color.darkGray);
		   appBorderTop.setBackground(java.awt.Color.white);
		   appBorderLeft.setBackground(java.awt.Color.white);
	   }		 
		 
			
	   if (borderType==BORDER_DOUBLE) {

		   appBorderBottom.setBackground(borderColor);
		   appBorderRight.setBackground(borderColor);
		   appBorderTop.setBackground(borderColor);
		   appBorderLeft.setBackground(borderColor);		  
	
		}	   		  
  }

  
	  // calculate size of the canvas used to simulate the border
	private void calculateBorderSize() {
	
	   if ((borderType==BORDER_LINE)|| (borderType==BORDER_LINE2)) {
		   upperBorder=1;
		   leftBorder=1;
		   bottomBorder=1;
		   rightBorder=1;
		   if (borderType==BORDER_LINE2) {
		     upperBorder=2;
		     leftBorder=2;
		     bottomBorder=2;
		     rightBorder=2;			   
		   }
	   }
	   
	   if (borderType==BORDER_LOWERED)  {
		   upperBorder=1;
		   leftBorder=1;
		   bottomBorder=1;
		   rightBorder=1;		   
	   }	   
	   
	   if ((borderType==BORDER_RAISED) || (borderType==BORDER_DOUBLE)) {
		   upperBorder=1;
		   leftBorder=1;
		   bottomBorder=1;
		   rightBorder=1;	
	   }
	   
	   if (borderType==BORDER_DOUBLE) {
		   upperBorder=4;
		   leftBorder=4;
		   bottomBorder=4;
		   rightBorder=4;
	   }	
	   
	    if (borderType==BORDER_SHADOW) {
		   upperBorder=0;
		   leftBorder=0;
		   bottomBorder=4;
		   rightBorder=4;			
		}	   
	
	} 
	
	
	// Border class
	private class borderCanvas  extends Canvas {
		
	int borderSide=0;	
		
	public borderCanvas(int side) {
		 borderSide=side;
		
	}
		
	public void paint(Graphics g) {
	 		 
			
	   if (borderType==BORDER_DOUBLE) {
		   
		   if (borderSide==TOP_BORDER) {
		     // upper
			 g.setColor(java.awt.Color.white);
		     g.drawLine(0,0,this.getSize().width,0); 
			 g.setColor(java.awt.Color.darkGray);
			 g.drawLine(3,3,this.getSize().width-4,3);
			 
			 // left border segment
			 g.setColor(java.awt.Color.white);
			 g.drawLine(0,0,0,this.getSize().height);
			 // right border segment
			 g.setColor(java.awt.Color.darkGray);
			 g.drawLine(this.getSize().width-1,0,this.getSize().width-1,this.getSize().height);
			 		   
		   }
		   
		   // left
		   if (borderSide==LEFT_BORDER) {
		     g.setColor(java.awt.Color.darkGray);
		     g.drawLine(3,0,3,this.getSize().height);
			 g.setColor(java.awt.Color.white);
			 g.drawLine(0,0,0,this.getSize().height);
			 
			 
		   }	
		   
		   // right
		   if (borderSide==RIGHT_BORDER) {
			  
			 g.setColor(java.awt.Color.white);
			 g.drawLine(this.getSize().width-4,0,this.getSize().width-4,this.getSize().height);
		     g.setColor(java.awt.Color.darkGray);
		     g.drawLine(this.getSize().width-1,0,this.getSize().width-1,this.getSize().height);			 
		   }
		   
		   // bottom
		   if (borderSide==BOTTOM_BORDER) {
			 g.setColor(java.awt.Color.white);
			 g.drawLine(3,0,this.getSize().width-4,0); 
		     g.setColor(java.awt.Color.darkGray);
		     g.drawLine(0,this.getSize().height-1,this.getSize().width,this.getSize().height-1); 
			 
			 // left border segment
			 g.setColor(java.awt.Color.white);
			 g.drawLine(0,0,0,this.getSize().height);
			 // right border segment
			 g.setColor(java.awt.Color.darkGray);
			 g.drawLine(this.getSize().width-1,0,this.getSize().width-1,this.getSize().height);			 
		   }		      
	   }	
	   
	    if (borderType==BORDER_SHADOW) {
			
			if (borderSide==BOTTOM_BORDER) {
			
  			  g.setColor(pageBackColor);
			  // simulate page backgorund
		      // bottom
		      g.fillRect(0,0,6,4); 
			  g.setColor(java.awt.Color.darkGray);
		      // bottom
		      g.fillRect(6,0,this.getSize().width-6,4);  
			
			}
			
			if (borderSide==RIGHT_BORDER) {
				
		      // right
		     g=appBorderRight.getGraphics();
		     g.setColor(pageBackColor);
		     g.fillRect(0,0,4,6); 
		     g.setColor(java.awt.Color.darkGray); 
		      // right
		     g.fillRect(0,6,4,appBorderRight.getSize().height); 
		   
			}
		   
		}	   		
		
		}
		
	}
	
}
