//  RTree version 1.1
//  Copyright (C)
//
//  RReport@Confluencia.net
//  All rights reserved
//
// Adquisition , use and distribution of this code is subject to restriction:
//  - You may modify the source code in order to adapt it to your needs.
//  - Redistribution of this ( or a modifed version) source code is prohibited. You may only redistribute compiled versions.
//  - You may not remove this notice from the source code
//  - This notice disclaim all warranties of all material
//


package MSBTree;

import java.awt.*;

public class RNode
{
	
	// state of the node
	public boolean expanded=false;
	public boolean selected=false;
	
	// properties of the node
	public java.awt.Image icon=null;	
	public boolean raisedEffectOnSelection=false;
	public java.awt.Image expandedIcon=null; // image to show when node is selected
	public java.awt.Font font=new java.awt.Font("Arial",java.awt.Font.PLAIN,10);
	public String text="";
	public Color color=java.awt.Color.black;
	public Color selectedColor=java.awt.Color.black; // color of the font when node is selected
	public Color backColor;
	public Color selectedBackColor;	
	public String Name="";
	public Object userValue=null;
	public RNode parent;
	// tip configuration
	public String tipText="";
	public boolean childrenDefinitionLoaded=false;
	public String childrenDefinitionFile="";
	public Image backImage=null;
	public boolean centerText=false;
	
	// for RMenu, configuration of the submenu for this node
	public static final int SBORDER_NO=0;
	public static final int SBORDER_RAISED=1;
	public static final int SBORDER_LINE=2;
	public int submenuBorder=SBORDER_NO;
	public Image submenuImage=null;
	public java.awt.Color submenuColor=null;
	public java.awt.Color submenuBorderColor=java.awt.Color.black;
	public boolean submenuInverted=false;
	
	// target frame when opennig the link related to this node
	public String target="";
	
	// the position and size of this child as displayed. Only for visible nodes
	public int xPos;
	public int yPos;
	public int hSize;
	public int wSize;
	public int level=0;

	// position of the text
	public int xPosText;
	public int wSizeText;	
	
	private java.util.Vector Children= new java.util.Vector(10,5);
	
	
	// add child
	public void addChild(RNode c) {
		
		 Children.addElement(c);
		 c.parent=this;
		 c.expanded=false;
	}
	
	// get number of children
	public int getChildrenNumber() {
		 return Children.size();
	}
	
	// does this node has children?
	public boolean hasChildren() {
		
		// has children or a definition file?
	    return ((getChildrenNumber()>0) || (childrenDefinitionFile.length()>0));
			
	}
	
	// remove children
	public void deleteChildren() {
		 Children.removeAllElements();
		 childrenDefinitionLoaded=false;
		 expanded=false;
	}
	
	public void deleteChild(int c) {
		 Children.removeElementAt(c);
	}	
	
	// get Child at
	public RNode getChild(int n) {
		 return (RNode) Children.elementAt(n);
	}	
	
	
	// draw the node at the given positions
	public void draw(java.awt.Graphics g,int x, int y,int h,int w) {
		
	   Image i=icon;
	   
	   this.xPos=x;
	   this.yPos=y;
	   this.hSize=h;
	   this.wSize=w;	   
	   
	   if ((expanded) && (expandedIcon!=null)) i=expandedIcon;
	   
	   // back color
	   if ((backColor!=null) && (!selected)) {
		   g.setColor(backColor);
		   g.fillRect(x,y,w,h);
	   }
	   
	   if ((selectedBackColor!=null) && (selected)) {
		   g.setColor(selectedBackColor);
		   g.fillRect(x,y,w,h);
	   }	   
	   
	   // draw icon
	   int iconWidth=0;
	   //wSize=0;
	   if (i!=null) {
			int toCenterY=(h-i.getHeight(null))/2;
			if (toCenterY<0) toCenterY=0;		   
		   
		     g.drawImage(i,x,y+toCenterY,null);
			 iconWidth=i.getWidth(null);
			 if (iconWidth==-1) iconWidth=0;
			 //wSize=iconWidth;
			 
	   }	 
	   
	   // draw back images
	   if (backImage!=null) {
			int toCenterY=(h-backImage.getHeight(null))/2;
			if (toCenterY<0) toCenterY=0;
			
            int toCenterX=0;
			if (centerText) toCenterX=((w-(iconWidth+6)-backImage.getWidth(null))/2);
			if (toCenterX<0) toCenterX=0;			
			
			g.drawImage(backImage,x+iconWidth+6+toCenterX,y+toCenterY,null);	
			
	   }
	   
	   // draw text
	   g.setFont(font);
	   g.setColor(color);
	   if (selected) {
		     g.setColor(selectedColor);
	   }	 
	   
	   int textH=g.getFontMetrics().getHeight();
	   int textW=g.getFontMetrics().stringWidth(text);
	   
	   //wSize=wSize+textW; // size of the item
		
	   int toCenterY=0;
	   int toCenterX=0;
	   if (h>textH) toCenterY=((h-textH)/2);
	   
	   if (centerText) {
		    toCenterX=((w-(iconWidth+6)-textW)/2);
			if (toCenterX<0) toCenterX=0;
	   }
	   
	   xPosText=0;
	   wSizeText=0;
	   if (text.length()>0) {
		    g.drawString(text,x+iconWidth+6+toCenterX,y+textH+toCenterY-2);
			xPosText=x+iconWidth+6+toCenterX;
			wSizeText=textW;
	   }	
	   
	   // draw now RAISED effect

	   if ((raisedEffectOnSelection) && (selected)) {
		   
		   g.setColor(java.awt.Color.white);
		   // left line
		   g.drawLine(toCenterX+x+iconWidth+3,y+toCenterY-2,toCenterX+x+iconWidth+3,y+toCenterY+textH+2);
		   // upper line
		   g.drawLine(toCenterX+x+iconWidth+3,y+toCenterY-2,toCenterX+x+iconWidth+6+textW+5,y+toCenterY-2);
		   
		   g.setColor(java.awt.Color.darkGray);
		   // right line
		   g.drawLine(toCenterX+x+iconWidth+6+textW+5,y+toCenterY-2,toCenterX+x+iconWidth+6+textW+5,y+toCenterY+textH+2);
		   // bottom line
		   g.drawLine(toCenterX+x+iconWidth+3,y+toCenterY+textH+2,toCenterX+x+iconWidth+6+textW+5,y+toCenterY+textH+2);		   
		   
	   }
	   
	
	
	   
	}
							
	
	
}
