//  RTree version 1.1
//  Copyright (C)
//
//  RReport@Confluencia.net
//  All rights reserved
//
// Adquisition , use and distribution of this code is subject to restriction:
//  - You may modify the source code in order to adapt it to your needs.
//  - Redistribution of this ( or a modifed version) source code is prohibited. You may only redistribute compiled versions.
//  - You may not remove this notice from the source code
//  - This notice disclaim all warranties of all material
//

package MSBTree;

import java.awt.*;
import java.util.Vector;
import java.awt.event.*;
import java.io.*;


public class RMenu extends Panel implements Runnable
{

	// backgound image  
	public java.awt.Image backImage=null;
	private java.awt.Image backImage2=null; // backup
	
	// the two components, draw area and scroll bar
	private menuCanvas drawArea=new menuCanvas();
	
	// loaded images
	private Vector ImNames=new Vector(10,5);
	private Vector Images=new Vector(10,5);	
	
    // how to expand?
    public static final int EXPAND_ON_CLICK=0;
    public static final int EXPAND_ON_ENTER=1;
    public int expandOn=EXPAND_ON_ENTER; 
	
	// menu type
	public static final int MENU_VERTICAL=0;
	public static final int MENU_HORIZONTAL=1;
	public static final int MENU_DEFINED=2;
	
	
	public int menuType=MENU_VERTICAL;
	public int[] userDefinedX; // position of the items of the menu
	public int[] userDefinedY;
	
	// separator for horizontal menu
	public Image hSeparator;
	
	public int menuInternalMargin=1;
	
	// items alignment in menu;
	public static final int ALIGN_LEFT=0;
	public static final int ALIGN_RIGHT=1;
	public static final int ALIGN_CENTER=2;
	public int menuAlignment=ALIGN_LEFT;
	
	// time to wait before showing the tip
	public int tipDelay=300;
	
	// this is for the shareware version only showCopyright=true will display the link to rreport.8m.com
	private static final boolean showCopyright=false;
	private int copyrightH=0; // space reserved for the copyroght at the bottom of the canvas

	
	// text to show when loading
	public String loadingText="Loading ...";
	
	
	// waiting for a URL to be opened
	private boolean openingURL=false;
	public String openingURLText="Opening URL ..."; // text to show to the user 
	
	public java.awt.Color backColor=java.awt.Color.lightGray;
	public java.awt.Color backColor2=null; // backup, to detect if the back color has been changed
	
	// space reserved for icons left to the text
    public int iconsWidth=16;
	
	// default values for nodes		 
	java.awt.Image nodeIcon=null;	
	java.awt.Image nodeSelectedIcon=null; // image to show when node is selected
	Color nodeColor=java.awt.Color.black;
	Color nodeSelectedColor=java.awt.Color.black; // color of the font when node is selected
	Color nodeBackColor;
	Color nodeSelectedBackColor;	
	Color nodeSubmenuColor=null;
    Color nodeSubmenuBorderColor=java.awt.Color.black;	
	boolean nodeSubmenuInverted=false;
    Image nodeSubmenuImage;
	int nodeSubmenuBorder;
	Image nodeBackImage;
	boolean nodeCenterText;
	boolean nodeRaised;	
	Font nodeFont=new java.awt.Font("Arial",Font.PLAIN,12);
	
	// true while the tree is beign created
	private boolean isLoading=true; // when the tree is created it is loading
	// image to show while loading
	public java.awt.Image loadingImage=null;
	// font used to display LOADING text
	public Font loadingFont=new Font("Arial",Font.BOLD,12);
	
	// icon to display ifd there is a submenu
	public Image subMenuIcon=null;
	
	
	// cursor position
	private int cursorX;
	private int cursorY;
	private int cursorBase;	
	
	// tips configuration
	public boolean showTip=false;
	public Font tipFont=new java.awt.Font("Arial",java.awt.Font.PLAIN,10);
	public Color tipColor=java.awt.Color.black;
	public Color tipBorder=java.awt.Color.gray;
	public Color tipBack=java.awt.Color.yellow;	

	
	public RNode Root=new RNode(); // this node will never be displayed, it is for internal use
	public boolean showRoot=true;
	
	// displayed on screen
	Vector displayedNodes=new Vector(10,5);
	
	// lebel tab
	public int levelTab=20;
	public int leftMargin=10;
	public int topMargin=20;
	public java.awt.Color lineColor=java.awt.Color.darkGray;
	public java.awt.Color plusminusboxColor=java.awt.Color.white;
	public boolean drawLine=true;
	public boolean drawPlusMinus=true;
    private RNode currentNode=null;
	
	public Image plusImage;
	public Image minusImage;
	
	public java.applet.Applet parentApplet;
	public String defaultTarget="_top";

	// time when the cursor entered current node
	long enterTime=0;
	long showingTipTime=0;
	

	// size of items in the tree
	public int itemHeight=20;
	public int itemWidth=100;
	
	// Javascript events
	public String JSOnEnter="";
	public String JSOnExit="";
	public String JSOnLoad="";
	public String JSOnLoadEnd="";
	public String JSOnExpand="";
	public String JSOnSelect="";
	public String JSOnDblClick="";
	

	// CONSTRUCTOR
	public RMenu() {
		 Root.expanded=true;
		 Root.level=0;
		 Root.Name="Root";
		 
		 drawArea.parentPanel=this;


		 this.setLayout(new BorderLayout());
		 
		 //this.add("East",Scroll);
		 this.add("Center",drawArea);
		 

		 
	}
	
	// while loading this trext will be displayed
	private void paintLoadingText(Graphics g) {
		
		try{	
		  int iwidth=0;	
		  if (loadingImage!=null) {
			  g.drawImage(loadingImage,20,20,null);
			  iwidth=loadingImage.getWidth(null);
		  }	  
		  
		  g.setFont(loadingFont);
		  if (loadingText!=null) g.drawString(loadingText,iwidth+10+15,20+g.getFontMetrics().getHeight());
		} catch (Exception e)  {}
		
	}
	
	// add child to root
	public void addFirstLevelNode(RNode n) {
		 if ((showCopyright) && (Root.getChildrenNumber()>3)) return;
		 Root.addChild(n);
	}
	
	// draw children of node as menu
	public void paintMenu(Graphics g,RNode n,int nx,int ny) {
		
		if (!n.hasChildren()) return;
		
		// if vertical submenus shoul be opened to the left
		int xCorrection=0;
		if ((this.getSize().width-nx-itemWidth-itemWidth)<0) xCorrection=-2*itemWidth;		
		
		// horizontal
		if ((n.level==0) && (menuType==MENU_HORIZONTAL)) paintHMenu(g,n,nx,ny);
		
		// drop down, first level
		if ((n.level==1) && (menuType==MENU_HORIZONTAL)) { 
			// is the plase for dropping down?
			if (n.submenuInverted)
				 paintVMenu(g,n,nx,ny-(itemHeight*n.getChildrenNumber()));
			else paintVMenu(g,n,nx,ny+itemHeight);
														   
		}
		
		// submenu on the right side, level >1
		if ((n.level>1) && (menuType==MENU_HORIZONTAL)) {
			if (n.submenuInverted) paintVMenu(g,n,nx+n.wSize+ xCorrection,ny+itemHeight-(itemHeight*n.getChildrenNumber()));
			else paintVMenu(g,n,nx+n.wSize+ xCorrection,ny);
		}	
	
		// vertical menu
		if ((n.level==0) && (menuType==MENU_VERTICAL)) {
			paintVMenu(g,n,nx,ny);
		}	
		
		// submenu on the right side, level >0
		if ((n.level>0) && (menuType==MENU_VERTICAL)) {
			
			if (n.submenuInverted) paintVMenu(g,n,nx+n.wSize+ xCorrection,ny+itemHeight-(itemHeight*n.getChildrenNumber()));
			else paintVMenu(g,n,nx+n.wSize+ xCorrection,ny);
		}	
		
		// user defined positions
		if ((n.level==0) && (menuType==MENU_DEFINED)) paintUserMenu(g,n,userDefinedX,userDefinedY);
		
		// submenu on the right side, level >0
		if ((n.level>0) && (menuType==MENU_DEFINED)) {
			if (n.submenuInverted) paintVMenu(g,n,nx+n.wSize+ xCorrection,ny+itemHeight-(itemHeight*n.getChildrenNumber()));
			else paintVMenu(g,n,nx+n.wSize+ xCorrection,ny);		
		}	 
	  
	}
	
	// draw children of node as user defined menu
	public void paintUserMenu(Graphics g,RNode n,int[] userX, int[] userY) {
		
		try{
			
		  // print items in menu
		  for (int i=0; i<n.getChildrenNumber();i++) {
			  n.getChild(i).xPos=userX[i];
			  n.getChild(i).yPos=userY[i];						  
			  n.getChild(i).draw(g,userX[i],userY[i],itemHeight,itemWidth);
		  }
		  
		} catch (Exception e) {}  
		  
	}
	

	// draw children of node as vertical menu
	public void paintVMenu(Graphics g,RNode n,int x,int y) {
		
	
		  // calculate size of menu
		  int w=itemWidth;
		  int h=itemHeight*n.getChildrenNumber();		
		  
		  for (int i=0; i<n.getChildrenNumber();i++) {
			  g.setFont(n.getChild(i).font);
			  int textWidth=g.getFontMetrics().stringWidth(n.getChild(i).text);
			  if ((textWidth+iconsWidth+26)>itemWidth) w=textWidth+iconsWidth+26;
		  }	   
		  
		  paintMenuBack(g,n,x,y,w,h);
		  
		  // print items in menu
		  for (int i=0; i<n.getChildrenNumber();i++) {
			  n.getChild(i).xPos=x;
			  n.getChild(i).yPos=y+(i*itemHeight);
			  n.getChild(i).draw(g,x,y+(i*itemHeight),itemHeight,w);
			  
			  // if there is a submenu, draw icon
			  if ((n.getChild(i).hasChildren()) && (subMenuIcon!=null)) g.drawImage(subMenuIcon,x+w-(subMenuIcon.getWidth(null)+2),y+(i*itemHeight)+1,null);
		  }
	
	}	
	
	// draw children of node as horizontal menu
	public void paintHMenu(Graphics g,RNode n,int x,int y) {
		
		  // calculate size of menu
		  int w=this.getSize().width-leftMargin-leftMargin;
		  int h=itemHeight;
		
	      paintMenuBack(g,n,x,y,w,h);
		  
		  int x1=0; // position of the item
		  int x2=0; // position of the separator
		  int sepWidth=0;
		  int centeredWidth=(this.getSize().width/n.getChildrenNumber());
		  
		  int toCenterSep=0;
		  // width of the items separator
		  if (hSeparator!=null) {
			  sepWidth=hSeparator.getWidth(null);
			  toCenterSep=(itemHeight-hSeparator.getHeight(null))/2;
		  }	  
		  
		  // print items in menu
		  for (int i=0; i<n.getChildrenNumber();i++) {
			  
			  if (menuAlignment==ALIGN_LEFT) {
				     x1=x+(i*(sepWidth+itemWidth));
					 x2=x1-sepWidth;
			  }	 
			  
			  if (menuAlignment==ALIGN_CENTER) {
				   x1=x+(centeredWidth*i+ ((centeredWidth-itemWidth)/2));				   x2=centeredWidth*i;
			  }
			  
			  if (menuAlignment==ALIGN_RIGHT) {
				   x1=x+(this.getSize().width-((n.getChildrenNumber()-i)*(sepWidth+itemWidth)));
				   x2=x1-sepWidth;
			  }
			  
			  // separator 
			  if ((i>0) && (hSeparator!=null)) g.drawImage(hSeparator,x2,topMargin+toCenterSep,null);
				  
				  
			  n.getChild(i).xPos=x1;
			  n.getChild(i).yPos=topMargin;						  
			  n.getChild(i).draw(g,x1,topMargin,itemHeight,itemWidth);  
			  
		  }		  
		  
	}
	
	// paint background of menu
	public void paintMenuBack(Graphics g,RNode n,int x, int y, int w, int h) {
		
	  x=x-menuInternalMargin;
	  y=y-menuInternalMargin;
	  w=w+menuInternalMargin+menuInternalMargin;
	  h=h+menuInternalMargin+menuInternalMargin;
	  
	  // color
	  if (n.submenuColor!=null) {
		     g.setColor(n.submenuColor);
			 g.fillRect(x,y,w,h);	
	}
	
	// image
	if (n.submenuImage!=null) {
		
      int ImageW=n.submenuImage.getWidth(null);
      int ImageH=n.submenuImage.getHeight(null);
	  int tmpw=0; // how to draw from the image?
	  int tmph=0;
	  

	  if ((ImageW!=-1)  && (ImageH!=-1)) 
          for (int j=0;j<this.getSize().width;j=j+ImageW) {
            for (int i=0;i<this.getSize().height;i=i+ImageH) {
				tmpw=ImageW;
			    tmph=ImageH; 
				if ((j+tmpw)>this.getSize().width) tmpw=this.getSize().width-j;
				if ((j+tmph)>this.getSize().height) tmpw=this.getSize().height-i;
                g.drawImage(n.submenuImage,j,i,tmpw,tmph,0,0,tmpw,tmph,null);
            }
          }		
		
	}
	
	
	// border
	if (n.submenuBorder==n.SBORDER_LINE) {
		g.setColor(n.submenuBorderColor);
		g.drawRect(x,y,w,h);			
	}
	  
	if (n.submenuBorder==n.SBORDER_RAISED) {
		g.setColor(java.awt.Color.darkGray);
		g.drawLine(x+w,y,x+w,y+h);
		g.drawLine(x,y+h,x+w,y+h);
		g.setColor(java.awt.Color.white);
		g.drawLine(x,y,x,y+h);
		g.drawLine(x,y,x+w,y);		
	}	  
	
	}
	
	
	// returns current node from cursor position
	private RNode getCurrentNode(int x, int y) {
		RNode n;
		int selectableWidth;
		
		// to which displayed not belongs those coordinates?
		for (int i=0;i<displayedNodes.size();i++) {
		 n=(RNode) displayedNodes.elementAt(i);	
		 selectableWidth=n.xPosText+n.wSizeText;
		 
		 if ((n.level>1) || (this.menuType==MENU_VERTICAL)) selectableWidth=n.xPos+n.wSize;
			 
		 if ((n.xPos<=x) && ((selectableWidth) >=x) &&(n.yPos<=y) && ((n.yPos+n.hSize) >=y)) {
			  return n;
		 }	  
		}
		
	  return null;	
	}

	// thread's entry point
	public void run() {
		 
		 init();
	}
 	
	// initial display
	private void init()  {
		
	   if (parentApplet!=null)	this.createTreeFromParameters(parentApplet);


	   if (itemWidth==0) itemWidth=this.getSize().width;
	   loadNode(Root); // read def. file	
	   this.setBackground(backColor);
		
	   this.paintAll(this.getGraphics());
	   drawArea.paint(drawArea.getGraphics());
	   		
	   try {	   
	 Thread.sleep(200);  
	 drawArea.paint(drawArea.getGraphics());
	 
	} catch (Exception e)   {} 
	   
	}
	
	
	private void endLoading() {
		
		
	  if (!isLoading) return;
	  
	  isLoading=false;

	 	// trigger Javascript event
	  if (JSOnLoadEnd.length()>0) {		
		try {
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnLoadEnd,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	  }			
	
	}
	
	private void startLoading() {
		
		
	  if (isLoading) return;
	  
	  isLoading=true;

	 	// trigger Javascript event
	  if (JSOnLoad.length()>0) {
		  try {  
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnLoad,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	  }		
	  
	 
	}
	
	// paint tree
	public void paint(Graphics g) {
		

		 int visibleNodes=countNodesToDraw(Root);
		
		 if (!showRoot) visibleNodes--;
		 
		 super.paint(g);
		 drawArea.paint(drawArea.getGraphics());
	}
	
	
	// number of visible nodes
	public int countNodesToDraw(RNode n) {
		int childrenCount=0;
		
		// count visible children
		if (n.expanded) {
			for (int i=0;i<n.getChildrenNumber();i++) 
				 childrenCount=childrenCount+countNodesToDraw(n.getChild(i));
	   }
			
	   return childrenCount+1;		
			
	}
	
	
	// exapnd a node by name
	public void expandNode(String Name,boolean expand) {
		 RNode n=findNode(Root,Name);
		 
		 if (n!=null) {
			   n.expanded=expand;
			   if (n.expanded) 
				     // load node if not loaded 
                     loadNode(n);			   
		 }	 
	}
	
	// force redrawing
	public void refresh() {
		
		drawArea.paint(drawArea.getGraphics());
		this.paint(this.getGraphics());
		
		
	}
	
	
	// clear tree
	public void clear(RNode n) {
		
	   // delete children of children	
	   for (int i=0;i<n.getChildrenNumber();i++) clear(n.getChild(i));	
		
	   // delete children
       n.deleteChildren();	
	   n.childrenDefinitionFile="";
		
	}	
	
	// find a node by name
	public RNode findNode(RNode n,String Name ) {
		int childrenCount=0;
		RNode child;
		
		if (n==null) n=Root;
		
		if (n.Name.toLowerCase().compareTo(Name.toLowerCase())==0) return n;
		
		// count visible children

		for (int i=0;i<n.getChildrenNumber();i++) { 
				  child=findNode(n.getChild(i),Name);
			     if (child!=null) return child;
		}		 

		
		return null;
			
	}	
	
	// load an image, but do not load twice the same one!
	public Image loadImageUrl(String urlAdd) {
		
		if (urlAdd.toUpperCase().compareTo("NULL")==0) return null;
		
	    // try to find the image in the vector
		String name;
		for (int i=0;i<ImNames.size();i++) {
			 name=(String) ImNames.elementAt(i);
			 if (name.compareTo(urlAdd)==0) return (Image) Images.elementAt(i); 
		}
		
		// image not loaded yet, load it
        try{
			java.awt.MediaTracker mt = new java.awt.MediaTracker(this);
						
			// load image
			Image im=null;
			if (parentApplet==null) {
				
			  InputStream in = null; 
              byte[] b = null; 
              int size = 0; 
              in = getClass().getResourceAsStream(urlAdd); 
              if (in!=null){
                 size = in.available(); 
                 b  = new byte[size]; 
                 in.read(b); 

              } 
			  else return null;
			  
			  im=Toolkit.getDefaultToolkit().createImage(b); 
			}
			else { // load from applet
			 String tmpURL=parentApplet.getCodeBase()+urlAdd;
			 System.out.println(tmpURL);
			 im= parentApplet.getImage(new java.net.URL(tmpURL));
			}
			
			mt.addImage(im,0); mt.waitForID(0);
			int Width_im = im.getWidth(null);
			
			Images.addElement(im);
			ImNames.addElement(urlAdd);
			return im;
		}
		catch(Exception e){
		  String err=e.getMessage();
		  System.out.println(err);
		};		
								  
       return null;								  
	
	}
	

 // function to convert a String parameter to a color
 public java.awt.Color convertColor(String c) {
	 if (c.compareTo("NULL")==0) return null;
    if (c.compareTo("RED")==0) return java.awt.Color.red;
    if (c.compareTo("BLACK")==0) return java.awt.Color.black;
    if (c.compareTo("BLUE")==0) return java.awt.Color.blue;
    if (c.compareTo("CYAN")==0) return java.awt.Color.cyan;
    if (c.compareTo("DARKGRAY")==0) return java.awt.Color.darkGray;
    if (c.compareTo("GRAY")==0) return java.awt.Color.gray;
    if (c.compareTo("GREEN")==0) return java.awt.Color.green;
    if (c.compareTo("LIGHTGRAY")==0) return java.awt.Color.lightGray;
    if (c.compareTo("MAGENTA")==0) return java.awt.Color.magenta;
    if (c.compareTo("ORANGE")==0) return java.awt.Color.orange;
    if (c.compareTo("PINK")==0) return java.awt.Color.pink;
    if (c.compareTo("WHITE")==0) return java.awt.Color.white;
    if (c.compareTo("YELLOW")==0) return java.awt.Color.yellow;
    try {
       return java.awt.Color.decode(c);
    } catch (Exception e) {return java.awt.Color.black;}
  }

  // convert an applet parameter to a Font
  public java.awt.Font convertFont(String f) {

    String[] items=convertList(f);

   if (items==null) return null;

    if (items.length<3) return null;

    int s=java.awt.Font.PLAIN;
    if (items[1].compareTo("BOLD")==0) s=java.awt.Font.BOLD;
    if (items[1].compareTo("ITALIC")==0) s=java.awt.Font.ITALIC;

    try {
    return new java.awt.Font(items[0],s,new Integer(items[2]).intValue());
    }
    catch (Exception e) {return null;}

  }	
  
	
  // function to read parameters
private String[] convertList(String items){

   String[] itema=new String[500];
   int itemCount=0;

   // count number of items
   int p=items.indexOf("|");
   while (p>=0) {
      itema[itemCount++]=items.substring(0,p);
      items=items.substring(p+1,items.length());
      p=items.indexOf("|");
   }

   if (items.compareTo("")!=0) itema[itemCount++]=items;

   if (itemCount==0) return null;

   String[] result=new String[itemCount];
   for (int i=0;i<itemCount;i++) result[i]=itema[i];

   return result;

 }

   public void createTreeFromFile(RNode startNode,String sFile) {
	  String fileData=""; 
	  String param="";
	  String value="";
	  RNode currentNode=startNode;
	  
	  // this will displayed a short message that the tree is bweing loaded
	  startLoading();
	  drawArea.paint(drawArea.getGraphics());	
	   
	  
	  if (startNode!=null) startNode.childrenDefinitionLoaded=true;
	   
      // read the file and process the contents line by line
	   try {
		   BufferedReader in=null; 
		  
		  
			// read url  
			  // if there is no ://  then add codebase
			if ( (parentApplet!=null) && (sFile.indexOf(":/")==-1)) sFile=parentApplet.getCodeBase()+sFile;
		    java.net.URL u =new java.net.URL(sFile);
			//System.out.println("Opening: "+sFile);
			
	        in = new BufferedReader(
				new InputStreamReader(
				u.openStream()));
		  
		  //System.out.println("File opened");

          String inputLine="";
		  while ((inputLine = in.readLine()) != null) {    			
            fileData=fileData+inputLine+((char) 13)+((char) 10);

		  }
		  //System.out.println("File closed");
		  in.close();
	   } catch (Exception e) {
		    String err=e.getMessage();
			System.out.println("Could not open file: "+sFile+" "+e);
	   }
	   
	   
	   // split into lines
	   String line="";
	   int p;
	   int p2;
	   while (fileData.length()>0) {
		
		   p=fileData.indexOf(""+((char) 13)+((char) 10));
		   p2=fileData.indexOf(""+((char) 10));
		   if ((p<=p2) && (p>=0)) {// if line ends with 13 +10
			   line=fileData.substring(0,p);
			   fileData=fileData.substring(p+2,fileData.length());  			   
		   }   

		   if ((p>p2) && (p2>=0)) { // if line ends only with 10
			   line=fileData.substring(0,p2);
			   fileData=fileData.substring(p2+1,fileData.length());  			   
		   }
		   
		   if ((p2==-1) && (p==-1)) {
			   line=fileData;
			   fileData="";   
		   }
		   
		   // process line
		   // split line, parameter=value
		   p=line.indexOf("=");
		   if (p>-1) {
			   param=line.substring(0,p);
			   value=line.substring(p+1,line.length());
			   
			   param=param.toUpperCase();
			   
			   // is this a create node parameter?
		       // create new node
			   if (param.compareTo("CHILD")==0) {
		         currentNode=new RNode(); 
			     currentNode.Name=value;
			     currentNode.color=nodeColor;
			     currentNode.selectedBackColor=nodeSelectedBackColor;
			     currentNode.selectedColor=nodeSelectedColor;
			     currentNode.backColor=nodeBackColor;	
			     currentNode.icon=nodeIcon;
			     currentNode.expandedIcon=nodeSelectedIcon;
			     currentNode.raisedEffectOnSelection=nodeRaised;
			     currentNode.expanded=false;		
				 currentNode.centerText=nodeCenterText;
				 currentNode.backImage=nodeBackImage;
				 currentNode.font=nodeFont;
				 
				 // add node to parent
				 if (startNode==Root) this.addFirstLevelNode(currentNode);
				 else startNode.addChild(currentNode);
				 
			   } else	   
			     // process normal param
			     processParameter(currentNode,param,value);
			   
			   
		   }
		   
		   
	   }
	   
	   endLoading();
	   
	   
   }

	public void createTreeFromParameters(java.applet.Applet pApplet) {
		
	   startLoading();


	   drawArea.paint(drawArea.getGraphics());	

		
		parentApplet=pApplet;
		
		// parameters for the tree
		processParameter(null,"TREE_ON_ENTER",getStringParam("TREE_ON_ENTER",""));
		processParameter(null,"TREE_SUBMENU_ICON",getStringParam("TREE_SUBMENU_ICON",""));
		processParameter(null,"TREE_ON_EXIT",getStringParam("TREE_ON_EXIT",""));
		processParameter(null,"TREE_ON_LOAD",getStringParam("TREE_ON_LOAD",""));
		processParameter(null,"TREE_ON_LOAD_END",getStringParam("TREE_ON_LOAD_END",""));
		processParameter(null,"TREE_ON_SELECT",getStringParam("TREE_ON_SELECT",""));
		processParameter(null,"TREE_ON_EXPAND",getStringParam("TREE_ON_EXPAND",""));
		processParameter(null,"TREE_ON_DBL_CLICK",getStringParam("TREE_ON_DBL_CLICK",""));
		processParameter(null,"TREE_BORDER",getStringParam("TREE_BORDER",""));
		processParameter(null,"TREE_ANIMATION",getStringParam("TREE_ANIMATION",""));
		processParameter(null,"TREE_MENU_TYPE",getStringParam("TREE_MENU_TYPE",""));
		processParameter(null,"TREE_BACK_COLOR",getStringParam("TREE_BACK_COLOR",""));
		processParameter(null,"TREE_ITEM_HEIGHT",getStringParam("TREE_ITEM_HEIGHT",""));
		processParameter(null,"TREE_ITEM_WIDTH",getStringParam("TREE_ITEM_WIDTH",""));
		processParameter(null,"TREE_SEPARATOR",getStringParam("TREE_SEPARATOR",""));
		processParameter(null,"TREE_BACK_COLOR",getStringParam("TREE_BACK_COLOR",""));
		processParameter(null,"TREE_BOX_COLOR",getStringParam("TREE_BOX_COLOR",""));
		processParameter(null,"TREE_LEFT_MARGIN",getStringParam("TREE_LEFT_MARGIN",""));
		processParameter(null,"TREE_TOP_MARGIN",getStringParam("TREE_TOP_MARGIN",""));
		processParameter(null,"TREE_INTERNAL_MARGIN",getStringParam("TREE_INTERNAL_MARGIN",""));
		processParameter(null,"TREE_TARGET",getStringParam("TREE_TARGET",""));
		processParameter(null,"TREE_ITEMSX",getStringParam("TREE_ITEMSX",""));
		processParameter(null,"TREE_ITEMSY",getStringParam("TREE_ITEMSY",""));
		processParameter(null,"TREE_MENU_TYPE",getStringParam("TREE_MENU_TYPE",""));
		processParameter(null,"TREE_ITEMS_ALIGN",getStringParam("TREE_ITEMS_ALIGN",""));
		processParameter(null,"TREE_TIP_COLOR",getStringParam("TREE_TIP_COLOR",""));
		processParameter(null,"TREE_TIP_BACK_COLOR",getStringParam("TREE_TIP_BACK_COLOR",""));
		processParameter(null,"TREE_TIP_BORDER_COLOR",getStringParam("TREE_TIP_BORDER_COLOR",""));
		processParameter(null,"TREE_TIP_FONT",getStringParam("TREE_TIP_FONT",""));		
		processParameter(null,"TREE_PAGE_BACK_COLOR",getStringParam("TREE_PAGE_BACK_COLOR",""));
		processParameter(null,"TREE_BACK_IMAGE",getStringParam("TREE_BACK_IMAGE",""));
		processParameter(null,"TREE_TIP_DELAY",getStringParam("TREE_TIP_DELAY",""));
		processParameter(null,"TREE_LINE_TYPE",getStringParam("TREE_LINE_TYPE",""));
		processParameter(null,"TREE_DRAW_LINE",getStringParam("TREE_DRAW_LINE",""));
		processParameter(null,"TREE_LOAD_TEXT",getStringParam("TREE_LOAD_TEXT",""));
		processParameter(null,"TREE_OPEN_TEXT",getStringParam("TREE_OPEN_TEXT",""));
		processParameter(null,"TREE_ICON_WIDTH",getStringParam("TREE_ICON_WIDTH",""));
		processParameter(null,"TREE_ANIMATION_DELAY",getStringParam("TREE_ANIMATION_DELAY",""));
		
		processParameter(null,"NODE_COLOR",getStringParam("NODE_COLOR",""));
		processParameter(null,"NODE_SUBMENUCOLOR",getStringParam("NODE_SUBMENUCOLOR",""));
		processParameter(null,"NODE_SUBMENU_INVERTED",getStringParam("NODE_SUBMENU_INVERTED",""));
		processParameter(null,"NODE_SUBMENU_BORDER_COLOR",getStringParam("NODE_SUBMENU_BORDER_COLOR",""));
		processParameter(null,"NODE_SUBMENU_BORDER",getStringParam("NODE_SUBMENU_BORDER",""));
		processParameter(null,"NODE_SUBMENU_IMAGE",getStringParam("NODE_SUBMENU_IMAGE",""));
		processParameter(null,"NODE_RAISED",getStringParam("NODE_RAISED",""));
		processParameter(null,"NODE_SELECTED_COLOR",getStringParam("NODE_SELECTED_COLOR",""));
		processParameter(null,"NODE_BACK_COLOR",getStringParam("NODE_BACK_COLOR",""));
		processParameter(null,"NODE_SELECTED_BACK_COLOR",getStringParam("NODE_SELECTED_BACK_COLOR",""));
		processParameter(null,"NODE_ICON",getStringParam("NODE_ICON",""));
		processParameter(null,"NODE_CENTER_TEXT",getStringParam("NODE_CENTER_TEXT",""));
		processParameter(null,"NODE_BACK_IMAGE",getStringParam("NODE_BACK_IMAGE",""));
		processParameter(null,"NODE_EXPANDED_ICON",getStringParam("NODE_EXPANDED_ICON",""));
		processParameter(null,"NODE_FONT",getStringParam("NODE_FONT",""));
		
	    // create now nodes
        createNode(null);
		
		endLoading();

	}
	
	// create a node and set all properties from parameters
	private void createNode(RNode parent) {
		
	   String pName="";
	   String cName="";
	   int child=1;
	   RNode n;
	   
	   if (parent!=null) pName=parent.Name;
	   else pName="ROOT";
	   
	   if (parent==null) { // this is the root
	    // if show root, then get params for the root
	    if (getStringParam("SHOW_ROOT","").compareTo("Y")==0) 
		    this.showRoot=true;	
	    else this.showRoot=false;
		
		
		this.Root.color=nodeColor;
		this.Root.selectedBackColor=nodeSelectedBackColor;
		this.Root.selectedColor=nodeSelectedColor;
		this.Root.backColor=nodeBackColor;	
		this.Root.icon=nodeIcon;
		this.Root.expandedIcon=nodeSelectedIcon;	
		this.Root.raisedEffectOnSelection=nodeRaised;
		this.Root.centerText=nodeCenterText;
		this.Root.backImage=nodeBackImage;		
		this.Root.font=nodeFont;	
		this.Root.submenuBorder=nodeSubmenuBorder;
		this.Root.submenuInverted=nodeSubmenuInverted;
		this.Root.submenuBorderColor=nodeSubmenuBorderColor;
		this.Root.submenuColor=nodeSubmenuColor;
		this.Root.submenuImage=nodeSubmenuImage;
		createNodeFromParameters(Root,"ROOT");
		
		// if we have a file for the root
		if (this.Root.childrenDefinitionFile.length()>0) loadNode(Root);		
	   }
	   
	   
	   cName=getStringParam(pName+"_"+child,"");
	   while (cName.length()>0) {
		   
		    // create new node
		    n=new RNode(); 
			n.Name=cName;
			n.color=nodeColor;
			n.selectedBackColor=nodeSelectedBackColor;
			n.selectedColor=nodeSelectedColor;
			n.backColor=nodeBackColor;	
			n.icon=nodeIcon;
			n.expandedIcon=nodeSelectedIcon;
			n.raisedEffectOnSelection=nodeRaised;
			n.centerText=nodeCenterText;
			n.backImage=nodeBackImage;			
			n.expanded=false;
			n.font=nodeFont;
		    n.submenuBorder=nodeSubmenuBorder;
			n.submenuInverted=nodeSubmenuInverted;
		    n.submenuBorderColor=nodeSubmenuBorderColor;
		    n.submenuColor=nodeSubmenuColor;
		    n.submenuImage=nodeSubmenuImage;			
		
		   
			// add to parent
		    if (parent==null) this.addFirstLevelNode(n);
			else parent.addChild(n);
			
			// parameters for this node
			createNodeFromParameters(n,cName);
			
			// create children
			createNode(n);
			
			// next node in the same level
		    child++;
		   	cName=getStringParam(pName+"_"+child,"");
	   }
	   
	
	}
	
	// process parameters refering to current node
	private void createNodeFromParameters(RNode n,String nodeName) {
		
		processParameter(n,"FONT",getStringParam(nodeName+"_FONT",""));
		processParameter(n,"COLOR",getStringParam(nodeName+"_COLOR",""));
		processParameter(n,"SELECTED_COLOR",getStringParam(nodeName+"_SELECTED_COLOR",""));
		processParameter(n,"BACK_COLOR",getStringParam(nodeName+"_BACK_COLOR",""));
		processParameter(n,"SUBMENUCOLOR",getStringParam(nodeName+"_SUBMENUCOLOR",""));
		processParameter(n,"SUBMENU_BORDER_COLOR",getStringParam(nodeName+"_SUBMENU_BORDER_COLOR",""));
		processParameter(n,"SUBMENU_BORDER",getStringParam(nodeName+"_SUBMENU_BORDER",""));
		processParameter(n,"SUBMENU_IMAGE",getStringParam(nodeName+"_SUBMENU_IMAGE",""));
		processParameter(n,"SUBMENU_INVERTED",getStringParam(nodeName+"_SUBMENU_INVERTED",""));
		processParameter(n,"SELECTED_BACK_COLOR",getStringParam(nodeName+"_SELECTED_BACK_COLOR",""));
		processParameter(n,"TEXT",getStringParam(nodeName+"_TEXT",""));
		processParameter(n,"LINK",getStringParam(nodeName+"_LINK",""));
		processParameter(n,"ICON",getStringParam(nodeName+"_ICON",""));
		processParameter(n,"EXPANDED_ICON",getStringParam(nodeName+"_EXPANDED_ICON",""));	
		processParameter(n,"RAISED",getStringParam(nodeName+"_RAISED",""));	
		processParameter(n,"BACK_IMAGE",getStringParam(nodeName+"_BACK_IMAGE",""));	
		processParameter(n,"CENTER_TEXT",getStringParam(nodeName+"_CENTER_TEXT",""));	
		processParameter(n,"DATA_FILE",getStringParam(nodeName+"_DATA_FILE",""));	
		processParameter(n,"TIP",getStringParam(nodeName+"_TIP",""));
		processParameter(n,"TARGET",getStringParam(nodeName+"_TARGET",""));
		processParameter(n,"EXPANDED",getStringParam(nodeName+"_EXPANDED",""));
		
	}

 // item list
 private String[] getItemsParameter(String key) {
   String items=getStringParam(key,"");
   return convertList(items);

 }	
	
 // get a aparameter as string
  private String getStringParam(String Param,String def) {

      return this.getParameter(Param, def);
	 

    }


  //Get a parameter value
  private String getParameter(String key, String def) {
    if (parentApplet.getParameter(key) != null) return parentApplet.getParameter(key) ;
    else return def;
  }	

// process a paramter
public void processParameter(RNode currentNode,String ParamName, String ParamValue) {
		
		try {
		
		if (ParamValue.length()==0) return;

		
		
		if (ParamName.compareTo("TREE_EXPAND_MODE")==0) {
			 if (ParamValue.compareTo("ON_CLICK")==0) this.expandOn=EXPAND_ON_CLICK;
		     if (ParamValue.compareTo("ON_ENTER")==0) this.expandOn=EXPAND_ON_ENTER;
		}	 
		
		if (ParamName.compareTo("TREE_MENU_TYPE")==0) {
			if (ParamValue.compareTo("VERTICAL")==0) this.menuType=this.MENU_VERTICAL;
			if (ParamValue.compareTo("HORIZONTAL")==0) this.menuType=this.MENU_HORIZONTAL;
			if (ParamValue.compareTo("DEFINED")==0) this.menuType=this.MENU_DEFINED;
		}
		
		if (ParamName.compareTo("TREE_ITEMS_ALIGN")==0) {
			if (ParamValue.compareTo("LEFT")==0) this.menuAlignment=this.ALIGN_LEFT;
			if (ParamValue.compareTo("RIGHT")==0) this.menuAlignment=this.ALIGN_RIGHT;
			if (ParamValue.compareTo("CENTER")==0) this.menuAlignment=this.ALIGN_CENTER;
		}
		
		if (ParamName.compareTo("TREE_ITEMSX")==0) {
			String[] l=convertList(ParamValue);
			if (l!=null) {
				int[] d=new  int[l.length];
				for (int i=0;i<l.length;i++) d[i]=new Integer(l[i]).intValue();
				userDefinedX=d;
			}	
		}
		
		if (ParamName.compareTo("TREE_ITEMSY")==0) {
			String[] l=convertList(ParamValue);
			if (l!=null) {
				int[] d=new  int[l.length];
				for (int i=0;i<l.length;i++) d[i]=new Integer(l[i]).intValue();
				userDefinedY=d;
			}				
		}		
		
	    if (ParamName.compareTo("TREE_ON_ENTER")==0) this.JSOnEnter=ParamValue;		
		if (ParamName.compareTo("TREE_ON_EXIT")==0) this.JSOnExit=ParamValue;	
		if (ParamName.compareTo("TREE_ON_LOAD")==0) this.JSOnLoad=ParamValue;	
		if (ParamName.compareTo("TREE_ON_LOAD_END")==0) this.JSOnLoadEnd=ParamValue;	
		if (ParamName.compareTo("TREE_ON_DBL_CLICK")==0) this.JSOnDblClick=ParamValue;	
		if (ParamName.compareTo("TREE_ON_SELECT")==0) this.JSOnSelect=ParamValue;
		if (ParamName.compareTo("TREE_ON_EXPAND")==0) this.JSOnExpand=ParamValue;	
		
		if (ParamName.compareTo("TREE_BACK_IMAGE")==0) backImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("TREE_SEPARATOR")==0) this.hSeparator=loadImageUrl(ParamValue);
	    
	    if (ParamName.compareTo("TREE_SUBMENU_ICON")==0) this.subMenuIcon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("TREE_TARGET")==0) this.defaultTarget=ParamValue;
		
		if (ParamName.compareTo("TREE_LOAD_TEXT")==0) this.loadingText=ParamValue;
		
		if (ParamName.compareTo("TREE_OPEN_TEXT")==0) this.openingURLText=ParamValue;
			
		try {
		if (ParamName.compareTo("TREE_TIP_DELAY")==0) this.tipDelay=new Integer(ParamValue).intValue();
		} catch (Exception e) {}
		
	
		if (ParamName.compareTo("TREE_ICON_WIDTH")==0) this.iconsWidth=new Integer(ParamValue).intValue();
		
		
		
		if (ParamName.compareTo("TREE_LEFT_MARGIN")==0) this.leftMargin=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_TOP_MARGIN")==0) this.topMargin=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_INTERNAL_MARGIN")==0) this.menuInternalMargin=new Integer(ParamValue).intValue();
		
	    if (ParamName.compareTo("TREE_ITEM_HEIGHT")==0) this.itemHeight=new Integer(ParamValue).intValue();
		
		if (ParamName.compareTo("TREE_ITEM_WIDTH")==0) this.itemWidth=new Integer(ParamValue).intValue();	
	
	    if (ParamName.compareTo("TREE_LINE_COLOR")==0) this.lineColor=convertColor(ParamValue);	
		
		if (ParamName.compareTo("TREE_BOX_COLOR")==0) this.plusminusboxColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("TREE_BACK_COLOR")==0) this.backColor=convertColor(ParamValue);		
		
		if (ParamName.compareTo("NODE_SUBMENU_BORDER")==0) {
			 if (ParamValue.compareTo("NO")==0) nodeSubmenuBorder=RNode.SBORDER_NO;
			 if (ParamValue.compareTo("LINE")==0) nodeSubmenuBorder=RNode.SBORDER_LINE;
			 if (ParamValue.compareTo("RAISED")==0) nodeSubmenuBorder=RNode.SBORDER_RAISED;
		}		
		
		if (ParamName.compareTo("NODE_SUBMENU_INVERTED")==0) nodeSubmenuInverted=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("NODE_SUBMENU_BORDER_COLOR")==0) nodeSubmenuBorderColor=convertColor(ParamValue);
			
		if (ParamName.compareTo("NODE_SUBMENUCOLOR")==0) nodeSubmenuColor=convertColor(ParamValue);
			
	    if (ParamName.compareTo("NODE_SUBMENU_IMAGE")==0) nodeSubmenuImage=loadImageUrl(ParamValue);		
		
		if (ParamName.compareTo("NODE_COLOR")==0) nodeColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_CENTER_TEXT")==0) nodeCenterText=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("NODE_BACK_IMAGE")==0) nodeBackImage=loadImageUrl(ParamValue);

		if (ParamName.compareTo("TREE_TIP_FONT")==0) this.tipFont=convertFont(ParamValue);		
		
		if (ParamName.compareTo("TREE_TIP_COLOR")==0) this.tipColor=convertColor(ParamValue);

		if (ParamName.compareTo("TREE_TIP_BACK_COLOR")==0) this.tipBack=convertColor(ParamValue);
		
		if (ParamName.compareTo("TREE_TIP_BORDER_COLOR")==0) this.tipBorder=convertColor(ParamValue);		
		
		if (ParamName.compareTo("NODE_SELECTED_COLOR")==0) nodeSelectedColor=convertColor(ParamValue);

		if (ParamName.compareTo("NODE_BACK_COLOR")==0) nodeBackColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_SELECTED_BACK_COLOR")==0) nodeSelectedBackColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("NODE_ICON")==0) nodeIcon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("NODE_RAISED")==0) nodeRaised=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("NODE_EXPANDED_ICON")==0) nodeSelectedIcon=loadImageUrl(ParamValue);
	
	     if (ParamName.compareTo("NODE_FONT")==0)  nodeFont=convertFont(ParamValue);		
		
		// parameters of the node
		
		if (ParamName.compareTo("FONT")==0)  currentNode.font=convertFont(ParamValue);

		if (ParamName.compareTo("TARGET")==0)  currentNode.target=ParamValue;
		
		if (ParamName.compareTo("TIP")==0)  currentNode.tipText=ParamValue;

		if (ParamName.compareTo("COLOR")==0) currentNode.color=convertColor(ParamValue);
		
		if (ParamName.compareTo("SUBMENUCOLOR")==0) currentNode.submenuColor=convertColor(ParamValue);
		
		if (ParamName.compareTo("SUBMENU_BORDER")==0) {
			 if (ParamValue.compareTo("NO")==0) currentNode.submenuBorder=RNode.SBORDER_NO;
			 if (ParamValue.compareTo("LINE")==0) currentNode.submenuBorder=RNode.SBORDER_LINE;
			 if (ParamValue.compareTo("RAISED")==0) currentNode.submenuBorder=RNode.SBORDER_RAISED;
		}
		
		if (ParamName.compareTo("SUBMENU_BORDER_COLOR")==0) currentNode.submenuBorderColor=convertColor(ParamValue);
				
		if (ParamName.compareTo("SELECTED_COLOR")==0) currentNode.selectedColor=convertColor(ParamValue);	
		
		if (ParamName.compareTo("BACK_COLOR")==0) currentNode.backColor=convertColor(ParamValue);
					
		if (ParamName.compareTo("SELECTED_BACK_COLOR")==0) currentNode.selectedBackColor=convertColor(ParamValue);
				
		if (ParamName.compareTo("TEXT")==0) currentNode.text=ParamValue;
		
		if (ParamName.compareTo("LINK")==0) currentNode.userValue=ParamValue;
		
		if (ParamName.compareTo("BACK_IMAGE")==0) currentNode.backImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("SUBMENU_IMAGE")==0) currentNode.submenuImage=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("CENTER_TEXT")==0) currentNode.centerText=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("ICON")==0) currentNode.icon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("DATA_FILE")==0) {
			  currentNode.childrenDefinitionFile=ParamValue;
			  if (currentNode.expanded) loadNode(currentNode); // read also the data file is the node is expanded
		}	  
		
		if (ParamName.compareTo("EXPANDED_ICON")==0) currentNode.expandedIcon=loadImageUrl(ParamValue);
		
		if (ParamName.compareTo("RAISED")==0) currentNode.raisedEffectOnSelection=(ParamValue.compareTo("Y")==0);
		
		if (ParamName.compareTo("EXPANDED")==0) {
			  currentNode.expanded=(ParamValue.compareTo("Y")==0);
			  if (currentNode.expanded) loadNode(currentNode);
		}		  
			  
				
		} catch (Exception e) {System.out.println(e.getMessage());}	
	
	}
	
	// load a node's children from the data file
	private void loadNode(RNode n) {
		
		if (n.expanded) {
			if ((n.childrenDefinitionFile.length()>0)  && (!n.childrenDefinitionLoaded)) {
				createTreeFromFile(n,n.childrenDefinitionFile);
				n.childrenDefinitionLoaded=true;
			}
		}
		
	}
	
	// draw node and its children 
	public void drawNode(java.awt.Graphics g,RNode n,int level,boolean redrawChildren) {
		
		RNode lastChild=null;
		RNode Child;
		int x=levelTab*level+leftMargin; 
		n.level=level; // save this node's level
		int nodeIndex=0;
		
		// this is to avoid the root node being displayed
		if (level>=1) {
		  // add to the list of displayed nodes
		  displayedNodes.addElement(n); }
		else {  
		  n.xPos=leftMargin; // root
		  n.yPos=topMargin;	
		  nodeIndex=-1;
		}
		
	   n.level=level;	
	   if (n.expanded) {
		   
		   paintMenu(g,n,n.xPos,n.yPos);
		
           if (redrawChildren) {
		
		    for (int i=0;i<n.getChildrenNumber();i++) {
				 drawNode(g,n.getChild(i),level+1,true);
				 lastChild=n.getChild(i);
		    }
			
		} // redraw children
	   } // expanded	   
			
	}		

private void performAction(RNode n) {
	
	
 	// trigger Javascript event
	if (JSOnDblClick.length()>0) {
		
		try {
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);

		Object[] o=new Object[1];
		o[0]=n.Name;
		JS.call(JSOnDblClick,o);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	}	
	
	// open a http
	if ((n.userValue!=null) && (parentApplet!=null)) {
		if (n.userValue instanceof String) {
			String add=""; // address
			String target=""; // target frame
			String val=(String) n.userValue;
			
			int p=val.indexOf("|");
			if (p>-1) {
				add=val.substring(0,p);
				target=val.substring(p+1,val.length());
			}
			else {add=val;
				  target=defaultTarget;
			}
			
			try {
			   // show text to user	
			   openingURL=true;
			   this.paint(this.getGraphics());
			   
			   String urlAdd=add;
			   // if there is no :, I asume it is a relative address, add CodeBase()
			   if (add.indexOf("://")==-1) urlAdd=parentApplet.getCodeBase()+add;
			   
			   if (n.target.length()>0) target=n.target;
			   
			   parentApplet.getAppletContext().showDocument(new java.net.URL(urlAdd),target);
			} catch (Exception e) {}
			
			// remove text
			openingURL=false;
			this.paint(this.getGraphics());			
			
		}
	}
  
}





// canvas classe to draw tree
private class menuCanvas extends Canvas implements MouseMotionListener,MouseListener {

	
	// Images used to store the tree
	private Image treeLayer;
	private Image backLayer;
	private Image finalImage; // combination fo the 2 layers
	
	public RMenu parentPanel;
	
	public menuCanvas() {
		 this.addMouseMotionListener(this);
		 this.addMouseListener(this);		
	}
	
   // draw the background, repeating the back images as many times as needed	
   private void drawBackImage(java.awt.Graphics g) {
		
	  if (backImage==null) return;	

      int ImageW=backImage.getWidth(null);
      int ImageH=backImage.getHeight(null);

	  if ((ImageW==-1)  || (ImageH==-1)) return;

          for (int j=0;j<this.getSize().width;j=j+ImageW) {
            for (int i=0;i<this.getSize().height;i=i+ImageH) {
               g.drawImage(backImage,j,i,null);
            }
          }


   }	
		
  
	
	public void collapseNotInPath(RNode n) {
		boolean inPath;
		RNode n1;
		
	   for (int i=0;i<displayedNodes.size();i++) {
		   inPath=false;
		   n1=(RNode) displayedNodes.elementAt(i);
		   // is this node?
		   if (n==n1) inPath=true;
		   // is the parent
		   if (n.parent==n1) inPath=true;
		   // parent of parent
		   if (n.parent!=null)
		           if (n.parent.parent==n1) inPath=true;
		   if (n.parent.parent!=null)
			       if (n.parent.parent.parent==n1) inPath=true; 
		  
		   if (!inPath) n1.expanded=false;   
	   }
	   
	}
	
	
	// draw the tree
	public void paint(java.awt.Graphics g) {
		boolean firstTime=false; // has the applet been displayed for the first time?
		boolean createImages=false;
		
		
		if (g==null) return;
		
		// just draw message is the tree is loading
		if (isLoading) {paintLoadingText(g);  
						return;
		}		

		
		// if we have not created the images yet
		if (treeLayer==null) {
			  createImages=true;
			  firstTime=true;	  
		}	  
		
		// if the canvas has been resized
		if (treeLayer!=null)
			if (this.getSize().height!=treeLayer.getHeight(null)) createImages=true;
		
		// draw back color
		if (createImages) {
		  cursorBase=0;	

		  backLayer=this.createImage(this.getSize().width,this.getSize().height);	

		  // final image
		  finalImage=this.createImage(this.getSize().width,this.getSize().height);
		  
		  // create tree image
		  treeLayer=this.createImage(this.getSize().width,this.getSize().height);
		  

		}
	
		// repaint background
		if ((backColor!=null) && ((backColor!=backColor2)|| (createImages))) {
			
			java.awt.Graphics g1=backLayer.getGraphics();
			g1.setColor(backColor); 
			g1.fillRect(0,0,this.getSize().width,this.getSize().height);
			backColor2=backColor;
		}			
		
		// reload background
		if ((backImage!=backImage2) || (createImages)) {

			drawBackImage(backLayer.getGraphics());
		}	
		
		if ((backImage2!=null) && (backImage==null)) {
			 // there was an image but not any more, delete it
			
			if (backColor!=null) {

			  java.awt.Graphics g1=backLayer.getGraphics();
			  g1.setColor(backColor); 
			  g1.fillRect(0,0,this.getSize().width,this.getSize().height);
			}			
		}
		
		backImage2=backImage; // backup
		
		
		displayedNodes.removeAllElements();
		
		// copy background layer to tree layer
		treeLayer.getGraphics().drawImage(backLayer,0,0,null);
		
		// draw tree in foreground layer
		drawNode(treeLayer.getGraphics(),Root,0,true);
		
		
		
        // show tip
		if (currentNode!=null)
	     if ((showingTipTime!=0) && (currentNode.tipText.length()>0)) {
		   
		   java.awt.Graphics g2=treeLayer.getGraphics();
			 
		   g2.setFont(tipFont);
		   int tipW=g2.getFontMetrics().stringWidth(currentNode.tipText);
		   int tipH=g2.getFontMetrics().getHeight();

		   g2.setColor(tipBack);  // tip background
		   g2.fillRect(cursorX,cursorY+20,tipW+6,tipH+4);		   
		   g2.setColor(tipBorder); // tip border
		   g2.drawRect(cursorX,cursorY+20,tipW+6,tipH+4);
		   g2.setColor(tipColor); // tip text
		   g2.drawString(currentNode.tipText,cursorX+3,cursorY+20+tipH);
		   
	     }	  
		
		// show copyright if not registered
		if ((showCopyright) && (!openingURL)) {
			java.awt.Graphics g2=treeLayer.getGraphics();
		    g2.setFont(new Font("Arial",Font.PLAIN,10));
			
			if (nodeColor!=null) g2.setColor(nodeColor);
			else g2.setColor(java.awt.Color.black);
			
			// blue color in cursor on the text
			copyrightH=g2.getFontMetrics().getHeight()+10;	

			if ((Root.submenuInverted)  && (menuType==MENU_HORIZONTAL)) 
				g2.drawString("Courtesy of http://rreport.8m.com",10,5+copyrightH); // draw the copyright at the top of the applet
			else	
			    g2.drawString("Courtesy of http://rreport.8m.com",10,this.getSize().height-(copyrightH/2)); // draw it at the bottom
		}
		
		// show text, opening url
		if (openingURL) {
			java.awt.Graphics g2=treeLayer.getGraphics();
		    g2.setFont(new Font("Arial",Font.PLAIN,10));
			if (backColor!=java.awt.Color.black) g2.setColor(java.awt.Color.black);
			else g2.setColor(java.awt.Color.white);

			g2.drawString(openingURLText,10,this.getSize().height-(copyrightH/2));
		}		
		
		
	
		
		
		// combine to final image
		if (finalImage!=null) {
		  finalImage.getGraphics().drawImage(backLayer,0,0,null);
		  finalImage.getGraphics().drawImage(treeLayer,0,0,null);
		  // draw border
		  //drawBorder(finalImage.getGraphics());
		
		  // draw images in the real graphics
		  g.drawImage(finalImage,0,0,this.getSize().width,parentPanel.getSize().height,0,cursorBase,this.getSize().width,cursorBase+parentPanel.getSize().height,null);
		}
		
		
	}
	
// mouse events
public void mouseClicked(MouseEvent e) {
   
	boolean textClicked=false;
	


	int i;
	
	cursorX=e.getX();
	cursorY=e.getY()+cursorBase;	
	

	
	try {
	 if ((showCopyright) && (cursorY>(this.getSize().height-copyrightH))) parentApplet.getAppletContext().showDocument(new java.net.URL("http://rreport.8m.com"));
	} catch(Exception e1) {}
	 
	
		RNode n=null;
		
		// to which displayed node belong the coordinates?
		//for (i=0;i<displayedNodes.size();i++) {
		//  n=(RNode) displayedNodes.elementAt(i);
		//  if ((cursorX>=(n.xPos+iconsWidth)) &&(n.yPos<=cursorY) && ((n.yPos+n.hSize) >=cursorY))  {textClicked=true;break;}
		//  if (((n.xPos-levelTab)<=cursorX) && (cursorX<(n.xPosText+n.wSizeText)) &&(n.yPos<=cursorY) && ((n.yPos+n.hSize) >=cursorY)) break;
		//}
		
		n=currentNode;
		
		if (n==null) { 
			int j=0;
		}
		else {
        
		//if (i<displayedNodes.size()) {
			
			// run action if clicked on the text
			performAction(n);

			if ( !n.hasChildren()) collapseNotInPath(n);
			
		    // expand if clicked and there is no action for the item
			if ( (n.hasChildren())&& (n.userValue==null)) {
			 n.expanded=(!n.expanded);
			 
			 if (n.expanded) {
				  collapseNotInPath(n);
				  loadNode(n);
				  
	 	       // trigger Javascript event
	          if (JSOnExpand.length()>0) {
		
		        try {
				  netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		          Object[] o=new Object[1];
		          o[0]=n.Name;
		          JS.call(JSOnExpand,null);
		         } catch (Exception e1) {System.out.println(e1.getMessage());}
	           }		  
			 }	  
			 
             // redraw canvas
             parentPanel.paint(parentPanel.getGraphics());
			 this.paint(this.getGraphics());
        }
		}		
       

    
 
	
}

public void mouseEntered(MouseEvent e) {
	
	// trigger Javascript event
	if (JSOnEnter.length()>0) {
		try {		
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnEnter,null);
		} catch (Exception e1) {
			 String err=e1.getMessage();
			 System.out.println(err);
		}
	}

}

public void mouseExited(MouseEvent e) {
	
   // deselect all nodes
   for (int i=0;i<displayedNodes.size();i++) ((RNode) displayedNodes.elementAt(i)).selected=false;

   refresh();

 	// trigger Javascript event
	if (JSOnExit.length()>0) {
		try {		
		netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		JS.call(JSOnExit,null);
		} catch (Exception e1) {System.out.println(e1.getMessage());}
	}  
   
}

public void mousePressed(MouseEvent e) {
}

public void mouseReleased(MouseEvent e) {
}

// mouse moved
public void mouseDragged(MouseEvent e) {
}
 
public void mouseMoved(MouseEvent e) {
    // change active node
    

	
	RNode tmp;
	boolean deleteTip=false;
	boolean redraw=false;
	boolean resize=false;
	
	cursorX=e.getX();
	cursorY=e.getY()+cursorBase;
	
	RNode n=getCurrentNode(cursorX,cursorY);


	if (n==currentNode) {
		if (n!=null) {	 	
		      // 3/4 second, show tip
              if (((System.currentTimeMillis()-enterTime)>tipDelay) && (showingTipTime==0)) {
			     showingTipTime=System.currentTimeMillis();
				 redraw=true;
			     
		   }	
		   
		}
	}
	
	
	if (n!=currentNode) {
       // deactivate previous node
       if (currentNode!=null) { 
      
	        
           currentNode.selected=false;
           // compress if we are not openning a descendant and EXPAND_ON_ENTER
		   
		   boolean collapse=false;	  
		   
           //if ((expandOn==EXPAND_ON_ENTER) && (currentNode!=null))
			//   if ((n!=Root) && (currentNode.getChildrenNumber()>0)) collapse=true;
		   
		   //if (n!=null)
			//   if (n.parent==currentNode) collapse=false;
		   
		   //if (collapse) {currentNode.expanded=false;
			//			  resize=true;}
               
  
       } 
 
	   enterTime=0;
	   showingTipTime=0;
       if (n!=null) { n.selected=true;
		  enterTime=System.currentTimeMillis();
		  
		  
		  // trigger javascript event
	     if (JSOnSelect.length()>0) {

		    try {			 
		    netscape.javascript.JSObject JS=netscape.javascript.JSObject.getWindow(parentApplet);
		     Object[] o=new Object[1];
		     o[0]=n.Name;
		     JS.call(JSOnSelect,o);
		    } catch (Exception e1) {System.out.println(e1.getMessage());}
	      }			  
		  
          // expand if EXPAND_ON_ENTER
		  if ((expandOn==EXPAND_ON_ENTER) && (n.hasChildren())) {n.expanded=true;
																 collapseNotInPath(n);
																 loadNode(n);
																 resize=true;}
		  if ((expandOn==EXPAND_ON_ENTER) && (!n.hasChildren())) collapseNotInPath(n);
       }

	   currentNode=n; 
	   
       // redraw canvas
       redraw=true;

    }
	
	
	if (redraw) {
		 if (resize) parentPanel.paint(parentPanel.getGraphics());
		 this.paint(this.getGraphics());
	}	 
   
}

	
	
}

	
}
