unit
  RTFRep;
interface
Uses
  Windows,
  SysUtils,
  Classes,
  Graphics,
  DB,
  Forms,
  Clipbrd,
  RTFRep_s;
Const           
  MaxRecordNumber = 10000;
  MaxArgNumber    = 99;
Type
  TArgList         = Array[0..MaxArgNumber-1] of Variant;
  TTagEvent        = Function ( Sender: TObject;
                                 FunctionName: String;
                                 const Args: TArgList;
                                 const ArgCnt: Integer
                                ): Variant of Object;
  TGetTableEvent   = Procedure ( Sender: TObject; TableName: String; var DataSet: TDataSet) of Object;
  TPictBorder      = (pbNone,pbSingle,pbDouble,pbThick,pbShadow,pbDot,pbHair );
  TPictShading     = (pshNone,pshHoriz,pshVert,pshFDiag,pshBDiag,
                      pshCross,pshDCross,pshDkHoriz,pshDkVert,
                      pshDkFDiag,pshDkBDiag,pshDkCross,pshDkDCross);

Type
  ScanRes  = ( srEmpty, srChar, srCWord, srGOpen, srGClose, srEOF);
  TTag     = (tgNone, tgVar, tgLoop, tgEndLoop, tgIf, tgElse, tgEndIf, tgCustom );
  TTagInfo = Packed Record
    Pos      : Integer;
    Format   : String;
    TAG,Args : String;
  end;
  PTableInfo      = ^TTableInfo;
  TTableInfo      = Packed Record
    Name          : String[63]; // Table name
    DataSet       : TDataSet;   // underlayed TDataset instance
    CurrentRecord : Integer;    // "Logical" current record number (according to sort order and filter conditions)
    RecNo         : Integer;    // Current record (index of Index array)
    RecCnt        : Integer;    // Total number of records (filters are not applyed)
    Index         : Array[0..MaxRecordNumber-1] of Integer; // Index array of DataSet records.
  end;

Const
  Version = '1.02';

Type
  TRTFReport = Class(TComponent)
  Private
    _OnTag         : TTagEvent;
    _OnGetTable    : TGetTableEvent;
    _OnFinish      : TNotifyEvent;
    _Template      : String;
    _CRC           : Array[0..3] of Byte;
    _CRCk          : Integer;
    _Colors        : Array of TColor;
    _FreeDatasets  : Boolean;
    _Terminated    : Boolean;
    _ProcessMessages : Boolean;
    _ErrorPrefix   : String;
    _Charset       : TFontCharset;
    _LangID        : DWord;
    _ANSICodePage  : DWord;

    Tmpl           : String;
    Prog           : Array of TTagInfo;

    InsertMode     : Boolean;
    ErrorStatus    : String;
    InsertPreffix  : String;
    DataToInsert   : String;

    _Tables        : Array[0..250] of PTableInfo;
    _TableCount    : Integer;
{$IFDEF DEMO}
    DemoFlag       : Boolean;
    Procedure About;
{$EndIf}

    Function _GetColors(Index: Integer): TColor;
    Function _GetColorCount: Integer;
    Function _GetTables( Index: Integer): PTableInfo;
    Function GetCRC: String;

    Function Scan(var Index: Integer; out CWord: String;  out Ch, Terminator: Char) : ScanRes;
    Function GetHidden( var Index: Integer; out Format, Args, Reminder: String): Integer;
    Function Parser: Boolean;
    Function ExtractFirstExpr( var Expr: String; out FirstExpr: String): Boolean;
    Function Evaluate_( Expr: String): Variant;
    Function ProcessIf( Var Index: Integer ): String;
    Function ProcessLoop( Var Index: Integer ): String;
    Function Process( StartPos, EndPos: Integer): String;


  Published
    Property Charset: TFontCharset read _Charset write _Charset;
    Property LangID: DWord read _LangID write _LangID;
    Property ANSICodePage: DWord read _ANSICodePage write _ANSICodePage;
    Property OnTag: TTagEvent read _OnTag write _OnTag;
    Property OnGetTable: TGetTableEvent read _OnGetTable write _OnGetTable;
    Property OnFinish: TNotifyEvent read _OnFinish write _OnFinish;
    Property FreeDatasets: Boolean read _FreeDatasets write _FreeDatasets;
    Property ProcessMessages: Boolean read _ProcessMessages write _ProcessMessages;
    Function GetVar(VarName: String): Variant;

  Public
    Property Template: String read _Template write _Template;
    Property CRC: String read GetCRC;
    Property Tables[ Index: Integer]: PTableInfo read _GetTables;
    Property TableCount: Integer read _TableCount;
    Property Colors[ Index: Integer ]: TColor read _GetColors;
    Property ColorCount: Integer read _GetColorCount;
    Property Terminated: Boolean read _Terminated write _Terminated;
    Property ErrorPrefix: String read _ErrorPrefix;

    Function GetTable( TableName: String): PTableInfo;
    Function Evaluate( Expr: String ): Variant;

    Function SetError( Error: String): String;
    Function InsertPlainText( PlainText: String ): String;
    Function InsertFormatted( RTFData: String ): String;
    Function InsertBitmap( Bmp            : TBitMap;
                           SizeInTwips    : TPoint;
                           ScaleInPercent : TPoint;
                           Crop           : TRect;
                           Border         : TPictBorder;
                           BrdWidth       : Integer;
                           BrdColor       : Integer;
                           Shadow         : TPictShading;
                           ShdDarkness    : Integer;
                           ShdBColor      : Integer;
                           ShdFColor      : Integer ): String;
    Function InsertMetaFile( EMF          : TMetaFile;
                           SizeInTwips    : TPoint;
                           ScaleInPercent : TPoint;
                           Crop           : TRect;
                           Border         : TPictBorder;
                           BrdWidth       : Integer;
                           BrdColor       : Integer;
                           Shadow         : TPictShading;
                           ShdDarkness    : Integer;
                           ShdBColor      : Integer;
                           ShdFColor      : Integer ): String;
    Function InsertObject: String;

    Function Execute: String;
    Function LoadTemplate( FileName: String ): Boolean;
    Function ExecuteAndSave( FileName: String ): Boolean;
    Procedure ClearTables;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

procedure Register;

implementation
//////////////////////////////////////////////////////////////////////////
Function LeftPad( s : String; Len: Integer): String;
begin
  If Len<=Length(s) then Result:=s else
    begin
      SetLength(Result,Len-Length(s));
      FillChar(Result[1],Length(Result),' ');
      Result:=Result+s;
    end;
end;
//////////////////////////////////////////////////////////////////////////
Function EncodeString(s: String): String;
Var i : Integer;
begin
  Result:='';
  For i:=1 to Length(s) do
   Case s[i] of
    #13:Result:=Result+'\par ';
    #10:;
    #0..#9,#11,#12,#14..#31: Result:=Result+'\'''+IntToHex(Ord(s[i]),2);
    '\','{','}':Result:=Result+'\'+s[i];
    else Result:=Result+s[i];
   end;
end;
//////////////////////////////////////////////////////////////////////////
{$IFDEF DEMO}
Procedure TRTFReport.About;
Var
   s : String;
   i : Integer;
begin
  If DemoFlag then Exit;
  DemoFlag:=True;
  s:=']rdvavhzezl~i~pmtqxu|yas"`yxvm*gupyCCLq~POT\utevix'+
     '{dk|o~jquJE6s|\ctgvxbizm|B=.ktxxsz~yretz:5&c|{l}p'+
     'krvqx|QL=zcmxhvygs|emwnrmtxsz~SN ]eofwjytel}pkrv'+
     'KF7t|}b]duhwycj{n}C>/lt~uyt{zbsfu{;6''dlvyr1nvyP'+
     'LPOxre"_uhbzt<@;hz|}Dp{{}ziovepagkr~}~vuw1ov~IIMNx~'+
     'invh|y<''dusyq-bwy2wx};~ hgqiwg{mm*m-rt}2y:=zljph$'+
     'cjesgxn|vAAEFpvS>TSVIVjvvz}hyo}wBBFGqwT !erquuumw~+'+
     ',s}0Uw}7t{<rtkrr%\]^)f{m.7S:2u5W\8lrf"+ejFuqlk9~7/l'+
     's4\{}{ ecwi?&klmfwu{s/ltw5sz<yieewpugydrxnyjpt{~'+
     ':xnh3378bhvrwqE0m5sz<yc]uo7;6c{uwx?kzvvxu{'+
     'tskjly&dukys>>BC1nu6t{=zqk^vp8<7d|vxy@l{wwyv|sutlk'+
     'mz''evlzt??CD2ov}|';
  For i:=1 to Length(s) do s[i]:=Char(Byte(s[i]) - Byte(i mod 31));
  i:=Pos('VVV',s);
  Delete(s,i,3);
  Insert(Version,s,i);
  i:=Pos('ddd',s);
  Delete(s,i,3);
  Insert(DateTimeToStr(Now),s,i);

  InsertFormatted( s );
end;
{$EndIf}
//////////////////////////////////////////////////////////////////////////
{$I RTFRep.i01} // Parser,
{$I RTFRep.i02} // GetTable, GetVar
{$I RTFRep.i03} // Evaluate
{$I RTFRep.i04} // InsertPlainText, InsertFormatted,
                // InsertBitmap, InsertObject
{$I RTFRep.i05} // ProcessIf
{$I RTFRep.i06} // ProcessLoop
{$I RTFRep.i07} // Process
{$I RTFRep.i08} // _GetColors _GetColorCount, _GetTables,
                // _GetTableCount, GetCRC, SetError, Execute
{$I RTFRep.i09} // LoadTemplate, ExecuteAndSave, ClearTables, Create, Destroy
//////////////////////////////////////////////////////////////////////////
procedure Register;
begin
  RegisterComponents('AE', [TRTFReport]);
end;
//////////////////////////////////////////////////////////////////////////
end.
