/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// PropertiesDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Identd.h"
#include "PropertiesDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropertiesDialog dialog


CPropertiesDialog::CPropertiesDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CPropertiesDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPropertiesDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPropertiesDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropertiesDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropertiesDialog, CDialog)
	//{{AFX_MSG_MAP(CPropertiesDialog)
	ON_BN_CLICKED(IDOK, OnOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropertiesDialog message handlers

void CPropertiesDialog::SetConfig(CIdentConfig* pConfig)
{
	m_pConfig = pConfig;
}

BOOL CPropertiesDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	((CButton*)GetDlgItem(IDC_USECURRENTUSERNAME))->SetCheck(m_pConfig->GetUseCurrentUser());
	SetDlgItemText(IDC_DEFAULTNAME, m_pConfig->GetDefaultUserName());

	((CButton*)GetDlgItem(IDC_OSUNIX))->SetCheck(m_pConfig->GetOS() == CIdentConfig::OS_UNIX);
	((CButton*)GetDlgItem(IDC_OSOTHER))->SetCheck(m_pConfig->GetOS() == CIdentConfig::OS_OTHER);
	((CButton*)GetDlgItem(IDC_OSSPECIFIED))->SetCheck(m_pConfig->GetOS() == CIdentConfig::OS_SPECIFIED);
	
	SetDlgItemText(IDC_OSNAME, m_pConfig->GetOSName());

	((CButton*)GetDlgItem(IDC_OPERNORMAL))->SetCheck(m_pConfig->GetMode() == CIdentConfig::OPER_NORMAL);
	((CButton*)GetDlgItem(IDC_OPERNOUSER))->SetCheck(m_pConfig->GetMode() == CIdentConfig::OPER_NOUSER);
	((CButton*)GetDlgItem(IDC_OPERHIDDEN))->SetCheck(m_pConfig->GetMode() == CIdentConfig::OPER_HIDDENUSER);
	((CButton*)GetDlgItem(IDC_OPERUNKNOWN))->SetCheck(m_pConfig->GetMode() == CIdentConfig::OPER_UNKNOWNERROR);

	((CButton*)GetDlgItem(IDC_UISHOWTOOLTIPS))->SetCheck(m_pConfig->GetUseToolTips());

	SetDlgItemInt(IDC_OPERPORT, m_pConfig->GetPort());

	m_ttToolTips.Create(this);
	m_ttToolTips.AddTool(GetDlgItem(IDC_USECURRENTUSERNAME), _T("If you are using Microsoft Networking, obtains the current username from the system"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_DEFAULTNAME), _T("If the program cannot resolve your username from the system, it uses this name instead."));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OSUNIX), _T("Reports your OS as \"UNIX\" (recommended)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OSOTHER), _T("Reports your OS as \"OTHER\" (advanced)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OSSPECIFIED), _T("Reports your OS as the text specified in the edit box (advanced)"));

	m_ttToolTips.AddTool(GetDlgItem(IDC_OSNAME), _T("Reports your OS as the text specified in the edit box (advanced)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OPERNORMAL), _T("Normal ident resolution operation (recommended)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OPERNOUSER), _T("Reports that there is no user using the port (advanced)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OPERHIDDEN), _T("Reports that your username is hidden and cannot be returned (advanced)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OPERUNKNOWN), _T("Reports that your username could not be resolved (advanced)"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_OPERPORT), _T("Specifies which port to listen for ident requests on (113 is recommended)"));

	m_ttToolTips.AddTool(GetDlgItem(IDC_UISHOWTOOLTIPS), _T("Specifies whether to show these help tooltips or not"));
	m_ttToolTips.Activate(true);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropertiesDialog::OnOk() 
{
	int iBuffer = GetDlgItemInt(IDC_OPERPORT, NULL, FALSE);
	if (iBuffer == 0)
	{
		MessageBox(_T("Please enter a valid port number to listen on (113 is recommended)."), NULL, MB_ICONHAND);
		return;
	}

	CString strNameBuffer;
	GetDlgItemText(IDC_DEFAULTNAME, strNameBuffer);
	strNameBuffer.TrimLeft();
	strNameBuffer.TrimRight();
	if (strNameBuffer.Find(" ") != -1)
	{
		MessageBox(_T("Please enter a username without spaces."), NULL, MB_ICONHAND);
		return;
	}
	
	CString strOSBuffer;
	GetDlgItemText(IDC_OSNAME, strOSBuffer);
	strOSBuffer.TrimLeft();
	strOSBuffer.TrimRight();
	if (strOSBuffer.Find(" ") != -1)
	{
		MessageBox(_T("Please enter an OS name without spaces."), NULL, MB_ICONHAND);
		return;
	}

	if (iBuffer != m_pConfig->GetPort())
	{
		MessageBox(_T("Changes to the listen port will not take effect until the program is stopped and restarted."), NULL, MB_ICONEXCLAMATION);
	}

	m_pConfig->SetDefaultUserName(strNameBuffer);
	m_pConfig->SetOSName(strOSBuffer);
		
	m_pConfig->SetPort(iBuffer);

	m_pConfig->SetMode(((CButton*)GetDlgItem(IDC_OPERNORMAL))->GetCheck() * CIdentConfig::OPER_NORMAL +
		((CButton*)GetDlgItem(IDC_OPERNOUSER))->GetCheck() * CIdentConfig::OPER_NOUSER +
		((CButton*)GetDlgItem(IDC_OPERHIDDEN))->GetCheck() * CIdentConfig::OPER_HIDDENUSER +
		((CButton*)GetDlgItem(IDC_OPERUNKNOWN))->GetCheck() * CIdentConfig::OPER_UNKNOWNERROR);
	
	m_pConfig->SetOS(((CButton*)GetDlgItem(IDC_OSUNIX))->GetCheck() * CIdentConfig::OS_UNIX +
		((CButton*)GetDlgItem(IDC_OSOTHER))->GetCheck() * CIdentConfig::OS_OTHER +
		((CButton*)GetDlgItem(IDC_OSSPECIFIED))->GetCheck() * CIdentConfig::OS_SPECIFIED);

	m_pConfig->SetUseCurrentUser(((CButton*)GetDlgItem(IDC_USECURRENTUSERNAME))->GetCheck() != 0);
	
	m_pConfig->SetUseToolTips(((CButton*)GetDlgItem(IDC_UISHOWTOOLTIPS))->GetCheck() != 0);

	CDialog::OnOK();
	if (!m_pConfig->Write())
	{
		MessageBox(_T("Could not write preferences file: you may not have write access to the file/directory, the disk could be full or the server could be on fire."), NULL, MB_ICONERROR);
	}
}

BOOL CPropertiesDialog::PreTranslateMessage(MSG* pMsg) 
{
	if (m_pConfig->GetUseToolTips())
		if (pMsg->message== WM_LBUTTONDOWN || pMsg->message== WM_LBUTTONUP || pMsg->message== WM_MOUSEMOVE)
			m_ttToolTips.RelayEvent(pMsg);	
	
	return CDialog::PreTranslateMessage(pMsg);
}
