/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentdDlg.h : header file
//

#if !defined(AFX_IDENTDDLG_H__21B4DF28_6069_11D2_B2AD_006008CED79E__INCLUDED_)
#define AFX_IDENTDDLG_H__21B4DF28_6069_11D2_B2AD_006008CED79E__INCLUDED_

#include "IdentConfig.h"	// Added by ClassView
#include "IdentSocketManager.h"	// Added by ClassView
#include "IdentSocket.h"	// Added by ClassView

class CIdentSocketManager;

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CIdentdDlg dialog

class CIdentdDlg : public CDialog
{
// Construction
public:
	void SetConfigFile(CString strConfigFile);
	void SetNoClose(bool bNoClose);
	void SetConfigReadOnly(bool bReadOnly);
	CIdentdDlg(CWnd* pParent = NULL);	// standard constructor
	virtual int DoModalEx(bool bVisible);

// Dialog Data
	//{{AFX_DATA(CIdentdDlg)
	enum { IDD = IDD_IDENTD_DIALOG };
	CListCtrl	m_lcRequests;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIdentdDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	CToolTipCtrl m_ttToolTips;
	CString m_strConfigFile;
	bool m_bNoClose;
	CIdentSocketManager m_SocketManager;
	CIdentConfig m_Config;
	CIdentSocket m_sockIdent;
	UINT m_uiTimer;
	HICON m_hIcon;
	bool m_bConfigReadOnly;

	// Generated message map functions
	//{{AFX_MSG(CIdentdDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnProperties();
	afx_msg void OnCloseNoStop();
	virtual void OnCancel();
	afx_msg void OnOk();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClearlog();
	afx_msg LRESULT OnUpdateLog(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IDENTDDLG_H__21B4DF28_6069_11D2_B2AD_006008CED79E__INCLUDED_)
