/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentdDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Identd.h"
#include "IdentdDlg.h"
#include "PropertiesDialog.h"
#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_strGPL;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnSeegpl();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_strGPL = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_GPL, m_strGPL);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIdentdDlg dialog

CIdentdDlg::CIdentdDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIdentdDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIdentdDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

int CIdentdDlg::DoModalEx(bool bVisible)
{
	// can be constructed with a resource template or InitModalIndirect
	ASSERT(m_lpszTemplateName != NULL || m_hDialogTemplate != NULL ||
		m_lpDialogTemplate != NULL);

	// load resource as necessary
	LPCDLGTEMPLATE lpDialogTemplate = m_lpDialogTemplate;
	HGLOBAL hDialogTemplate = m_hDialogTemplate;
	HINSTANCE hInst = AfxGetResourceHandle();
	if (m_lpszTemplateName != NULL)
	{
		hInst = AfxFindResourceHandle(m_lpszTemplateName, RT_DIALOG);
		HRSRC hResource = ::FindResource(hInst, m_lpszTemplateName, RT_DIALOG);
		hDialogTemplate = LoadResource(hInst, hResource);
	}
	if (hDialogTemplate != NULL)
		lpDialogTemplate = (LPCDLGTEMPLATE)LockResource(hDialogTemplate);

	// return -1 in case of failure to load the dialog template resource
	if (lpDialogTemplate == NULL)
		return -1;

	// disable parent (before creating dialog)
	HWND hWndParent = PreModal();
	AfxUnhookWindowCreate();
	BOOL bEnableParent = FALSE;
	if (hWndParent != NULL && ::IsWindowEnabled(hWndParent))
	{
		::EnableWindow(hWndParent, FALSE);
		bEnableParent = TRUE;
	}

	TRY
	{
		// create modeless dialog
		AfxHookWindowCreate(this);
		if (CreateDlgIndirect(lpDialogTemplate,
						CWnd::FromHandle(hWndParent), hInst))
		{
			if (m_nFlags & WF_CONTINUEMODAL)
			{
				// enter modal loop
				DWORD dwFlags = 0;
				if (bVisible)
					dwFlags = MLF_SHOWONIDLE;
				if (GetStyle() & DS_NOIDLEMSG)
					dwFlags |= MLF_NOIDLEMSG;
				VERIFY(RunModalLoop(dwFlags) == m_nModalResult);
			}

			// hide the window before enabling the parent, etc.
			if (m_hWnd != NULL)
				SetWindowPos(NULL, 0, 0, 0, 0, SWP_HIDEWINDOW|
					SWP_NOSIZE|SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOZORDER);
		}
	}
	CATCH_ALL(e)
	{
		e->Delete();
		m_nModalResult = -1;
	}
	END_CATCH_ALL

	if (bEnableParent)
		::EnableWindow(hWndParent, TRUE);
	if (hWndParent != NULL && ::GetActiveWindow() == m_hWnd)
		::SetActiveWindow(hWndParent);

	// destroy modal window
	DestroyWindow();
	PostModal();

	// unlock/free resources as necessary
	if (m_lpszTemplateName != NULL || m_hDialogTemplate != NULL)
		UnlockResource(hDialogTemplate);
	if (m_lpszTemplateName != NULL)
		FreeResource(hDialogTemplate);

	return m_nModalResult;
}

void CIdentdDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIdentdDlg)
	DDX_Control(pDX, IDC_REQUESTS, m_lcRequests);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIdentdDlg, CDialog)
	//{{AFX_MSG_MAP(CIdentdDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PROPERTIES, OnProperties)
	ON_BN_CLICKED(IDC_CLOSE, OnCloseNoStop)
	ON_BN_CLICKED(IDOK, OnOk)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CLEARLOG, OnClearlog)
	ON_MESSAGE(WM_UPDATELOG, OnUpdateLog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIdentdDlg message handlers

BOOL CIdentdDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CRect r;
	m_lcRequests.GetClientRect(&r);

	r.DeflateRect(0, 0, GetSystemMetrics(SM_CXVSCROLL), 0);

	int iTotalWidth = r.Width(), iWidth;

	iWidth = iTotalWidth * 35 / 100;
	r.DeflateRect(0, 0, iWidth, 0);
	m_lcRequests.InsertColumn(0, _T("Source"), LVCFMT_LEFT, iWidth, 0);
	iWidth = iTotalWidth * 13 / 100;
	r.DeflateRect(0, 0, iWidth, 0);
	m_lcRequests.InsertColumn(1, _T("Local"), LVCFMT_LEFT, iWidth, 1);
	iWidth = iTotalWidth * 13 / 100;
	r.DeflateRect(0, 0, iWidth, 0);
	m_lcRequests.InsertColumn(2, _T("Remote"), LVCFMT_LEFT, iWidth, 2);
	iWidth = r.Width();
	r.DeflateRect(0, 0, iWidth, 0);
	m_lcRequests.InsertColumn(3, _T("Response"), LVCFMT_LEFT, iWidth, 3);

	m_Config.SetConfigFile(m_strConfigFile);
	if (!m_Config.Read())
	{
		if (MessageBox(_T("I couldn't find a configuration file specified by the path \"" + m_strConfigFile + "\".  "
			"If your configuration file is located elsewhere, please specify it on the command like, like so: IDENTD /START /CONFIG:\"\\\\NTSERVER\\Users\\Identd\\Identd.ini\".\n\n"
			"Would you like to create a new configuration file at this location?  If you answer no, I will terminate."), NULL, MB_ICONQUESTION | MB_YESNO) == IDYES)
		{
			m_Config.Write();
			MessageBox(_T("As this is your first time running the program, I'd just like to point out a few helpful tips to get you started:\n\n"
				"- You probably want to set a default name in the preferences dialog if you don't use Microsoft Networking.\n"
				"- Keeping the default settings for the other options is probably a good idea, unless you've read RFC1413 and want to experiment.\n"
				"- You can specify a preferences file to read by putting the filename on the commandline with the /START option, like so:\n IDENTD /START /CONFIG:\"\\\\NTSERVER\\Users\\Identd\\Identd.ini\".\n"
				"- You can disable the preferences button by using the /READONLY option (useful if your preferences file is read-only anyways).\n\n"
				"- You can disable the Close + stop option by using the /NOSHUTDOWN option.\n"
				"Enjoy the program.  If you use it regularily, please send me some email so I can know there's support out there for it.\n\nThanks,\nMatthew Mastracci\n10/11/98"
				));
		}
		else
		{
			EndDialog(IDOK);
		}
	}

	m_SocketManager.SetConfig(&m_Config);

	int nTries = 3;
	int iError = 0;

	while (nTries > 0)
	{
		int iError = m_sockIdent.Create(m_Config.GetPort());
		m_sockIdent.SetSocketManager(&m_SocketManager);
		if (iError == 0)
		{
			iError = GetLastError();
			TRACE("Error %08x opening socket\n", iError);
			if (iError == WSAEADDRINUSE)
			{
				Sleep(100);
				nTries--;
			}
			else
			{
				EndDialog(IDOK);
				return false;
			}
		}
		else
		{
			m_sockIdent.Listen();
			break;
		}
	}

	if (nTries == 0)
	{
		CString strText;
		strText.Format(_T("Another application has locked socket %i for its own use.  You may already have an identd server running.\n\nThe application must now terminate."), m_Config.GetPort());
		MessageBox(strText, NULL, MB_ICONERROR);
		EndDialog(IDOK);

		return false;
	}		

	m_uiTimer = SetTimer(1, 30000, NULL);
	if (m_uiTimer = 0)
		TRACE("Could not create timer! (not fatal, but not good!)\n");

	SetDlgItemText(IDC_ACTIVECONNECTIONS, "Ident Requests");
	GetDlgItem(IDC_PROPERTIES)->EnableWindow(!m_bConfigReadOnly);
	GetDlgItem(IDOK)->EnableWindow(!m_bNoClose);

	m_ttToolTips.Create(this);
	m_ttToolTips.AddTool(GetDlgItem(IDC_PROPERTIES), _T("Edit the configuration properties of the daemon"));
	m_ttToolTips.AddTool(GetDlgItem(IDOK), _T("Close the log window and shuts the program down"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_ACTIVECONNECTIONS), _T("Indicates if any connections are currently active"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_CLOSE), _T("Close the log window and leave the program running"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_REQUESTS), _T("Displays the source and contents of each ident request"));
	m_ttToolTips.AddTool(GetDlgItem(IDC_CLEARLOG), _T("Clears the ident request log"));
	m_ttToolTips.Activate(true);

//	m_ttToolTips.SetMaxTipWidth(

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIdentdDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CIdentdDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CIdentdDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CIdentdDlg::OnProperties() 
{
	CPropertiesDialog dlg;
	dlg.SetConfig(&m_Config);
	dlg.DoModal();
}

void CIdentdDlg::OnCloseNoStop() 
{
	ShowWindow(SW_HIDE);
}

void CIdentdDlg::OnCancel() 
{
	OnCloseNoStop();
}

void CIdentdDlg::OnOk() 
{
	if (MessageBox(_T("Are you sure you want to shut the server down?"), NULL, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		KillTimer(m_uiTimer);
		if (!m_bConfigReadOnly)
			m_Config.Write();
		CDialog::OnOK();	
	}
}

void CIdentdDlg::OnTimer(UINT nIDEvent) 
{
	m_SocketManager.CleanUp();

	CString strIdentRequests;
	strIdentRequests.Format("Ident Requests - %i active connection(s)", m_SocketManager.GetActiveConnections());
	SetDlgItemText(IDC_ACTIVECONNECTIONS, strIdentRequests);

	CDialog::OnTimer(nIDEvent);
}

void CIdentdDlg::OnClearlog() 
{
	m_lcRequests.DeleteAllItems();	
}

LRESULT CIdentdDlg::OnUpdateLog(WPARAM wParam, LPARAM lParam)
{
	SLogMessageInfo* pInfo = (SLogMessageInfo*)lParam;
	
	int iItemPos = m_lcRequests.GetItemCount();
	m_lcRequests.InsertItem(iItemPos, pInfo->strSourceAddres); 
	CString strPort;
	strPort.Format("%i", pInfo->iLocalPort);
	m_lcRequests.SetItemText(iItemPos, 1, strPort);
	strPort.Format("%i", pInfo->iRemotePort);
	m_lcRequests.SetItemText(iItemPos, 2, strPort);
	m_lcRequests.SetItemText(iItemPos, 3, pInfo->strResponse);
	
	return 0;
}

void CIdentdDlg::SetConfigReadOnly(bool bReadOnly)
{
	m_bConfigReadOnly = bReadOnly;
}

void CIdentdDlg::SetNoClose(bool bNoClose)
{
	m_bNoClose = bNoClose;
}

void CIdentdDlg::SetConfigFile(CString strConfigFile)
{
	m_strConfigFile = strConfigFile;
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_strGPL = _T(
		"GNU GENERAL PUBLIC LICENSE\r\n"
		"Version 2, June 1991\r\n"
		"\r\n"
		"Copyright (C) 1989, 1991 Free Software Foundation, Inc.\r\n"
		"59 Temple Place - Suite 330, Boston, MA  02111-1307, USA\r\n"
		"\r\n"
		"Everyone is permitted to copy and distribute verbatim copies"
		"of this license document, but changing it is not allowed.\r\n\r\n"
		"Preamble\r\n\r\n"
		"The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users. This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it. (Some other Free Software Foundation software is covered by the GNU Library General Public License instead.) You can apply it to your programs, too. \r\n"
		"\r\n"
		"When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things. \r\n"
		"\r\n"
		"To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights. These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it. \r\n"
		"\r\n"
		"For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights. \r\n"
		"\r\n"
		"We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software. \r\n"
		"\r\n"
		"Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software. If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations. \r\n"
		"\r\n"
		"Finally, any free program is threatened constantly by software patents. We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary. To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all. \r\n"
		"\r\n"
		"The precise terms and conditions for copying, distribution and modification follow. \r\n"
		"\r\n"
		"TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\r\n\r\n"
		"0. This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License. The \"Program\", below, refers to any such program or work, and a \"work based on the Program\" means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language. (Hereinafter, translation is included without limitation in the term \"modification\".) Each licensee is addressed as \"you\". \r\n"
		"\r\n"
		"Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program). Whether that is true depends on what the Program does. \r\n"
		"\r\n"
		"1. You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program. \r\n"
		"\r\n"
		"You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee. \r\n"
		"\r\n"
		"2. You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions: \r\n"
		"\r\n"
		"\r\n"
		"a) You must cause the modified files to carry prominent notices stating that you changed the files and the date of any change. \r\n"
		"\r\n"
		"b) You must cause any work that you distribute or publish, that in whole or in part contains or is derived from the Program or any part thereof, to be licensed as a whole at no charge to all third parties under the terms of this License. \r\n"
		"\r\n"
		"c) If the modified program normally reads commands interactively when run, you must cause it, when started running for such interactive use in the most ordinary way, to print or display an announcement including an appropriate copyright notice and a notice that there is no warranty (or else, saying that you provide a warranty) and that users may redistribute the program under these conditions, and telling the user how to view a copy of this License. (Exception: if the Program itself is interactive but does not normally print such an announcement, your work based on the Program is not required to print an announcement.)  "
		"These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.  "
		"Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program. \r\n"
		"\r\n"
		"In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License. \r\n"
		"\r\n"
		"3. You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following: \r\n"
		"\r\n"
		"a) Accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, \r\n"
		"\r\n"
		"b) Accompany it with a written offer, valid for at least three years, to give any third party, for a charge no more than your cost of physically performing source distribution, a complete machine-readable copy of the corresponding source code, to be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, \r\n"
		"\r\n"
		"c) Accompany it with the information you received as to the offer to distribute corresponding source code. (This alternative is allowed only for noncommercial distribution and only if you received the program in object code or executable form with such an offer, in accord with Subsection b above.) \r\n"
		"The source code for a work means the preferred form of the work for making modifications to it. For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable. However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable. \r\n"
		"If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code. \r\n"
		"\r\n"
		"4. You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance. \r\n"
		"\r\n"
		"5. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Program or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it. \r\n"
		"\r\n"
		"6. Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License. \r\n"
		"\r\n"
		"7. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all. For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program. \r\n"
		"\r\n"
		"If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances. \r\n"
		"\r\n"
		"It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice. \r\n"
		"\r\n"
		"This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License. \r\n"
		"\r\n"
		"8. If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License. \r\n"
		"\r\n"
		"9. The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns. \r\n"
		"\r\n"
		"Each version is given a distinguishing version number. If the Program specifies a version number of this License which applies to it and \"any later version\", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation. \r\n"
		"\r\n"
		"10. If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally. \r\n"
		"\r\n"
		"NO WARRANTY\r\n\r\n"
		"\r\n"
		"11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. \r\n"
		"\r\n"
		"12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. \r\n"
	);

	UpdateData(false);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CIdentdDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (m_Config.GetUseToolTips())
		if (pMsg->message == WM_LBUTTONDOWN || pMsg->message == WM_LBUTTONUP || pMsg->message == WM_MOUSEMOVE)
			m_ttToolTips.RelayEvent(pMsg);	

	return CDialog::PreTranslateMessage(pMsg);
}

