/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// Identd.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Identd.h"
#include "IdentdDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIdentdApp

BEGIN_MESSAGE_MAP(CIdentdApp, CWinApp)
	//{{AFX_MSG_MAP(CIdentdApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIdentdApp construction

CIdentdApp::CIdentdApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CIdentdApp object

CIdentdApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CIdentdApp initialization

BOOL CIdentdApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	HWND hWnd = ::FindWindow(NULL, _T("Ident Daemon (Status Window)"));
	bool bStart = false, bReadOnly = false, bNoClose = false;
	CString strConfigFile;

	CString strCmdLine = m_lpCmdLine;
	strCmdLine.MakeUpper();
	
	if (strCmdLine.Find("/START") != -1)
	{
		bStart = true;	
	}
	if (strCmdLine.Find("/GOSERVICE") != -1)
	{
		bStart = true;	
		OSVERSIONINFO os;
		os.dwOSVersionInfoSize = sizeof(os);
		GetVersionEx(&os);

		if (os.dwPlatformId != VER_PLATFORM_WIN32_WINDOWS)
		{
			MessageBox(NULL, _T("The /SERVICE switch is for use with Windows '95 or Windows '98 only."), NULL, MB_ICONERROR);
			
			return false;
		}

		if (hWnd != NULL)
			return false;

		typedef DWORD(__stdcall *RSP)(DWORD, DWORD);

		RSP RegisterServiceProcess;
		RegisterServiceProcess = (RSP)GetProcAddress(GetModuleHandle("KERNEL32"), "RegisterServiceProcess");
		if (RegisterServiceProcess == NULL)
		{
			MessageBox(NULL, _T("Whoa: I couldn't find the RegisterServiceProcess entry point.  This is totally unexpected, so I'll quit now.  Ask your sysadmin to check your KERNEL32.DLL file."), NULL, MB_ICONERROR);

			return false;
		}
		DWORD dwResult = RegisterServiceProcess(NULL, 1);
	}
	if (strCmdLine.Find("/READONLY") != -1)
	{
		bReadOnly = true;
	}
	if (strCmdLine.Find("/NOSHUTDOWN") != -1)
	{
		bNoClose = true;
	}
	if (strCmdLine.Find("/CONFIG:") != -1)
	{
		bool bBadFormat = false;
		strConfigFile = strCmdLine.Mid(strCmdLine.Find("/CONFIG:") + 8);
		if (strConfigFile.Find("\"") == -1)
		{
			bBadFormat = true;
		}
		else
		{
			strConfigFile = strConfigFile.Mid(1);
			if (strConfigFile.Find("\"") == -1)
			{
				bBadFormat = true;
			}
			else
			{
				strConfigFile = strConfigFile.Left(strConfigFile.Find("\""));
			}
		}

		if (bBadFormat)
		{
			::MessageBox(NULL, _T("Bad format for /CONFIG: option.  The format of the /CONFIG: option is:\n\nIDENTD /CONFIG:\"full path to config file\""), NULL, MB_ICONERROR);
			strConfigFile.Empty();
		}
	}

	if (strCmdLine.Find("/UNINSTALL") != -1)
	{
		HKEY hKey;
		if (RegOpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\RunServices", &hKey) == ERROR_SUCCESS)
		{
			RegDeleteValue(hKey, "IDENTDSERVER");
			
			RegCloseKey(hKey);
		}
		if (RegOpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", &hKey) == ERROR_SUCCESS)
		{
			RegDeleteValue(hKey, "IDENTDSERVER");
			
			RegCloseKey(hKey);
		}

		MessageBox(NULL, _T("Identd service successfully uninstalled.  The program will not start when you reboot."), _T("Service Install"), MB_ICONINFORMATION);

		return false;
	}

	if ((strCmdLine.Find("/SERVICE") != -1) || (strCmdLine.Find("/INSTALL:") != -1))
	{
		OSVERSIONINFO os;
		os.dwOSVersionInfoSize = sizeof(os);
		GetVersionEx(&os);

		if (os.dwPlatformId != VER_PLATFORM_WIN32_WINDOWS)
		{
			MessageBox(NULL, _T("The /SERVICE[QUIET] and /INSTALL[QUIET] switches are for use with Windows '95 or Windows '98 only."), NULL, MB_ICONERROR);
			
			return false;
		}
		
		CString strFilePath;
		if (strCmdLine.Find("/SERVICE") != -1)
		{
			GetModuleFileName(NULL, strFilePath.GetBuffer(MAX_PATH), MAX_PATH);
			
			strFilePath.ReleaseBuffer();
			strFilePath = "\"" + strFilePath + "\" /GOSERVICE";
		}
		else
		{
			bool bBadFormat = false;
			CString strDirectory = strCmdLine.Mid(strCmdLine.Find("/INSTALL:") + 9);
			if (strDirectory.Find("\"") == -1)
			{
				bBadFormat = true;
			}
			else
			{
				strDirectory = strDirectory.Mid(1);
				if (strDirectory.Find("\"") == -1)
				{
					bBadFormat = true;
				}
				else
				{
					strDirectory = strDirectory.Left(strDirectory.Find("\""));
				}
			}

			if (bBadFormat)
			{
				::MessageBox(NULL, _T("Bad format for /INSTALL: option.  The format of the /INSTALL: option is:\n\nIDENTD /INSTALL:\"path to install to\""), NULL, MB_ICONERROR);
				strDirectory.Empty();

				return false;
			}

			bool bSuccess;
			bSuccess = CreateDirectory(strDirectory, NULL);
			if (!bSuccess && GetLastError() != ERROR_ALREADY_EXISTS)
			{
				CString s;
				s.Format(_T("Error creating directory \"%s\": %08x"), strDirectory, GetLastError());
				::MessageBox(NULL, s, NULL, MB_ICONERROR);

				return false;
			}

			CString strFilename;
			GetModuleFileName(NULL, strFilename.GetBuffer(MAX_PATH), MAX_PATH);
			strFilename.ReleaseBuffer();

			if (strDirectory.Right(1) != "\\")
				strDirectory += "\\";

			bSuccess = CopyFile(strFilename, strDirectory + "IDENTD.EXE", false); 

			if (!bSuccess)
			{
				CString s;
				s.Format(_T("Error copying file \"%s\" to directory \"%s\": %08x"), strFilename, strDirectory, GetLastError());
				::MessageBox(NULL, strDirectory, NULL, MB_ICONERROR);

				return false;
			}

			strFilePath = strDirectory + "IDENTD.EXE /GOSERVICE";
		}

		if (strCmdLine.Find("/READONLY") != -1)
		{
			strFilePath += " /READONLY";
		}
		
		if (strCmdLine.Find("/NOSHUTDOWN") != -1)
		{
			strFilePath += " /NOSHUTDOWN";
		}
		
		if (!strConfigFile.IsEmpty())
		{
			strFilePath += " /CONFIG:\"" + strConfigFile + "\"";
		}
		else
		{
			CString strDirectory;
			GetCurrentDirectory(MAX_PATH, strDirectory.GetBuffer(MAX_PATH));
			strDirectory.ReleaseBuffer();

			strFilePath += " /CONFIG:\"" + strDirectory + "\\IDENTD.INI\"";
		}

		if ((strCmdLine.Find("/SERVICE") != -1) && (strCmdLine.Find("/INSTALL:") == -1))
		{
			HKEY hKey;
			if (RegOpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\RunServices", &hKey) == ERROR_SUCCESS)
			{
				RegSetValueEx(hKey, "IDENTDSERVER", 0, REG_SZ, (CONST BYTE*)(const char*)strFilePath, strFilePath.GetLength() + 1);
				
				RegCloseKey(hKey);
			}
			if (RegOpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", &hKey) == ERROR_SUCCESS)
			{
				RegDeleteValue(hKey, "IDENTDSERVER");
				
				RegCloseKey(hKey);
			}
		}

		if (strCmdLine.Find("/SERVICEQUIET") == -1 && strCmdLine.Find("/INSTALL:") == -1)
			MessageBox(NULL, _T("Identd service successfully installed.  The program will start on the next boot."), _T("Service Install"), MB_ICONINFORMATION);

		return false;
	}

	if (strConfigFile.IsEmpty())
	{
		strConfigFile = "IDENTD.INI";
	}

	if (hWnd != NULL)
	{
		if (!bStart)
		{
			::ShowWindow(hWnd, SW_SHOW);
			::SetForegroundWindow(hWnd);
		}

		return false;
	}
	
	CIdentdDlg dlg;
	dlg.SetConfigReadOnly(bReadOnly);
	dlg.SetNoClose(bNoClose);
	dlg.SetConfigFile(strConfigFile);
	m_pMainWnd = &dlg;

	int nResponse = dlg.DoModalEx(!bStart);
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

int CIdentdApp::ExitInstance() 
{
	AfxSocketTerm();
	
	return CWinApp::ExitInstance();
}
