/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentSocketManager.h: interface for the CIdentSocketManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IDENTSOCKETMANAGER_H__66ADBCC4_60A8_11D2_B2AD_006008CED79E__INCLUDED_)
#define AFX_IDENTSOCKETMANAGER_H__66ADBCC4_60A8_11D2_B2AD_006008CED79E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "IdentProtocolSocket.h"

class CIdentSocketManager  
{
public:
	int GetActiveConnections();
	void CleanUp();
	void AddSocket(CIdentProtocolSocket* pSocket);
	void SetConfig(CIdentConfig* pConfig);
	CIdentSocketManager();
	virtual ~CIdentSocketManager();

protected:
	CIdentConfig* m_pConfig;
	CArray<CIdentProtocolSocket*, CIdentProtocolSocket*> m_arSockets;
	CCriticalSection m_csListLock;
};

#endif // !defined(AFX_IDENTSOCKETMANAGER_H__66ADBCC4_60A8_11D2_B2AD_006008CED79E__INCLUDED_)
