/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentSocketManager.cpp: implementation of the CIdentSocketManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Identd.h"
#include "IdentSocketManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIdentSocketManager::CIdentSocketManager()
{

}

CIdentSocketManager::~CIdentSocketManager()
{
	for (int i = 0; i < m_arSockets.GetSize(); i++)
	{
		delete m_arSockets[i];
	}
}

void CIdentSocketManager::AddSocket(CIdentProtocolSocket *pSocket)
{
	CleanUp();

	CSingleLock slLock(&m_csListLock, true);

	pSocket->SetConfig(m_pConfig);
	m_arSockets.Add(pSocket);
}

void CIdentSocketManager::SetConfig(CIdentConfig* pConfig)
{
	CSingleLock slLock(&m_csListLock, true);

	m_pConfig = pConfig;
}

void CIdentSocketManager::CleanUp()
{
	CSingleLock slLock(&m_csListLock, true);

	for (int i = 0; i < m_arSockets.GetSize(); i++)
	{
		if (m_arSockets[i]->IsFinished())
		{
			delete m_arSockets[i];
			m_arSockets.RemoveAt(i);
			i--;
		}
	}
}

int CIdentSocketManager::GetActiveConnections()
{
	CSingleLock slLock(&m_csListLock, true);

	return m_arSockets.GetSize();
}
