/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentProtocolSocket.cpp : implementation file
//

#include "stdafx.h"
#include "Identd.h"
#include "IdentProtocolSocket.h"
#include <strstrea.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIdentProtocolSocket

CIdentProtocolSocket::CIdentProtocolSocket()
{
	m_tCreateTime = CTime::GetCurrentTime();
}

CIdentProtocolSocket::~CIdentProtocolSocket()
{
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CIdentProtocolSocket, CAsyncSocket)
	//{{AFX_MSG_MAP(CIdentProtocolSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CIdentProtocolSocket member functions

void CIdentProtocolSocket::OnReceive(int nErrorCode) 
{
	char c;
	int iReceived = 0;
	
	do
	{
		iReceived = Receive(&c, sizeof(c));
		
		if (iReceived == sizeof(c))
			m_strReceivedData += c;

		if (m_strReceivedData.Right(2) == "\r\n")
		{
			m_strReceivedData = m_strReceivedData.Left(m_strReceivedData.GetLength() - 2);
			ProcessData();
			Close();
			m_bStillOpen = false;
			break;
		}

		if (m_strReceivedData.GetLength() > IDENTD_STRING_MAX)
		{
			m_bStillOpen = false;
			Close();
			break;
		}
	}
	while (iReceived == sizeof(c));

	CAsyncSocket::OnReceive(nErrorCode);
}

void CIdentProtocolSocket::OnClose(int nErrorCode) 
{
	m_bStillOpen = false;
	
	CAsyncSocket::OnClose(nErrorCode);
}

void CIdentProtocolSocket::SetIsOpen()
{
	m_bStillOpen = true;
}

CTimeSpan CIdentProtocolSocket::GetOpenTime()
{
	return CTime::GetCurrentTime() - m_tCreateTime;
}

void CIdentProtocolSocket::ProcessData()
{
	TRACE("Identd request: \"%s\"\n", m_strReceivedData);

	m_strReceivedData.TrimLeft();
	m_strReceivedData.TrimRight();

	int iInPort = 0, iOutPort = 0;
	CString strText, strPorts = "0, 0 : ";
	if (m_strReceivedData.Find(",") == -1)
	{
		strText = "ERROR : UNKNOWN-ERROR";
	}
	else
	{
		bool bHitEnd = false;
		istrstream ins(m_strReceivedData.GetBuffer(m_strReceivedData.GetLength()), m_strReceivedData.GetLength());

		ins >> iInPort;
		ins.ignore(IDENTD_STRING_MAX, ',');
		bHitEnd = (ins == false);
		ins >> iOutPort;

		if (bHitEnd)
		{
			strText = "ERROR : UNKNOWN-ERROR";
		}
		else
		{
			strPorts.Format("%i, %i : ", iInPort, iOutPort);
			if (iInPort < 1 || iInPort > 65535 || iOutPort < 1 || iOutPort > 65535)
			{
				strText = "ERROR : INVALID-PORT";
			}
			else
			{
				switch (m_pConfig->GetMode())
				{
				case CIdentConfig::OPER_NORMAL:
					strText = "USERID : " + m_pConfig->GetOSText() + " : " + m_pConfig->GetUserName() + "\r\n";
					break;
				case CIdentConfig::OPER_NOUSER:
					strText = "ERROR : NO-USER";
					break;
				case CIdentConfig::OPER_HIDDENUSER:
					strText = "ERROR : HIDDEN-USER";
					break;
				case CIdentConfig::OPER_UNKNOWNERROR:
					strText = "ERROR : UNKNOWN-ERROR";
					break;
				}
			}
		}
	}
	
	CString strResponse = strPorts + strText;
	TRACE("Identd response: \"%s\"\n", strResponse);
	strResponse += "\r\n";
	Send(strResponse, strResponse.GetLength());

	SLogMessageInfo Info;
	CString strPeerName;
	UINT uiPeerSocket;
	GetPeerName(strPeerName, uiPeerSocket);
	Info.strSourceAddres.Format("%s: %i", strPeerName, uiPeerSocket);

	Info.iLocalPort = iInPort;
	Info.iRemotePort = iOutPort;
	Info.strResponse = strText;

	::SendMessage(*AfxGetMainWnd(), WM_UPDATELOG, 0, (long)&Info);
}

void CIdentProtocolSocket::SetConfig(CIdentConfig* pConfig)
{
	m_pConfig = pConfig;
}

bool CIdentProtocolSocket::IsFinished()
{
	if (m_bStillOpen == false)
		return true;

	if (CTime::GetCurrentTime() - m_tCreateTime > CTimeSpan(0, 0, 0, 60))
		return true;

	return false;
}
