/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentConfig.h: interface for the CIdentConfig class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IDENTCONFIG_H__34D56372_606C_11D2_B2AD_006008CED79E__INCLUDED_)
#define AFX_IDENTCONFIG_H__34D56372_606C_11D2_B2AD_006008CED79E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CIdentConfig  
{
public:
	void SetUseToolTips(bool bUseToolTips);
	bool GetUseToolTips();
	void SetConfigFile(CString strConfigFile);
	enum { OPER_NORMAL = 0, OPER_NOUSER = 1, OPER_HIDDENUSER = 2, OPER_UNKNOWNERROR = 3 };
	enum { OS_UNIX = 0, OS_OTHER = 1, OS_SPECIFIED = 2 };

	CString GetUserName();
	int GetPort()					{ return m_iPort; }
	CString GetOSName()				{ return m_strOSName; }
	CString GetOSText();			
	int GetMode()					{ return m_iMode; }
	int GetOS()						{ return m_iOS; }
	int GetUseCurrentUser()			{ return (int)m_bUseCurrentUser; }
	CString GetDefaultUserName()	{ return m_strDefaultUserName; }


	void SetPort(int iPort);
	void SetOSName(CString strOSName);
	void SetMode(int iMode);
	void SetOS(int iOS);
	void SetUseCurrentUser(bool bUseCurrentUser);
	void SetDefaultUserName(CString strUserName);

	bool Write();
	bool Read();

	CIdentConfig();
	virtual ~CIdentConfig();

protected:
	bool m_bShowToolTips;
	CString m_strConfigFile;
	bool m_bUseCurrentUser;
	int m_iOS;
	int m_iMode;
	int m_iPort;
	CString m_strOSName;
	CString m_strDefaultUserName;
};

#endif // !defined(AFX_IDENTCONFIG_H__34D56372_606C_11D2_B2AD_006008CED79E__INCLUDED_)
