/*
Identd Ident Server for Windows '95/'98
Copyright (C) 1998 Matthew Mastracci

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

See the documentation for information on how to contact the author.

*/

// IdentConfig.cpp: implementation of the CIdentConfig class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Identd.h"
#include "IdentConfig.h"
#include <lmcons.h>
#include <fstream.h>
#include <strstrea.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIdentConfig::CIdentConfig() 
	: m_iPort(113), m_strDefaultUserName(_T("default")), 
	m_bUseCurrentUser(true), m_iMode(0), 
	m_iOS(0), m_strOSName(_T("")),
	m_bShowToolTips(true)
{

}

CIdentConfig::~CIdentConfig()
{

}

void CIdentConfig::SetPort(int iPort)
{
	m_iPort = iPort;
}

bool CIdentConfig::Read()
{
	CFile fConfigFile;
	if (!fConfigFile.Open(m_strConfigFile, CFile::modeRead))
		return false;

	CString strFile;
	fConfigFile.Read(strFile.GetBuffer(fConfigFile.GetLength()), fConfigFile.GetLength());
	fConfigFile.Close();
	strFile.ReleaseBuffer();

	istrstream fConfig(strFile.GetBuffer(strFile.GetLength()));
	if (fConfig)
	{
		fConfig >> m_iPort;
		fConfig.ignore(IDENTD_STRING_MAX, '\n');
		fConfig.getline(m_strDefaultUserName.GetBuffer(IDENTD_STRING_MAX), IDENTD_STRING_MAX);
		m_strDefaultUserName.ReleaseBuffer();
		m_strDefaultUserName.TrimLeft();
		m_strDefaultUserName.TrimRight();
		fConfig >> m_iOS;
		int iBoolVal;
		fConfig >> iBoolVal;
		m_bUseCurrentUser = (iBoolVal != 0);
		fConfig.ignore(IDENTD_STRING_MAX, '\n');
		fConfig.getline(m_strOSName.GetBuffer(IDENTD_STRING_MAX), IDENTD_STRING_MAX);
		m_strOSName.ReleaseBuffer();
		m_strOSName.TrimLeft();
		m_strOSName.TrimRight();
		fConfig >> m_iMode;
		fConfig >> iBoolVal;
		m_bShowToolTips = (iBoolVal != 0);
		return true;
	}
	else
		return false;

}

bool CIdentConfig::Write()
{
	CFile fConfigFile;
	if (!fConfigFile.Open(m_strConfigFile, CFile::modeWrite | CFile::modeCreate))
		return false;

	CString strFile;
	strFile.Format("%i\n%s\n%i\n%i\n%s\n%i\n%i\n", m_iPort, m_strDefaultUserName, m_iOS, m_bUseCurrentUser, m_strOSName, m_iMode, m_bShowToolTips);

	try
	{
		fConfigFile.Write(strFile, strFile.GetLength());
	}
	catch (...)
	{
		return false;
	}

	fConfigFile.Close();

	return true;
}

CString CIdentConfig::GetOSText()
{ 
	switch (m_iOS)
	{
	case OS_UNIX: 
		return "UNIX";
	case OS_OTHER: 
		return "OTHER"; 
	default:
		return m_strOSName; 
	}
}

void CIdentConfig::SetDefaultUserName(CString strUserName)
{
	m_strDefaultUserName = strUserName;
}

void CIdentConfig::SetUseCurrentUser(bool bUseCurrentUser)
{
	m_bUseCurrentUser = bUseCurrentUser;
}

void CIdentConfig::SetOS(int iOS)
{
	m_iOS = iOS;
}

void CIdentConfig::SetMode(int iMode)
{
	m_iMode = iMode;
}

void CIdentConfig::SetOSName(CString strOSName)
{
	m_strOSName = strOSName;
}

CString CIdentConfig::GetUserName()
{
	CString strUserName;
	DWORD dwSize = UNLEN + 1;
	if (m_bUseCurrentUser)
	{
		::GetUserName(strUserName.GetBuffer(dwSize), &dwSize);
		strUserName.ReleaseBuffer();
	}

	if (strUserName.IsEmpty())
		return m_strDefaultUserName;

	return strUserName;
}

void CIdentConfig::SetConfigFile(CString strConfigFile)
{
	m_strConfigFile = strConfigFile;
}

bool CIdentConfig::GetUseToolTips()
{
	return m_bShowToolTips;
}

void CIdentConfig::SetUseToolTips(bool bUseToolTips)
{
	m_bShowToolTips = bUseToolTips;
}
