
(* Yacc parser template (TP Yacc V3.0), V1.2 6-17-91 AG *)

(* global definitions: *)

{**********************************************}
{   Parser for TxQuery component               }
{   Copyright (c) 1999 by Alfonso Moreno       }
{**********************************************}
unit xqYacc;

{$I XQ_FLAG.INC}
{$R xqyacc.res}  
interface

uses SysUtils,Classes,Dialogs,Windows,LexLibQ,YaccLibQ,
     xqBase, xquery, DB, xqmiscel
{$IFDEF LEVEL3}
     , DBTables
{$ENDIF}
     ;

const _IDENTIFIER = 257;
const _UINTEGER = 258;
const _SINTEGER = 259;
const _NUMERIC = 260;
const _STRING = 261;
const _COMA = 262;
const _LPAREN = 263;
const _RPAREN = 264;
const _PERIOD = 265;
const _SEMICOLON = 266;
const _COLON = 267;
const _EQ = 268;
const _NEQ = 269;
const _GT = 270;
const _LT = 271;
const _GE = 272;
const _LE = 273;
const RW_BETWEEN = 274;
const RW_IN = 275;
const RW_LIKE = 276;
const _PLUS = 277;
const _SUB = 278;
const RW_OR = 279;
const _DIV = 280;
const _MULT = 281;
const RW_AND = 282;
const _NEG = 283;
const _EXP = 284;
const RW_NOT = 285;
const _ILLEGAL = 286;
const RW_TRUE = 287;
const RW_FALSE = 288;
const RW_SELECT = 289;
const RW_DISTINCT = 290;
const RW_FROM = 291;
const RW_WHERE = 292;
const RW_ORDER = 293;
const RW_BY = 294;
const RW_ASC = 295;
const RW_DESC = 296;
const RW_AS = 297;
const RW_INNER = 298;
const RW_OUTER = 299;
const RW_FULL = 300;
const RW_JOIN = 301;
const RW_ON = 302;
const RW_GROUP = 303;
const RW_HAVING = 304;
const RW_ANY = 305;
const RW_ALL = 306;
const RW_SUM = 307;
const RW_AVG = 308;
const RW_COUNT = 309;
const RW_MIN = 310;
const RW_MAX = 311;
const RW_LEFT = 312;
const RW_RIGHT = 313;
const RW_LEADING = 314;
const RW_TRAILING = 315;
const RW_BOTH = 316;
const RW_TRIM = 317;
const RW_EXTRACT = 318;
const RW_YEAR = 319;
const RW_MONTH = 320;
const RW_DAY = 321;
const RW_HOUR = 322;
const RW_MINUTE = 323;
const RW_SECOND = 324;
const RW_FOR = 325;
const RW_SUBSTRING = 326;
const RW_DELETE = 327;
const RW_UPDATE = 328;
const RW_INSERT = 329;
const RW_INTO = 330;
const RW_VALUES = 331;
const RW_SET = 332;
const RW_CAST = 333;
const RW_CHAR = 334;
const RW_INTEGER = 335;
const RW_BOOLEAN = 336;
const RW_DATE = 337;
const RW_TIME = 338;
const RW_DATETIME = 339;
const RW_FLOAT = 340;
const RW_ESCAPE = 341;
const RW_NOW = 342;
const _COMMENT = 343;
const _BLANK = 344;
const _TAB = 345;
const _NEWLINE = 346;
const RW_CREATE = 347;
const RW_TABLE = 348;
const RW_SMALLINT = 349;
const RW_MONEY = 350;
const RW_AUTOINC = 351;
const RW_PRIMARY = 352;
const RW_KEY = 353;
const RW_BLOB = 354;
const RW_INDEX = 355;
const RW_UNIQUE = 356;
const RW_DROP = 357;
const RW_TRANSFORM = 358;
const RW_PIVOT = 359;
const RW_MERGE = 360;
const RW_WITH = 361;
const RW_IS = 362;
const RW_NULL = 363;

type YYSType = record
                 yystring : string;
               end(*YYSType*);

var yylval : YYSType;


type
  TxqParser = class( TCustomParser )
  private
      FInPredicateList : TStringList;
      FIsNotInList     : Boolean;
      FForLength       : String;
      FEscapeChar      : String;
      FJoinKind        : TJoinKind;
      FTrimPosition    : Integer;
      FExtractField    : Integer;
      FCastType        : Integer;
      FCastLen         : Integer;
      FCurrentJoin     : Integer;
      FIsDistinctAggr  : Boolean;
      FAnalizer        : TSqlAnalizer;
      FAsAlias         : String;
      FJoinRelOperator : TRelationalOperator;
      FNumInserts      : Integer;   { used in INSERTO INTO...}
      FAggregateList   : TAggregateList;

      { for CREATE TABLE }
      FNumTables, FFieldType, FScale, FPrecision, FSize, FBlobType: Integer;
      procedure SetFieldParams(AFieldType,
                               AScale,
                               APrecision,
                               ASize,
                               ABlobType: Integer);
      procedure SetTableName(const TableName: String);
      procedure AddCreateField(const FieldName: String);
      procedure AddPrimaryKeyField(const FieldName: String);
      function CurrentCreateTable: TCreateTableItem;
      function GetCurrentAnalizer: TSqlAnalizer;
      function CurrentInsertItem : TInsertItem;
      function CreateInListExpression( const Expr : String ): String;
  public

      constructor Create(Analizer: TSqlAnalizer);
      destructor Destroy; override;

      function yyparse : integer; override;
      procedure yyerror(const msg : string); override;

      { specials }
      procedure AddColumn(const AColText : String);
      function AddAggregate( pAggregate  : TAggregateKind;
                    const pAggregateStr : String ) : String;
      procedure AddGroupBy(const ColName: String);
      procedure AddOrderBy(const ColName: String; Descending: Boolean);
      procedure AddTable(const TableName, Alias: String);
      procedure AddJoin(const LeftExpr, RightExpr, AndExpr: String);
      procedure AddJoinCandidate(const LeftExpr, RightExpr: String);
      procedure AddHavingColumn( const ColText : String );
      procedure AddUpdateColumn(const ColumnName, ColumnExpr: String);
      procedure AddWhereOptimize(const AFieldName,
                                 ARangeStart,
                                 ARangeEnd    : String;
                                 ARelOperator : TRelationalOperator);
      procedure AddParam(const ParamName: String);

      property Analizer: TSqlAnalizer read FAnalizer write FAnalizer;
      property AsAlias: String read FAsAlias write FAsAlias;
      property CurrentAnalizer: TSqlAnalizer read GetCurrentAnalizer;
  end;

implementation

uses
   xqLex, xqConsts;

(*----------------------------------------------------------------------------*)
procedure TxqParser.yyerror(const msg : string);
begin
   yyerrorMsg := msg;
   { yyerrorMsg := IntToStr(yyLexer.yylineno) +  ': ' + msg + ' at or before '+ yyLexer.yytext + '. ' +
         Format('Line %d, Column %d',[yyLexer.yylineno,yyLexer.yycolno]);
   if Analizer.xQuery.ShowErrorMessage then
      ShowMessage( yyerrorMsg ); }
end;

constructor TxqParser.Create(Analizer: TSqlAnalizer);
begin
   inherited Create;
   FAnalizer:= Analizer;
   FInPredicateList := TStringList.Create;
end;

destructor TxqParser.Destroy;
begin
   FInPredicateList.Free;
   if Assigned(FAggregateList) then
      FAggregateList.Free;
   inherited Destroy;
end;

function TxqParser.GetCurrentAnalizer: TSqlAnalizer;
var
   NumSelects   : Integer;
   MainAnalizer : TSqlAnalizer;
   TmpAnalizer  : TSqlAnalizer;

   function StandardAnalizer : TSqlAnalizer;
   begin
     Result := MainAnalizer;
     NumSelects := (yylexer as TxqLexer).NumSelects;
     while NumSelects > 1 do
     begin
        TmpAnalizer := Result;
        Result := Result.SubQuery;
        if Result = nil then
        begin
           Result := TSqlAnalizer.Create(TmpAnalizer, FAnalizer.xQuery);
           TmpAnalizer.SubQuery := Result;
        end;
        Dec(NumSelects);
     end;
   end;

begin
   with (yylexer as TxqLexer) do begin
      if IsMergeActive or IsWithActive then
      begin
         if IsMergeActive then                { merge is active. Return standard analizer }
         begin
            MainAnalizer := Self.FAnalizer;
            Result       := StandardAnalizer;
         end else                             { with is active. Return alternate analizer }
         begin
            if Self.FAnalizer.MergeAnalizer = nil then
               Self.FAnalizer.MergeAnalizer := TSqlAnalizer.Create(nil, FAnalizer.xQuery);
            MainAnalizer := Self.FAnalizer.MergeAnalizer;
            Result       := StandardAnalizer;
         end;
      end else
      begin
         MainAnalizer := Self.FAnalizer;
         Result       := StandardAnalizer;
      end;
   end;
end;

procedure TxqParser.AddColumn(const AColText : String);
var
   Column : TColumnItem;

   function StripFields(const s: String): String;
   var
      p, i, j: Integer;
      Found: Boolean;
   begin
      Result:= s;
      p:= Pos('\f"', Result);
      while p > 0 do
      begin
         j:= p + 3;
         i:= j;
         Found:= True;
         while (j <= Length(Result)) do
         begin
            if Result[j] = '"' then
            begin
               Found:= True;
               Break;
            end;
            Inc(j);
         end;
         if Not Found then Exit;    { fatal error }
         if j <= Length(Result) then
            Result:= Copy(Result, 1, p - 1) + Copy(Result, i, j - i) +
               Copy(Result, j + 1, Length(Result));

         p:= Pos('\f"', Result);
      end;
   end;

begin
   if (CurrentAnalizer.ColumnList.Count = 0) and (yylexer as TxqLexer).IsTransform then
   begin
      Column := CurrentAnalizer.TransformColumn;
      (yylexer as TxqLexer).IsTransform:= False;
   end else
      Column := CurrentAnalizer.ColumnList.Add;
   with Column do
   begin
      ColumnExpr:= AColText;
      { this mean that aggregate columns are embedded in ColumnExpr}
      if Assigned(Self.FAggregateList) then
      begin
         Column.AggregateList.Free;    { free previous aggregate list}
         Column.AggregateList := Self.FAggregateList; { assign the current list}
         Self.FAggregateList:= nil;    { define as nil the current }
      end;
      CastType  := Self.FCastType;
      CastLen   := IMax(1, Self.FCastLen);      // only used for strings
      if Length(self.FAsAlias) > 0 then
      begin
         AsAlias:= self.FAsAlias;
         IsAsExplicit:= True;
      end else
      begin
         IsAsExplicit := False;
         AsAlias := StripFields(AColText);
         if AggregateList.Count > 0  then
            case AggregateList[0].Aggregate of
               akSUM: AsAlias := SAggrSUM + StripFields(AggregateList[0].AggregateStr);
               akAVG: AsAlias := SAggrAVG + StripFields(AggregateList[0].AggregateStr);
               akMIN: AsAlias := SAggrMIN + StripFields(AggregateList[0].AggregateStr);
               akMAX: AsAlias := SAggrMAX + StripFields(AggregateList[0].AggregateStr);
               akCOUNT: AsAlias := SAggrCOUNT;
            end;
      end;
   end;

   FAsAlias  := '';
   FCastType := 0;
   FCastLen  := 0;
end;

{ This function will return an aggregate encoded with something like :
  (Aggregate 1) }
function TxqParser.AddAggregate( pAggregate  : TAggregateKind;
                         const pAggregateStr : String ) : String;
begin
  if FAggregateList = nil then
     FAggregateList := TAggregateList.Create;
  with FAggregateList.Add do
  begin
     AggregateStr := pAggregateStr;
     Aggregate    := pAggregate;
     IsDistinctAg := Self.FIsDistinctAggr;
  end;
  Result := Format('{Aggregate %d}', [FAggregateList.Count - 1]);

  Self.FIsDistinctAggr := False;
end;

procedure TxqParser.AddGroupBy(const ColName: String);
var
   GroupBy: TOrderByItem;
   Index, Code: integer;
begin
   Val(ColName, Index, Code);
   GroupBy := CurrentAnalizer.GroupByList.Add;
   if Code = 0 then
   begin
      GroupBy.Alias := '';
      GroupBy.ColIndex := Index - 1;
   end else
   begin
      GroupBy.Alias := ColName;
      GroupBy.ColIndex:= -1;   { means: not defined by number }
   end;
end;

procedure TxqParser.AddOrderBy(const ColName: String; Descending: Boolean);
var
  OrderBy     : TOrderByItem;
  Index, Code : integer;
begin
  Val(ColName, Index, Code);
  OrderBy:= CurrentAnalizer.OrderByList.Add;
  if Code = 0 then
  begin
     OrderBy.Alias := '';
     OrderBy.ColIndex := Index - 1;
  end else
  begin
     OrderBy.Alias := ColName;
     { means: not defined by number and must be solved in checkintegrity }
     OrderBy.ColIndex:= -1;
  end;
  OrderBy.Desc:= Descending;
end;

procedure TxqParser.AddTable(const TableName, Alias: String);
var
   Table: TTableItem;
begin
   Table := CurrentAnalizer.TableList.Add;
   Table.TableName := TableName;
   if Length(Alias) > 0 then
      Table.Alias := Alias
   else
      Table.Alias := TableName;
end;

procedure TxqParser.AddJoin(const LeftExpr, RightExpr, AndExpr: String);
var
   JoinOnItem          : TJoinOnItem;
   LeftJoinOnExprItem  : TJoinOnExprItem;
   RightJoinOnExprItem : TJoinOnExprItem;
   AndJoinOnExprItem   : TJoinOnExprItem;
begin

   if CurrentAnalizer.JoinList.Count <= FCurrentJoin then
   begin
      JoinOnItem          := CurrentAnalizer.JoinList.Add;
      LeftJoinOnExprItem  := JoinOnItem.LeftJoinOn.Add;
      RightJoinOnExprItem := JoinOnItem.RightJoinOn.Add;
      AndJoinOnExprItem   := JoinOnItem.AndJoinOn.Add;
   end else
   begin
      JoinOnItem          := CurrentAnalizer.JoinList[FCurrentJoin];
      LeftJoinOnExprItem  := JoinOnItem.LeftJoinOn.Add;
      RightJoinOnExprItem := JoinOnItem.RightJoinOn.Add;
      AndJoinOnExprItem   := JoinOnItem.AndJoinOn.Add;
   end;

   with JoinOnItem do
   begin
      JoinKind:= Self.FJoinKind;
      RelOperator:= FJoinRelOperator;
   end;
   LeftJoinOnExprItem.Expression   := LeftExpr;
   RightJoinOnExprItem.Expression := RightExpr;
   AndJoinOnExprItem.Expression     := AndExpr;

   Self.FJoinKind:= jkInnerJoin;
   Self.FJoinRelOperator:= ropBETWEEN;
end;

procedure TxqParser.AddJoinCandidate(const LeftExpr, RightExpr: String);
begin
  CurrentAnalizer.LJoinCandidateList.Add( LeftExpr );
  CurrentAnalizer.RJoinCandidateList.Add( RightExpr );
end;

procedure TxqParser.AddHavingColumn( const ColText : String );
var
   Column: TColumnItem;
begin
   Column := CurrentAnalizer.ColumnList.Add;
   with Column do
   begin
      ColumnExpr := ColText;
      if Assigned(Self.FAggregateList) then
      begin
         AggregateList.Free;    { free previous aggregate list}
         AggregateList := Self.FAggregateList; { assign the current list}
         Self.FAggregateList:= nil;    { define as nil the current }
      end;
      { mark also as a temporary column that will be deleted after result set is
        generated }
      IsTemporaryCol := True;
   end;
end;

procedure TxqParser.AddUpdateColumn(const ColumnName, ColumnExpr: String);
var
   UpdateItem: TUpdateItem;
begin
   UpdateItem := CurrentAnalizer.UpdateColumnList.Add;
   with UpdateItem do
   begin
      ColName := ColumnName;
      ColExpr := ColumnExpr;
   end;

end;

procedure TxqParser.AddWhereOptimize(const AFieldName,
                                     ARangeStart,
                                     ARangeEnd: String;
                                     ARelOperator: TRelationalOperator);
var
   WhereOptimize : TWhereOptimizeItem;
   N             : Integer;

   function DeleteStringDelim(const s: String): String;
   begin
      Result := s;
      if Length(Result) > 1 then
      begin
         if (Result[1] in xqbase.SQuote) and (Result[Length(Result)] in xqbase.SQuote) then
            Result:= Copy(Result, 2, Length(Result) - 2);
      end;
   end;

begin
   if Not (yyLexer as TxqLexer).IsWhereActive then Exit;
   N := CurrentAnalizer.WhereOptimizeList.Count - 1;
   if ((ARelOperator in [ropLE, ropLT]) or (ARelOperator in [ropGE, ropGT]) ) and (N > 0) then
   begin

      { I will check if the previous command was something like (CustNo >= 1000)
         and if so, and this is something like (CustNo <= 3000) then
         I will add to the previous optimize and will generate a ropBETWEEN range   }

      WhereOptimize:= CurrentAnalizer.WhereOptimizeList[N - 1];
      if ( ((ARelOperator in [ropLE, ropLT]) and (WhereOptimize.RelOperator in [ropGE, ropGT])) or
         ((ARelOperator in [ropGE, ropGT]) and (WhereOptimize.RelOperator in [ropLE, ropLT])) ) and
         (AnsiCompareText(WhereOptimize.FieldNames, AFieldName) = 0) then
      begin
         WhereOptimize.RangeEnd    := DeleteStringDelim( ARangeEnd );
         WhereOptimize.RelOperator := ropBETWEEN;
         Exit;
      end;
   end;

   WhereOptimize := CurrentAnalizer.WhereOptimizeList.Add;
   with WhereOptimize do
   begin
      FieldNames  := AFieldName;
      RangeStart  := DeleteStringDelim(ARangeStart);
      RangeEnd    := DeleteStringDelim(ARangeEnd);
      RelOperator := ARelOperator;
      CanOptimize := False;
   end;

end;

procedure TxqParser.AddParam(const ParamName: String);
begin
  CurrentAnalizer.Params.CreateParam(ftString, ParamName, ptUnknown);
end;

{ CREATE TABLE }
function TxqParser.CurrentCreateTable: TCreateTableItem;
begin
  if FNumTables > CurrentAnalizer.CreateTableList.Count - 1 then
     Result := CurrentAnalizer.CreateTableList.Add
  else
     Result:= CurrentAnalizer.CreateTableList[ FNumTables ];
end;

procedure TxqParser.SetTableName(const TableName: String);
begin
   CurrentCreateTable.TableName := TableName;
end;

procedure TxqParser.SetFieldParams(AFieldType, AScale, APrecision, ASize, ABlobType: Integer);
begin
  FFieldType := AFieldType;
  FScale     := AScale;
  FPrecision := APrecision;
  FSize      := ASize;
  FBlobType  := ABlobType;
end;

procedure TxqParser.AddCreateField(const FieldName: String);
var
  I: Integer;
begin
  { check if field exists }
  with CurrentCreateTable do
     for I := 0 to FieldCount - 1 do
        if AnsiCompareText(Fields[I].FieldName, FieldName) = 0 then
        begin
           yyerror(SDuplicateFieldName);
           yyabort;
           Exit;
        end;
  if (FFieldType = RW_BLOB) and not (FBlobType in [1..5]) then
  begin
    yyerror(SBlobFieldWrongType);
    yyabort;
  end;
  CurrentCreateTable.Fields.AddField(FieldName,
                                     FFieldType,
                                     FScale,
                                     FPrecision,
                                     FSize,
                                     FBlobType);
end;

procedure TxqParser.AddPrimaryKeyField(const FieldName: String);
var
  I : Integer;
  Found : Boolean;
begin
  { check that the field exists in the list of field names }
  Found := False;
  with CurrentCreateTable do
     for I := 0 to FieldCount - 1 do
        if AnsiCompareText(Fields[I].FieldName, FieldName) = 0 then
        begin
           Found:= True;
           Break;
        end;
  if Not Found then
  begin
     yyerror(SFieldNameNotFound);
     yyabort;
  end;
  CurrentCreateTable.PrimaryKey.Add( FieldName );
end;

function TxqParser.CurrentInsertItem: TInsertItem;
begin
   if FNumInserts >= CurrentAnalizer.InsertList.Count then
      Result := CurrentAnalizer.InsertList.Add
   else
      Result := CurrentAnalizer.InsertList[FNumInserts];
end;

function TxqParser.CreateInListExpression( const Expr : String ) : String;
var
   i : Integer;
begin
   { This subroutine helps to change the syntax:
     custno IN (1000, 2000, 3000)
     to this :
     (custno = 1000) OR (custno = 2000) OR (custno = 3000) }
   Result := '';
   for i := 0 to FInPredicateList.Count - 1 do begin
      Result := Result + Format('(%s = %s)', [Expr, FInPredicateList[i]]);
      if i < FInPredicateList.Count - 1 then
         Result := Result + ' OR ';
   end;
   if FIsNotInList then
      Result := 'NOT ( ' + Result + ' )'
   else
      Result := '( ' + Result + ' )';
   FInPredicateList.Clear;
end;

// function yylex : Integer; forward;  // addition 1

function TXQParser.yyparse : Integer; // addition 2

var yystate, yysp, yyn : SmallInt;
    yys : array [1..yymaxdepth] of SmallInt;
    yyv : array [1..yymaxdepth] of YYSType;
    yyval : YYSType;

procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)
begin
  (* actions: *)
  case yyruleno of
   1 : begin
         FAnalizer.Statement := ssSelect;
       end;
   2 : begin
         FAnalizer.Statement := ssSelect;
       end;
   3 : begin
         FAnalizer.Statement := ssMerge;
       end;
   4 : begin
         FAnalizer.Statement := ssUpdate;
       end;
   5 : begin
         FAnalizer.Statement := ssDelete;
       end;
   6 : begin
         FAnalizer.Statement := ssInsert;
       end;
   7 : begin
         FAnalizer.Statement := ssCreateTable;
       end;
   8 : begin
         FAnalizer.Statement := ssCreateIndex;
       end;
   9 : begin
         FAnalizer.Statement := ssDropTable;
       end;
  10 : begin
         FAnalizer.Statement := ssDropIndex;
       end;
  11 : begin
         yyval := yyv[yysp-5];
       end;
  12 : begin
         CurrentAnalizer.DoSelectAll := True;
       end;
  13 : begin
         yyval := yyv[yysp-1];
       end;
  14 : begin
         yyval := yyv[yysp-0];
       end;
  15 : begin
         CurrentAnalizer.IsDistinct:= True;
       end;
  16 : begin
         yyval := yyv[yysp-0];
       end;
  17 : begin
         yyval := yyv[yysp-2];
       end;
  18 : begin
         AddColumn( yyv[yysp-1].yystring ); 
       end;
  19 : begin
         CurrentAnalizer.TableAllFields.Add( yyv[yysp-2].yystring ); 
       end;
  20 : begin
         AddColumn( yyv[yysp-4].yystring ); 
       end;
  21 : begin
       end;
  22 : begin
         FAsAlias:= yyv[yysp-0].yystring;
       end;
  23 : begin
         yyval := yyv[yysp-0];
       end;
  24 : begin
         yyval := yyv[yysp-0];
       end;
  25 : begin
         yyval := yyv[yysp-0];
       end;
  26 : begin
         yyval := yyv[yysp-0];
       end;
  27 : begin
         yyval := yyv[yysp-0];
       end;
  28 : begin
         yyval := yyv[yysp-0];
       end;
  29 : begin
         yyval := yyv[yysp-0];
       end;
  30 : begin
         yyval := yyv[yysp-0];
       end;
  31 : begin
         yyval := yyv[yysp-0];
       end;
  32 : begin
         yyval := yyv[yysp-0];
       end;
  33 : begin
         yyval := yyv[yysp-0];
       end;
  34 : begin
         yyval := yyv[yysp-0];
       end;
  35 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' + '  + yyv[yysp-0].yystring; 
       end;
  36 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' - '  + yyv[yysp-0].yystring; 
       end;
  37 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' * '  + yyv[yysp-0].yystring; 
       end;
  38 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' / '  + yyv[yysp-0].yystring; 
       end;
  39 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' ^ '  + yyv[yysp-0].yystring; 
       end;
  40 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' > '  + yyv[yysp-0].yystring; 
       end;
  41 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' < '  + yyv[yysp-0].yystring; 
       end;
  42 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' <> ' + yyv[yysp-0].yystring; 
       end;
  43 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' >= ' + yyv[yysp-0].yystring; 
       end;
  44 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' <= ' + yyv[yysp-0].yystring; 
       end;
  45 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' = '  + yyv[yysp-0].yystring; 
       end;
  46 : begin
         yyval.yystring := yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
  47 : begin
         yyval.yystring := yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
  48 : begin
         yyval.yystring := yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
  49 : begin
         yyval.yystring := AddAggregate(akSUM, yyv[yysp-1].yystring); 
       end;
  50 : begin
         yyval.yystring := AddAggregate(akMIN, yyv[yysp-1].yystring); 
       end;
  51 : begin
         yyval.yystring := AddAggregate(akMAX, yyv[yysp-1].yystring); 
       end;
  52 : begin
         yyval.yystring := AddAggregate(akAVG, yyv[yysp-1].yystring); 
       end;
  53 : begin
         yyval.yystring := AddAggregate(akCOUNT, '0'); 
       end;
  54 : begin
         yyval.yystring := AddAggregate(akCOUNT, yyv[yysp-1].yystring); 
       end;
  55 : begin
       end;
  56 : begin
         Self.FIsDistinctAggr:= True; 
       end;
  57 : begin
         yyval.yystring := yyv[yysp-3].yystring + yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
  58 : begin
         yyval.yystring := Format('SQLTRIM(%s, %s, %d)',[yyv[yysp-3].yystring, yyv[yysp-1].yystring, FTrimPosition]);
       end;
  59 : begin
         FTrimPosition := 0;
       end;
  60 : begin
         FTrimPosition := 1;
       end;
  61 : begin
         FTrimPosition := 2;
       end;
  62 : begin
         yyval.yystring := Format('SQLEXTRACT(%s, %d)',[yyv[yysp-1].yystring, FExtractField]);
       end;
  63 : begin
         FExtractField:= 0; 
       end;
  64 : begin
         FExtractField:= 1; 
       end;
  65 : begin
         FExtractField:= 2; 
       end;
  66 : begin
         FExtractField:= 3; 
       end;
  67 : begin
         FExtractField:= 4; 
       end;
  68 : begin
         FExtractField:= 5; 
       end;
  69 : begin
         if Length(FForLength) > 0 then
         yyval.yystring := Format('COPY(%s,%s,%s)',[yyv[yysp-4].yystring,yyv[yysp-2].yystring,FForLength])
         else
         yyval.yystring := Format('COPY(%s,%s,LENGTH(%s))',[yyv[yysp-4].yystring,yyv[yysp-2].yystring,yyv[yysp-4].yystring]);
         FForLength:='';
       end;
  70 : begin
       end;
  71 : begin
         FForLength:= yyv[yysp-0].yystring;
       end;
  72 : begin
         FCastType := RW_CHAR;
         FCastLen:= StrToInt( yyv[yysp-1].yystring ); 
       end;
  73 : begin
         FCastType := RW_INTEGER; 
       end;
  74 : begin
         FCastType := RW_BOOLEAN; 
       end;
  75 : begin
         FCastType := RW_DATE; 
       end;
  76 : begin
         FCastType := RW_TIME; 
       end;
  77 : begin
         FCastType := RW_DATETIME; 
       end;
  78 : begin
         FCastType := RW_FLOAT; 
       end;
  79 : begin
         FCastType := RW_MONEY; 
       end;
  80 : begin
         yyval.yystring := Format('\f"%s"',[yyv[yysp-0].yystring]); 
       end;
  81 : begin
         yyval := yyv[yysp-0];
       end;
  82 : begin
         yyval.yystring := yyv[yysp-1].yystring + yyv[yysp-0].yystring;
         AddParam( yyv[yysp-0].yystring ); 
       end;
  83 : begin
         yyval.yystring := Format('\f"%s.%s"',[yyv[yysp-2].yystring, yyv[yysp-0].yystring]); 
       end;
  84 : begin
       end;
  85 : begin
         yyval := yyv[yysp-0];
       end;
  86 : begin
         yyval := yyv[yysp-0];
       end;
  87 : begin
         yyval := yyv[yysp-0];
       end;
  88 : begin
         yyval.yystring:= yyv[yysp-2].yystring + ', ' + yyv[yysp-0].yystring;
       end;
  89 : begin
         yyval := yyv[yysp-1];
       end;
  90 : begin
         yyval := yyv[yysp-2];
       end;
  91 : begin
         yyval := yyv[yysp-0];
       end;
  92 : begin
         yyval := yyv[yysp-2];
       end;
  93 : begin
         AddTable(yyv[yysp-0].yystring, '');
       end;
  94 : begin
         AddTable(yyv[yysp-1].yystring, yyv[yysp-0].yystring);
       end;
  95 : begin
         yyval := yyv[yysp-0];
       end;
  96 : begin
         yyval := yyv[yysp-1];
       end;
  97 : begin
         Inc(FCurrentJoin);
       end;
  98 : begin
         FJoinKind:= jkInnerJoin;     
       end;
  99 : begin
         FJoinKind:= jkInnerJoin;     
       end;
 100 : begin
         FJoinKind:= jkLeftOuterJoin; 
       end;
 101 : begin
         FJoinKind:= jkLeftOuterJoin; 
       end;
 102 : begin
         FJoinKind:= jkRightOuterJoin;
       end;
 103 : begin
         FJoinKind:= jkRightOuterJoin;
       end;
 104 : begin
         FJoinKind:= jkFullOuterJoin; 
       end;
 105 : begin
         FJoinKind:= jkFullOuterJoin; 
       end;
 106 : begin
         yyval := yyv[yysp-0];
       end;
 107 : begin
         yyval := yyv[yysp-2];
       end;
 108 : begin
         AddJoin(yyv[yysp-3].yystring, yyv[yysp-1].yystring, ''); 
       end;
 109 : begin
         AddJoin(yyv[yysp-5].yystring, yyv[yysp-3].yystring, yyv[yysp-1].yystring); 
       end;
 110 : begin
         FJoinRelOperator := ropBETWEEN;
       end;
 111 : begin
         FJoinRelOperator := ropGT;
       end;
 112 : begin
         FJoinRelOperator := ropLT;
       end;
 113 : begin
         FJoinRelOperator := ropGE;
       end;
 114 : begin
         FJoinRelOperator := ropLE;
       end;
 115 : begin
         FJoinRelOperator := ropNEQ;
       end;
 116 : begin
         yyval := yyv[yysp-0];
       end;
 117 : begin
         yyval := yyv[yysp-0];
       end;
 118 : begin
         yyval := yyv[yysp-0];
       end;
 119 : begin
         yyval := yyv[yysp-0];
       end;
 120 : begin
         yyval := yyv[yysp-0];
       end;
 121 : begin
         yyval := yyv[yysp-0];
       end;
 122 : begin
         yyval := yyv[yysp-0];
       end;
 123 : begin
         yyval.yystring := yyv[yysp-3].yystring + yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring; 
       end;
 124 : begin
         yyval.yystring := yyv[yysp-3].yystring + yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring; 
       end;
 125 : begin
         yyval.yystring := yyv[yysp-3].yystring + yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring; 
       end;
 126 : begin
         yyval.yystring := Format('(%s >= %s) AND (%s <= %s)',
         [yyv[yysp-4].yystring, yyv[yysp-2].yystring, yyv[yysp-4].yystring, yyv[yysp-0].yystring]);
         AddWhereOptimize( yyv[yysp-4].yystring, yyv[yysp-2].yystring, yyv[yysp-0].yystring, ropBETWEEN ); 
       end;
 127 : begin
         yyval.yystring :=  CreateInListExpression( yyv[yysp-4].yystring ); 
       end;
 128 : begin
         if Pos('NOT',AnsiUpperCase(yyv[yysp-1].yystring)) = 0 then
         yyval.yystring := yyv[yysp-2].yystring + ' = (subquery)'
         else
         yyval.yystring := yyv[yysp-2].yystring + ' <> (subquery)'; 
       end;
 129 : begin
         if FEscapeChar = '' then FEscapeChar := #39#39; 
         yyval.yystring := Format('SQLLIKE(%s, %s, %s)',[yyv[yysp-3].yystring, yyv[yysp-1].yystring, FEscapeChar]); FEscapeChar:= '';
       end;
 130 : begin
         if FEscapeChar = '' then FEscapeChar := #39#39;
         yyval.yystring := Format('SQLNOTLIKE(%s, %s, %s)',[yyv[yysp-4].yystring, yyv[yysp-1].yystring, FEscapeChar]); FEscapeChar:= '';
       end;
 131 : begin
         yyval.yystring := yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
 132 : begin
         yyval.yystring := yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
 133 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' + ' + yyv[yysp-0].yystring;
       end;
 134 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' - ' + yyv[yysp-0].yystring;
       end;
 135 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' * ' + yyv[yysp-0].yystring;
       end;
 136 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' / ' + yyv[yysp-0].yystring;
       end;
 137 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' ^ ' + yyv[yysp-0].yystring;
       end;
 138 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropGE); 
       end;
 139 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropLE); 
       end;
 140 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropGT); 
       end;
 141 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropLT); 
       end;
 142 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddJoinCandidate(yyv[yysp-2].yystring, yyv[yysp-0].yystring);
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropBETWEEN); 
       end;
 143 : begin
         yyval.yystring := yyv[yysp-2].yystring + #32 + yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring;
         AddWhereOptimize( yyv[yysp-2].yystring, yyv[yysp-0].yystring, yyv[yysp-0].yystring, ropNEQ); 
       end;
 144 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' AND ' + yyv[yysp-0].yystring;
       end;
 145 : begin
         yyval.yystring := yyv[yysp-2].yystring + ' OR ' + yyv[yysp-0].yystring;
       end;
 146 : begin
         yyval.yystring := ' NOT ' + yyv[yysp-0].yystring;
       end;
 147 : begin
         yyval.yystring := yyv[yysp-2].yystring + yyv[yysp-1].yystring + yyv[yysp-0].yystring;
       end;
 148 : begin
         yyval.yystring := '(subquery)';
       end;
 149 : begin
         yyval.yystring := Format('ISNULL(%s,TRUE)', [yyv[yysp-2].yystring]);
       end;
 150 : begin
         yyval.yystring := Format('ISNULL(%s,FALSE)', [yyv[yysp-3].yystring]); 
       end;
 151 : begin
         FIsNotInList := False; 
       end;
 152 : begin
         yyval.yystring := yyv[yysp-1].yystring + #32 + yyv[yysp-0].yystring; FIsNotInList := True; 
       end;
 153 : begin
         FInPredicateList.Add( yyv[yysp-0].yystring ); 
       end;
 154 : begin
         FInPredicateList.Add( yyv[yysp-0].yystring ); 
       end;
 155 : begin
         yyval := yyv[yysp-0];
       end;
 156 : begin
         yyval := yyv[yysp-0];
       end;
 157 : begin
         yyval := yyv[yysp-0];
       end;
 158 : begin
         yyval := yyv[yysp-0];
       end;
 159 : begin
         yyval.yystring := 'DummyBoolean(True)'; 
       end;
 160 : begin
         yyval.yystring := 'DummyBoolean(False)'; 
       end;
 161 : begin
         yyval := yyv[yysp-0];
       end;
 162 : begin
         yyval := yyv[yysp-0];
       end;
 163 : begin
         yyval.yystring:= yyv[yysp-2].yystring + ', ' + yyv[yysp-0].yystring;
       end;
 164 : begin
       end;
 165 : begin
         CurrentAnalizer.WhereStr := yyv[yysp-0].yystring; 
       end;
 166 : begin
         CurrentAnalizer.SubQueryKind:= skAny;
       end;
 167 : begin
         CurrentAnalizer.SubQueryKind:= skAny;
       end;
 168 : begin
         CurrentAnalizer.SubQueryKind:= skAll;
       end;
 169 : begin
         with TxqLexer(yylexer) do NumSelects := NumSelects - 1; 
       end;
 170 : begin
         FEscapeChar := '';
       end;
 171 : begin
         FEscapeChar := yyv[yysp-0].yystring;
       end;
 172 : begin
       end;
 173 : begin
         yyval := yyv[yysp-3];
       end;
 174 : begin
         AddGroupBy( yyv[yysp-0].yystring );
       end;
 175 : begin
         AddGroupBy( yyv[yysp-0].yystring );
       end;
 176 : begin
         yyval.yystring := Format('\f"%s"', [yyv[yysp-0].yystring]); 
       end;
 177 : begin
         yyval := yyv[yysp-0];
       end;
 178 : begin
         yyval.yystring := yyv[yysp-0].yystring; 
       end;
 179 : begin
       end;
 180 : begin
         AddHavingColumn( yyv[yysp-0].yystring );
         CurrentAnalizer.HavingCol := CurrentAnalizer.ColumnList.Count-1; 
       end;
 181 : begin
       end;
 182 : begin
         yyval := yyv[yysp-2];
       end;
 183 : begin
         yyval := yyv[yysp-0];
       end;
 184 : begin
         yyval := yyv[yysp-2];
       end;
 185 : begin
         AddOrderBy( yyv[yysp-0].yystring, False );
       end;
 186 : begin
         AddOrderBy( yyv[yysp-1].yystring, False );
       end;
 187 : begin
         AddOrderBy( yyv[yysp-1].yystring, True );
       end;
 188 : begin
       end;
 189 : begin
         yyval := yyv[yysp-0];
       end;
 190 : begin
         yyval := yyv[yysp-5];
       end;
 191 : begin
         AddUpdateColumn(yyv[yysp-2].yystring,yyv[yysp-0].yystring);
       end;
 192 : begin
         yyval := yyv[yysp-0];
       end;
 193 : begin
         yyval := yyv[yysp-2];
       end;
 194 : begin
         yyval := yyv[yysp-4];
       end;
 195 : begin
         yyval := yyv[yysp-1];
       end;
 196 : begin
         Inc(FNumInserts); 
       end;
 197 : begin
         Inc(FNumInserts); 
       end;
 198 : begin
         CurrentInsertItem.TableName := yyv[yysp-2].yystring ; 
       end;
 199 : begin
         yyval := yyv[yysp-2];
       end;
 200 : begin
         yyval := yyv[yysp-2];
       end;
 201 : begin
         CurrentInsertItem.FieldNames.Add(yyv[yysp-0].yystring);
       end;
 202 : begin
         CurrentInsertItem.FieldNames.Add(yyv[yysp-0].yystring);
       end;
 203 : begin
         yyval := yyv[yysp-3];
       end;
 204 : begin
         yyval := yyv[yysp-0];
       end;
 205 : begin
         CurrentInsertItem.ExprList.Add( yyv[yysp-0].yystring );
       end;
 206 : begin
         CurrentInsertItem.ExprList.Add( yyv[yysp-0].yystring );
       end;
 207 : begin
         yyval := yyv[yysp-1];
       end;
 208 : begin
         Inc(FNumTables);
       end;
 209 : begin
         Inc(FNumTables);
       end;
 210 : begin
         SetTableName( Copy(yyv[yysp-4].yystring, 2, Length(yyv[yysp-4].yystring) - 2) );
       end;
 211 : begin
         SetFieldParams(RW_CHAR,0,0,StrToInt(yyv[yysp-1].yystring),0);
       end;
 212 : begin
         SetFieldParams(RW_INTEGER,0,0,0,0);
       end;
 213 : begin
         SetFieldParams(RW_SMALLINT,0,0,0,0);
       end;
 214 : begin
         SetFieldParams(RW_BOOLEAN,0,0,0,0);
       end;
 215 : begin
         SetFieldParams(RW_DATE,0,0,0,0);
       end;
 216 : begin
         SetFieldParams(RW_TIME,0,0,0,0);
       end;
 217 : begin
         SetFieldParams(RW_DATETIME,0,0,0,0);
       end;
 218 : begin
         SetFieldParams(RW_MONEY,0,0,0,0);
       end;
 219 : begin
         SetFieldParams(RW_FLOAT,0,0,0,0);
       end;
 220 : begin
         SetFieldParams(RW_FLOAT,StrToInt(yyv[yysp-1].yystring),0,0,0);
       end;
 221 : begin
         SetFieldParams(RW_FLOAT,StrToInt(yyv[yysp-3].yystring),StrToInt(yyv[yysp-1].yystring),0,0);
       end;
 222 : begin
         SetFieldParams(RW_AUTOINC,0,0,0,0);
       end;
 223 : begin
         SetFieldParams(RW_BLOB,0,0,0,StrToInt(yyv[yysp-1].yystring));
       end;
 224 : begin
         AddCreateField(yyv[yysp-1].yystring);
       end;
 225 : begin
         AddCreateField(yyv[yysp-1].yystring);
       end;
 226 : begin
       end;
 227 : begin
         yyval := yyv[yysp-4];
       end;
 228 : begin
         AddPrimaryKeyField(yyv[yysp-0].yystring);
       end;
 229 : begin
         AddPrimaryKeyField(yyv[yysp-0].yystring);
       end;
 230 : begin
         CurrentAnalizer.IndexName  := yyv[yysp-6].yystring;
         CurrentAnalizer.IndexTable := Copy(yyv[yysp-4].yystring, 2, Length(yyv[yysp-4].yystring) - 2); 
       end;
 231 : begin
       end;
 232 : begin
         CurrentAnalizer.IndexUnique:= True;
       end;
 233 : begin
       end;
 234 : begin
         yyval := yyv[yysp-0];
       end;
 235 : begin
         CurrentAnalizer.IndexDescending:= True;
       end;
 236 : begin
         CurrentAnalizer.IndexColumnList.Add(yyv[yysp-0].yystring);
       end;
 237 : begin
         CurrentAnalizer.IndexColumnList.Add(yyv[yysp-0].yystring);
       end;
 238 : begin
         CurrentAnalizer.IndexTable:= Copy(yyv[yysp-1].yystring, 2, Length(yyv[yysp-1].yystring) - 2);
       end;
 239 : begin
         CurrentAnalizer.IndexTable:= Copy(yyv[yysp-2].yystring, 2, Length(yyv[yysp-2].yystring) - 2);
         CurrentAnalizer.IndexName := yyv[yysp-1].yystring; 
       end;
 240 : begin
         CurrentAnalizer.PivotStr := yyv[yysp-2].yystring; 
       end;
 241 : begin
         AddColumn( yyv[yysp-0].yystring ); 
       end;
 242 : begin
         AddColumn( yyv[yysp-3].yystring ); 
       end;
 243 : begin
       end;
 244 : begin
         yyval := yyv[yysp-3];
       end;
 245 : begin
         CurrentAnalizer.PivotInList.Add( RemoveStrDelim( yyv[yysp-0].yystring));
       end;
 246 : begin
         CurrentAnalizer.PivotInList.Add( RemoveStrDelim( yyv[yysp-0].yystring));
       end;
 247 : begin
         yyval := yyv[yysp-3];
       end;
  end;
end(*yyaction*);

(* parse table: *)

type YYARec = record
                sym, act : SmallInt;
              end;
     YYRRec = record
                len, sym : SmallInt;
              end;

const

yynacts   = 2929;
yyngotos  = 688;
yynstates = 475;
yynrules  = 247;

var

yya : array [1..yynacts    ] of YYARec;
yyg : array [1..yyngotos   ] of YYARec;
yyd : array [0..yynstates-1] of SmallInt;
yyal: array [0..yynstates-1] of SmallInt;
yyah: array [0..yynstates-1] of SmallInt;
yygl: array [0..yynstates-1] of SmallInt;
yygh: array [0..yynstates-1] of SmallInt;
yyr : array [1..yynrules   ] of YYRRec;

procedure LoadResArrays;
var
  ResInstance: Longint;
  
  procedure ResLoad(const resname: string; ResourceBuffer: Pointer);
  var
    ResourceSize: Integer;
    ResourcePtr: PChar;
    BinResource: THandle;
  begin
    ResourceSize := SizeofResource(ResInstance,
      FindResource(ResInstance, PChar(resname), RT_RCDATA));
    BinResource := LoadResource(ResInstance,
      FindResource(ResInstance, PChar(resname), RT_RCDATA));
    ResourcePtr := LockResource(BinResource);
    Move(ResourcePtr^, ResourceBuffer^, ResourceSize);
    UnlockResource(BinResource);
    FreeResource(BinResource);

  end;
begin
  ResInstance := System.FindResourceHInstance(HInstance);
  ResLoad('XQYACC_YYA', @yya[1]);
  ResLoad('XQYACC_YYG', @yyg[1]);

  ResLoad('XQYACC_YYD', @yyd[0]);

  ResLoad('XQYACC_YYAL', @yyal[0]);

  ResLoad('XQYACC_YYAH', @yyah[0]);

  ResLoad('XQYACC_YYGL', @yygl[0]);

  ResLoad('XQYACC_YYGH', @yygh[0]);

  ResLoad('XQYACC_YYR', @yyr[1]);


end;


const _error = 256; (* error token *)

function yyact(state, sym : Integer; var act : SmallInt) : Boolean;
  (* search action table *)
  var k : Integer;
  begin
    k := yyal[state];
    while (k<=yyah[state]) and (yya[k].sym<>sym) do inc(k);
    if k>yyah[state] then
      yyact := false
    else
      begin
        act := yya[k].act;
        yyact := true;
      end;
  end(*yyact*);

function yygoto(state, sym : Integer; var nstate : SmallInt) : Boolean;
  (* search goto table *)
  var k : Integer;
  begin
    k := yygl[state];
    while (k<=yygh[state]) and (yyg[k].sym<>sym) do inc(k);
    if k>yygh[state] then
      yygoto := false
    else
      begin
        nstate := yyg[k].act;
        yygoto := true;
      end;
  end(*yygoto*);

label parse, next, error, errlab, shift, reduce, accept, abort;

begin(*yyparse*)

  (* load arrays from resource *)
  LoadResArrays;

  yystate := 0; yychar := -1; yynerrs := 0; yyerrflag := 0; yysp := 0;

{$ifdef yydebug}
  yydebug := true;
{$else}
  yydebug := false;
{$endif}

parse:

  (* push state and value: *)

  inc(yysp);
  if yysp>yymaxdepth then
    begin
      yyerror('yyparse stack overflow');
      goto abort;
    end;
  yys[yysp] := yystate; yyv[yysp] := yyval;

next:

  if (yyd[yystate]=0) and (yychar=-1) then
    (* get next symbol *)
    begin
      repeat
         yychar := yyLexer.yylex; if yychar<0 then yychar := 0;
         // ignore comments and blanks [ \n\t]
         if not( (yychar=_COMMENT) or (yychar=_BLANK) or
                 (yychar=_TAB) or (yychar=_NEWLINE) ) then break;
      until false;
      if yychar= _ILLEGAL then goto error;
    end;

  (*
  if yydebug then
    writeln( yyLexer.yyOutput, 'state '+intToStr( yystate)+ ', char '+
                               intToStr( yychar) + ' at line n'+
                               intToStr(yyLexer.yylineno) + ', col n' +
                               intToStr( yyLexer.yycolno));
  *)

  (* determine parse action: *)

  yyn := yyd[yystate];
  if yyn<>0 then goto reduce; (* simple state *)

  (* no default action; search parse table *)

  if not yyact(yystate, yychar, yyn) then goto error
  else if yyn>0 then                      goto shift
  else if yyn<0 then                      goto reduce
  else                                    goto accept;

error:

  (* error; start error recovery: *)

  if yyerrflag=0 then yyerror('syntax error');

errlab:

  if yyerrflag=0 then inc(yynerrs);     (* new error *)

  if yyerrflag<=2 then                  (* incomplete recovery; try again *)
    begin
      yyerrflag := 3;
      (* uncover a state with shift action on error token *)
      while (yysp>0) and not ( yyact(yys[yysp], _error, yyn) and
                               (yyn>0) ) do
        begin
          (*
          if yydebug then
            if yysp>1 then
              writeln( yyLexer.yyOutput, 'error recovery pops state ' +
                       intToStr(yys[yysp])+', uncovers '+ intToStr(yys[yysp-1]))
            else
              writeln( yyLexer.yyOutput, 'error recovery fails ... abort');
          *)
          dec(yysp);
        end;
      if yysp=0 then goto abort; (* parser has fallen from stack; abort *)
      yystate := yyn;            (* simulate shift on error *)
      goto parse;
    end
  else                                  (* no shift yet; discard symbol *)
    begin
      (*
      if yydebug then
        writeln( yyLexer.yyOutput, 'error recovery discards char '+
                 intToStr( yychar));
      *)
      if yychar=0 then goto abort; (* end of input; abort *)
      yychar := -1; goto next;     (* clear lookahead char and try again *)
    end;

shift:

  (* go to new state, clear lookahead character: *)

  yystate := yyn; yychar := -1; yyval := yylval;
  if yyerrflag>0 then dec(yyerrflag);

  goto parse;

reduce:

  (* execute action, pop rule from stack, and go to next state: *)

  //if yydebug then writeln( yyLexer.yyOutput, 'reduce '+ intToStr( -yyn));

  yyflag := yyfnone; yyaction(-yyn);
  dec(yysp, yyr[-yyn].len);
  if yygoto(yys[yysp], yyr[-yyn].sym, yyn) then yystate := yyn;

  (* handle action calls to yyaccept, yyabort and yyerror: *)

  case yyflag of
    yyfaccept : goto accept;
    yyfabort  : goto abort;
    yyferror  : goto errlab;
  end;

  goto parse;

accept:

  yyparse := 0; exit;

abort:

  yyparse := 1; exit;

end(*yyparse*);

end.




