
(* lexical analyzer template (TP Lex V3.0), V1.0 3-2-91 AG *)

(* global definitions: *)

{**********************************************}
{   Lexical analizer for TxQuery component     }
{   Copyright (c) 1999 by Alfonso Moreno       }
{**********************************************}
unit XQLex;

{$I XQ_FLAG.INC}
interface
  uses SysUtils, Classes, LexLibQ, xqYacc;

  type
    TxqLexer = Class( TCustomLexer)
    private
      FIsWhereActive : Boolean;
      FDateFormat    : String;
      FNumSelects    : Integer;
      FIsTransform   : Boolean;
      FIsMergeActive : Boolean;
      FIsWithActive  : Boolean;
      FIgnoreBadDates: Boolean;
    public

      // utility functions
      function IsKeyword(const id : String; var token : integer) : boolean;
      // Lexer main functions
      function yylex : Integer; override;
      procedure yyaction( yyruleno : integer);
      procedure commenteof;

      property IsWhereActive: Boolean read FIsWhereActive write FIsWhereActive;
      property DateFormat: String read FDateFormat write FDateFormat;
      property NumSelects : Integer read FNumSelects write FNumSelects;
      property IsTransform: Boolean read FIsTransform write FIsTransform;
      property IsMergeActive : Boolean read FIsMergeActive;
      property IsWithActive : Boolean read FIsWithActive;
      property IgnoreBadDates: Boolean read FIgnoreBadDates write FIgnoreBadDates;
    end;

//===============================================
// reserved words definition
//===============================================
  type
    TRWord = record
       rword: string[10];
       token: smallint;
    end;

  const
    rwords : array [1..80] of TRword = (
    (rword:'SELECT';       token: RW_SELECT),
    (rword:'DISTINCT';     token: RW_DISTINCT),
    (rword:'TRUE';         token: RW_TRUE),
    (rword:'FALSE';        token: RW_FALSE),
    (rword:'AND';          token: RW_AND),
    (rword:'OR';           token: RW_OR),
    (rword:'NOT';          token: RW_NOT),
    (rword:'FROM';         token: RW_FROM),
    (rword:'WHERE';        token: RW_WHERE),
    (rword:'ORDER';        token: RW_ORDER),
    (rword:'BY';           token: RW_BY),
    (rword:'ASC';          token: RW_ASC),
    (rword:'DESC';         token: RW_DESC),
    (rword:'AS';           token: RW_AS),
    (rword:'INNER';        token: RW_INNER),
    (rword:'OUTER';        token: RW_OUTER),
    (rword:'FULL';         token: RW_FULL),
    (rword:'JOIN';         token: RW_JOIN),
    (rword:'ON';           token: RW_ON),
    (rword:'GROUP';        token: RW_GROUP),
    (rword:'ANY';          token: RW_ANY),
    (rword:'ALL';          token: RW_ALL),
    (rword:'SUM';          token: RW_SUM),
    (rword:'AVG';          token: RW_AVG),
    (rword:'COUNT';        token: RW_COUNT),
    (rword:'MIN';          token: RW_MIN),
    (rword:'MAX';          token: RW_MAX),
    (rword:'BETWEEN';      token: RW_BETWEEN),
    (rword:'IN';           token: RW_IN),
    (rword:'LIKE';         token: RW_LIKE),
    (rword:'LEFT';         token: RW_LEFT),
    (rword:'RIGHT';        token: RW_RIGHT),
    (rword:'HAVING';       token: RW_HAVING),
    (rword:'LEADING';      token: RW_LEADING),
    (rword:'TRAILING';     token: RW_TRAILING),
    (rword:'BOTH';         token: RW_BOTH),
    (rword:'TRIM';         token: RW_TRIM),
    (rword:'EXTRACT';      token: RW_EXTRACT),
    (rword:'YEAR';         token: RW_YEAR),
    (rword:'MONTH';        token: RW_MONTH),
    (rword:'DAY';          token: RW_DAY),
    (rword:'HOUR';         token: RW_HOUR),
    (rword:'MINUTE';       token: RW_MINUTE),
    (rword:'SECOND';       token: RW_SECOND),
    (rword:'SUBSTRING';    token: RW_SUBSTRING),
    (rword:'FOR';          token: RW_FOR),
    (rword:'DELETE';       token: RW_DELETE),
    (rword:'UPDATE';       token: RW_UPDATE),
    (rword:'INSERT';       token: RW_INSERT),
    (rword:'INTO';         token: RW_INTO),
    (rword:'VALUES';       token: RW_VALUES),
    (rword:'SET';          token: RW_SET),
    (rword:'CAST';         token: RW_CAST),
    (rword:'CHAR';         token: RW_CHAR),
    (rword:'INTEGER';      token: RW_INTEGER),
    (rword:'BOOLEAN';      token: RW_BOOLEAN),
    (rword:'DATE';         token: RW_DATE),
    (rword:'DATETIME';     token: RW_DATETIME),
    (rword:'TIME';         token: RW_TIME),
    (rword:'FLOAT';        token: RW_FLOAT),
    (rword:'NUMERIC';      token: RW_FLOAT),
    (rword:'ESCAPE';       token: RW_ESCAPE),
    (rword:'CREATE';       token: RW_CREATE),
    (rword:'TABLE';        token: RW_TABLE),
    (rword:'SMALLINT';     token: RW_SMALLINT),
    (rword:'MONEY';        token: RW_MONEY),
    (rword:'AUTOINC';      token: RW_AUTOINC),
    (rword:'PRIMARY';      token: RW_PRIMARY),
    (rword:'KEY';          token: RW_KEY),
    (rword:'BLOB';         token: RW_BLOB),
    (rword:'NOW';          token: RW_NOW),
    (rword:'INDEX';        token: RW_INDEX),
    (rword:'UNIQUE';       token: RW_UNIQUE),
    (rword:'DROP';         token: RW_DROP),
    (rword:'TRANSFORM';    token: RW_TRANSFORM),
    (rword:'PIVOT';        token: RW_PIVOT),
    (rword:'MERGE';        token: RW_MERGE),
    (rword:'WITH';         token: RW_WITH),
    (rword:'IS';           token: RW_IS),
    (rword:'NULL';         token: RW_NULL)
    );

implementation

uses xqConsts, xquery;

function TxqLexer.IsKeyword(const id : string; var token : integer) : boolean;
(* returns corresponding token number in token *)

var
  k : integer;
begin
  Result:= false;
  for k:= Low(rwords) to High(rwords) do
     if AnsiCompareText(id, rwords[k].rword)=0 then
     begin
        Result:= True;
        token := rwords[k].token;
        Exit;
     end;
end;

procedure TxqLexer.commenteof;
begin
  writeln(yyErrorfile, 'unexpected EOF inside comment at line '
                       +intToStr( yylineno));
end;





procedure TXQLexer.yyaction ( yyruleno : Integer );
  (* local definitions: *)

   var
      c : char;
      token: integer;
      SaveDate: String;

begin
  yylval.yystring:= yytext;
  (* actions: *)
  case yyruleno of
  1:
                                 if IsKeyword(yytext, token) then
                                 begin

                                    if token = RW_MERGE then
                                       FIsMergeActive := True;
                                    if FIsMergeActive and (token = RW_WITH) then
                                    begin
                                       FIsMergeActive := False;
                                       FIsWithActive  := True;
                                       FNumSelects    := 0;         { reset count of SELECTs }
                                    end;

                                    if token = RW_TRANSFORM then
                                       FIsTransform := True;

                                    if token = RW_SELECT then
                                       Inc(FNumSelects);

                                    if token = RW_WHERE then
                                       FIsWhereActive:= True
                                    else if FIsWhereActive and ( (token = RW_GROUP) or
                                       (token =RW_ORDER) or (token = RW_SELECT) or
                                        (token =RW_PIVOT) ) then
                                       FIsWhereActive := False;

                                    returni(token);
                                 end else
                                    returni(_IDENTIFIER);
  2:
                     begin
                        // extended identifier
                        yylval.yystring := Copy(yytext, 2, Length(yytext) - 2);
                        returni( _IDENTIFIER );
                     end;

  3:
                     returni( _NUMERIC );

  4:
                     returni( _SINTEGER );

  5:
                     returni( _UINTEGER );

  6:
            begin
               // Added code to handle syntax like 'Mike''s programming'
               //  by: Mike Williams
               c := get_char;
               unget_char(c);
               if c = #39 then
                  yymore
               else
                  returni( _STRING );
            end;
  7:
            returni( _STRING );
            (* begin
              yylval.yystring := '''' + Copy(yytext,2,Length(yytext)-2) + '''';
              returni( _STRING );
            end;*)
  8:
            begin
               // previously this "#"{DIGIT}{1,2}"/"{DIGIT}{1,2}"/"({DIGIT}{2}|{DIGIT}{4})"#"
               SaveDate := ShortDateFormat;
               if Length( Self.FDateFormat ) = 0 then
                  Self.FDateFormat := SDefaultDateFormat;
               ShortDateFormat := Self.FDateFormat;
               try
                  yylval.yystring := FloatToStr( StrToDate( Copy( yytext, 2, Length( yytext ) - 2) ) );
                  if FIsWhereActive then
                     yylval.yystring := 'DummyDate(' + yylval.yystring + ')';
                  ShortDateFormat := SaveDate;
                  returni( _NUMERIC );
               except
                  if not FIgnoreBadDates then
                  begin
                     FIgnoreBadDates:= False;
                     raise;
                  end else
                     returni( _NUMERIC );
               end;
            end;
  9:
   	returni( _COMA );
  10:
   	returni( _LPAREN );
  11:
   	returni( _RPAREN );
  12:
   	returni( _GT );
  13:
   	returni( _LT );
  14:
   	returni( _PERIOD );
  15:
   	returni( _COLON );
  16:
   	returni( _SEMICOLON );
  17:
   	returni( _EQ );
  18:
   	returni( _MULT );
  19:
   	returni( _PLUS );
  20:
   	returni( _SUB );
  21:
   	returni( _NEG );
  22:
   	returni( _EXP );
  23:
   	returni( _DIV );
  24:
    	returni( _NEQ );
  25:
    	returni( _GE );
  26:
    	returni( _LE );
  27:
    	begin yylval.yystring := '+'; returni( _PLUS ); end;
  28:
               returni( _COMMENT );
  29:
     returni( _BLANK );
  30:
     returni( _NEWLINE );
  31:
     returni( _TAB );
  32:
 	  returni( _ILLEGAL );



  end;
end(*yyaction*);

function TXQLexer.yylex : Integer;
(* DFA table: *)

type YYTRec = record
                cc : set of Char;
                s  : SmallInt;
              end;

const

yynmarks   = 58;
yynmatches = 58;
yyntrans   = 89;
yynstates  = 49;

yyk : array [1..yynmarks] of SmallInt = (
  { 0: }
  { 1: }
  { 2: }
  1,
  32,
  { 3: }
  32,
  { 4: }
  20,
  21,
  32,
  { 5: }
  5,
  32,
  { 6: }
  14,
  32,
  { 7: }
  32,
  { 8: }
  32,
  { 9: }
  32,
  { 10: }
  9,
  32,
  { 11: }
  10,
  32,
  { 12: }
  11,
  32,
  { 13: }
  12,
  32,
  { 14: }
  13,
  32,
  { 15: }
  15,
  32,
  { 16: }
  16,
  32,
  { 17: }
  17,
  32,
  { 18: }
  18,
  32,
  { 19: }
  19,
  32,
  { 20: }
  22,
  32,
  { 21: }
  23,
  32,
  { 22: }
  32,
  { 23: }
  29,
  32,
  { 24: }
  30,
  { 25: }
  31,
  32,
  { 26: }
  32,
  { 27: }
  1,
  { 28: }
  { 29: }
  4,
  { 30: }
  5,
  { 31: }
  3,
  { 32: }
  3,
  { 33: }
  { 34: }
  6,
  { 35: }
  { 36: }
  7,
  { 37: }
  { 38: }
  8,
  { 39: }
  25,
  { 40: }
  24,
  { 41: }
  26,
  { 42: }
  { 43: }
  27,
  { 44: }
  2,
  { 45: }
  { 46: }
  { 47: }
  { 48: }
  28
);

yym : array [1..yynmatches] of SmallInt = (
{ 0: }
{ 1: }
{ 2: }
  1,
  32,
{ 3: }
  32,
{ 4: }
  20,
  21,
  32,
{ 5: }
  5,
  32,
{ 6: }
  14,
  32,
{ 7: }
  32,
{ 8: }
  32,
{ 9: }
  32,
{ 10: }
  9,
  32,
{ 11: }
  10,
  32,
{ 12: }
  11,
  32,
{ 13: }
  12,
  32,
{ 14: }
  13,
  32,
{ 15: }
  15,
  32,
{ 16: }
  16,
  32,
{ 17: }
  17,
  32,
{ 18: }
  18,
  32,
{ 19: }
  19,
  32,
{ 20: }
  22,
  32,
{ 21: }
  23,
  32,
{ 22: }
  32,
{ 23: }
  29,
  32,
{ 24: }
  30,
{ 25: }
  31,
  32,
{ 26: }
  32,
{ 27: }
  1,
{ 28: }
{ 29: }
  4,
{ 30: }
  5,
{ 31: }
  3,
{ 32: }
  3,
{ 33: }
{ 34: }
  6,
{ 35: }
{ 36: }
  7,
{ 37: }
{ 38: }
  8,
{ 39: }
  25,
{ 40: }
  24,
{ 41: }
  26,
{ 42: }
{ 43: }
  27,
{ 44: }
  2,
{ 45: }
{ 46: }
{ 47: }
{ 48: }
  28
);

yyt : array [1..yyntrans] of YYTrec = (
{ 0: }
  ( cc: [ #1..#8,#11..#31,'!','$'..'&','?','@','\',']',
            '_','`','{','}'..#127 ]; s: 26),
  ( cc: [ #9 ]; s: 25),
  ( cc: [ #10 ]; s: 24),
  ( cc: [ ' ' ]; s: 23),
  ( cc: [ '"' ]; s: 8),
  ( cc: [ '#' ]; s: 9),
  ( cc: [ '''' ]; s: 7),
  ( cc: [ '(' ]; s: 11),
  ( cc: [ ')' ]; s: 12),
  ( cc: [ '*' ]; s: 18),
  ( cc: [ '+' ]; s: 19),
  ( cc: [ ',' ]; s: 10),
  ( cc: [ '-' ]; s: 4),
  ( cc: [ '.' ]; s: 6),
  ( cc: [ '/' ]; s: 21),
  ( cc: [ '0'..'9' ]; s: 5),
  ( cc: [ ':' ]; s: 15),
  ( cc: [ ';' ]; s: 16),
  ( cc: [ '<' ]; s: 14),
  ( cc: [ '=' ]; s: 17),
  ( cc: [ '>' ]; s: 13),
  ( cc: [ 'A'..'Z','a'..'z',#128..#255 ]; s: 2),
  ( cc: [ '[' ]; s: 3),
  ( cc: [ '^' ]; s: 20),
  ( cc: [ '|' ]; s: 22),
{ 1: }
  ( cc: [ #1..#8,#11..#31,'!','$'..'&','?','@','\',']',
            '_','`','{','}'..#127 ]; s: 26),
  ( cc: [ #9 ]; s: 25),
  ( cc: [ #10 ]; s: 24),
  ( cc: [ ' ' ]; s: 23),
  ( cc: [ '"' ]; s: 8),
  ( cc: [ '#' ]; s: 9),
  ( cc: [ '''' ]; s: 7),
  ( cc: [ '(' ]; s: 11),
  ( cc: [ ')' ]; s: 12),
  ( cc: [ '*' ]; s: 18),
  ( cc: [ '+' ]; s: 19),
  ( cc: [ ',' ]; s: 10),
  ( cc: [ '-' ]; s: 4),
  ( cc: [ '.' ]; s: 6),
  ( cc: [ '/' ]; s: 21),
  ( cc: [ '0'..'9' ]; s: 5),
  ( cc: [ ':' ]; s: 15),
  ( cc: [ ';' ]; s: 16),
  ( cc: [ '<' ]; s: 14),
  ( cc: [ '=' ]; s: 17),
  ( cc: [ '>' ]; s: 13),
  ( cc: [ 'A'..'Z','a'..'z',#128..#255 ]; s: 2),
  ( cc: [ '[' ]; s: 3),
  ( cc: [ '^' ]; s: 20),
  ( cc: [ '|' ]; s: 22),
{ 2: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z',#128..#255 ]; s: 27),
{ 3: }
  ( cc: [ 'A'..'Z','a'..'z',#128..#255 ]; s: 28),
{ 4: }
  ( cc: [ '0'..'9' ]; s: 29),
{ 5: }
  ( cc: [ '.' ]; s: 31),
  ( cc: [ '0'..'9' ]; s: 30),
{ 6: }
  ( cc: [ '0'..'9' ]; s: 32),
{ 7: }
  ( cc: [ #1..'&','('..#255 ]; s: 33),
  ( cc: [ '''' ]; s: 34),
{ 8: }
  ( cc: [ #1..'!','#'..#255 ]; s: 35),
  ( cc: [ '"' ]; s: 36),
{ 9: }
  ( cc: [ #1..'"','$'..#255 ]; s: 37),
  ( cc: [ '#' ]; s: 38),
{ 10: }
{ 11: }
{ 12: }
{ 13: }
  ( cc: [ '=' ]; s: 39),
{ 14: }
  ( cc: [ '=' ]; s: 41),
  ( cc: [ '>' ]; s: 40),
{ 15: }
{ 16: }
{ 17: }
{ 18: }
{ 19: }
  ( cc: [ '0'..'9' ]; s: 29),
{ 20: }
{ 21: }
  ( cc: [ '*' ]; s: 42),
{ 22: }
  ( cc: [ '|' ]; s: 43),
{ 23: }
{ 24: }
{ 25: }
{ 26: }
{ 27: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z',#128..#255 ]; s: 27),
{ 28: }
  ( cc: [ #1..'Z','\','^'..#255 ]; s: 28),
  ( cc: [ ']' ]; s: 44),
{ 29: }
  ( cc: [ '.' ]; s: 45),
  ( cc: [ '0'..'9' ]; s: 29),
{ 30: }
  ( cc: [ '.' ]; s: 31),
  ( cc: [ '0'..'9' ]; s: 30),
{ 31: }
  ( cc: [ '0'..'9' ]; s: 31),
{ 32: }
  ( cc: [ '0'..'9' ]; s: 32),
  ( cc: [ 'E','e' ]; s: 46),
{ 33: }
  ( cc: [ #1..'&','('..#255 ]; s: 33),
  ( cc: [ '''' ]; s: 34),
{ 34: }
{ 35: }
  ( cc: [ #1..'!','#'..#255 ]; s: 35),
  ( cc: [ '"' ]; s: 36),
{ 36: }
{ 37: }
  ( cc: [ #1..'"','$'..#255 ]; s: 37),
  ( cc: [ '#' ]; s: 38),
{ 38: }
{ 39: }
{ 40: }
{ 41: }
{ 42: }
  ( cc: [ #1..')','+'..#255 ]; s: 42),
  ( cc: [ '*' ]; s: 47),
{ 43: }
{ 44: }
{ 45: }
  ( cc: [ '0'..'9' ]; s: 31),
{ 46: }
  ( cc: [ '+','-' ]; s: 45),
{ 47: }
  ( cc: [ '/' ]; s: 48)
{ 48: }
);

yykl : array [0..yynstates-1] of SmallInt = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 3,
{ 4: } 4,
{ 5: } 7,
{ 6: } 9,
{ 7: } 11,
{ 8: } 12,
{ 9: } 13,
{ 10: } 14,
{ 11: } 16,
{ 12: } 18,
{ 13: } 20,
{ 14: } 22,
{ 15: } 24,
{ 16: } 26,
{ 17: } 28,
{ 18: } 30,
{ 19: } 32,
{ 20: } 34,
{ 21: } 36,
{ 22: } 38,
{ 23: } 39,
{ 24: } 41,
{ 25: } 42,
{ 26: } 44,
{ 27: } 45,
{ 28: } 46,
{ 29: } 46,
{ 30: } 47,
{ 31: } 48,
{ 32: } 49,
{ 33: } 50,
{ 34: } 50,
{ 35: } 51,
{ 36: } 51,
{ 37: } 52,
{ 38: } 52,
{ 39: } 53,
{ 40: } 54,
{ 41: } 55,
{ 42: } 56,
{ 43: } 56,
{ 44: } 57,
{ 45: } 58,
{ 46: } 58,
{ 47: } 58,
{ 48: } 58
);

yykh : array [0..yynstates-1] of SmallInt = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 2,
{ 3: } 3,
{ 4: } 6,
{ 5: } 8,
{ 6: } 10,
{ 7: } 11,
{ 8: } 12,
{ 9: } 13,
{ 10: } 15,
{ 11: } 17,
{ 12: } 19,
{ 13: } 21,
{ 14: } 23,
{ 15: } 25,
{ 16: } 27,
{ 17: } 29,
{ 18: } 31,
{ 19: } 33,
{ 20: } 35,
{ 21: } 37,
{ 22: } 38,
{ 23: } 40,
{ 24: } 41,
{ 25: } 43,
{ 26: } 44,
{ 27: } 45,
{ 28: } 45,
{ 29: } 46,
{ 30: } 47,
{ 31: } 48,
{ 32: } 49,
{ 33: } 49,
{ 34: } 50,
{ 35: } 50,
{ 36: } 51,
{ 37: } 51,
{ 38: } 52,
{ 39: } 53,
{ 40: } 54,
{ 41: } 55,
{ 42: } 55,
{ 43: } 56,
{ 44: } 57,
{ 45: } 57,
{ 46: } 57,
{ 47: } 57,
{ 48: } 58
);

yyml : array [0..yynstates-1] of SmallInt = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 3,
{ 4: } 4,
{ 5: } 7,
{ 6: } 9,
{ 7: } 11,
{ 8: } 12,
{ 9: } 13,
{ 10: } 14,
{ 11: } 16,
{ 12: } 18,
{ 13: } 20,
{ 14: } 22,
{ 15: } 24,
{ 16: } 26,
{ 17: } 28,
{ 18: } 30,
{ 19: } 32,
{ 20: } 34,
{ 21: } 36,
{ 22: } 38,
{ 23: } 39,
{ 24: } 41,
{ 25: } 42,
{ 26: } 44,
{ 27: } 45,
{ 28: } 46,
{ 29: } 46,
{ 30: } 47,
{ 31: } 48,
{ 32: } 49,
{ 33: } 50,
{ 34: } 50,
{ 35: } 51,
{ 36: } 51,
{ 37: } 52,
{ 38: } 52,
{ 39: } 53,
{ 40: } 54,
{ 41: } 55,
{ 42: } 56,
{ 43: } 56,
{ 44: } 57,
{ 45: } 58,
{ 46: } 58,
{ 47: } 58,
{ 48: } 58
);

yymh : array [0..yynstates-1] of SmallInt = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 2,
{ 3: } 3,
{ 4: } 6,
{ 5: } 8,
{ 6: } 10,
{ 7: } 11,
{ 8: } 12,
{ 9: } 13,
{ 10: } 15,
{ 11: } 17,
{ 12: } 19,
{ 13: } 21,
{ 14: } 23,
{ 15: } 25,
{ 16: } 27,
{ 17: } 29,
{ 18: } 31,
{ 19: } 33,
{ 20: } 35,
{ 21: } 37,
{ 22: } 38,
{ 23: } 40,
{ 24: } 41,
{ 25: } 43,
{ 26: } 44,
{ 27: } 45,
{ 28: } 45,
{ 29: } 46,
{ 30: } 47,
{ 31: } 48,
{ 32: } 49,
{ 33: } 49,
{ 34: } 50,
{ 35: } 50,
{ 36: } 51,
{ 37: } 51,
{ 38: } 52,
{ 39: } 53,
{ 40: } 54,
{ 41: } 55,
{ 42: } 55,
{ 43: } 56,
{ 44: } 57,
{ 45: } 57,
{ 46: } 57,
{ 47: } 57,
{ 48: } 58
);

yytl : array [0..yynstates-1] of SmallInt = (
{ 0: } 1,
{ 1: } 26,
{ 2: } 51,
{ 3: } 52,
{ 4: } 53,
{ 5: } 54,
{ 6: } 56,
{ 7: } 57,
{ 8: } 59,
{ 9: } 61,
{ 10: } 63,
{ 11: } 63,
{ 12: } 63,
{ 13: } 63,
{ 14: } 64,
{ 15: } 66,
{ 16: } 66,
{ 17: } 66,
{ 18: } 66,
{ 19: } 66,
{ 20: } 67,
{ 21: } 67,
{ 22: } 68,
{ 23: } 69,
{ 24: } 69,
{ 25: } 69,
{ 26: } 69,
{ 27: } 69,
{ 28: } 70,
{ 29: } 72,
{ 30: } 74,
{ 31: } 76,
{ 32: } 77,
{ 33: } 79,
{ 34: } 81,
{ 35: } 81,
{ 36: } 83,
{ 37: } 83,
{ 38: } 85,
{ 39: } 85,
{ 40: } 85,
{ 41: } 85,
{ 42: } 85,
{ 43: } 87,
{ 44: } 87,
{ 45: } 87,
{ 46: } 88,
{ 47: } 89,
{ 48: } 90
);

yyth : array [0..yynstates-1] of SmallInt = (
{ 0: } 25,
{ 1: } 50,
{ 2: } 51,
{ 3: } 52,
{ 4: } 53,
{ 5: } 55,
{ 6: } 56,
{ 7: } 58,
{ 8: } 60,
{ 9: } 62,
{ 10: } 62,
{ 11: } 62,
{ 12: } 62,
{ 13: } 63,
{ 14: } 65,
{ 15: } 65,
{ 16: } 65,
{ 17: } 65,
{ 18: } 65,
{ 19: } 66,
{ 20: } 66,
{ 21: } 67,
{ 22: } 68,
{ 23: } 68,
{ 24: } 68,
{ 25: } 68,
{ 26: } 68,
{ 27: } 69,
{ 28: } 71,
{ 29: } 73,
{ 30: } 75,
{ 31: } 76,
{ 32: } 78,
{ 33: } 80,
{ 34: } 80,
{ 35: } 82,
{ 36: } 82,
{ 37: } 84,
{ 38: } 84,
{ 39: } 84,
{ 40: } 84,
{ 41: } 84,
{ 42: } 86,
{ 43: } 86,
{ 44: } 86,
{ 45: } 87,
{ 46: } 88,
{ 47: } 89,
{ 48: } 89
);


var yyn : Integer;

label start, scan, action;

begin

start:

  (* initialize: *)

  yynew;

scan:

  (* mark positions and matches: *)

  for yyn := yykl[yystate] to     yykh[yystate] do yymark(yyk[yyn]);
  for yyn := yymh[yystate] downto yyml[yystate] do yymatch(yym[yyn]);

  if yytl[yystate]>yyth[yystate] then goto action; (* dead state *)

  (* get next character: *)

  yyscan;

  (* determine action: *)

  yyn := yytl[yystate];
  while (yyn<=yyth[yystate]) and not (yyactchar in yyt[yyn].cc) do inc(yyn);
  if yyn>yyth[yystate] then goto action;
    (* no transition on yyactchar in this state *)

  (* switch to new state: *)

  yystate := yyt[yyn].s;

  goto scan;

action:

  (* execute action: *)

  if yyfind(yyrule) then
    begin
      yyaction(yyrule);
      if yyreject then goto action;
    end
  else if not yydefault and yywrap then
    begin
      yyclear;
      returni(0);
    end;

  if not yydone then goto start;

  yylex := yyretval;

end(*yylex*);

end.
