Unit Ex1U;

{$I XQ_FLAG.INC}
Interface

//{$DEFINE QUERYBUILDER} { use query builder in the demo. Uncomment if not used }
Uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Grids,
  DBGrids,
  XQuery,
  Db,
  DBTables,
  StdCtrls,
  ComCtrls,
  Menus,
  ExtCtrls,
  DBCtrls,
  Buttons,
  PrExprQ,
  SyntaxHi,
  XQMiscel,
  xqbase
  {$IFDEF USE_DBF_ENGINE},
  halcn6DB,
  gs6_shel
  {$ENDIF}
  {$IFDEF QUERYBUILDER},
  QBuilder,
  OQBExQry
  {$ENDIF}
  ;

Type
  TfrmTest = Class(TForm)
    About1: TMenuItem;
    Button3: TButton;
    Button4: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    ComboBox1: TComboBox;
    Contents1: TMenuItem;
    DBGrid2: TDBGrid;
    DBGrid3: TDBGrid;
    DBGrid4: TDBGrid;
    DBGrid5: TDBGrid;
    DBGrid6: TDBGrid;
    DBImage1: TDbImage;
    DBLabel1: TDbText;
    DBMemo1: TDbMemo;
    DBNavigator2: TDbNavigator;
    DBNavigator3: TDbNavigator;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    DataSource4: TDataSource;
    DataSource5: TDataSource;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Exit1: TMenuItem;
    File1: TMenuItem;
    Help1: TMenuItem;
    Howtobuy1: TMenuItem;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    MainMenu1: TMainMenu;
    N5: TMenuItem;
    N6: TMenuItem;
    PageControl1: TPageControl;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    PopupMenu2: TPopupMenu;
    RichEdit2: TRichEdit;
    RichEdit3: TRichEdit;
    RichEdit4: TRichEdit;
    SaveDialog1: TSaveDialog;
    Saveresultsetastext1: TMenuItem;
    StatusBar1: TStatusBar;
    SyntaxHighlighter1: TSyntaxHighlighter;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    Table1: TTable;
    Table2: TTable;
    Table3: TTable;
    Table4: TTable;
    Table5: TTable;
    XQuery1: TXQuery;
    XQuery2: TXQuery;
    xQuery3: TXQuery;
    xQuery4: TXQuery;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2EmpNo: TIntegerField;
    Table2ShipToContact: TStringField;
    Table2ShipToAddr1: TStringField;
    Table2ShipToAddr2: TStringField;
    Table2ShipToCity: TStringField;
    Table2ShipToState: TStringField;
    Table2ShipToZip: TStringField;
    Table2ShipToCountry: TStringField;
    Table2ShipToPhone: TStringField;
    Table2ShipVIA: TStringField;
    Table2PO: TStringField;
    Table2Terms: TStringField;
    Table2PaymentMethod: TStringField;
    Table2ItemsTotal: TCurrencyField;
    Table2TaxRate: TFloatField;
    Table2Freight: TCurrencyField;
    Table2AmountPaid: TCurrencyField;
    Table3OrderNo: TFloatField;
    Table3ItemNo: TFloatField;
    Table3PartNo: TFloatField;
    Table3Qty: TIntegerField;
    Table3Discount: TFloatField;
    Table4PartNo: TFloatField;
    Table4VendorNo: TFloatField;
    Table4Description: TStringField;
    Table4OnHand: TFloatField;
    Table4OnOrder: TFloatField;
    Table4Cost: TCurrencyField;
    Table4ListPrice: TCurrencyField;
    Table5SpeciesNo: TFloatField;
    Table5Category: TStringField;
    Table5Common_Name: TStringField;
    Table5SpeciesName: TStringField;
    Table5Lengthcm: TFloatField;
    Table5Length_In: TFloatField;
    Table5Notes: TMemoField;
    Table5Graphic: TGraphicField;
    Panel5: TPanel;
    Label2: TLabel;
    DBLabel2: TDbText;
    PageControlSQLExamples: TPageControl;
    TabSheetSQLString: TTabSheet;
    Panel8: TPanel;
    RadioGroupSQLExamples: TRadioGroup;
    Panel11: TPanel;
    RichEdit1: TRichEdit;
    PanelSideButtons: TPanel;
    Button2: TButton;
    Button5: TButton;
    BtnQBuilder: TButton;
    ButtonRunSQL: TBitBtn;
    TabSheetResultDataSet: TTabSheet;
    Panel9: TPanel;
    DBGrid1: TDBGrid;
    Panel10: TPanel;
    DBNavigator1: TDbNavigator;
    Bar1: TProgressBar;
    Procedure ButtonRunSQLClick(Sender: TObject);
    Procedure Button3Click(Sender: TObject);
    Procedure Button4Click(Sender: TObject);
    Procedure XQuery1FunctionCheck(Sender: TObject; Const Identifier: String; Params: TParameterList; Var Accept: Boolean);
    Procedure XQuery1FunctionSolve(Sender: TObject; Const Identifier: String; Params: TParameterList; Var Value: Variant);
    Procedure XQuery1Progress(Sender: TObject; Status: TXProgressStatus; Min, Max, Position: Integer);
    Procedure Contents1Click(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure About1Click(Sender: TObject);
    Procedure Howtobuy1Click(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure Exit1Click(Sender: TObject);
    Procedure PageControl1Change(Sender: TObject);
    Procedure SyntaxHighlighter1PosChange(Sender: TObject; Row, Col: Integer);
    Procedure Button2Click(Sender: TObject);
    Procedure Button5Click(Sender: TObject);
    Procedure Button6Click(Sender: TObject);
    Procedure XQuery1CancelRange(Sender: TObject; DataSet: TDataSet);
    Procedure Button7Click(Sender: TObject);
    Procedure Button8Click(Sender: TObject);
    Procedure XQuery1SetRange(Sender: TObject; RelOperator: TRelationalOperator; DataSet: TDataSet; Const FieldNames, StartValues, EndValues: String);
    Procedure XQuery1CreateIndex(Sender: TObject; Unique, Descending: Boolean; Const TableName, IndexName: String; ColumnExprList: TStringList);
    Procedure XQuery1DropTable(Sender: TObject; Const TableName: String);
    Procedure XQuery1DropIndex(Sender: TObject; Const TableName, IndexName: String);
    Procedure XQuery1IndexNeededFor(Sender: TObject; DataSet: TDataSet; Const FieldNames: String; ActivateIndex: Boolean; Var Accept: Boolean);
    Procedure XQuery1CreateTable(Sender: TObject; CreateTable: TCreateTableItem);
    Procedure XQuery1SetFilter(Sender: TObject; DataSet: TDataSet; Const Filter: String; Var Handled: Boolean);
    Procedure XQuery1CancelFilter(Sender: TObject; DataSet: TDataSet);
    Procedure XQuery1SyntaxError(Sender: TObject; Const ErrorMsg, OffendingText: String; LineNum, ColNum, TextLen: Integer);
    Procedure Button12Click(Sender: TObject);
    Procedure BtnQBuilderClick(Sender: TObject);
    Procedure Saveresultsetastext1Click(Sender: TObject);
    Procedure RadioGroupSQLExamplesClick(Sender: TObject);
    Procedure PageControlSQLExamplesChange(Sender: TObject);
  Private
    {$IFDEF QUERYBUILDER}
    FOQBDialog: TOQBuilderDialog;
    FOQBxQuery: TOQBEnginexQry;
    {$ENDIF}
    {$IFNDEF LEVEL3}
    Procedure PopupDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
    Procedure PopupMeasureItem(Sender: TObject; ACanvas: TCanvas; Var Width, Height: Integer);
    {$ENDIF}
  Public
  End;

Var
  frmTest: TfrmTest;

Implementation

{$R *.DFM}

Uses
  DemoAb,
  DemoReg,
  BDE,
  XQYacc;

Const
  CRLF = #13#10;
  (* Examples of SQL statements supported (some of them not useful at all but will show you the syntax supported)  *)

Procedure TfrmTest.ButtonRunSQLClick(Sender: TObject);
Begin
  PageControlSQLExamples.ActivePage := TabSheetResultDataSet;
  XQuery1.Close;
  RichEdit1.WordWrap := False; //There is a silly bug in RichEdit. It returns wrapped lines as new lines.
  XQuery1.Sql.Assign(RichEdit1.Lines);
  RichEdit1.WordWrap := True; //We're havin wordwrapping again
  XQuery1.Filtered := False;
  If ButtonRunSQL.Caption = 'Run SQL' Then XQuery1.Open //Run SQL
  Else XQuery1.ExecSql; //Exec SQL
  ButtonRunSQL.Enabled := False;
End;

Procedure TfrmTest.Button3Click(Sender: TObject);
Begin
  XQuery1.Filter := ComboBox1.Text;
  XQuery1.Filtered := True;
End;

Procedure TfrmTest.Button4Click(Sender: TObject);
Begin
  XQuery2.Close;
  XQuery2.Sql.SetText(PChar(RichEdit2.Text));
  XQuery2.Open;
End;

Procedure TfrmTest.XQuery1FunctionCheck(Sender: TObject;
  Const Identifier: String; Params: TParameterList; Var Accept: Boolean);
Var
  I: Integer;
Begin
  If AnsiCompareText(Identifier, 'DTOS') = 0 Then Begin
    Accept := True;
    Exit;
  End Else If AnsiCompareText(Identifier, 'AVGOF') = 0 Then Begin
    If Not (Assigned(Params) And (Params.Count > 1)) Then Begin
      Accept := False;
      Exit;
    End;
    {check that the function have only integers and float parameters}
    For I := 0 To Params.Count - 1 Do Begin
      If Not (Params.ExprType[I] In [TtFloat, TtInteger]) Then Begin
        Accept := False;
        Exit;
      End;
    End;
  End Else If AnsiCompareText(Identifier, 'TRIMDC') = 0 Then Begin
    {this function will trim all "$" and "," from a string
     and will return a float
     example of use SELECT TRIMDC("$10,000.45") FROM MyTable }
    If Not (Assigned(Params) And (Params.Count = 1)) Then Begin
      Accept := False;
      Exit;
    End;
    {check that the function have only string parameters}
    If Not (Params.ExprType[0] = TtString) Then Begin
      Accept := False;
      Exit;
    End;
  End;
End;

Procedure TfrmTest.XQuery1FunctionSolve(Sender: TObject; Const Identifier: String; Params: TParameterList; Var Value: Variant);
Var
  I: Integer;
  Temp: Double;
  TempS, S: String;
Begin
  If AnsiCompareText(Identifier, 'DTOS') = 0 Then Begin
    Value := '';
  End Else If AnsiCompareText(Identifier, 'AVGOF') = 0 Then Begin
    Temp := Params.AsFloat[0];
    For I := 1 To Params.Count - 1 Do // start from second param of function
      Temp := Temp + Params.AsFloat[I];
    Value := Temp / Params.Count;
  End Else If AnsiCompareText(Identifier, 'TRIMDC') = 0 Then Begin
    S := Params.AsString[0];
    TempS := '';
    For I := 1 To Length(S) Do Begin
      If Not (S[I] In ['$', ',']) Then TempS := TempS + S[I]; // discard "$" and ","
    End;
    Value := StrToFloat(TempS);
  End;
End;

Procedure TfrmTest.XQuery1Progress(Sender: TObject; Status: TXProgressStatus; Min, Max, Position: Integer);
Begin
  Case Status Of
    PsXStart: Begin
        If (Min = 0) Or (Max = 0) Then Exit;
        Bar1.Visible := True;
        Bar1.Min := Min;
        Bar1.Max := Max;
        Bar1.Position := Position;
      End;
    PsXProgress: Begin
        If Position = 0 Then Exit;
        Bar1.Position := Position;
      End;
    PsXEnd: Begin
        Bar1.Visible := False;
      End;
  End;
End;

Procedure TfrmTest.Contents1Click(Sender: TObject);
Begin
  Application.HelpCommand(HELP_CONTENTS, 0);
End;

Procedure TfrmTest.FormCreate(Sender: TObject);
Begin
  Application.HelpFile := ExtractFilePath(Application.ExeName) + 'txquery.hlp';
  ComboBox1.ItemIndex := 0;
  {$IFNDEF LEVEL3}
  PopupMenu2.OwnerDraw := True;
  {$ELSE}
  Button5.Visible := False;
  {$ENDIF}
End;

Procedure TfrmTest.About1Click(Sender: TObject);
Begin
  With TFrmAbout.Create(Application) Do Begin
    Try
      ShowModal;
    Finally
      Free;
    End;
  End;
End;

Procedure TfrmTest.Howtobuy1Click(Sender: TObject);
Begin
  With TfrmRegister.Create(Application) Do Begin
    Try
      ShowModal;
    Finally
      Free;
    End;
  End;
End;

Procedure TfrmTest.FormDestroy(Sender: TObject);
Begin
  Application.HelpCommand(HELP_QUIT, 0);
End;

Procedure TfrmTest.Exit1Click(Sender: TObject);
Begin
  Close;
End;

Procedure TfrmTest.PageControl1Change(Sender: TObject);
Begin
  If PageControl1.ActivePage = TabSheet2 Then Begin
  End Else If PageControl1.ActivePage = TabSheet1 Then SyntaxHighlighter1.Editor := RichEdit1
  Else If PageControl1.ActivePage = TabSheet3 Then SyntaxHighlighter1.Editor := RichEdit2
  Else If PageControl1.ActivePage = TabSheet4 Then SyntaxHighlighter1.Editor := RichEdit3
  Else If PageControl1.ActivePage = TabSheet5 Then SyntaxHighlighter1.Editor := RichEdit4;
  If Not (PageControl1.ActivePage = TabSheet5) Then XQuery4.Close;
End;

Procedure TfrmTest.SyntaxHighlighter1PosChange(Sender: TObject; Row,
  Col: Integer);
Begin
  StatusBar1.SimpleText := Format('Row: %d Col: %d', [Row, Col]);
End;

Procedure TfrmTest.Button2Click(Sender: TObject);
Begin
  SyntaxHighlighter1.EditColorSet;
End;

Procedure TfrmTest.Button5Click(Sender: TObject);
Var
  TmpPt: TPoint;
  Item: TMenuItem;
  ColorElement: PColorElement;
  I: Integer;
  g: TElementGroup;
Begin
  TmpPt := PanelSideButtons.ClientToScreen(Point(Button5.Left, Button5.Top + Button5.Height));
  For I := 0 To PopupMenu2.Items.Count - 1 Do PopupMenu2.Items.Delete(0);

  For g := Low(TElementGroup) To High(TElementGroup) Do Begin
    For I := 0 To SyntaxHighlighter1.ColorConfig.ColorSettings.Count - 1 Do Begin
      ColorElement := PColorElement(SyntaxHighlighter1.ColorConfig.ColorSettings[I]);
      If ColorElement^.Group = g Then Begin
        Item := TMenuItem.Create(Self);
        {$IFNDEF LEVEL3}
        Item.OnDrawItem := PopupDrawItem; // Delphi 3 cannot owner draw in menus
        Item.OnMeasureItem := PopupMeasureItem;
        {$ENDIF}
        Item.Tag := I;
        Case ColorElement^.Group Of
          IdWhiteSpace: Item.Caption := 'WhiteSpace';
          IdComment: Item.Caption := 'Comment';
          IdReservedWord: Item.Caption := 'ReservedWord';
          IdIdentifier: Item.Caption := 'Identifier';
          IdTable: Item.Caption := 'Dataset';
          IdField: Item.Caption := 'Field';
          IdString: Item.Caption := 'String';
          IdNumber: Item.Caption := 'Number';
          IdComma: Item.Caption := 'Comma';
          IdParenthesis: Item.Caption := 'Parenthesis';
          IdOperator: Item.Caption := 'Operator';
          IdSemicolon: Item.Caption := 'Semicolon';
          IdPeriod: Item.Caption := 'Period';
        End;
        PopupMenu2.Items.Add(Item);
      End;
    End;
  End;
  PopupMenu2.Popup(TmpPt.X, TmpPt.Y);
End;

{$IFNDEF LEVEL3}

Procedure TfrmTest.PopupDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
Var
  S: String;
  TmpRect: TRect;
  ColorElement: PColorElement;
Begin
  With ACanvas Do Begin
    FillRect(ARect);
    S := (Sender As TMenuItem).Caption;
    ReplaceString(S, '&', '');
    TmpRect := ARect;
    TmpRect.Left := TextWidth('X') * 2;
    //TextOut(TmpRect.Left, TmpRect.Top, (Sender as TMenuItem).Caption);
    DrawText(Handle, PChar(S), -1, TmpRect, DT_SINGLELINE Or DT_LEFT Or DT_VCENTER);
    ColorElement := PColorElement(SyntaxHighlighter1.ColorConfig.ColorSettings[(Sender As TMenuItem).Tag]);
    TmpRect := ARect;
    TmpRect.Right := TextWidth('X') * 2 - 1;
    InflateRect(TmpRect, -2, -2);
    Brush.Color := ColorElement^.ForeColor;
    FillRect(TmpRect);
  End;
End;

Procedure TfrmTest.PopupMeasureItem(Sender: TObject;
  ACanvas: TCanvas; Var Width, Height: Integer);
Begin
  With ACanvas Do Begin
    Height := TextHeight('0') + 2;
    Width := TextWidth('X') * 13 + 2;
  End;
End;
{$ENDIF}

Procedure TfrmTest.Button6Click(Sender: TObject);
Begin
  XQuery1.Find(Edit1.Text);
End;

Procedure TfrmTest.XQuery1CancelRange(Sender: TObject; DataSet: TDataSet);
Begin
  (DataSet As TTable).CancelRange; // if a range was set
  (DataSet As TTable).Filtered := False; // if was filtered
End;

Procedure TfrmTest.Button7Click(Sender: TObject);
Begin
  If XQuery3.ParamCount = 0 Then Begin
    XQuery3.Params.CreateParam(FtInteger, 'LOWRANGE', PtUnknown);
    XQuery3.Params.CreateParam(FtInteger, 'HIGHRANGE', PtUnknown);
  End;
  XQuery3.Close;
  XQuery3.ParamByName('LOWRANGE').AsInteger := StrToInt(Edit2.Text);
  XQuery3.ParamByName('HIGHRANGE').AsInteger := StrToInt(Edit3.Text);
  XQuery3.Open;
End;

Procedure TfrmTest.Button8Click(Sender: TObject);
Begin
  If xQuery4.ParamCount = 0 Then
    xQuery4.Params.CreateParam(FtFloat, 'CustNo', PtUnknown);
  xQuery4.Close;
  xQuery4.Open;
End;

Procedure TfrmTest.XQuery1SetRange(Sender: TObject;
  RelOperator: TRelationalOperator; DataSet: TDataSet; Const FieldNames,
  StartValues, EndValues: String);
Var
  F: TField;
Begin
  If RelOperator = ropBETWEEN Then Begin // Warning: this will fail with multiple fields "OrderNo;ItemNo"
    With DataSet As TTable Do Begin
      SetRangeStart;
      FieldByName(FieldNames).AsString := StartValues;
      SetRangeEnd;
      FieldByName(FieldNames).AsString := EndValues;
      ApplyRange;
    End;
  End Else If RelOperator In [ropGT, ropGE, ropLT, ropLE, ropNEQ] Then Begin // instead, will use a filter
    With DataSet As TTable Do Begin
      F := FindField(FieldNames);
      Case F.DataType Of
        FtString{$IFDEF LEVEL4}, FtFixedChar, FtWideString{$ENDIF}: Begin
            Case RelOperator Of
              ropGT: Filter := Format('%s > ''%s''', [FieldNames, StartValues]);
              ropGE: Filter := Format('%s >= ''%s''', [FieldNames, StartValues]);
              ropLT: Filter := Format('%s < ''%s''', [FieldNames, StartValues]);
              ropLE: Filter := Format('%s <= ''%s''', [FieldNames, StartValues]);
              ropNEQ: Filter := Format('%s <> ''%s''', [FieldNames, StartValues]);
            End;
            Filtered := True;
          End;
        FtFloat, FtCurrency, FtBCD, FtDate, FtTime, FtDateTime,
          FtAutoInc, FtSmallint, FtInteger, FtWord
          {$IFNDEF LEVEL3}, FtLargeInt{$ENDIF}, FtBoolean: Begin
            Case RelOperator Of
              ropGT: Filter := Format('%s > %s', [FieldNames, StartValues]);
              ropGE: Filter := Format('%s >= %s', [FieldNames, StartValues]);
              ropLT: Filter := Format('%s < %s', [FieldNames, StartValues]);
              ropLE: Filter := Format('%s <= %s', [FieldNames, StartValues]);
              ropNEQ: Filter := Format('%s <> %s', [FieldNames, StartValues]);
            End;
            Filtered := True;
          End;
      End;
    End;
  End;
End;

Procedure TfrmTest.XQuery1CreateIndex(Sender: TObject; Unique, Descending: Boolean; Const TableName, IndexName: String; ColumnExprList: TStringList);
Var
  S, TempS: String;
  I: Integer;
Begin
  S := 'Requested to create an index on table : ' + TableName + CRLF + 'Index name on this table : ' + IndexName + CRLF;
  If Unique Then TempS := 'Index Unique ' Else TempS := 'Duplicates allowed ';

  S := S + TempS + CRLF;
  If Descending Then TempS := 'Sort descending ' Else TempS := 'Sort ascending';

  S := S + TempS + CRLF + 'Columns expressions to index on :' + CRLF;

  For I := 0 To ColumnExprList.Count - 1 Do S := S + ColumnExprList[I] + CRLF;
  ShowMessage(S);
End;

Procedure TfrmTest.XQuery1DropTable(Sender: TObject; Const TableName: String);
Begin
  ShowMessage('Requested to drop table ' + TableName);
End;

Procedure TfrmTest.XQuery1DropIndex(Sender: TObject; Const TableName, IndexName: String);
Begin
  ShowMessage('Requested to drop index ' + IndexName + ' on table ' + TableName);
End;

Procedure TfrmTest.XQuery1IndexNeededFor(Sender: TObject; DataSet: TDataSet; Const FieldNames: String; ActivateIndex: Boolean; Var Accept: Boolean);
Begin
  If DataSet = Table1 Then Accept := (AnsiCompareText(FieldNames, 'CustNo') = 0)
  Else If DataSet = Table2 Then Accept := (AnsiCompareText(FieldNames, 'CustNo') = 0) Or (AnsiCompareText(FieldNames, 'OrderNo') = 0)
  Else If DataSet = Table3 Then Accept := (AnsiCompareText(FieldNames, 'OrderNo') = 0)
    Or (AnsiCompareText(FieldNames, 'OrderNo;ItemNo') = 0)
      Or (AnsiCompareText(FieldNames, 'PartNo') = 0)
  Else If DataSet = Table4 Then Accept := (AnsiCompareText(FieldNames, 'PartNo') = 0)
    Or (AnsiCompareText(FieldNames, 'Description') = 0)
      Or (AnsiCompareText(FieldNames, 'VendorNo') = 0);

  If Accept And ActivateIndex Then (DataSet As TTable).IndexFieldNames := FieldNames;
End;

Procedure TfrmTest.XQuery1CreateTable(Sender: TObject;
  CreateTable: TCreateTableItem);
Var
  S, BlobType: String;
  I: Integer;
  {$IFDEF USE_DBF_ENGINE}
  FieldList: TStringList;
  FileName, FieldName, IndexFileName: String;
  FieldType: Char;
  FieldSize, FieldDec: Integer;
  Halc: THalcyonDataSet;
  {$ENDIF}
Begin
  S := 'SQL statement issued:' + CRLF + XQuery1.Sql.Text + CRLF;
  ShowMessage(S);

  S := 'Analisis of CREATE TABLE statement:' + CRLF + Format('CREATE TABLE requested on table "%s"', [CreateTable.TableName]) + CRLF + Format('Number of fields to create : %d', [CreateTable.FieldCount]) + CRLF;

  For I := 0 To CreateTable.FieldCount - 1 Do Begin
    S := S + Format('"%s" ', [CreateTable.Fields[I].FieldName]);
    Case CreateTable.Fields[I].FieldType Of // list of possible types accepted in TxQuery parser
      RW_CHAR: S := S + Format('type CHAR of Length %d', [CreateTable.Fields[I].Size]) + CRLF; // use Size property here
      RW_INTEGER: S := S + 'type INTEGER' + CRLF;
      RW_SMALLINT: S := S + 'type SMALLINT' + CRLF;
      RW_BOOLEAN: S := S + 'type BOOLEAN' + CRLF;
      RW_DATE: S := S + 'type DATE' + CRLF;
      RW_TIME: S := S + 'type TIME' + CRLF;
      RW_DATETIME: S := S + 'type DATETIME' + CRLF;
      RW_MONEY: S := S + 'type MONEY' + CRLF;
      RW_FLOAT: S := S + Format('type FLOAT Scale %d Precision %d', [CreateTable.Fields[I].Scale, CreateTable.Fields[I].Precision]) + CRLF; // use Scale and Precision properties here
      RW_AUTOINC: S := S + 'type AUTOINC' + CRLF;
      RW_BLOB: Begin // use BlobType property here
          Case CreateTable.Fields[I].BlobType Of
            1: BlobType := 'Memo';
            2: BlobType := 'Binary';
            3: BlobType := 'Formatted Memo';
            4: BlobType := 'OLE';
            5: BlobType := 'Graphic/Binary';
          End;
          S := S + Format('is a BLOB of type %s', [BlobType]) + CRLF;
        End;
    End;
  End;

  S := S + CRLF + 'SORT ORDER:' + CRLF;

  If CreateTable.PrimaryKey.Count = 0 Then S := S + 'NONE'
  Else Begin
    For I := 0 To CreateTable.PrimaryKey.Count - 1 Do S := S + CreateTable.PrimaryKey[I] + CRLF;
  End;

  ShowMessage(S);

  {$IFDEF USE_DBF_ENGINE} // A working example with Halcyon
  FieldList := TStringList.Create;
  Try
    For I := 0 To CreateTable.FieldCount - 1 Do Begin
      FieldName := CreateTable.Fields[I].FieldName;
      Case CreateTable.Fields[I].FieldType Of // list of possible types accepted in TxQuery parser
        RW_CHAR: Begin
            FieldType := 'C';
            FieldSize := CreateTable.Fields[I].Size;
            FieldDec := 0;
          End;
        RW_INTEGER, RW_AUTOINC: Begin
            FieldType := 'N';
            FieldSize := 11;
            FieldDec := 0;
          End;
        RW_SMALLINT: Begin
            FieldType := 'N';
            FieldSize := 6;
            FieldDec := 0;
          End;
        RW_BOOLEAN: Begin
            FieldType := 'L';
            FieldSize := 1;
            FieldDec := 0;
          End;
        RW_DATE, RW_TIME, RW_DATETIME: Begin
            FieldType := 'D';
            FieldSize := 10;
            FieldDec := 0;
          End;
        RW_MONEY, RW_FLOAT: Begin
            FieldType := 'N';
            If CreateTable.Fields[I].Scale = 0 Then Begin
              FieldSize := 20;
              FieldDec := 4;
            End Else Begin
              FieldSize := CreateTable.Fields[I].Scale;
              FieldDec := CreateTable.Fields[I].Precision;
            End;
          End;
        RW_BLOB: Begin // use BlobType property here
            Case CreateTable.Fields[I].BlobType Of
              1, 3: FieldType := 'M'; // Memo, Formatted Memo
              2, 4: FieldType := 'B'; // Binary, OLE
              5: FieldType := 'G'; // Graphic/Binary
            End;
            FieldSize := 8;
            FieldDec := 0;
          End;
      End;
      FieldList.Add(Format('%s;%s;%d;%d', [FieldName, FieldType, FieldSize, FieldDec]));
    End;
    FileName := CreateTable.TableName;
    gs6_shel.CreateDBF(FileName, '', FoxPro2, FieldList); // change FoxPro2 to your choice
    If CreateTable.PrimaryKey.Count > 0 Then Begin
      S := CreateTable.PrimaryKey[0];
      For I := 1 To CreateTable.PrimaryKey.Count - 1 Do S := S + '+' + CreateTable.PrimaryKey[I];
      Halc := THalcyonDataSet.Create(Nil);
      Try
        Halc.DataBaseName := ExtractFilePath(FileName);
        Halc.TableName := ExtractFileName(FileName);
        Halc.Open;
        IndexFileName := ChangeFileExt(FileName, '.cdx');
        Halc.IndexOn(IndexFileName, 'PRIMARY', S, '.NOT.DELETED()', Halcn6DB.Unique, Halcn6DB.Ascending); // optionl
      Finally
        Halc.Free;
      End;
    End;
    ShowMessage(Format('Table %s was successful created', [FileName]));
  Finally
    FieldList.Free;
  End;
  {$ENDIF}
End;

Procedure TfrmTest.XQuery1SetFilter(Sender: TObject; DataSet: TDataSet; Const Filter: String; Var Handled: Boolean);
Begin
  { Note: in this case, filters now needed, they are set in OnSetRange this is only to illustrate how to }
  //ShowMessage(Filter);
  { can this filter be set ?}
  {try
     (DataSet as TTable).Filtered := False;
     (DataSet as TTable).Filter   := Filter;
     (DataSet as TTable).Filtered := True;
     Handled := True;
  except
     Handled := False;
     (DataSet as TTable).Filtered := False;
  end; }
End;

Procedure TfrmTest.XQuery1CancelFilter(Sender: TObject; DataSet: TDataSet);
Begin
  {(DataSet as TTable).Filtered := False;
   (DataSet as TTable).Filter := '';}
End;

Procedure TfrmTest.XQuery1SyntaxError(Sender: TObject; Const ErrorMsg, OffendingText: String; LineNum, ColNum, TextLen: Integer);
Var
  I, NumChars: Integer;
Begin
  ShowMessage(ErrorMsg + ' at or before ' + OffendingText + Format(' Line %d, Column %d', [LineNum, ColNum]));
  { Will not show or use ErrorMsg parameter }
  NumChars := 0;
  I := 0;
  While I < LineNum - 1 Do Begin
    Inc(NumChars, Length(RichEdit1.Lines[I]) + 2);
    Inc(I);
  End;
  PageControlSQLExamples.ActivePage := TabSheetSQLString;
  RichEdit1.SelStart := NumChars + ColNum;
  RichEdit1.SelLength := TextLen;
  RichEdit1.SetFocus;
End;

Procedure TfrmTest.Button12Click(Sender: TObject);
Begin
  If Not XQuery1.Active Then Exit;
End;

Procedure TfrmTest.BtnQBuilderClick(Sender: TObject);
Begin
  {$IFDEF QUERYBUILDER}
  If Not Assigned(FOQBDialog) Then Begin
    FOQBDialog := TOQBuilderDialog.Create(Self);
    FOQBxQuery := TOQBEnginexQry.Create(Self);
    FOQBxQuery.XQuery := XQuery1;
    FOQBxQuery.UseTableAliases := True;
    FOQBDialog.OQBEngine := FOQBxQuery;
  End;
  If FOQBDialog.Execute Then RichEdit1.Lines.Text := FOQBDialog.Sql.Text;
  {$ELSE}
  ShowMessage('If you want to use the query builder option,' + CRLF +
    'You must download the software from this URL : ' + CRLF +
    'http://www.geocities.com/SiliconValley/Way/9006/index.html' + CRLF +
    'After downloading see help file for details searching for:' + CRLF +
    '"Query builder"' + CRLF +
    'After that, enable optional compilation switch QUERYBUILDER on' + CRLF +
    'top of this form');
  {$ENDIF}
End;

Procedure TfrmTest.Saveresultsetastext1Click(Sender: TObject);
Var
  FieldNames: TStringList;
Begin
  If Not XQuery1.Active Or Not SaveDialog1.Execute Then Exit;
  FieldNames := TStringList.Create;
  Try
    XQuery1.WriteToTextFile(SaveDialog1.FileName, // save to this file
      '"', // field delim character
      ',', // text separator
      False, // true = CSV format, false = text only
      FieldNames); // empty = all fields
  Finally
    FieldNames.Free;
  End;
End;

Procedure TfrmTest.RadioGroupSQLExamplesClick(Sender: TObject);
Begin
  RichEdit1.Lines.Clear;
  ButtonRunSQL.Caption := 'Run SQL';
  SyntaxHighlighter1.Editor := Nil;
  Table1.First;
  Case RadioGroupSQLExamples.ItemIndex Of
    00: Begin //BETWEEN
        RichEdit1.Lines.Add('SELECT customer.* FROM customer ');
        RichEdit1.Lines.Add('WHERE LastInvoiceDate ');
        RichEdit1.Lines.Add('BETWEEN #01/01/1990# ');
        RichEdit1.Lines.Add('AND #12/31/1994# ORDER BY ');
        RichEdit1.Lines.Add('Customer.LastInvoiceDate');
      End;
    01: Begin //DISTINCT Aggregate
        RichEdit1.Lines.Add('Select Count(DISTINCT Country)');
        RichEdit1.Lines.Add('FROM Customer;');
      End;
    02: Begin //DISTINCT Record
        RichEdit1.Lines.Add('Select DISTINCT Country');
        RichEdit1.Lines.Add('FROM Customer ORDER BY Country;');
      End;
    03: Begin //GROUP BY and Aggregates: Sample 1
        RichEdit1.Lines.Add('SELECT c.CustNo, CAST(Sum(AmountPaid) ');
        RichEdit1.Lines.Add('AS MONEY) As SumAmount, ');
        RichEdit1.Lines.Add('CAST(Avg(AmountPaid) AS MONEY), ');
        RichEdit1.Lines.Add('CAST(Min(AmountPaid) AS MONEY), ');
        RichEdit1.Lines.Add('Count(*) FROM Customer c, Orders o ');
        RichEdit1.Lines.Add('WHERE (c.CustNo = o.CustNo) ');
        RichEdit1.Lines.Add('GROUP BY c.CustNo HAVING Sum(AmountPaid) > 80000;');
      End;
    04: Begin //GROUP BY and Aggregates: Sample 2
        RichEdit1.Lines.Add('SELECT CUSTNO, SUM(AMOUNTPAID) / SUM(ITEMSTOTAL) ');
        RichEdit1.Lines.Add('As Rate ');
        RichEdit1.Lines.Add('FROM ORDERS GROUP BY CUSTNO;');
      End;
    05: Begin //GROUP BY and Aggregates: Sample 3
        RichEdit1.Lines.Add('SELECT CAST(SUM(ItemsTotal) / COUNT(CustNo) AS MONEY) ');
        RichEdit1.Lines.Add('FROM ORDERS;');
      End;
    06: Begin //IN
        RichEdit1.Lines.Add('SELECT * FROM customer WHERE City IN (');
        RichEdit1.Lines.Add('"Bogota", "Sarasota", "Freeport", "Tampa", ');
        RichEdit1.Lines.Add('"Somerset", "Honolulu");');
      End;
    07: Begin //JOIN
        RichEdit1.Lines.Add('SELECT * FROM Customer c, Orders o, Items i, ');
        RichEdit1.Lines.Add('Parts p WHERE (c.CustNo = o.CustNo) And ');
        RichEdit1.Lines.Add('(o.OrderNo = i.OrderNo) And (i.PartNo = p.PartNo) ');
        RichEdit1.Lines.Add('And (c.CustNo > 1300) And (c.CustNo < 2000);');
      End;
    08: Begin //JOIN In SELECT
        RichEdit1.Lines.Add('SELECT * FROM Customer INNER JOIN Orders ON ');
        RichEdit1.Lines.Add('(Customer.CustNo = Orders.CustNo)');
        RichEdit1.Lines.Add(' INNER JOIN Items ON (Orders.OrderNo = Items.OrderNo)');
        RichEdit1.Lines.Add(' INNER JOIN Parts ON (Items.PartNo = Parts.PartNo);');
      End;
    09: Begin //JOIN In WHERE
        RichEdit1.Lines.Add('SELECT * FROM Customer c, Orders o, Items i, ');
        RichEdit1.Lines.Add('Parts p ');
        RichEdit1.Lines.Add('WHERE (c.CustNo = o.CustNo) And (o.OrderNo = i.OrderNo) ');
        RichEdit1.Lines.Add('And (i.PartNo = p.PartNo);');
      End;
    10: Begin //JOIN With Multiple Fields
        RichEdit1.Lines.Add('/* This is only to illustrate multiple fields joining */ ');
        RichEdit1.Lines.Add('SELECT * FROM Customer c INNER JOIN Orders o ON ');
        RichEdit1.Lines.Add('(c.CustNo = o.CustNo) AND (c.CustNo = o.CustNo) ');
        RichEdit1.Lines.Add('AND (c.CustNo = o.CustNo) ');
        RichEdit1.Lines.Add('INNER JOIN Items i ');
        RichEdit1.Lines.Add('ON (o.OrderNo = i.OrderNo);');
      End;
    11: Begin //JOIN With Table Alias
        RichEdit1.Lines.Add('SELECT * FROM Customer c ');
        RichEdit1.Lines.Add('INNER JOIN Orders o ON (c.CustNo = o.CustNo)');
        RichEdit1.Lines.Add(' INNER JOIN Items i ON (o.OrderNo = i.OrderNo)');
        RichEdit1.Lines.Add(' INNER JOIN Parts p ON (i.PartNo = p.PartNo);');
      End;
    12: Begin //LIKE: Sample 1
        RichEdit1.Text := 'SELECT * FROM Customer WHERE Company LIKE "%Under%";';
      End;
    13: Begin //LIKE: Sample 2
        RichEdit1.Text := 'SELECT * FROM Customer WHERE Company LIKE "%C_ub";';
      End;
    14: Begin //LIKE: Sample 3
        RichEdit1.Text := 'SELECT * FROM Customer WHERE company LIKE ''A%Under%'';';
      End;
    15: Begin //MERGE
        RichEdit1.Lines.Add('/* MERGE is customer requested command ');
        RichEdit1.Lines.Add('(it is not part of SQL). Syntax is: ');
        RichEdit1.Lines.Add('MERGE select_statement1 WITH select_statement2 ');
        RichEdit1.Lines.Add('You can also combine different tables ');
        RichEdit1.Lines.Add('but they must have compatible column types */');
        RichEdit1.Lines.Add('MERGE SELECT * FROM customer WHERE custno ');
        RichEdit1.Lines.Add('BETWEEN 1000 AND 2500; ');
        RichEdit1.Lines.Add('WITH  SELECT * FROM customer WHERE custno ');
        RichEdit1.Lines.Add('BETWEEN 2000 AND 3000;');
      End;
    16: Begin //ORDER BY: Sample 1
        RichEdit1.Text := 'SELECT CustNo, Company, Addr1, Addr2 FROM customer ORDER BY custno DESC;';
      End;
    17: Begin //ORDER BY: Sample 2
        RichEdit1.Text := 'SELECT CustNo, Company, Addr1, Addr2 FROM customer ORDER BY 2 DESC;';
      End;
    18: Begin //ORDER BY: Sample 3
        RichEdit1.Text := 'SELECT CustNo, Company, City FROM Customer ORDER BY City, 2 DESC;';
      End;
    19: Begin //SELECT
        RichEdit1.Lines.Add('/* TXQuery dataset demo');
        RichEdit1.Lines.Add('Version 1.50 */');
        RichEdit1.Lines.Add('SELECT * FROM Customer;');
      End;
    20: Begin //Some Functions
        RichEdit1.Lines.Add('SELECT LOWER(TRIM(TRAILING "e" FROM company)) As TrimmedAndLowered, ');
        RichEdit1.Lines.Add(' EXTRACT(YEAR FROM LastInvoiceDate) As TheYear, ');
        RichEdit1.Lines.Add(' EXTRACT(MONTH FROM LastInvoiceDate) As TheMonth, ');
        RichEdit1.Lines.Add(' CAST(MINOF(LastInvoiceDate, NOW) AS DATETIME) As MinDate, ');
        RichEdit1.Lines.Add(' CAST(FORMATDATETIME("dd/mm/yy",MAXOF(LastInvoiceDate, NOW)) AS CHAR(20)) ');
        RichEdit1.Lines.Add(' As MaxDate, ');
        RichEdit1.Lines.Add(' SUBSTRING(country FROM 2 FOR 6) As SubCountry, ');
        RichEdit1.Lines.Add(' /* same as */');
        RichEdit1.Lines.Add(' COPY(country, 2, 6) As UsingCopy,');
        RichEdit1.Lines.Add(' addr2,');
        RichEdit1.Lines.Add(' LENGTH(addr2) > 0 As LenAddr2 ');
        RichEdit1.Lines.Add('FROM customer ');
        RichEdit1.Lines.Add('ORDER BY 2 DESC;');
      End;
    21: Begin //Functions Solved In Events
        RichEdit1.Lines.Add('SELECT itemstotal, amountpaid, freight, ');
        RichEdit1.Lines.Add(' /* AVGOF() is a function solved in events');
        RichEdit1.Lines.Add(' OnFunctionCheck and OnFunctionSolve and');
        RichEdit1.Lines.Add(' defined in property ExFunctions      */');
        RichEdit1.Lines.Add(' AVGOF(itemstotal, amountpaid, freight) As Average ');
        RichEdit1.Lines.Add('FROM orders; ');
      End;
    22: Begin //Subqueries: Sample 1
        RichEdit1.Lines.Add('SELECT * ');
        RichEdit1.Lines.Add('FROM Customer ');
        RichEdit1.Lines.Add('WHERE CustNo > (SELECT AVG(CustNo) FROM Customer);');
      End;
    23: Begin //Subqueries: Sample 2
        RichEdit1.Lines.Add('SELECT * FROM Customer WHERE custno >= ');
        RichEdit1.Lines.Add('ALL (SELECT CustNo FROM customer WHERE ');
        RichEdit1.Lines.Add('/* This is a comment inside SQL statement*/ City ');
        RichEdit1.Lines.Add('IN ("Freeport", "Christiansted", "Kailua-Kona", ');
        RichEdit1.Lines.Add('"Giribaldi", "Kitchener", "Negril"));');
      End;
    24: Begin //TRANSFORM...PIVOT: Sample 1
        RichEdit1.Lines.Add('/* This is a TRANSFORM...PIVOT demo ala Microsoft Access */');
        RichEdit1.Lines.Add('TRANSFORM CAST(SUM(AmountPaid) AS MONEY) SELECT CUSTNO FROM ');
        RichEdit1.Lines.Add('ORDERS GROUP BY CUSTNO ');
        RichEdit1.Lines.Add('PIVOT FormatDateTime("yyyy", SALEDATE);');
      End;
    25: Begin //TRANSFORM...PIVOT: Sample 2
        RichEdit1.Lines.Add('TRANSFORM SUM(AmountPaid) SELECT CUSTNO ');
        RichEdit1.Lines.Add('FROM ORDERS GROUP BY CUSTNO ');
        RichEdit1.Lines.Add('PIVOT FormatDateTime("yyyy", SALEDATE) IN ');
        RichEdit1.Lines.Add('("1988", "1992", "1993", "1995", "1996");');
      End;
    26: Begin //TRANSFORM...PIVOT: Sample 3
        RichEdit1.Lines.Add('TRANSFORM CAST(SUM(AmountPaid) AS MONEY) ');
        RichEdit1.Lines.Add('SELECT CUSTNO FROM ORDERS ');
        RichEdit1.Lines.Add('GROUP BY CUSTNO ');
        RichEdit1.Lines.Add('PIVOT FormatDateTime("mmm", SALEDATE) IN ');
        RichEdit1.Lines.Add('("Jan", "Feb", "Mar", "Apr", "May", "Jun", ');
        RichEdit1.Lines.Add('"Jul", "Aug", "Sep", "Oct", "Nov", "Dec");');
      End;
    27: Begin //CREATE TABLE
        ButtonRunSQL.Caption := 'Exec SQL';
        RichEdit1.Lines.Add('CREATE TABLE "MyDatabase.Dbf"');
        RichEdit1.Lines.Add('(');
        RichEdit1.Lines.Add(' last_name  CHAR(30),');
        RichEdit1.Lines.Add(' first_name CHAR(40),');
        RichEdit1.Lines.Add(' salary     FLOAT(20,2),');
        RichEdit1.Lines.Add(' zip_code   CHAR(15),');
        RichEdit1.Lines.Add(' work_phone CHAR(30),');
        RichEdit1.Lines.Add(' home_phone CHAR(30),');
        RichEdit1.Lines.Add(' f1         FLOAT,');
        RichEdit1.Lines.Add(' f2         FLOAT(15),');
        RichEdit1.Lines.Add(' i1         SMALLINT,');
        RichEdit1.Lines.Add(' i2         INTEGER,');
        RichEdit1.Lines.Add(' B1         BOOLEAN,');
        RichEdit1.Lines.Add(' D1         DATE,');
        RichEdit1.Lines.Add(' D2         TIME,');
        RichEdit1.Lines.Add(' D3         DATETIME,');
        RichEdit1.Lines.Add(' CUSTNO     AUTOINC,');
        RichEdit1.Lines.Add(' M          MONEY,');
        RichEdit1.Lines.Add(' photo      BLOB(5)');
        RichEdit1.Lines.Add(' PRIMARY KEY (last_name, first_name)');
        RichEdit1.Lines.Add(')');
        RichEdit1.Lines.Add('CREATE TABLE "Table2.Dbf"');
        RichEdit1.Lines.Add('(');
        RichEdit1.Lines.Add(' last_name   CHAR(30),');
        RichEdit1.Lines.Add(' first_name  CHAR(40),');
        RichEdit1.Lines.Add(' salary      FLOAT(20,2)');
        RichEdit1.Lines.Add(');');
      End;
    28: Begin //CREATE INDEX
        ButtonRunSQL.Caption := 'Exec SQL';
        RichEdit1.Text := 'CREATE UNIQUE DESC INDEX custdate ON "Table1.DBF" (first_name, last_name); ';
      End;
    29: Begin //DROP TABLE
        ButtonRunSQL.Caption := 'Exec SQL';
        RichEdit1.Text := 'DROP TABLE "table1.dbf" ;';
      End;
    30: Begin //DROP INDEX
        ButtonRunSQL.Caption := 'Exec SQL';
        RichEdit1.Text := 'DROP INDEX "table1.dbf" primaryindex ;';
      End;
  End;
  SyntaxHighlighter1.Editor := RichEdit1;
  ButtonRunSQL.Enabled := True;
End;

Procedure TfrmTest.PageControlSQLExamplesChange(Sender: TObject);
Begin
  ButtonRunSQL.Enabled := (PageControlSQLExamples.ActivePage = TabSheetSQLString) And (Trim(RichEdit1.Text) <> '');
End;

End.

