unit Ex1U;

{$I XQ_FLAG.INC}
interface

//{$define QUERYBUILDER}     { use query builder in the demo. Uncomment if not used }
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, xquery, Db, DBTables, StdCtrls, ComCtrls, Menus, ExtCtrls,
  DBCtrls, Buttons, PrExprQ, SyntaxHi, xqmiscel, xqbase
  {$IFDEF USE_DBF_ENGINE} , halcn6DB, gs6_shel {$ENDIF}
  {$ifdef QUERYBUILDER} , QBuilder, OQBExQry {$endif}
  ;

type
  TForm1 = class(TForm)
    XQuery1: TXQuery;
    DataSource1: TDataSource;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DBGrid1: TDBGrid;
    PopupMenu1: TPopupMenu;
    SingleSELECT1: TMenuItem;
    JOINsinSELECT1: TMenuItem;
    AnotherJOIN1: TMenuItem;
    JOINsinWHERE1: TMenuItem;
    N2: TMenuItem;
    UsingLIKE1: TMenuItem;
    UsingIN1: TMenuItem;
    UsingBETWEEN1: TMenuItem;
    UsingTRIM1: TMenuItem;
    GROUPBY11: TMenuItem;
    Sample11: TMenuItem;
    Sample21: TMenuItem;
    Sample31: TMenuItem;
    JOINs1: TMenuItem;
    AnotherSample1: TMenuItem;
    N1: TMenuItem;
    ORDERBY1: TMenuItem;
    N3: TMenuItem;
    Subqueries1: TMenuItem;
    Sample12: TMenuItem;
    Sample22: TMenuItem;
    Sample13: TMenuItem;
    Sample23: TMenuItem;
    Sample32: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    Button3: TButton;
    DBGrid2: TDBGrid;
    XQuery2: TXQuery;
    DataSource2: TDataSource;
    Table5: TTable;
    TabSheet3: TTabSheet;
    DBGrid3: TDBGrid;
    Panel3: TPanel;
    DBNavigator2: TDBNavigator;
    Button4: TButton;
    BtnSelect: TButton;
    DBNavigator1: TDBNavigator;
    Table1: TTable;
    Table2: TTable;
    Table3: TTable;
    Table4: TTable;
    N4: TMenuItem;
    Somefunctions1: TMenuItem;
    Panel4: TPanel;
    DBLabel1: TDBText;
    DBImage1: TDBImage;
    Panel5: TPanel;
    Label2: TLabel;
    DBLabel2: TDBText;
    Panel6: TPanel;
    DBMemo1: TDBMemo;
    Functions1: TMenuItem;
    Bar1: TProgressBar;
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    Howtobuy1: TMenuItem;
    N5: TMenuItem;
    About1: TMenuItem;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Label1: TLabel;
    ComboBox1: TComboBox;
    StatusBar1: TStatusBar;
    RichEdit2: TRichEdit;
    Button2: TButton;
    Button5: TButton;
    RichEdit1: TRichEdit;
    PopupMenu2: TPopupMenu;
    SyntaxHighlighter1: TSyntaxHighlighter;
    Label3: TLabel;
    Edit1: TEdit;
    Button6: TButton;
    DISTINCT1: TMenuItem;
    DISTINCTfield1: TMenuItem;
    DISTINCTaggregate1: TMenuItem;
    TabSheet4: TTabSheet;
    RichEdit3: TRichEdit;
    DBGrid4: TDBGrid;
    xQuery3: TxQuery;
    DataSource3: TDataSource;
    Label4: TLabel;
    Edit2: TEdit;
    Label5: TLabel;
    Edit3: TEdit;
    Button7: TButton;
    Multiplefields1: TMenuItem;
    TabSheet5: TTabSheet;
    Panel7: TPanel;
    DBGrid5: TDBGrid;
    DataSource4: TDataSource;
    DBGrid6: TDBGrid;
    DataSource5: TDataSource;
    xQuery4: TxQuery;
    Button8: TButton;
    RichEdit4: TRichEdit;
    Label6: TLabel;
    DBNavigator3: TDBNavigator;
    PopupMenu3: TPopupMenu;
    CreateTable1: TMenuItem;
    CREATEINDEXstatement1: TMenuItem;
    Button10: TButton;
    DROPTABLE1: TMenuItem;
    DROPINDEX1: TMenuItem;
    TRANSFORMPIVOT1: TMenuItem;
    TPEXAMPLE1: TMenuItem;
    TPExample2: TMenuItem;
    TPExample3: TMenuItem;
    MERGE1: TMenuItem;
    Button1: TBitBtn;
    Button9: TBitBtn;
    BtnQBuilder: TButton;
    SaveDialog1: TSaveDialog;
    Sample14: TMenuItem;
    Sample24: TMenuItem;
    Sample33: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    N6: TMenuItem;
    Saveresultsetastext1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure BtnSelectClick(Sender: TObject);
    procedure SingleSELECT1Click(Sender: TObject);
    procedure JOINsinSELECT1Click(Sender: TObject);
    procedure AnotherJOIN1Click(Sender: TObject);
    procedure JOINsinWHERE1Click(Sender: TObject);
    procedure UsingIN1Click(Sender: TObject);
    procedure UsingBETWEEN1Click(Sender: TObject);
    procedure Sample11Click(Sender: TObject);
    procedure Sample21Click(Sender: TObject);
    procedure Sample31Click(Sender: TObject);
    procedure AnotherSample1Click(Sender: TObject);
    procedure Sample13Click(Sender: TObject);
    procedure Sample23Click(Sender: TObject);
    procedure Sample32Click(Sender: TObject);
    procedure Sample12Click(Sender: TObject);
    procedure Sample22Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Somefunctions1Click(Sender: TObject);
    procedure XQuery1FunctionCheck(Sender: TObject;
      const Identifier: String; Params: TParameterList;
      var Accept: Boolean);
    procedure XQuery1FunctionSolve(Sender: TObject;
      const Identifier: String; Params: TParameterList;
      var Value: Variant);
    procedure Functions1Click(Sender: TObject);
    procedure XQuery1Progress(Sender: TObject; Status: TXProgressStatus;
      Min, Max, Position: Integer);
    procedure Contents1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Howtobuy1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure SyntaxHighlighter1PosChange(Sender: TObject; Row,
      Col: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure XQuery1CancelRange(Sender: TObject; DataSet: TDataSet);
    procedure DISTINCTfield1Click(Sender: TObject);
    procedure DISTINCTaggregate1Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Multiplefields1Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure XQuery1SetRange(Sender: TObject;
      RelOperator: TRelationalOperator; DataSet: TDataSet;
      const FieldNames, StartValues, EndValues: String);
    procedure CREATETABLE1Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure CREATEINDEXstatement1Click(Sender: TObject);
    procedure XQuery1CreateIndex(Sender: TObject; Unique,
      Descending: Boolean; const TableName, IndexName: String;
      ColumnExprList: TStringList);
    procedure DROPTABLE1Click(Sender: TObject);
    procedure DROPINDEX1Click(Sender: TObject);
    procedure XQuery1DropTable(Sender: TObject; const TableName: String);
    procedure XQuery1DropIndex(Sender: TObject; const TableName,
      IndexName: String);
    procedure XQuery1IndexNeededFor(Sender: TObject; DataSet: TDataSet;
      const FieldNames: String; ActivateIndex: Boolean;
      var Accept: Boolean);
    procedure XQuery1CreateTable(Sender: TObject;
      CreateTable: TCreateTableItem);
    procedure TPEXAMPLE1Click(Sender: TObject);
    procedure TPExample2Click(Sender: TObject);
    procedure TPExample3Click(Sender: TObject);
    procedure MERGE1Click(Sender: TObject);
    procedure XQuery1SetFilter(Sender: TObject; DataSet: TDataSet;
      const Filter: String; var Handled: Boolean);
    procedure XQuery1CancelFilter(Sender: TObject; DataSet: TDataSet);
    procedure XQuery1SyntaxError(Sender: TObject; const ErrorMsg,
      OffendingText: String; LineNum, ColNum, TextLen: Integer);
    procedure Button12Click(Sender: TObject);
    procedure BtnQBuilderClick(Sender: TObject);
    procedure Sample14Click(Sender: TObject);
    procedure Sample24Click(Sender: TObject);
    procedure Sample33Click(Sender: TObject);
    procedure Saveresultsetastext1Click(Sender: TObject);
  private
    { Private declarations }
{$ifdef QUERYBUILDER}
    FOQBDialog : TOQBuilderDialog;
    FOQBxQuery: TOQBEnginexQry;
{$endif}
    {$IFNDEF LEVEL3}
     procedure PopupDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
     procedure PopupMeasureItem(Sender: TObject;
       ACanvas: TCanvas; var Width, Height: Integer);
    {$ENDIF}
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  DemoAb, DemoReg, xqyacc ;

const
   CrLf = #13#10;

(* Examples of SQL statements supported (some of them not useful at all but
   will show you the syntax supported)
*)
procedure TForm1.Button1Click(Sender: TObject);
begin
  XQuery1.Close;
  XQuery1.SQL.SetText(PChar(RichEdit1.Text));
  XQuery1.Filtered:= False;
  XQuery1.Open;
end;

procedure TForm1.BtnSelectClick(Sender: TObject);
var
  TmpPt: TPoint;
begin
  TmpPt := Panel1.ClientToScreen(Point(BtnSelect.Left,BtnSelect.Top + BtnSelect.Height));
  PopupMenu1.Popup( TmpPt.x, TmpPt.y );
end;

procedure TForm1.SingleSELECT1Click(Sender: TObject);
begin
  RichEdit1.Text:= '/* TXQuery dataset demo'+ CrLf+
                '    Version 1.50           */'+ CrLf +
                'SELECT * FROM Customer;'
end;

procedure TForm1.JOINsinSELECT1Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM Customer INNER JOIN Orders ON (Customer.CustNo = Orders.CustNo)'+
             ' INNER JOIN Items ON (Orders.OrderNo = Items.OrderNo)'+
             ' INNER JOIN Parts ON (Items.PartNo = Parts.PartNo);';
end;

procedure TForm1.AnotherJOIN1Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM Customer c INNER JOIN Orders o ON (c.CustNo = o.CustNo)'+
             ' INNER JOIN Items i ON (o.OrderNo = i.OrderNo)'+
             ' INNER JOIN Parts p ON (i.PartNo = p.PartNo);';
end;

procedure TForm1.JOINsinWHERE1Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM Customer c, Orders o, Items i, Parts p '+
             'WHERE (c.CustNo = o.CustNo) And (o.OrderNo = i.OrderNo) '+
             'And (i.PartNo = p.PartNo);';
end;

procedure TForm1.UsingIN1Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM customer WHERE City IN ('+
             '"Bogota", "Sarasota", "Freeport", "Tampa", "Somerset", "Honolulu");';
end;

procedure TForm1.UsingBETWEEN1Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT customer.* FROM customer WHERE LastInvoiceDate '+
             'BETWEEN #01/01/1990# AND #12/31/1994# ORDER BY customer.LastInvoiceDate';
end;

procedure TForm1.Sample11Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM Customer WHERE Company LIKE "%Under%";';
end;

procedure TForm1.Sample21Click(Sender: TObject);
begin
RichEdit1.Text:= 'SELECT * FROM Customer WHERE Company LIKE "%C_ub";';
end;

procedure TForm1.Sample31Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT * FROM Customer WHERE company LIKE ''A%Under%'';';
end;

procedure TForm1.AnotherSample1Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT * FROM Customer c, Orders o, Items i, Parts p '+
                'WHERE (c.CustNo = o.CustNo) And (o.OrderNo = i.OrderNo) '+
                'And (i.PartNo = p.PartNo) And (c.CustNo > 1300) And (c.CustNo < 2000);';
end;

procedure TForm1.Sample13Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT CustNo, Company, Addr1, Addr2 FROM customer ORDER BY custno DESC;';
end;

procedure TForm1.Sample23Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT CustNo, Company, Addr1, Addr2 FROM customer ORDER BY 2 DESC;';
end;

procedure TForm1.Sample32Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT CustNo, Company, City FROM Customer ORDER BY City, 2 DESC;';
end;

procedure TForm1.Sample12Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT * '+CrLf+
                'FROM Customer '+CrLf+
                'WHERE CustNo > (SELECT AVG(CustNo) FROM Customer);';
end;

procedure TForm1.Sample22Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT * FROM Customer WHERE custno >= '+
                'ALL (SELECT CustNo FROM customer WHERE '+
                '/* This is a comment inside SQL statement*/ City IN ("Freeport", "Christiansted", "Kailua-Kona", '+
                '"Giribaldi", "Kitchener", "Negril"));';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   XQuery1.Filter:= ComboBox1.Text;
   XQuery1.Filtered:= True;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   XQuery2.Close;
   XQuery2.SQL.SetText(PChar(RichEdit2.Text));
   XQuery2.Open;
end;

procedure TForm1.Somefunctions1Click(Sender: TObject);
begin
   RichEdit1.Text:= 'SELECT LOWER(TRIM(TRAILING "e" FROM company)) As TrimmedAndLowered, '+CrLf+
                '   EXTRACT(YEAR FROM LastInvoiceDate) As TheYear, '+CrLf+
                '   EXTRACT(MONTH FROM LastInvoiceDate) As TheMonth, '+CrLf+
                '   CAST(MINOF(LastInvoiceDate, NOW) AS DATETIME) As MinDate, '+CrLf+
                '   CAST(FORMATDATETIME("dd/mm/yy",MAXOF(LastInvoiceDate, NOW)) AS CHAR(20)) As MaxDate, '+CrLf+
                '   SUBSTRING(country FROM 2 FOR 6) As SubCountry, '+CrLf +
                '    /* same as */'+CrLf +
                '    COPY(country, 2, 6) As UsingCopy,'+CrLf +
                '    addr2,'+CrLf +
                '    LENGTH(addr2) > 0 As LenAddr2 '+CrLf +
                'FROM customer '+CrLf+
                'ORDER BY 2 DESC;';           
end;

procedure TForm1.XQuery1FunctionCheck(Sender: TObject;
  const Identifier: String; Params: TParameterList; var Accept: Boolean);
var
   i: Integer;
begin
   if AnsiCompareText(Identifier, 'DTOS') = 0 then
   begin
      Accept := True;
      Exit;
   end
   else if AnsiCompareText(Identifier, 'AVGOF') = 0 then
   begin
      if not( Assigned(Params) and (Params.Count > 1) ) then
      begin
         Accept:= False;
         Exit;
      end;
      {check that the function have only integers and float parameters}
      for i:= 0 to Params.Count - 1 do
      begin
         if not (Params.ExprType[i] in [ttFloat,ttInteger]) then
         begin
            Accept:= False;
            Exit;
         end;
      end;
   end
   else if AnsiCompareText(Identifier, 'TRIMDC') = 0 then
   begin
      {this function will trim all "$" and "," from a string
       and will return a float
       example of use SELECT TRIMDC("$10,000.45") FROM MyTable }
      if not( Assigned(Params) and (Params.Count = 1) ) then
      begin
         Accept:= False;
         Exit;
      end;
      {check that the function have only string parameters}
      if not (Params.ExprType[0] = ttString) then
      begin
         Accept:= False;
         Exit;
      end;
   end;
end;

procedure TForm1.XQuery1FunctionSolve(Sender: TObject;
  const Identifier: String; Params: TParameterList; var Value: Variant);
var
   i: Integer;
   Temp: Double;
   Temps, s: String;
begin
   if AnsiCompareText(Identifier, 'DTOS') = 0 then
   begin
      Value := '';
   end
   else if AnsiCompareText(Identifier, 'AVGOF') = 0 then
   begin
      Temp := Params.AsFloat[0];
      for I:= 1 to Params.Count - 1 do    // start from second param of function
         Temp := Temp + Params.AsFloat[i];
      Value := Temp / Params.Count;
   end else if AnsiCompareText(Identifier, 'TRIMDC')=0 then
   begin
      s:= Params.AsString[0];
      Temps:= '';
      for i:= 1 to Length(s) do
      begin
         if not (s[i] in ['$', ',']) then  // discard "$" and ","
            Temps:= Temps + s[i];
      end;
      Value := StrToFloat(Temps);
   end;
end;

procedure TForm1.Functions1Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text:= 'SELECT itemstotal, amountpaid, freight, '+CrLf +
                ''+CrLf +
                '    /* AVGOF() is a function solved in events'+CrLf +
                '       OnFunctionCheck and OnFunctionSolve and'+CrLf +
                '       defined in property ExFunctions      */'+CrLf +
                ''+CrLf +
                '    AVGOF(itemstotal, amountpaid, freight) As Average '+CrLf +
                'FROM orders; ';
end;

procedure TForm1.XQuery1Progress(Sender: TObject; Status: TXProgressStatus;
  Min, Max, Position: Integer);
begin
   case Status of
      psXStart:
         begin
            if (Min=0) or (Max = 0) then Exit;
            Bar1.Visible:= True;
            Bar1.Min:= Min;
            Bar1.Max:= Max;
            Bar1.Position:= Position;
         end;
      psXProgress:
         begin
         if Position=0 then Exit;
         Bar1.Position:= Position;
         end;
      psXEnd:
         begin
            Bar1.Visible:= False;
         end;
   end;
end;

procedure TForm1.Contents1Click(Sender: TObject);
begin
   Application.HelpCommand( HELP_CONTENTS, 0 );
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Application.HelpFile := ExtractFilePath(Application.ExeName) + 'txquery.hlp';
   ComboBox1.ItemIndex:= 0;
   {$IFNDEF LEVEL3}
   PopupMenu2.OwnerDraw:= True;
   {$ELSE}
   Button5.Visible:= False;
   {$ENDIF}

end;

procedure TForm1.About1Click(Sender: TObject);
begin
   with TfrmAbout.Create(Application) do
   begin
      try
         ShowModal;
      finally
         Free;
      end;
   end;
end;

procedure TForm1.Howtobuy1Click(Sender: TObject);
begin
   with TfrmRegister.Create(Application) do
   begin
      try
         ShowModal;
      finally
         Free;
      end;
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   Application.HelpCommand( HELP_QUIT, 0 );
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
var sql:String;
begin
   if PageControl1.ActivePage = TabSheet2 then
   begin
      XQuery1.Close;
      XQuery1.Filtered:= False;
      sql:= '/* demo with filtering */ SELECT * FROM Customer';
      XQuery1.SQL.SetText(PChar(sql));
      XQuery1.Open;
   end else if PageControl1.ActivePage = TabSheet1 then
      SyntaxHighlighter1.Editor:=RichEdit1
   else if PageControl1.ActivePage = TabSheet3 then
      SyntaxHighlighter1.Editor:=RichEdit2
   else if PageControl1.ActivePage = TabSheet4 then
      SyntaxHighlighter1.Editor:=RichEdit3
   else if PageControl1.ActivePage = TabSheet5 then
      SyntaxHighlighter1.Editor:=RichEdit4;
   if not(PageControl1.ActivePage = TabSheet5) then
      XQuery4.Close;
end;

procedure TForm1.SyntaxHighlighter1PosChange(Sender: TObject; Row,
  Col: Integer);
begin
StatusBar1.SimpleText:= Format('Row: %d Col: %d',[Row,Col]);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$ifndef BCB}
SyntaxHighlighter1.EditColorSet;
{$endif}
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  TmpPt: TPoint;
  Item: TMenuItem;
  ColorElement: PColorElement;
  I: Integer;
  G: TElementGroup;
begin
  TmpPt := Panel1.ClientToScreen(Point(Button5.Left,Button5.Top + Button5.Height));
  for I:= 0 to PopupMenu2.Items.Count - 1 do
      PopupMenu2.Items.Delete(0);

  for G:= Low(TElementGroup) to High(TElementGroup) do
  begin
     for I:= 0 to SyntaxHighlighter1.ColorConfig.ColorSettings.Count - 1 do
     begin
        ColorElement:= PColorElement(SyntaxHighlighter1.ColorConfig.ColorSettings[I]);
        if ColorElement^.Group=G then
        begin
           Item:= TMenuItem.Create(Self);
           {$IFNDEF LEVEL3}
           Item.OnDrawItem:= PopupDrawItem;  // Delphi 3 cannot owner draw in menus
           Item.OnMeasureItem:=PopupMeasureItem;
           {$ENDIF}
           Item.Tag:= I;
           case ColorElement^.Group of
              idWhiteSpace:   Item.Caption:= 'WhiteSpace';
              idComment:      Item.Caption:= 'Comment';
              idReservedWord: Item.Caption:= 'ReservedWord';
              idIdentifier:   Item.Caption:= 'Identifier';
              idTable:        Item.Caption:= 'Dataset';
              idField:        Item.Caption:= 'Field';
              idString:       Item.Caption:= 'String';
              idNumber:       Item.Caption:= 'Number';
              idComma:        Item.Caption:= 'Comma';
              idParenthesis:  Item.Caption:= 'Parenthesis';
              idOperator:     Item.Caption:= 'Operator';
              idSemicolon:    Item.Caption:= 'Semicolon';
              idPeriod:       Item.Caption:= 'Period';
           end;
           PopupMenu2.Items.Add(Item);
        end;
     end;
  end;
  PopupMenu2.Popup( TmpPt.x, TmpPt.y );
end;

{$IFNDEF LEVEL3}
procedure TForm1.PopupDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
var
   s:String;
   TmpRect:TRect;
   ColorElement: PColorElement;
begin
   with ACanvas do
   begin
      FillRect(ARect);
      s:=(Sender as TMenuItem).Caption;
      ReplaceString(s,'&','');
      TmpRect:=ARect;
      TmpRect.Left:=TextWidth('X')*2;
      //TextOut(TmpRect.Left, TmpRect.Top, (Sender as TMenuItem).Caption);
      DrawText(Handle,pchar(s),-1,TmpRect,DT_SINGLELINE Or DT_LEFT or DT_VCENTER);
      ColorElement:= PColorElement(SyntaxHighlighter1.ColorConfig.ColorSettings[(Sender as TMenuItem).Tag]);
      TmpRect:=ARect;
      TmpRect.Right:=TextWidth('X')*2-1;
      InflateRect(TmpRect,-2,-2);
      Brush.Color:= ColorElement^.ForeColor;
      FillRect(TmpRect);
   end;
end;

procedure TForm1.PopupMeasureItem(Sender: TObject;
  ACanvas: TCanvas; var Width, Height: Integer);
begin
   with ACanvas do
   begin
      Height:=TextHeight('0')+2;
      Width:= TextWidth('X')*13+2;
   end;
end;
{$ENDIF}

procedure TForm1.Button6Click(Sender: TObject);
begin
   XQuery1.Find(Edit1.Text);
end;

procedure TForm1.XQuery1CancelRange(Sender: TObject; DataSet: TDataSet);
begin
   (DataSet as TTable).CancelRange;       // if a range was set
   (DataSet as TTable).Filtered:= False;  // if was filtered
end;

procedure TForm1.DISTINCTfield1Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text:= 'SELECT DISTINCT Country FROM Customer ORDER BY Country;'
end;

procedure TForm1.DISTINCTaggregate1Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text:= 'SELECT COUNT(DISTINCT Country) FROM Customer;'
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  if XQuery3.ParamCount = 0 then
  begin
     XQuery3.Params.CreateParam(ftInteger, 'LOWRANGE', ptUnknown);
     XQuery3.Params.CreateParam(ftInteger, 'HIGHRANGE', ptUnknown);
  end;
  XQuery3.Close;
  XQuery3.ParamByName('LOWRANGE').AsInteger:= StrToInt(Edit2.Text);
  XQuery3.ParamByName('HIGHRANGE').AsInteger:= StrToInt(Edit3.Text);
  XQuery3.Open;
end;

procedure TForm1.Multiplefields1Click(Sender: TObject);
begin
RichEdit1.Text:= '/* Not useful query, only to illustrate multiple fields joining */ ' +
   'SELECT * FROM Customer c INNER JOIN Orders o ON (c.CustNo = o.CustNo) AND '+
   ' (c.CustNo = o.CustNo) AND (c.CustNo = o.CustNo) '+
   ' INNER JOIN Items i ON (o.OrderNo = i.OrderNo);';
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
   if xQuery4.ParamCount = 0 then
      xQuery4.Params.CreateParam(ftFloat, 'CustNo', ptUnknown);
   xQuery4.Close;
   xQuery4.Open;
end;

procedure TForm1.XQuery1SetRange(Sender: TObject;
  RelOperator: TRelationalOperator; DataSet: TDataSet; const FieldNames,
  StartValues, EndValues: String);
var
   F: TField;
begin
   if RelOperator = ropBETWEEN then            
   begin
      // Warning: this will fail with multiple fields "OrderNo;ItemNo"
      with DataSet as TTable do
      begin
         SetRangeStart;
         FieldByName(FieldNames).AsString := StartValues;
         SetRangeEnd;
         FieldByName(FieldNames).AsString := EndValues;
         ApplyRange;
      end;
   end else if RelOperator in [ropGT, ropGE, ropLT, ropLE, ropNEQ] then
   begin
      // instead, will use a filter
      with DataSet as TTable do
      begin
         F:= FindField(FieldNames);
         case F.DataType of
            ftString{$IFDEF LEVEL4},ftFixedChar,ftWideString{$ENDIF} :
               begin
                  case RelOperator of
                     ropGT:  Filter := Format('%s > ''%s''',  [FieldNames, StartValues]);
                     ropGE:  Filter := Format('%s >= ''%s''', [FieldNames, StartValues]);
                     ropLT:  Filter := Format('%s < ''%s''',  [FieldNames, StartValues]);
                     ropLE:  Filter := Format('%s <= ''%s''', [FieldNames, StartValues]);
                     ropNEQ: Filter := Format('%s <> ''%s''', [FieldNames, StartValues]);
                  end;
                  Filtered:= True;
               end;
            ftFloat,ftCurrency,ftBCD,ftDate,ftTime,ftDateTime,
            ftAutoInc,ftSmallInt,ftInteger,ftWord
            {$ifndef LEVEL3},ftLargeInt{$endif}, ftBoolean:
               begin
                  case RelOperator of
                     ropGT:  Filter := Format('%s > %s',  [FieldNames, StartValues]);
                     ropGE:  Filter := Format('%s >= %s', [FieldNames, StartValues]);
                     ropLT:  Filter := Format('%s < %s',  [FieldNames, StartValues]);
                     ropLE:  Filter := Format('%s <= %s', [FieldNames, StartValues]);
                     ropNEQ: Filter := Format('%s <> %s', [FieldNames, StartValues]);
                  end;
                  Filtered:= True;
               end;
         end;
      end;
   end;
end;

procedure TForm1.CREATETABLE1Click(Sender: TObject);
var
  S: String;
begin
  S:= 'CREATE TABLE "MyDatabase.Dbf"' + CrLf +
      '(' + CrLf +
      '      last_name   CHAR(30),' + CrLf +
      '      first_name  CHAR(40),' + CrLf +
      '      salary      FLOAT(20,2),' + CrLf +
      '      zip_code    CHAR(15),' + CrLf +
      '      work_phone  CHAR(30),' + CrLf +
      '      home_phone  CHAR(30),' + CrLf +
      '      f1          FLOAT,' + CrLf +
      '      f2          FLOAT(15),'+ CrLf +
      '      i1          SMALLINT,'+ CrLf +
      '      i2          INTEGER,'+ CrLf +
      '      B1          BOOLEAN,'+ CrLf +
      '      D1          DATE,'+ CrLf +
      '      D2          TIME,'+ CrLf +
      '      D3          DATETIME,'+ CrLf +
      '      CUSTNO      AUTOINC,'+ CrLf +
      '      M           MONEY,'+ CrLf +
      '      photo       BLOB(5)' + CrLf +
      '                          ' + CrLf +
      '      PRIMARY KEY (last_name, first_name)      ' + CrLf +
      ')' + CrLf + CrLf +
      'CREATE TABLE "Table2.Dbf"' + CrLf +
      '(' + CrLf +
      '      last_name   CHAR(30),' + CrLf +
      '      first_name  CHAR(40),' + CrLf +
      '      salary      FLOAT(20,2)' + CrLf +
      ')' + CrLf +
      ';'
      ;
  RichEdit1.Text:= s;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  XQuery1.Close;
  XQuery1.SQL.SetText(PChar(RichEdit1.Text));
  XQuery1.Filtered:= False;
  XQuery1.ExecSQL;
end;

procedure TForm1.Button10Click(Sender: TObject);
var
  TmpPt: TPoint;
begin
  TmpPt := Panel1.ClientToScreen(Point(Button10.Left,Button10.Top + Button10.Height));
  PopupMenu3.Popup( TmpPt.x, TmpPt.y );
end;

procedure TForm1.CREATEINDEXstatement1Click(Sender: TObject);
var
  S: String;
begin
  S:= 'CREATE UNIQUE DESC INDEX custdate ON "Table1.DBF" (first_name, last_name); ' ;
  RichEdit1.Text:= s;
end;

procedure TForm1.XQuery1CreateIndex(Sender: TObject; Unique,
  Descending: Boolean; const TableName, IndexName: String;
  ColumnExprList: TStringList);
var
  S, Temps: String;
  I: Integer;
begin                
  S:= 'Requested to create an index on table : ' + TableName + CrLf +
      'Index name on this table : ' + IndexName + CrLf;
  if Unique then Temps := 'Index Unique ' else Temps := 'Duplicates allowed ';
  S := S + Temps + CrLf;
  if Descending then Temps:= 'Sort descending ' else Temps:= 'Sort ascending';
  S := S + Temps + CrLf +
       'Columns expressions to index on :'+CrLf;
  for I:= 0 to ColumnExprList.Count - 1 do
     S := S + ColumnExprList[I] + CrLf;
  ShowMessage(S);
end;

procedure TForm1.DROPTABLE1Click(Sender: TObject);
begin
RichEdit1.Text:= 'DROP TABLE "table1.dbf" ;';
end;

procedure TForm1.DROPINDEX1Click(Sender: TObject);
begin
RichEdit1.Text:= 'DROP INDEX "table1.dbf" primaryindex ;';
end;

procedure TForm1.XQuery1DropTable(Sender: TObject;
  const TableName: String);
begin
ShowMessage('Requested to drop table ' + TableName);
end;

procedure TForm1.XQuery1DropIndex(Sender: TObject; const TableName,
  IndexName: String);
begin
ShowMessage('Requested to drop index ' + IndexName + ' on table ' + TableName);
end;

procedure TForm1.XQuery1IndexNeededFor(Sender: TObject; DataSet: TDataSet;
  const FieldNames: String; ActivateIndex: Boolean; var Accept: Boolean);
begin
   if DataSet = Table1 then
   begin
      Accept:= (AnsiCompareText(FieldNames,'CustNo') = 0)
               //or (AnsiCompareText(FieldNames,'Company') = 0)
               ;
   end else if DataSet = Table2 then
   begin
      Accept:= (AnsiCompareText(FieldNames,'CustNo') = 0) or
               (AnsiCompareText(FieldNames,'OrderNo') = 0);
   end else if DataSet = Table3 then
   begin
      Accept:= (AnsiCompareText(FieldNames,'OrderNo') = 0) or
               (AnsiCompareText(FieldNames,'OrderNo;ItemNo') = 0) or
               (AnsiCompareText(FieldNames,'PartNo') = 0);
   end else if DataSet = Table4 then
   begin
      Accept:= (AnsiCompareText(FieldNames,'PartNo') = 0) or
               (AnsiCompareText(FieldNames,'Description') = 0) or
               (AnsiCompareText(FieldNames,'VendorNo') = 0);
   end;
   if Accept and ActivateIndex then
      (DataSet as TTable).IndexFieldNames:= FieldNames;
end;

procedure TForm1.XQuery1CreateTable(Sender: TObject;
  CreateTable: TCreateTableItem);
var
   S, BlobType: String;
   I: Integer;
{$IFDEF USE_DBF_ENGINE}
   FieldList: TStringList;
   FileName, FieldName, IndexFileName: String;
   FieldType: Char;
   FieldSize, FieldDec: Integer;
   Halc: THalcyonDataSet;
{$ENDIF}
begin
   S:= 'SQL statement issued:' + CrLf +
       xQuery1.SQL.Text + CrLf;
   ShowMessage(S);

   S:= 'Analisis of CREATE TABLE statement:' + CrLf +
       Format('CREATE TABLE requested on table "%s"',[CreateTable.TableName]) + CrLf +
       Format('Number of fields to create : %d',[CreateTable.FieldCount]) + CrLf;
   for I:= 0 to CreateTable.FieldCount - 1 do
   begin
      S:= S + Format('"%s" ',[CreateTable.Fields[I].FieldName]);
      case CreateTable.Fields[I].FieldType of
         // list of possible types accepted in TxQuery parser
         RW_CHAR     :
            // use Size property here
            S:= S + Format('type CHAR of Length %d',[CreateTable.Fields[I].Size]) + CrLf;
         RW_INTEGER  :
            S:= S + 'type INTEGER' + CrLf;
         RW_SMALLINT :
            S:= S + 'type SMALLINT' + CrLf;
         RW_BOOLEAN  :
            S:= S + 'type BOOLEAN' + CrLf;
         RW_DATE     :
            S:= S + 'type DATE' + CrLf;
         RW_TIME     :
            S:= S + 'type TIME' + CrLf;
         RW_DATETIME :
            S:= S + 'type DATETIME' + CrLf;
         RW_MONEY    :
            S:= S + 'type MONEY' + CrLf;
         RW_FLOAT    :
            // use Scale and Precision properties here
            S:= S + Format('type FLOAT Scale %d Precision %d',[CreateTable.Fields[I].Scale, CreateTable.Fields[I].Precision]) + CrLf;
         RW_AUTOINC  :
            S:= S + 'type AUTOINC' + CrLf;
         RW_BLOB     :
            begin
            // use BlobType property here
            case CreateTable.Fields[I].BlobType of
               1: BlobType:= 'Memo';
               2: BlobType:= 'Binary';
               3: BlobType:= 'Formatted Memo';
               4: BlobType:= 'OLE';
               5: BlobType:= 'Graphic/Binary';
            end;
            S:= S + Format('is a BLOB of type %s',[BlobType]) + CrLf;
            end;
      end;
   end;
   S:= S + CrLf +
       'SORT ORDER:' + CrLf;
   if CreateTable.PrimaryKey.Count=0 then
      S:= S + 'NONE'
   else
   begin
      for I:= 0 to CreateTable.PrimaryKey.Count - 1 do
         S := S + CreateTable.PrimaryKey[I] + CrLf;
   end;

   ShowMessage( S );

   // A working example with Halcyon
{$IFDEF USE_DBF_ENGINE}
   FieldList:= TStringList.Create;
   try
     for I:= 0 to CreateTable.FieldCount - 1 do
     begin
        FieldName:= CreateTable.Fields[I].FieldName;
        case CreateTable.Fields[I].FieldType of
           // list of possible types accepted in TxQuery parser
           RW_CHAR     :
              begin
                 FieldType:= 'C';
                 FieldSize:= CreateTable.Fields[I].Size;
                 FieldDec := 0;
              end;
           RW_INTEGER, RW_AUTOINC  :
              begin
                 FieldType:= 'N';
                 FieldSize:= 11;
                 FieldDec := 0;
              end;
           RW_SMALLINT :
              begin
                 FieldType:= 'N';
                 FieldSize:= 6;
                 FieldDec := 0;
              end;
           RW_BOOLEAN  :
              begin
                 FieldType:= 'L';
                 FieldSize:= 1;
                 FieldDec := 0;
              end;
           RW_DATE, RW_TIME, RW_DATETIME :
              begin
                 FieldType:= 'D';
                 FieldSize:= 10;
                 FieldDec := 0;
              end;
           RW_MONEY, RW_FLOAT    :
              begin
                 FieldType:= 'N';
                 if CreateTable.Fields[I].Scale= 0 then
                 begin
                   FieldSize:= 20;
                   FieldDec := 4;
                 end else
                 begin
                   FieldSize:= CreateTable.Fields[I].Scale;
                   FieldDec := CreateTable.Fields[I].Precision;
                 end;
              end;
           RW_BLOB     :
              begin
              // use BlobType property here
              case CreateTable.Fields[I].BlobType of
                 1, 3: // Memo, Formatted Memo
                   FieldType:= 'M';
                 2,4 : // Binary, OLE
                   FieldType:= 'B';
                 5:  // Graphic/Binary
                   FieldType:= 'G';
              end;
              FieldSize:= 8;
              FieldDec:= 0;
              end;
        end;
        FieldList.Add(Format('%s;%s;%d;%d',[FieldName,FieldType,FieldSize,FieldDec]));
     end;
     FileName:= CreateTable.TableName;
     gs6_shel.CreateDBF( FileName, '', FoxPro2, FieldList);  // change FoxPro2 to your choice
     if CreateTable.PrimaryKey.Count > 0 then
     begin
       s:= CreateTable.PrimaryKey[0];
       for I:= 1 to CreateTable.PrimaryKey.Count - 1 do
            S:= S + '+' + CreateTable.PrimaryKey[I];
       Halc:= THalcyonDataSet.Create(nil);
       try
          Halc.DatabaseName:= ExtractFilePath(FileName);
          Halc.TableName:= ExtractFileName(FileName);
          Halc.Open;
          IndexFileName:= ChangeFileExt(FileName, '.cdx');
          Halc.IndexOn(IndexFileName, 'PRIMARY', S, '.NOT.DELETED()',  // optionl
             Halcn6DB.Unique, Halcn6DB.Ascending);
       finally
          Halc.Free;
       end;
     end;
     ShowMessage(Format('Table %s was successful created',[FileName]));

   finally
     FieldList.Free;
   end;
{$ENDIF}
end;

procedure TForm1.TPEXAMPLE1Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text := '/* This is a TRANSFORM...PIVOT demo ala Microsoft Access */' + CRLF +
                     'TRANSFORM CAST(SUM(AmountPaid) AS MONEY) SELECT CUSTNO FROM ORDERS GROUP BY CUSTNO ' + CRLF +
                     'PIVOT FormatDateTime("yyyy", SALEDATE);';
end;

procedure TForm1.TPExample2Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text := 'TRANSFORM SUM(AmountPaid) SELECT CUSTNO FROM ORDERS GROUP BY CUSTNO ' + CRLF +
                     'PIVOT FormatDateTime("yyyy", SALEDATE) IN ("1988", "1992", ''1993'', "1995", "1996");';
end;

procedure TForm1.TPExample3Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text := 'TRANSFORM CAST(SUM(AmountPaid) AS MONEY) SELECT CUSTNO FROM ORDERS GROUP BY CUSTNO ' + CRLF +
                     'PIVOT FormatDateTime("mmm", SALEDATE) IN ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", '+
                     '"Oct", "Nov", "Dec");';
end;                 

procedure TForm1.MERGE1Click(Sender: TObject);
begin
   Table1.First;
   RichEdit1.Text := '/* MERGE is customer requested command (not part of SQL) ' + CRLF +
                     ' syntax is: MERGE select_statement1 WITH select_statement2 ' + CRLF +
                     ' You can also combine different tables but they must have compatible column types */' + CRLF +
                     'MERGE SELECT * FROM customer WHERE custno BETWEEN 1000 AND 2500; ' + CRLF +
                     'WITH  SELECT * FROM customer WHERE custno BETWEEN 2000 AND 3000;';
end;

procedure TForm1.XQuery1SetFilter(Sender: TObject; DataSet: TDataSet;
  const Filter: String; var Handled: Boolean);
begin
   { Note: in this case, filters now needed, they are set in OnSetRange
     this is only to illustrate how to }
   //ShowMessage(Filter);
   { can this filter be set ?}

   {try
      (DataSet as TTable).Filtered := False;
      (DataSet as TTable).Filter   := Filter;
      (DataSet as TTable).Filtered := True;
      Handled := True;
   except
      Handled := False;
      (DataSet as TTable).Filtered := False;
   end; }

end;

procedure TForm1.XQuery1CancelFilter(Sender: TObject; DataSet: TDataSet);
begin

   {(DataSet as TTable).Filtered := False;
    (DataSet as TTable).Filter := '';}

end;

procedure TForm1.XQuery1SyntaxError(Sender: TObject; const ErrorMsg,
  OffendingText: String; LineNum, ColNum, TextLen: Integer);
var
  i, NumChars: Integer;
begin
  ShowMessage(ErrorMsg + ' at or before ' + OffendingText +
     Format(' Line %d, Column %d',[LineNum, ColNum]) );
  { Will not show or use ErrorMsg parameter }
  NumChars := 0;
  i := 0;
  while i < LineNum - 1 do
  begin
     Inc(NumChars, Length(RichEdit1.Lines[i]) + 2);
     Inc(i);
  end;
  RichEdit1.SelStart  := NumChars + ColNum;
  RichEdit1.SelLength := TextLen;
  RichEdit1.SetFocus;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
   if not xQuery1.Active then Exit;
end;

procedure TForm1.BtnQBuilderClick(Sender: TObject);
begin
{$ifdef QUERYBUILDER}
  if not Assigned(FOQBDialog) then
  begin
     FOQBDialog := TOQBuilderDialog.Create(Self);
     FOQBxQuery := TOQBEnginexQry.Create(Self);
     FOQBxQuery.xQuery := xQuery1;
     FOQBxQuery.UseTableAliases := True;
     FOQBDialog.OQBEngine := FOQBxQuery;
  end;
  if FOQBDialog.Execute then
    RichEdit1.Lines.Text := FOQBDialog.SQL.Text;
{$else}
  ShowMessage('If you want to use the query builder option,' + CrLf +
              'You must download the software from this URL : '+CrLf+
              'http://www.geocities.com/SiliconValley/Way/9006/index.html'+CrLf+
              'After downloading see help file for details searching for:'+CrLf+
              '"Query builder"' + CrLf+
              'After that, enable optional compilation switch QUERYBUILDER on' + CrLf+
              'top of this form');
{$endif}
end;

procedure TForm1.Sample14Click(Sender: TObject);
begin
  RichEdit1.Text:= 'SELECT c.CustNo, CAST(Sum(AmountPaid) AS MONEY) As SumAmount, CAST(Avg(AmountPaid) AS MONEY), CAST(Min(AmountPaid) AS MONEY), ' +
        'Count(*) FROM Customer c, Orders o WHERE (c.CustNo = o.CustNo) ' +
        'GROUP BY c.CustNo HAVING Sum(AmountPaid) > 80000;';
end;

procedure TForm1.Sample24Click(Sender: TObject);
begin
   RichEdit1.Text := 'SELECT CUSTNO, SUM(AMOUNTPAID) / SUM(ITEMSTOTAL) As Rate ' + CrLf +
                     'FROM ORDERS GROUP BY CUSTNO;';
end;

procedure TForm1.Sample33Click(Sender: TObject);
begin
   RichEdit1.Text := 'SELECT CAST(SUM(ItemsTotal) / COUNT(CustNo) AS MONEY) ' + CrLf +
                     'FROM ORDERS;';
end;

procedure TForm1.Saveresultsetastext1Click(Sender: TObject);
var
   FieldNames: TStringList;
begin
   if not xQuery1.Active or not SaveDialog1.Execute then exit;
   FieldNames := TStringList.Create;
   try
     xqbase.WriteToTextFile(xQuery1,                 // dataset to save
                             SaveDialog1.FileName,   // save to this file
                             '"',                    // field delim character
                             ',',                    // text separator
                             False,                  // true = CSV format, false = text only
                             FieldNames);            // empty = all fields
   finally
      FieldNames.Free;
   end;
end;

end.

