/*
	This simple extension of the java.awt.Frame class
	contains all the elements necessary to act as the
	main window of an application.
 */

import java.awt.*;
import cprot.make.*;


public class TheApp extends Frame
{
	public TheApp()
	{
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		
		//{{INIT_CONTROLS
		setLayout(null);
		setSize(405,305);
		setVisible(false);
		sernumtext.setText("Enter your serial number");
		add(sernumtext);
		sernumtext.setBounds(48,48,156,24);
		add(serialnumber);
		serialnumber.setFont(new Font("Dialog", Font.BOLD, 16));
		serialnumber.setBounds(216,48,144,27);
		featuretext.setText("and the feature code (1 - 15)");
		add(featuretext);
		featuretext.setBounds(48,108,156,24);
		featurecode.setText("1");
		add(featurecode);
		featurecode.setFont(new Font("Dialog", Font.BOLD, 16));
		featurecode.setBounds(216,108,36,24);
		generate.setLabel("Create code!");
		add(generate);
		generate.setBackground(java.awt.Color.lightGray);
		generate.setFont(new Font("Dialog", Font.BOLD, 12));
		generate.setBounds(120,180,144,28);
		regcode.setEditable(false);
		regcode.setEnabled(false);
		add(regcode);
		regcode.setBackground(java.awt.Color.yellow);
		regcode.setFont(new Font("Dialog", Font.BOLD, 16));
		regcode.setBounds(216,240,144,24);
		regcodetext.setText("Your registration code:");
		add(regcodetext);
		regcodetext.setBounds(48,240,149,23);
		setTitle("AWT Application");
		//}}
		
		//{{INIT_MENUS
		menu1.setLabel("File");
		menu1.add(exitMenuItem);
		exitMenuItem.setLabel("Exit");
		mainMenuBar.add(menu1);
		menu3.setLabel("Help");
		menu3.add(aboutMenuItem);
		aboutMenuItem.setLabel("About...");
		mainMenuBar.add(menu3);
		//$$ mainMenuBar.move(0,312);
		setMenuBar(mainMenuBar);
		//}}
		
		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		exitMenuItem.addActionListener(lSymAction);
		aboutMenuItem.addActionListener(lSymAction);
		SymMouse aSymMouse = new SymMouse();
		generate.addMouseListener(aSymMouse);
		//}}
	}
	
	public TheApp(String title)
	{
		this();
		setTitle(title);
	}
	
    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	static public void main(String args[])
	{
		try
		{
			//Create a new instance of our application's frame, and make it visible.
    		(new TheApp()).setVisible(true);
		}
		catch (Throwable t)
		{
			System.err.println(t);
			t.printStackTrace();
			//Ensure the application exits with an error condition.
			System.exit(1);
		}
	}
	
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	
	//{{DECLARE_CONTROLS
	java.awt.Label sernumtext = new java.awt.Label();
	java.awt.TextField serialnumber = new java.awt.TextField();
	java.awt.Label featuretext = new java.awt.Label();
	java.awt.TextField featurecode = new java.awt.TextField();
	java.awt.Button generate = new java.awt.Button();
	java.awt.TextField regcode = new java.awt.TextField();
	java.awt.Label regcodetext = new java.awt.Label();
	//}}
	
	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar = new java.awt.MenuBar();
	java.awt.Menu menu1 = new java.awt.Menu();
	java.awt.MenuItem exitMenuItem = new java.awt.MenuItem();
	java.awt.Menu menu3 = new java.awt.Menu();
	java.awt.MenuItem aboutMenuItem = new java.awt.MenuItem();
	//}}
	
	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == TheApp.this)
				TheApp_WindowClosing(event);
		}
	}
	
	void TheApp_WindowClosing(java.awt.event.WindowEvent event)
	{
		// to do: code goes here.
			 
		TheApp_WindowClosing_Interaction1(event);
	}


	void TheApp_WindowClosing_Interaction1(java.awt.event.WindowEvent event)
	{
		try {
			// QuitDialog Create and show as modal
			(new QuitDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}

	
	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == aboutMenuItem)
				aboutMenuItem_ActionPerformed(event);
			else if (object == exitMenuItem)
				exitMenuItem_ActionPerformed(event);
		}
	}


	void aboutMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		aboutMenuItem_ActionPerformed_Interaction1(event);
	}


	void aboutMenuItem_ActionPerformed_Interaction1(java.awt.event.ActionEvent event)
	{
		try {
			// AboutDialog Create and show as modal
			(new AboutDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}
	
	
	void exitMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		exitMenuItem_ActionPerformed_Interaction1(event);
	}


	void exitMenuItem_ActionPerformed_Interaction1(java.awt.event.ActionEvent event)
	{
		try {
			// QuitDialog Create and show as modal
		    (new QuitDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}


	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mouseReleased(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == generate)
				generate_MouseReleased(event);
		}
	}

	void generate_MouseReleased(java.awt.event.MouseEvent event)
	{
		generate_MouseReleased_Interaction1(event);
	}

	void generate_MouseReleased_Interaction1(java.awt.event.MouseEvent event)
	{
        Integer fcode = new Integer(featurecode.getText());
        int fc = fcode.intValue();
        String sn = new String(serialnumber.getText());
        String ms = new String();
        boolean ok = false;
        if( fc < 1 || fc > 15 ) 
            ms.concat("Featurecode error");
        else if( sn.length() != 14 ) 
            ms.concat("Sernumber error");
        else
            ok = true;
        if(ok){
            Generator cg = new Generator( fc, sn);
		    try {
                regcode.setText(cg.makeCode());
	    	} catch (Exception e) {
		    }
		}
		else {
		    try {
                regcode.setText(ms);
	    	} catch (Exception e) {
		    }
        }		    
	}
}

