/*
 */

%{

#include <stdarg.h>
#include <stdio.h>

void yyerror(const char * string)
{
	fprintf(stderr, "%s\n", string);
}

int yylex(void)
{
	int token;
	static int first = 1;
	if (first) {
		first = 0;
		token = ' ';
	} else {
		token = 0;
	}
	return token;
}

/* the grammar rule actions may appear as if inside the following function */
static void rule_actions() { }

%}

%%

grammar
	: symbol
	;

symbol
	: ' '
		{ if (1) printf("action 1\n"); }
	| '\n'
		{ if (1) printf("action 2\n"); }
	;

%%

int main()
{
	return yyparse();
}

/* prevent #line from associating more code with main */
static void extra() { }
