/***********************************************************************
 * $Id: which.c,v 1.6 1998/08/18 18:55:49 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *    which -- display full pathname for executable command
 *
 * Usage
 *    which [-a] command ...
 *
 * Private Functions
 *    command_exist	- check for an executable
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

/*========== Private Functions =======================================*/

int command_exist(char * dir, char * command)
{
	struct stat stat_buf;
	char buf[1024];
	strcpy(buf, dir);
	strcat(buf, "/");
	strcat(buf, command);
	return (stat(buf, &stat_buf) == 0);
}

/*========== Main ====================================================*/

int main(int argc, char * * argv)
{
	int status = 1;
	char * path = getenv("PATH");
	if (path != 0) {
		int argv_i;
		for (argv_i = 1; argv_i < argc; argv_i++) {
			unsigned path_i;
			unsigned dir_i = 0;
			char dir[1024];

			dir[0] = '\0';
			for (path_i = 0; path[path_i] != '\0'; path_i++) {
				if (path[path_i] == ':') {
					if (command_exist(dir, argv[argv_i])) {
						printf("%s/%s\n", dir, argv[argv_i]);
						status = 0;
						break;
					}
					dir_i = 0;
				} else {
					dir[dir_i++] = path[path_i];
				}
				dir[dir_i] = '\0';
			}
			/* If end of PATH reached */
			if (path[path_i] == '\0') {
				if (command_exist(dir, argv[argv_i])) {
					printf("%s/%s\n", dir, argv[argv_i]);
					status = 0;
				}
			}
		}
	}
	return status;
}
