/* Copyright (c) Bullseye Testing Technology */


#include "fgq.h"
#include "pngnFinwx.h"
#include "gxCtncu.h"
#include "rxfFltgcz.h"
#include "gxNIbpgrethcb.h"

#if _DEBUG
#include "fxGtrcg.h"
static Z aa[]={
Z(h::ac,__FILE__),
Z(h::ac,Hv::ac),
Z(h::ac,I4::ac),
};
void h::ac()
{
h KA;
#if !SYS_UNIX
{
char p[PATH_MAX];
X R=sizeof(KA);
vx::KB(p,&R);
KA=p;
}
#endif


h(".").chdir();
bool V=0;
try{
h("none-123").chdir();
}
catch (const aS&zi){
assert(zi.aU().v(
"File system error: none-123: set current directory failure"
": No such file or directory"));
V=1;
}
assert(V);


{
const h O="pkgPath.tmp";
fclose(fopen(O,"w"));


O.chmod(0);
#if !SYS_UNIX
assert(::remove(O)!=0);
assert(errno==EACCES);
#endif

O.chmod(KC|read|write);
assert(::remove(O)==0);
}


assert(KD("","",0));
assert(KD("","a",-1));
assert(KD("/","/a",-1));
assert(KD("//","//",0));
assert(KD("a","a",0));
assert(KD("a","a/",-1));
assert(KD("a","aa",-1));
assert(KD("a","b",-1));
assert(KD("a/","a//",0));
assert(KD("a/a","a//a",0));
assert(KD("aa","aa",0));
assert(KD("aa","ab",-1));
#if SYS_UNIX
assert(KD("a","A",'a' -'A'));
assert(KD("/","\\",'/' -'\\'));
assert(KD("/a/b","//a/b",0));
#else
assert(KD("a","A",0));
assert(KD("/","\\",0));

assert(KD("/a/b","//a/b",'a' -'/'));
assert(KD("/a/b","///a/b",0));
assert(KD("","//a",-1));

assert(h("/").F5(i("\\"))==0);
assert(h("/").v(i("\\")));

assert(h("/").F5("\\")==0);
assert(h("/").v("\\"));
#endif


{

const h O="pkgPath.tmp";
FILE*x=fopen(O,"w");
fputs("echo hello world\n",x);
fclose(x);
O.JP(g_());
struct stat KE;
struct stat KF;
O.T(KE);
(g_()+O).T(KF);
assert(KE.st_mode==KF.st_mode);
assert(KE.st_mtime==KF.st_mtime);
assert(KE.st_size==KF.st_size);
assert(::remove(g_()+O)==0);

O.JP(g_()+O+"1");
assert(::remove(g_()+O+"1")==0);

try{
O.JP("/ /");
assert(0);
}
catch (const aS&zi){
#if SYS_UNIX
assert(zi.aU().v(
"File system error: pkgPath.tmp: cannot copy to / /: "
"Permission denied"));
#else
assert(zi.aU().v(
"File system error: pkgPath.tmp: cannot copy to / /: "
"No such file or directory"));
#endif
}

assert(::remove(O)==0);
}


assert(h("a").KG().v(getcwd()+"a"));
assert(h("a/b/").KG().v(getcwd()+"a/b/"));
assert(h("a//b/").KG().v(getcwd()+"a/b/"));
assert(h("a/../b/").KG().v(getcwd()+"b/"));
assert(h("a/b/../../").KG().v(getcwd()));
assert(h(".").KG().v(getcwd()));
assert(h("./a/./b").KG().v(getcwd()+"a/b"));
#if SYS_UNIX
assert(h("/../").KG().v("/"));
#else
assert(h("//?/a").KG().v("//?/a/"));
assert(h("//?/a/../").KG().v("//?/"));
assert(h("//?/../").KG().v("//?/"));
assert(h("/").KG().v("c:/"));
assert(h("/../").KG().v("c:/"));
#endif


assert(getcwd().KH());
assert(getcwd().hc());


assert(h("a/b").m9()==h("a/b").m9());
assert(h("a/b").m9()!=h("b/a").m9());
#if SYS_NT
assert(h("a/b").m9()==h("A\\B").m9());
#endif


assert(h("/").KH());
assert(!h("a").KH());
#if !SYS_UNIX
assert(h("c:").KH());
#endif


assert(h(".").hc());
assert(h("/").hc());
#if !SYS_UNIX
assert(h("c:/").hc());
#endif


#if SYS_NT
assert(h("c:/mksnt/sh.exe").c8());
{
const char*O="exe";
fclose(fopen(O,"w"));
assert(!h(O).c8());
remove(O);
}
#elif SYS_UNIX
assert(h("/bin/sh").c8());
#endif
assert(!h(__FILE__).c8());

assert(h("abc/def").HO("ab")==0);
assert(h("abc/def").HO("ab",1u)==-1);
assert(h("abc/def").HO("ef")==5);
assert(h("abc/def").HO("fg")==-1);


assert(KI("").v(""));
assert(KI("/").v("/,"));
assert(KI("base").v("base$"));
assert(KI("dir/base").v("dir,base$"));
assert(KI("dir//base").v("dir,base$"));
assert(KI("/a/bb/ccc").v("/,a,bb,ccc$"));
assert(KI("/a/bb/ccc/").v("/,a,bb,ccc,"));
assert(KI(".").v(".,"));
assert(KI("..").v("..,"));
#if !SYS_UNIX
assert(KI("c:").v("c:;"));
assert(KI("c:/").v("c:;"));
assert(KI("c://").v("c:;"));
assert(KI("c:/a/bb/ccc").v("c:;a,bb,ccc$"));
assert(KI("c://a/bb/ccc").v("c:;a,bb,ccc$"));
#endif
#if SYS_NT
assert(KI("//computer/a/bb/ccc").v("computer#a,bb,ccc$"));
assert(KI("//").v("#"));
assert(KI("//computer").v("computer#"));
assert(KI("//computer/").v("computer#"));
assert(KI("//computer/a").v("computer#a,"));
#endif


{
const h O="pkgPath.tmp";
O.mkdir();
assert(O.hc());
try{
O.mkdir();
assert(0);
}
catch (const aS&zi){
assert(zi.aU().v(
"File system error: pkgPath.tmp: make directory failure: File exists"));
}

O.an();
}


#if SYS_NT
{

assert(!i(__FILE__).HS().v(__FILE__));
const h x=__FILE__;
const h KJ=x.HS();
assert(KJ.b1().v(x));
}
{
const h O="\\\\"+KA+"\\C\\TMP\\";
assert(O.b1().v("//"+KA+"/c/tmp/"));
assert(h("/progra~1").b1().v("c:/Program Files/"));
}
#endif


assert(h("a").KK(".").v("a"));
assert(h("a/").KK("a/").v("./"));
assert(h("a/b").KK("a/").v("b"));
assert(h("/a").KK("/").v("a"));
assert(h("/a").KK("/c/").v("../a"));
assert(h("/a/b").KK("/").v("a/b"));
assert(h("/a/b").KK("/a/").v("b"));
assert(h("/a/b").KK("/c/d/").v("../../a/b"));
#if SYS_NT
assert(h("a").KK("//?/a/").v(getcwd()+"a"));
assert(h("//?/a/b").KK("./").v("//?/a/b"));
assert(h("//?/a/b").KK("//?/a/").v("b"));
assert(h("z:/a").KK("//?/b/").v("z:/a"));
assert(h("//?/a/b").KK("z:/").v("//?/a/b"));
assert(h("//?/a/b").KK("//?/c/").v("../a/b"));
#endif
#if !SYS_UNIX
assert(h("a").KK("z:/").v(getcwd()+"a"));
assert(h("z:/a").KK("./").v("z:/a"));
assert(h("z:/a").KK("z:/").v("a"));
#endif


const h g2="tmp.pkgPath";

fclose(fopen(g2,"w"));
g2.an();
assert(fopen(g2,"r")==NULL);

g2.mkdir();
fclose(fopen(g2+"/file","w"));
g2.an();


fclose(fopen(g2,"w"));
g2.mg(g2+"2");
fclose(fopen(g2,"w"));
g2.mg(g2+"2");
try{
g2.mg("./");
assert(0);
}
catch (const aS&zi){
const i U="File system error: "+g2+": cannot rename to .";
assert(zi.aU().Ht(0,U.F()).v(U));

}
(g2+"2").an();


h("").Cs(NULL,NULL,NULL);
assert(KL("",",,"));
assert(KL("a/b.c","a/,b,.c"));
assert(KL("ab/cd.ef","ab/,cd,.ef"));
assert(KL("a/","a/,,"));
assert(KL("b",",b,"));
assert(KL("b.c",",b,.c"));
assert(KL(".",",.,"));
assert(KL("..",",..,"));
assert(KL("./a","./,a,"));
assert(KL(".a",",.a,"));
assert(KL("a.",",a.,"));
assert(KL("/.a","/,.a,"));
#if SYS_UNIX
assert(KL("d:a",",d:a,"));
#else
assert(KL("d:a","d:,a,"));
#endif


assert(h("a/b.c").gQ().v("b.c"));
assert(h("a/b/").gQ().v(""));


assert(h("a/b.c").Kd().v("a/"));
assert(h("a/").Kd().v("a/"));
assert(h("a").Kd().v("./"));


{
struct stat hv;
assert(h("/").T(hv));
assert(h("/tmp/").T(hv));
#if SYS_NT
assert(h("\\").T(hv));
assert(h("c:\\").T(hv));
assert(h("c://").T(hv));
assert((h("\\\\")+KA+"\\c\\").T(hv));
assert((h("//")+KA+"/c").T(hv));
assert((h("//")+KA+"/c/").T(hv));
#endif
}


{
const h O="pkgPath.tmp";
fclose(fopen(O,"w"));
const time_t W=(time(NULL) -1000)&~1;
O.utime(W);
struct stat hv;
assert(O.T(hv)&&hv.st_mtime==W);
::remove(O);
}


const h KM="pkgPath.tmp";
{
h KN;
KO z;
const h BB="./pkgPath.cpp";
assert(BB.uc(z,KN)&&KN.v("./"));
assert(!BB.uc(z,KN));
assert(KN.F()==0);

z.B=0;

z.KP=
i::ha(z.KQ)+
"."+
i::ha(z.KQ)+
"~/."+
i::ha(z.KQ)+
getcwd();
fclose(fopen(KM,"w"));
assert(KM.uc(z,KN)&&KN.v("./"));
assert(KM.uc(z,KN)&&KN.v("./"));
assert(KM.uc(z,KN)&&KN.v(getcwd()));
assert(!KM.uc(z,KN));
assert(KN.F()==0);
}


{
KR KS(".");
h gQ;
bool V=0;
while(KS.readdir(gQ)){
if(gQ.v(KM)){
V=1;
break;
}
}
assert(V);

V=0;
try{
KR KT("none");
}
catch (const aS&zi){
assert(zi.aU().v(
"File system error: "
"none: "
"directory open failure: "
"No such file or directory"));
V=1;
}
assert(V);
}

KM.an();
}

bool h::KD(const char*BB,const char*BC,int q_)
{
int Fv=h(BB).F5(BC);
bool V=
(Fv>0)==(q_>0)&&
(Fv<0)==(q_<0);
Fv=h(BC).F5(BB);
V=V&&
(Fv>0)==(q_<0)&&
(Fv<0)==(q_>0);
return V;
}

i h::KI(const h&O)
{
i q_;
KU z;
while(O.KV(z)){
q_+=z.Y;
switch(z.E){
case KU::KW:
q_+="#";
break;
case KU::KX:
q_+=";";
break;
case KU::KN:
q_+=",";
break;
case KU::gQ:
q_+="$";
break;
default:
assert(0);
break;
}
}
return q_;
}

bool h::KL(const char*U,const char*q_)
{
h KN;
h c5;
h c6;
h(U).Cs(&KN,&c5,&c6);
return(KN+","+c5+","+c6).F5(q_)==0;
}
#endif

h::KY h::m8;
const h h::KZ=
#if SYS_UNIX
"";
#else
".exe";
#endif

h::KY::KY()
{
for(unsigned z=0;z<sizeof(GK);z++){
if(z=='\\'){
GK[z]='/';
}else{
GK[z]=char(tolower(int(z)));
}
}
}






h h::KG() const
{
h O= *this;
if(!O.KH()){
O=getcwd()+O;
}




Hv tB;
KU K0;
while(O.KV(K0)){

if(K0.Y.v("..")){

assert(!tB.GE());

KU&K1=reinterpret_cast<KU&>(tB.Hz());
if(K1.E==KU::KN&&
!K1.Y.v("/"))
{


tB.HA();
delete&K1;
assert(!tB.GE());
}

}else if(K0.Y.v(".")){

}else{
tB.Hy(reinterpret_cast<FE&>(*new KU(K0)));
}
}

O="";
for(unsigned z=0;z<tB.R();z++){
KU&K1=reinterpret_cast<KU&>(tB.Ij(z));
if(K1.E==KU::KW){
O+="\\\\";
}
if(z==0&&K1.Y.v("/")){
#if SYS_UNIX
K1.Y="";
#else
K1.Y=getcwd().Ht(0,2);
#endif
}
O+=K1.Y;
if(K1.E!=KU::gQ){

#if SYS_UNIX
O+="/";
#else
O+="\\";
#endif
}
delete&K1;
}

if(hc()){
O.hb();
}
return O;
}


char h::K2(unsigned B) const
{
char q;
if(B<F()){
q=m7(B);
}else{
q='\0';
}
return q;
}

void h::chdir() const
{
if(::chdir(*this)!=0){
K3("set current directory failure");
}
}



void h::chmod(unsigned K4) const
{
if(::chmod(*this,int(K4))!=0){
K3("set file permission failure");
}
}

int h::F5(const FE&L) const
{
F6(
typeid(L)==typeid(h)||
typeid(L)==typeid(i));
int Fv=1;
const h&Ba= *this;
const h&Bb=static_cast<const h&>(L);
unsigned G6=0;
unsigned Hx=0;
char pz;
char pB;
do{
pz=Ba.K2(G6);
pB=Bb.K2(Hx);

if(pz=='/'&&pB=='/'){

do{
G6++;
pz=Ba.K2(G6);
}while(pz=='/');
do{
Hx++;
pB=Bb.K2(Hx);
}while(pB=='/');
#if !SYS_UNIX

if(Fv!=0&&

(G6==2||Hx==2)&&

G6!=Hx)
{

Fv=Ba.Hp::F5(Bb);
assert(Fv!=0);
break;
}
#endif
}
Fv=pz -pB;
G6++;
Hx++;
}while(Fv==0&&pz!='\0');
return Fv;
}

int h::F5(const char*O) const
{
return F5(i(O));
}

h h::getcwd()
{
char O[PATH_MAX];
if(::getcwd(O,sizeof(O))!=O){
throw aS("get current directory failure");
}
return h(O).hb();
}


unsigned h::m9() const
{

unsigned ft=0;
unsigned m_=F();
if(m_<16){
m_=16;
}
unsigned s=0;
for(unsigned z=0;z<16*F();z+=m_,s++){
unsigned B=z/16;
if(s==15){
B=F() -1;
}
ft=ft ^ (ft>>24);
ft=(ft<<4)+eM(m7(B));
}
return ft;
}

const i&h::K5() const
{
static i u;
if(u.F()==0){
const char*N=getenv("HOME");
if(N!=NULL){
u=N;
}
}
return u;
}

bool h::KH() const
{
bool bx;
#if SYS_UNIX
bx=F()>0&&Hc(0)=='/';
#else
bx=(F()>0&&m7(0)=='/')||
(F()>=2&&isalpha(Hc(0))&&Hc(1)==':');
#endif
return bx;
}

bool h::hc() const
{
struct stat hv;
bool V=T(hv);
if(V){
V=S_ISDIR(hv.st_mode);
}
return V;
}

bool h::c8() const
{
struct stat hv;
bool V=T(hv);
if(V){
V=S_ISREG(hv.st_mode);
}
if(V){
#if SYS_NT
if(F()<4||Ht(F() -4).F5(".exe")!=0){
V=0;
}
#elif SYS_UNIX
if((hv.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH))==0){
V=0;
}
#endif
}
return V;
}

bool h::bl() const
{
struct stat hv;
bool V=T(hv);
if(V){
V=S_ISREG(hv.st_mode);
}
return V;
}

int h::HO(const i&U,int z2) const
{

assert(U.F()!=0);

int B= -1;
const h&O=U;
for(int z=z2;z<=int(F()) -int(U.F());z++){
int D;
for(D=0;D<int(O.F())&&
m7(z+D)==O.m7(D);D++)
{
}
if(D==int(O.F())){
B=z;
break;
}
}
return B;
}

bool h::KV(KU&K6) const
{
bool V=1;
bool K7=0;
unsigned z=K6.B;
const KU::sb K8=K6.E;
if(z>=F()){
V=0;
K6.B=0;
K6.Y="";
}else{
K6.E=KU::KN;
if(z==0){
if(m7(0)=='/'){
K7=1;
z++;
#if !SYS_UNIX
if(F()>1&&m7(1)=='/'){
z++;
K6.E=KU::KW;

K6.B=z;
while(z<F()&&m7(z)!='/'){
z++;
}
}
#endif
}
#if !SYS_UNIX

if(!K7&&F()>1&&Hc(1)==':'){
K6.E=KU::KX;
K7=1;
z=2;



}
#endif
}
if(!K7){
while(z<F()&&m7(z)!='/'){
z++;
}
if(z==F()){
K6.E=KU::gQ;
}
if(K8==KU::KW){
K6.E=KU::KN;
}
}
K6.Y=Ht(K6.B,z);

while(z<F()&&m7(z)=='/'){
z++;
}

if(K6.Y.v(".")||K6.Y.v("..")){
K6.E=KU::KN;
}
K6.B=z;
}
return V;
}

void h::mkdir() const
{
int T;
#if SYS_NT
T=::mkdir(*this);
#else
T=::mkdir(*this,KC|read|write);
#endif
if(T!=0){
K3("make directory failure");
}
}





h h::b1() const
{
h O;
#if SYS_NT

const h K9=KG();
bool K_=0;

KU K6;
while(K9.KV(K6)){
switch(K6.E){
case KU::gQ:
case KU::KN:
if(K_){


O+=K6.Y.HR();
K_=0;
}else{

const h z3=O+K6.Y;
char gQ[PATH_MAX];
const La Jq=vx::Lb(z3,gQ);
if(Jq==Lc){

O+=K6.Y.HR();
}else{

O+=gQ;
vx::Ld(Jq);
}
}
break;
case KU::KW:
O="//";
K_=1;

default:

O+=K6.Y.HR();
break;
}
if(K6.E!=KU::gQ){

O+="/";
}
}
#elif SYS_UNIX
O=KG();
#else
#error not implemented
#endif
return O;
}



h h::operator+(const i&U) const
{
return HM(U);
}



h h::operator+(const char*U) const
{
return HM(U);
}


h&h::operator=(const h&O)
{
Hp::operator=(static_cast<const i&>(O));
return*this;
}


h&h::operator=(const i&O)
{
Hp::operator=(O);
return*this;
}


h&h::operator=(const char*O)
{
Hp::operator=(O);
return*this;
}






h h::KK(const h&KN) const
{
assert(KN.hc()||(KN.F()>0&&
KN.m7(KN.F() -1)=='/'));


const h Le=KN.KG();
const h Lf=KG();


KU Lg;
KU Lh;
bool Li;

unsigned Lj=0;
for(;;){
Li=
Le.KV(Lg);
if(!Lf.KV(Lh)||
!Li||
Lh.E!=Lg.E||
!Lh.Y.v(Lg.Y))
{
break;
}
Lj=Lh.B;
}


h O;
if(Li&&Lg.E==KU::KN){
do{
O+="../";
}while(Le.KV(Lg));
}


O+=Lf.Ht(Lj);


if(O.F()==0){
O="./";
}

return O;
}



void h::an() const
{

struct stat hv;
if(T(hv)){

if(!S_ISDIR(hv.st_mode)){
#if SYS_NT

if((hv.st_mode&write)!=write){

chmod(hv.st_mode|write);
}
#endif

if(::remove(*this)!=0){
K3("remove file failure");
}
}else{

if((hv.st_mode&(write|KC))!=(write|KC)){

chmod(hv.st_mode|write|KC);
}

au It;
{

KR KS(*this);
h KN= *this;
KN.hb();
h O;
while(KS.readdir(O)){
It.aQ(*new h(KN+O));
}

}

for(unsigned z=0;z<It.R();z++){
const h&O=static_cast<const h&>(It.Ij(z));
O.an();
}

if(rmdir(*this)!=0){
K3("remove directory failure");
}
}
}else{
errno=ENOENT;
K3("remove failure");
}
}


void h::mg(const h&O) const
{
h Lk=O;
if(Lk.hc()){
Lk+=gQ();
}
if(Lk.bl()){
Lk.chmod(KC|read|write);
}
bool V=rename(*this,Lk)==0;
if(!V&&errno==EEXIST&&remove(Lk)==0){
errno=0;
V=rename(*this,Lk)==0;
}
if(!V){

if(errno==EXDEV){
JP(Lk);
an();
}else{
K3("cannot rename to "+O);
}
}
}

h&h::hb()
{
if(F()>0&&m7(F() -1)!='/'){
*this+=ha(Ll());
}
return*this;
}


char h::Ll() const
{
char q;
#if SYS_UNIX
q='/';
#else
q='\\';
for(int z=int(F()) -1;z>=0;z--){
if(m7(unsigned(z))=='/'){
q=Hc(unsigned(z));
break;
}
}
#endif
return q;
}

void h::Cs(h*KN,h*c5,h*c6) const
{
const int Lm=int(F()) -1;

int Ln;
for(Ln=Lm;Ln>=0;Ln--){
if(m7(unsigned(Ln))=='/'){
break;
}
#if !SYS_UNIX
if(Hc(unsigned(Ln))==':'){
break;
}
#endif
}

if(KN!=NULL){
if(Ln>=0){
*KN=Ht(0,unsigned(Ln)+1);
}else{
*KN="";
}
}


int Lo;
assert(Ln>=-1);
for(Lo=Lm;Lo>Ln;Lo--){
if(Hc(unsigned(Lo))=='.'){
break;
}
}


if(Lo==Lm||Lo -Ln<=1){
Lo=int(F());
}

if(c6!=NULL){
*c6=Ht(unsigned(Lo));
}

if(c5!=NULL){
assert(Lo!=Ln);
assert(Lo -Ln -1>=0);
assert(Lo>=0);
*c5=Ht(unsigned(Ln+1),unsigned(Lo));
}
}

h h::gQ() const
{
h c5;
h c6;
Cs(NULL,&c5,&c6);
return c5+c6;
}



void h::JP(const h&O) const
{
h Lk=O;
if(Lk.hc()){
Lk+=gQ();
}
if(Lk.bl()){
Lk.chmod(KC|read|write);
}
FILE*l9=fopen(*this,"rb");
FILE*mc=fopen(Lk,"wb");
bool V=0;
if(l9!=NULL&&mc!=NULL){
V=1;
do{
char p[0x1000];
const size_t I=fread(p,1,sizeof(p),l9);
if(I==0){
break;
}
if(fwrite(p,1,I,mc)!=I){
V=0;
}
}while(V);
if(ferror(l9)||ferror(mc)){
V=0;
}
}
if(!V){


remove(Lk);
}
if(l9==NULL){
K3("cannot copy from "+*this);
}else{
fclose(l9);
}
if(mc==NULL){
K3("cannot copy to "+O);
}else{
fclose(mc);
}

if(!V){
K3("cannot copy to "+O);
}


struct stat hv;
T(hv);
Lk.utime(hv.st_mtime);
Lk.chmod(unsigned(hv.st_mode));
}


h h::Kd() const
{
h KN;
Cs(&KN,NULL,NULL);
if(KN.F()==0){
KN="./";
}
return KN;
}






bool h::T(struct stat&hv) const
{
h O= *this;
bool Lp=v("/");
#if SYS_NT
if(!Lp){
Lp=F()==3&&
isalpha(Hc(0))&&
Hc(1)==':'&&
m7(2)=='/';
}
if(!Lp&&F()>2&&
m7(0)=='/'&&m7(1)=='/')
{
KU K0;
if(KV(K0)&&K0.E==KU::KW&&
KV(K0)&&K0.E==KU::KN&&
!KV(K0))
{
O.hb();
O=O.HQ('/','\\');
Lp=1;
}
}
#endif

if(!Lp&&F()>1&&m7(F() -1)=='/'){

O=Ht(0,F() -1);
}

int T;
#if _DEBUG&&SYS_NT
if(O.F()>=3&&
O[0]=='\\'&&
O[1]=='\\'&&
O[2]=='?')
{

O="";
}
T=stat(O,&hv);
#else
T=stat(O,&hv);
#endif
return T==0;
}


void h::K3(const char*Ab) const
{
i U= *this;
U+=": ";
U+=Ab;
throw aS(U);
}

h h::g_()
{
h O;
#if SYS_NT
char p[PATH_MAX];
vx::Lq(sizeof(p),p);
O=p;
#else
O=getenv("TMP");
if(O.F()==0){
O=getenv("TMPDIR");
}
if(O.F()==0){
O="/tmp/";
}
#endif
assert(O.hc());
return O.hb();
}

void h::utime(time_t time) const
{
utimbuf Lr;
Lr.actime=time;
Lr.modtime=time;
if(::utime(*this,&Lr)==-1){
K3("set modification time failure");
}
}








bool h::uc(KO&z,h&KN) const
{
bool V;
Cs(&KN,NULL,NULL);
if(KN.F()==0){
assert(F()!=0);
V=0;

while(!V&&z.B<z.KP.F()){

const unsigned z2=z.B;

const int kf=z.KP.HO(z.KQ,z.B);
if(kf==-1){
z.B=z.KP.F();
}else{
z.B=unsigned(kf);
}

KN=h(z.KP.Ht(z2,z.B)).hb();
if(KN.F()==0){
KN="./";
}

if(KN.F()>2&&KN[0]=='~'&&
KN[1]=='/'&&K5().F()!=0)
{

h Ls=K5();
Ls.hb();
Ls+=KN.Ht(2);
KN=Ls;
}

z.B++;
h O=(KN+*this);

if(O.bl()){
V=1;
}
#if !SYS_UNIX
if(!V){

O+=".exe";
if(O.bl()){
V=1;
}
}
#endif
}
}else{

V=z.B==0;
z.B=1;
}
if(!V){

KN="";
}
return V;
}


KU::KU()
{
B=0;
E=Lt;
}


KU::~KU()
{
}

KR::KR(const h&KN)
{
u=opendir(KN);
if(u==NULL){
throw h::aS(KN+": directory open failure");
}
this->KN=KN;
}

KR::~KR()
{
if(u!=NULL){
closedir(u);
}
#if _lint
u=NULL;
#endif
}



bool KR::readdir(h&gQ)
{








struct dirent*q_;
do{
q_=::readdir(u);
}while(q_!=NULL&&(
strcmp(q_->d_name,".")==0||
strcmp(q_->d_name,"..")==0));
if(q_!=NULL){
gQ=q_->d_name;
}
return q_!=NULL;
}
