/* Copyright (c) Bullseye Testing Technology */



































#include "fgq.h"
#if SYS_NT
#include <windows.h>
#endif
#include "ree.h"
#include "fge.h"
#include "gncu.h"
#if !SYS_UNIX
#include "msdos.h"
#endif






#if !defined(S_ISDIR)
#define S_ISDIR(fu) ((fu)&S_IFDIR)
#endif
#if !defined(S_IRWXU)&&S_IREAD&&S_IWRITE&&S_IEXEC
#define S_IRWXU (S_IREAD|S_IWRITE|S_IEXEC)
#endif
#if !defined(S_IRWXU)
#define S_IRWXU 0700
#endif
#if !defined(S_IRWXG)||!defined(S_IRWXO)
#define S_IRWXG 0070
#define S_IRWXO 0007
#endif








static char Bt[PATH_MAX];
static bool Bu=0;









#if SYS_UNIX
#define Bv(q) ((q)=='/')
#else
#define Bv(q) ((q)=='/'||(q)=='\\'||(q)==':')
#endif

#if !SYS_UNIX







static const char*Bw g(const char*,O)
{
static char p[2];
unsigned z;
p[0]='\\';
for(z=0;O[z]!='\0';z++){
if(O[z]=='/'||O[z]=='\\'){
p[0]=O[z];
}
}
return p;
}
#endif








static void Bx g(char*,O)
{
unsigned F;

F=strlen(O);
if(F>0&&!Bv(O[F -1])){
#if SYS_UNIX
strcat(O,"/");
#else
strcat(O,Bw(O));
#endif
}
}







#if SYS_UNIX
static void By g(char*,u)
{
unsigned F=strlen(u);
while(F>1&&u[F -1]=='/'){
F--;
u[F]='\0';
}
}
#else
static void By(char*u)
{
unsigned Bz;
unsigned F;

if(isalpha(u[0])&&u[1]==':'){
Bz=3;
}
else{
Bz=1;
}
F=strlen(u);
while(F>Bz&&
(u[F -1]=='/'||u[F -1]=='\\'))
{
F--;
u[F]='\0';
}
}
#endif

static void BA bQ(
const char*,BB,
const char*,BC,
char*,p)
{
char BD[PATH_MAX];
char BE[PATH_MAX];
unsigned z;
unsigned fp=0;


if(strcmp(BB,".")==0){

hR(BD);
}else{
strcpy(BD,BB);
if(!hL(BD)){
strcpy(BD,BB);
Bx(BD);
}
}
strcpy(BE,BC);
if(!hL(BE)){
strcpy(BE,BC);
}

for(z=0;BD[z]!='\0'&&
#if SYS_UNIX
BD[z]==BE[z]
#else
tolower(BD[z])==tolower(BE[z])||
(Bv(BD[z])&&Bv(BE[z]))
#endif
;z++)
{
if(Bv(BD[z])){
fp=z+1;
}
}
if(fp==0){

strcpy(p,BE);
}else{

static char BF[]="../";
#if !SYS_UNIX
BF[2]= *Bw(BB);
if(BF[2]=='\\'){
BF[2]= *Bw(BC);
}
#endif
p[0]='\0';
for(z=fp;BD[z]!='\0';z++){
if(Bv(BD[z])){
strcat(p,BF);
}
}

strcat(p,BE+fp);
}
#if !SYS_UNIX
{

int gk=(int)strlen(p) -1;
int N;
char BG[PATH_MAX];

strcpy(BG,BC);
kC(BG);
N=(int)strlen(BG) -1;
if(gk>=0&&N>=0&&
p[gk]=='\\'&&BG[N]!='/'&&BG[N]!='\\')
{
gk--;
}
for(;gk>=0&&N>=0;gk--,N--){
if(tolower(p[gk])==tolower(BG[N])||(
(p [gk]=='/'||p [gk]=='\\')&&
(BG[N]=='/'||BG[N]=='\\')))
{
p[gk]=BG[N];
}else{
break;
}
}
}
#endif
}













bool bL bE(
const char*,x,
char*,u)
{
bool hI=0;
static char BH[PATH_MAX];
static bool vW=1;
char BI[PATH_MAX];

if(x!=NULL){

bK(x,u,NULL,NULL);
assert(u[0]=='\0');

strcpy(BH,x);
vW=1;

#if !SYS_UNIX

bM(BI,NULL,x,".exe");
if(e2(x)||e2(BI)){
strcpy(u,".");
hI=1;
}
#endif
}
while(!hI){
#if SYS_UNIX
const char BJ=':';
#else
const char BJ=';';
#endif
bool gS;

if(vW){
gS=gT(getenv("PATH"),BJ,u,PATH_MAX);
vW=0;
}else{
gS=gT(NULL,BJ,u,PATH_MAX);
}
if(!gS){
break;
}

if(u[0]=='~'&&u[1]=='/'){

char BK[PATH_MAX];
strcpy(BK,getenv("HOME"));
Bx(BK);
strcat(BK,u+2);
strcpy(u,BK);
}

bM(BI,u,BH,NULL);
hI=e2(BI);

#if !SYS_UNIX

if(!hI){
strcat(BI,".exe");
hI=e2(BI);
}
#endif
}
return hI;
}

int el bE(
const char c*,mp,
const char c*,mq)
{
int r;
register char pz;
register char pB;

do{
pz= *mp;
pB= *mq;
if(wX(pz)&&wX(pB)){
do{
mp++;
pz= *mp;
}while(wX(pz));
do{
mq++;
pB= *mq;
}while(wX(pB));
}
#if SYS_UNIX
r=pz -pB;
#else
if(pz=='\\'){
pz='/';
}
if(pB=='\\'){
pB='/';
}
r=pz -pB;
if(r!=0){
r=tolower(pz) -tolower(pB);
}
#endif
if(r<0){

if(pz=='\0'){

while(wX(pB)){
mq++;
pB= *mq;
}
if(pB=='\0'){
r=0;
}else{
r= -2;
}
}else{
r= -1;
}
}else if(r>0){

if(pB=='\0'){

while(wX(pz)){
mp++;
pz= *mp;
}
if(pz=='\0'){
r=0;
}else{
r=2;
}
}else{
r=1;
}
}else{
mp++;
mq++;
}
}while(r==0&&pz!='\0');
return r;
}








int kA bE(
const char*,mp,
const char*,mq)
{
int r=0;

#if SYS_UNIX
unsigned s=2;
#else
unsigned s=3;
#endif
unsigned z;
char lZ[PATH_MAX];
char BL[PATH_MAX];

strcpy(lZ,mp);
strcpy(BL,mq);
hL(lZ);
hL(BL);
for(z=0;lZ[z]!='\0'&&BL[z]!='\0';z++){
#if SYS_UNIX
r=lZ[z] -BL[z];
#else

r=tolower(lZ[z]) -tolower(BL[z]);
#endif
if(r!=0){
break;
}
if(Bv(lZ[z])){
s--;
if(s==0){
break;
}
}
}
return r;
}


void kC g(char*,O)
{
#if SYS_UNIX
const unsigned BM=0;
#else

unsigned BM=0;
if(isalpha(O[0])&&O[1]==':'){
BM=2;
}
#endif


unsigned z2=BM;

unsigned z;

unsigned BN[PATH_MAX]={0};
unsigned BO[PATH_MAX]={0};

bool BP[PATH_MAX]={0};
unsigned BQ=0;

for(z=BM;O[z]!='\0';z++){

if(wX(O[z])){
bool BR=0;
bool BS=1;

if(z>=1&&
O[z -1]=='.'&&
z -1==z2)
{

BS=0;

}else if(z>=2&&
O[z -1]=='.'&&
O[z -2]=='.'&&
z -2==z2)
{
BR=1;

if(BQ!=0&&BP[BQ -1]){
BS=0;
BQ--;
}
}

if(BS){
BN[BQ]=z2;
BO[BQ]=z+1;

BP[BQ]=!BR&&z!=0;
BQ++;
}
z2=z+1;
}
}

BN[BQ]=z2;
BO[BQ]=z;
BQ++;

unsigned N=BM;

for(unsigned Q=0;Q<BQ;Q++){

for(z=BN[Q];z<BO[Q];z++){
O[N++]=O[z];
}
}
O[N]='\0';

if(O[0]=='\0'){
strcpy(O,"./");
}
}

int gD bE(
const char*,BT,
const char*,BU)
{
int T=0;
int A;
int M= -1;
int I;
char p[1024];
A=open(BT,O_RDONLY,S_IRUSR|S_IWUSR);
if(A==-1){
T=1;
}
if(T==0){
M=open(BU,O_WRONLY|O_CREAT|O_TRUNC,
S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
if(M==-1){
T=2;
}
}
while(T==0){
I=read(A,p,sizeof(p));
if(I<=0){
break;
}
if(write(M,p,(unsigned)I)!=I){
T=3;
}
}
if(A!=-1){
close(A);
}
if(M!=-1){
close(M);
}
return T;
}

void kB bQ(
const char*,u,
const char*,x,
char*,p)
{
static struct{
X time;
char u[PATH_MAX];
char BV[PATH_MAX];
char hQ[PATH_MAX];
char BW[PATH_MAX];
}BX[10];
static X s=0;

char BV[PATH_MAX];
char BY[PATH_MAX];
char BZ[PATH_MAX];
unsigned z;
unsigned B1=0;
bool hI=0;
char hQ[PATH_MAX];


s++;
hR(hQ);
bK(x,BV,BY,BZ);
assert(BY[0]!='\0');
if(BV[0]=='\0'){
strcpy(BV,".");
}


for(z=0;z<cQ(BX);z++){
if(BX[z].time<=BX[B1].time){
B1=z;
if(BX[z].time==0){

break;
}
}
if(strcmp(u,BX[z].u)==0&&
strcmp(BV,BX[z].BV)==0&&
strcmp(hQ,BX[z].hQ)==0)
{
hI=1;
break;
}
}
if(hI){

bM(p,BX[z].BW,BY,BZ);
BX[z].time=s;
}else{

char BW[PATH_MAX];
BA(u,BV,BW);
bM(p,BW,BY,BZ);


assert(strlen(u)<sizeof(BX[B1].u));
assert(strlen(BV)<sizeof(BX[B1].BV));
assert(strlen(hQ)<sizeof(BX[B1].hQ));
assert(strlen(p)<sizeof(BX[B1].BW));
strcpy(BX[B1].u,u);
strcpy(BX[B1].BV,BV);
strcpy(BX[B1].hQ,hQ);
strcpy(BX[B1].BW,BW);
BX[B1].time=s;
}
}

bool B2 g(const char*,u)
{
bool V;
char p[PATH_MAX];
struct stat aM;

strcpy(p,u);

#if SYS_UNIX
V=1;
#else

if(isalpha(p[0])&&p[1]==':'&&p[2]=='\0'){
strcat(p,".");
}
By(p);


V=(strchr(p,'*')==NULL&&strchr(p,'?')==NULL);
#endif

if(V){
V=(stat(p,&aM)==0&&S_ISDIR(aM.st_mode));
}

#if !SYS_UNIX

if(!V){
V=(isalpha(p[0])&&strcmp(&p[1],":/")==0);
}
#endif

#if !SYS_OS2

if(V){
V=(access(p,R_OK|W_OK|X_OK)==0);
}
#endif

return V;
}

bool B3 g(const char*,u)
{
bool V;
char p[PATH_MAX];

strcpy(p,u);
By(p);

#if (SYS_UNIX||__GNUC__)&&!SYS__VxWorks

V=(mkdir(p,S_IRWXU|S_IRWXG|S_IRWXO)==0);
#else
V=(mkdir(p)==0);
#endif

return V;
}

void B4 g(const char*,u)
{
char p[PATH_MAX];

strcpy(p,u);
By(p);
rmdir(p);
}

const char*me g(const char*,sM)
{
const char*g_;
const char*u[9];
unsigned z=0;

g_=getenv("TMP");
if(g_!=NULL){
static char p[PATH_MAX];
strcpy(p,g_);
u[z++]=p;
}

g_=getenv("TMPDIR");
if(g_!=NULL){
static char p[PATH_MAX];
strcpy(p,g_);
u[z++]=p;
}

if(sM!=NULL){
u[z++]=sM;
}
#if SYS_OS2
u[z++]="\\tmp";
u[z++]="\\temp";
u[z++]="\\";
u[z++]="c:\\";
#endif
#if SYS_NT
{
static char p[PATH_MAX];
B5(sizeof(p),p);
u[z++]=p;
u[z++]="c:\\";
}
#endif
#if SYS_UNIX
u[z++]="/tmp";
#endif
u[z++]=NULL;
assert(z<=cQ(u));

g_=NULL;
for(z=0;u[z]!=NULL;z++){
if(B2(u[z])){
g_=u[z];
break;
}
}

return g_;
}

bool hi bE(
const char*,mp,
const char*,mq)
{
bool B6;
char lZ[PATH_MAX];
char BL[PATH_MAX];

bK(mp,NULL,lZ,NULL);
bK(mq,NULL,BL,NULL);
if(el(lZ,BL)!=0){
B6=0;
}
else{

assert(strlen(mp)<sizeof(lZ));
assert(strlen(mq)<sizeof(BL));
strcpy(lZ,mp);
strcpy(BL,mq);
hL(lZ);
hL(BL);
B6=(el(lZ,BL)==0);
}
return B6;
}

bool kW(const char*O)
{
char p[PATH_MAX];
struct stat aM;
strcpy(p,O);
By(p);
return stat(p,&aM)==0&&S_ISDIR(aM.st_mode);
}

bool e2(const char*O)
{
struct stat aM;
return stat(O,&aM)==0&&S_ISREG(aM.st_mode);
}

void bK eO(
const char*,O,
char*,u,
char*,J,
char*,wc)
{
assert(O!=NULL);
int pQ;
int B7;
int I;

I=(int)strlen(O) -1;


for(pQ=I;pQ>=0&&!Bv(O[pQ]);pQ--)
;

if(u!=NULL){
if(pQ>=0){
assert(pQ+1<PATH_MAX);
strncpy(u,O,(size_t)(pQ+1));
}
u[pQ+1]='\0';
}


for(B7=I;B7>pQ&&O[B7]!='.';B7--)
;




if((I>=0&&O[I]=='.')||B7 -pQ<=1){
B7=I+1;
}
if(wc!=NULL){
if(B7>=I){
wc[0]='\0';
}
else{
assert(strlen(O+B7)<PATH_MAX);
strcpy(wc,&O[B7]);
}
}
if(J!=NULL){
assert(B7!=pQ);
assert(B7 -pQ -1>=0);
assert(B7 -pQ -1<PATH_MAX);
strncpy(J,&O[pQ+1],(size_t)(B7 -pQ -1));
J[B7 -pQ -1]='\0';
}
}

void bM eO(
char*,O,
const char*,u,
const char*,c5,
const char*,wc)
{

if(u==NULL){
O[0]='\0';
}
else{
strcpy(O,u);
Bx(O);
}


if(c5!=NULL){
assert(!hK(c5));
strcat(O,c5);
}


if(wc!=NULL){
assert(!hK(wc));
strcat(O,wc);
}
}








char*rt g(char*,B8)
{
char*g2=NULL;
static const char B9[7]="XXXXXX";
char*B_;
static X I=0;


if(I==0){
if(B8==NULL){

I=123456;
}else{

I=(X)(long)getpid();
}

I=I*100;

I=I % 90000;
}

if(B8!=NULL){
B_=B8+strlen(B8) -sizeof(B9)+1;
if(B_>=B8&&strcmp(B_,B9)==0){
do{
I++;
sprintf(B_,"%02lu.%03lu",I/1000,I % 1000);

}while(I<=99999&&access(B8,0)==0);
if(I<=99999){
assert(strlen(B_)==sizeof(B9) -1);
g2=B8;
}
}
}
return g2;
}

bool hK g(const char*,O)
{
#if SYS_UNIX
return(O[0]=='/');
#else
return(O[0]=='/'||O[0]=='\\'||
(isalpha(O[0])&&O[1]==':'));
#endif
}

bool hR g(char*,u)
{
bool V;

if(Bu){
strcpy(u,Bt);
V=1;
}else{
V=(getcwd(u,PATH_MAX)!=NULL);
if(V){
Bx(u);
strcpy(Bt,u);
Bu=1;
}
}
return V;
}

bool Ca g(const char*,u)
{
bool V;
if(el(".",u)==0||
(Bu&&el(Bt,u)==0))
{
V=1;
}else{
#if SYS_UNIX
V=(chdir(u)==0);
#else
char p[PATH_MAX];
char*Q;


strcpy(p,u);
if(p[1]!=':'){
Q= &p[0];
}
else{
Q= &p[2];
if(p[2]=='\0'){

p[2]='.';
p[3]='\0';
}
}
By(Q);
V=(chdir(p)==0);
if(V&&p[1]==':'){

Cb((unsigned)(toupper(p[0]) -'A'));
}
#endif
Bu=0;
}
return V;
}

void Cc(void)
{
Bu=0;
}

bool hL g(char*,O)
{
bool V;
char w7[PATH_MAX];

#if !SYS_UNIX
char Cd[PATH_MAX];
Cd[0]='\0';



{
unsigned Q;
unsigned fs;

assert(O[0]!='\0');
fs=1;
for(Q=1;O[Q]!='\0';Q++){
if((O[Q ]=='/'||O[Q ]=='\\')&&
(O[Q+1]=='/'||O[Q+1]=='\\'))
;
else{
O[fs++]=O[Q];
}
}
O[fs]='\0';
}
#endif

V=1;
hR(w7);

#if !SYS_UNIX

if(isalpha(O[0])&&O[1]==':'&&
tolower(O[0])!=tolower(w7[0]))
{
strcpy(Cd," :.");
Cd[0]=O[0];
V=Ca(Cd)&&
hR(Cd);
}
#endif

if(V){

if(Ca(O)){

V=hR(O);
}else{

char u[PATH_MAX];
char bJ[PATH_MAX];
char c6[PATH_MAX];
char hP[PATH_MAX];
bK(O,u,bJ,c6);


if(u[0]!='\0'){

V=Ca(u);
}
if(V){

hR(hP);
bM(O,hP,bJ,c6);
}
}
}

if(V){
assert(hK(O));
}

#if !SYS_UNIX
if(Cd[0]!='\0'){

Ca(Cd);
}
#endif

Ca(w7);

return V;
}
