/* Copyright (c) Bullseye Testing Technology */




























#include "fgq.h"
#include "ybfabpr.h"
#include "gfu.h"



#define Ew 512
#define Ex 512
#define Ey 64







typedef struct{
const char*o[b6];
unsigned be;
const char*Ez;
bool EA;
}EB,*EC;







static char ED[PATH_MAX];






static void EE(void);
static void EF(void);
static void EG(void);
static void EH(void);
static void EI(void);
static void EJ(void);
static void EK(void);
static void EL(void);
static void EM(void);
static void EN(void);
static void EO(void);
static void EP(void);
static void EQ(void);

static const cf ER[]={
{"?",EJ,"show test shell commands"},
{"call %s",EE,"call script file %s"},
{"create %s %s",EF,"create file %s with contents %s"},
{"echo *",EG,"output *"},
{"error %s",EH,"cause a run-time error"},
{"exit",EI,"quit"},
{"help",EJ,"show test shell commands"},
{"if *",EK,"%s1 = %s2, %s1 <> %s2"},
{"inform *",EL,"output * to user"},
{"mkdir %s",EM,"make directory %s"},
{"q",EI,"quit"},
{"read %s",EN,"read and display file %s"},
{"rm %s",EO,"remove file %s"},
{"rmdir %s",EP,"remove directory %s"},
{"run %s",EQ,"run via system command processor"},
{NULL,0,NULL}
};





static struct{
const cf*ci;
const char*J;
CC*CD;
}ES={
NULL,
NULL,
NULL
};





static bool ET=0;





static bool da=0;





static bool EU;






static bool cV=0;







static struct{
bool EV;
size_t CU;
char p[Ex+1];
}mc;





static FILE*EW;





static bool EX;





static const char*EY[b6];





static bool EZ=1;





static unsigned E0=0;

#if !SYS_UNIX




static char E1[2];
static char E2[2];
#endif










static void E3 g(EC,E4)
{
unsigned E5;

printf("+%u ",E0);
for(E5=0;E5<E4->be;E5++){
const char*Q=E4->o[E5];
if((Q[0]=='\0'||strchr(Q,' ')!=NULL)&&strchr(Q,'"')==NULL){
printf("\"%s\" ",Q);
}else{
printf("%s ",Q);
}
}
if(E4->Ez!=NULL){
printf("-> %s",E4->Ez);
}
printf("\n");
}


















static bool E6(
FILE*l9,
EB*E4,
bool E7)
{
static char E8[Ew+1];
size_t E9;
int q;
bool E_;
bool Fa;
const char*Fb;
bool Fc;
unsigned be;
const char*Ez;
char bR;
bool Fd;
bool Fe;
bool Ff;
char Fg[32];
const char*Fh;
unsigned Fi;

memset(E8,0,sizeof(E8));
E0++;

if(E7){
printf("tsh:%s> ",ES.J);
fflush(stdout);
}

E9=0;
E_=0;
Fc=0;
Fe=0;
be=0;
Ez=NULL;
Fb=E8;
E4->EA=0;

while(!E_){
Fa=0;
Fd=0;
q=getc(l9);

switch(q){
case' ':
case'\t':
do{
q=getc(l9);
}while(q!=EOF&&(q==' '||q=='\t'||q=='\r'));
ungetc(q,l9);
Fa=1;
break;
case EOF:
case'\n':
E_=1;
break;
case'#':
E_=1;
do{
q=getc(l9);
}while((q!=EOF)&&(q!='\n'));
break;
case'$':

Fi=0;
do{
q=getc(l9);
assert(Fi<sizeof(Fg));
Fg[Fi]=(char)q;
Fi++;
}while(isalnum(q)||q=='_');
ungetc(q,l9);
Fi--;
Fg[Fi]='\0';

Fh=NULL;
if(Fh==NULL&&strcmp(Fg,"d")==0){
#if SYS_UNIX
Fh="";
#else
Fh=E1;
#endif
}
if(Fh==NULL&&strcmp(Fg,"D")==0){
#if SYS_UNIX
Fh="";
#else
Fh=E2;
#endif
}
if(Fh==NULL&&strcmp(Fg,"sys")==0){

#if SYS_NT
Fh="nt";
#endif
#if SYS_OS2
Fh="os2";
#endif
#if SYS_UNIX
Fh="unix";
#endif
assert(Fh!=NULL);
}
if(Fh==NULL&&strcmp(Fg,"dir")==0){
Fh=ED;
}
if(Fh==NULL&&ES.CD!=NULL){
unsigned z;
for(z=0;ES.CD[z].J!=NULL;z++){
if(strcmp(Fg,ES.CD[z].J)==0){
Fh=ES.CD[z].Y;
break;
}
}
}
if(Fh==NULL){
Fh=getenv(Fg);
}
if(Fh==NULL){
printf("*** unknown name %s\n",Fg);
cV=1;
}else{

for(Fi=0;Fh[Fi]!='\0';Fi++){
assert(E9<sizeof(E8));
E8[E9]=Fh[Fi];
E9++;
}
}


Fc=1;
break;
case'-':
q=getc(l9);
Fd=(q=='>');
Fa=Fd;
if(Fd){

q=getc(l9);
if(q=='!'){
E4->EA=1;
}else{
ungetc(q,l9);
}
}else{
ungetc(q,l9);
assert(E9<sizeof(E8));
E8[E9]='-';
E9++;
Fc=1;
}
break;
case'"':
case'\'':
bR=(char)q;
q=getc(l9);
while((q!=EOF)&&(q!=bR)){
if(q=='\n'){
E0++;
}
assert(E9<sizeof(E8));
E8[E9]=(char)q;
E9++;
q=getc(l9);
}
Fc=1;
break;
default:
assert(E9<sizeof(E8));
E8[E9]=(char)q;
E9++;
Fc=1;
break;
}

if((E_||Fa)&&Fc){
if(Fe){
assert(E9<sizeof(E8));
E8[E9]=' ';
E9++;
}
else{
assert(E9<sizeof(E8));
E8[E9]='\0';
E9++;
assert(be+1<cQ(E4->o));
E4->o[be]=Fb;
be++;
Fb=E8+E9;
}
Fc=0;
}

if(Fd){

Ez=E8+E9;
Fe=1;
}
}

E4->o[be]=NULL;
if(Fe&&(E9>0)&&(E8[E9 -1]==' ')){
E9--;
}
assert(E9<sizeof(E8));
E8[E9]='\0';

E4->be=be;
E4->Ez=Ez;


Ff=((be>0)||(Ez!=NULL));

if(da&&Ff&&EZ)
{
E3(E4);
}

return(!feof(l9)||Ff);
}
















static const cf*Fj(
const cf*ci,
const char**o,
unsigned be)
{
const cf*Fk;
unsigned z;
char p[Ey+1];
char*J;
char*N;
unsigned Fl;

Fk=NULL;
for(z=0;ci[z].AY!=NULL;z++){
assert(strlen(ci[z].AY)<sizeof(p));
strcpy(p,ci[z].AY);

J=strtok(p," \t");
assert(J!=NULL);

if(strcmp(o[0],J)==0){
Fk=ci+z;
Fl=0;
for(N=strtok(NULL," \t");
N!=NULL;
N=strtok(NULL," \t"))
{
Fl++;
}
if(be -1==Fl){
break;
}
}
}
return(Fk);
}















static bool Fm(
const cf*Fk,
const char**o,
const char**Du)
{
static double Fn[b6];
unsigned Fo;
char AY[Ey+1];
unsigned Fp;
char*cB;

assert(o[0]!=NULL);
Du[0]=o[0];
Fp=1;
Fo=0;
assert(strlen(Fk->AY)<sizeof(AY));
strcpy(AY,Fk->AY);

strtok(AY," \t");


for(cB=strtok(NULL," \t");
(cB!=NULL)&&(o[Fp]!=NULL);
cB=strtok(NULL," \t"))
{
if(cB[0]=='%'){
if(strcmp(cB,"%s")==0){
Du[Fp]=o[Fp];
}
else{
sscanf(o[Fp],cB,Fn+Fo);
Du[Fp]=(const char*)(Fn+Fo);
Fo++;
}
Fp++;
}
else if(cB[0]=='*'){

assert(cB[0]=='*');
while(o[Fp]!=NULL){
Du[Fp]=o[Fp];
Fp++;
}
}
else{

assert(0);
}
}
Du[Fp]=NULL;




return((cB==NULL)&&(o[Fp]==NULL));
}







static char*Fq g(char*,p)
{
size_t F;

assert(p!=NULL);


while(isspace(*p)){
p++;
}


F=strlen(p);
while((F>0)&&(isspace(p[F -1]))){
F--;
p[F]='\0';
}

return(p);
}









static bool Fr(
EB*E4,
FILE*l9,
bool E7)
{
bool V;
const cf*Fk;

EW=l9;
EX=E7;

mc.EV=(E4->Ez!=NULL);
mc.CU=0;
mc.p[0]='\0';

if(E4->be==0){
V=1;
}
else{

Fk=Fj(ES.ci,E4->o,
E4->be);
if(Fk==NULL){
Fk=Fj(ER,E4->o,
E4->be);
}
V=(Fk!=NULL);
if(V){

V=Fm(Fk,E4->o,EY);
if(V){

(*Fk->bH)();
}
else{
if(!da){
E3(E4);
}
printf("*** wrong number of arguments\n");
cV=1;
}
}
else{
if(!da){
E3(E4);
}
printf("*** unrecognized command\n");
cV=1;
}
}


mc.EV=0;
if(V&&(E4->Ez!=NULL)){
V=
(strcmp(E4->Ez,Fq(mc.p))==0);
if(E4->EA){
V=!V;
}
cV=!V;
if(cV){
if(!da){
E3(E4);
}
printf("*** expected%s: %s\n",E4->EA?" not":"",
E4->Ez);
printf("*** actual  %s: %s\n",E4->EA?"    ":"",
Fq(mc.p));
}
}

if(E7){
cV=0;
V=1;
}

return(V);
}








static bool Fs(
FILE*l9,
bool E7)
{
bool V;
EB Ft;

EU=0;
V=1;
while(V&&E6(l9,&Ft,E7)){
V=Fr(&Ft,l9,E7);
if(cV){
V=0;
}
if(EU){
break;
}
}
EU=0;
return(V);
}







static void Fu g(const char*,Q)
{
assert(Q!=NULL);
k("%s: %s\n",Q,strerror(errno));
}

static void EE(void)
{
const char**Du=j();
FILE*l9;

assert(strcmp(Du[0],"call")==0);
assert(Du[1]!=NULL);
assert(Du[2]==NULL);

l9=fopen(Du[1],"r");
if(l9==NULL){
Fu(Du[1]);
}
else{
Fs(l9,0);
fclose(l9);
}
}

static void EF(void)
{
const char**Du=j();
FILE*bH;

bH=fopen(Du[1],"w");
if(bH==NULL){
Fu(Du[1]);
}
else{
fputs(Du[2],bH);
fclose(bH);
}
}

static void EG(void)
{
unsigned z;
for(z=1;j()[z]!=NULL;z++){
k("%s ",(const char*)(j()[z]));
}
k("\n");
}








static bool Fv g(const char**,Du)
{
bool r9;
assert(Du[0]!=NULL);
assert(Du[1]!=NULL);
assert(Du[2]!=NULL);
r9=(strcmp(Du[0],Du[2])==0);
if(strcmp(Du[1],"==")==0){
}
else if(strcmp(Du[1],"!=")==0){
r9=!r9;
}
else{
printf("*** expected '==' or '!=', got '%s'\n",Du[1]);
cV=1;
}
return r9;
}

static void EK(void)
{
const char**Du=j();
bool r9;
bool V;
bool Fw;
EB Ft;
bool Fx;

Du++;
r9=Fv(Du);
while(!cV&&Du[3]!=NULL){
Du+=3;
if(strcmp(Du[0],"and")==0){
Du++;
r9=(bool)((unsigned)r9&(unsigned)Fv(Du));
}
else if(strcmp(Du[0],"or")==0){
Du++;
r9=(bool)((unsigned)r9|(unsigned)Fv(Du));
}
else{
printf("*** expected 'and' or 'or', got '%s'\n",Du[0]);
cV=1;
}
}


Fx=EZ;
Fw=0;
EU=0;
V=!cV;
while(V&&E6(EW,&Ft,EX)){
if(Ft.o[0]!=NULL&&strcmp(Ft.o[0],"if")==0){
EZ=Fx&&r9;
V=Fr(&Ft,EW,EX);
}
else if(!Fw&&Ft.o[0]!=NULL&&
strcmp(Ft.o[0],"else")==0)
{
Fw=1;
r9=!r9;
EZ=r9;
}
else if(Ft.o[0]!=NULL&&
strcmp(Ft.o[0],"endif")==0)
{
break;
}
else if(Fx&&r9){
V=Fr(&Ft,EW,EX);
}
if(cV){
V=0;
}
if(EU){
break;
}
}
if(feof(EW)){
printf("*** expected endif\n");
cV=1;
}
EZ=Fx;
}

static void EH(void)
{
const char**Du=j();
printf("*** user error: %s\n",Du[1]);
cV=1;
}

static void EI(void)
{
EU=1;
}

static void EM(void)
{
int T;
const char*u=j()[1];
#if SYS_UNIX||__GNUC__
T=mkdir(u,0777);
#else
T=mkdir((char*)u);
#endif
if(T!=0){
Fu(u);
}
}

static void EN(void)
{
const char**o=j();
FILE*bO;

bO=fopen(o[1],"r");
if(bO==NULL){
Fu(o[1]);
}else{
char p[99];
while(fgets(p,sizeof(p),bO)!=NULL){
k("%s",p);
}
fclose(bO);
}
}

static void EO(void)
{
const char**Du=j();
if(remove(Du[1])!=0){
Fu(Du[1]);
}
}

static void EP(void)
{
const char*u=j()[1];
if(rmdir((char*)u)!=0){
Fu(u);
}
}

static void EQ(void)
{
errno=0;
if(system(j()[1])!=0||errno!=0){
Fu(j()[1]);
}
}


static void Fy(const cf*ci)
{
unsigned z;
size_t Fz;

Fz=16;
for(z=0;ci[z].AY!=NULL;z++){
if(Fz<strlen(ci[z].AY)){
Fz=strlen(ci[z].AY);
}
}
for(z=0;ci[z].AY!=NULL;z++){
k("    %-*s - %s\n",(int)Fz,ci[z].AY,
ci[z].Bm);
}
}







static void EJ(void)
{
char p[9];
k("TSH commands\n");
Fy(ER);
if(EX){
k("Press enter ");
fgets(p,2,stdin);
}
k("%s unit test commands\n",ES.J);
Fy(ES.ci);
}

static void EL(void)
{
unsigned z;
for(z=1;j()[z]!=NULL;z++){
printf("%s ",(const char*)(j()[z]));
}
printf("\n");
}












int bd main(int be,const char**o)
{
bool V;
unsigned z;

o=cp(o);


strcpy(ED,".");
for(z=strlen(o[0]);z>0;z--){
if(o[0][z]=='/'||o[0][z]=='\\'){
strncpy(ED,o[0],z);
ED[z]='\0';
break;
}
}

#if !SYS_UNIX
{
char p[PATH_MAX];
getcwd(p,sizeof(p));
E1[0]=(char)tolower(p[0]);
E2[0]=(char)toupper(p[0]);
}
#endif


for(z=1;z<(unsigned)be&&o[z][0]=='-';z++){
switch(o[z][1]){
case'q':ET=1;break;
case'v':da=1;break;
default:
cq("invalid option %s",o[z]);
break;
}
}

ce(&ES.ci,&ES.J);
assert(ES.ci!=NULL&&ES.J!=NULL);

if((unsigned)be -z==0){
V=Fs(stdin,1);
}
else{
FILE*l9;

V=1;
for(;(V&&(z<(unsigned)be));z++){
l9=fopen(o[z],"r");
V=(l9!=NULL);
if(V){
V=Fs(l9,0);
fclose(l9);
}
else{
perror(o[z]);
}
}
}

cj();
if(da){
cq("exit status %d",V?0:1);
}
cs();
return V?0:1;
}

const char**j()
{
return EY;
}

void CF g(CC*,CD)
{
ES.CD=CD;
}

void bd k(const char*cB,...)
{
va_list cC;
char p[Ex+1];
int F;

va_start(cC,cB);
#if SYS_UNIX
vsprintf(p,cB,cC);
F=(int)strlen(p);
#else
F=vsprintf(p,cB,cC);
#endif
va_end(cC);

if(F<0){
printf("*** error in TSH_printf format string");
cV=1;
}
else if((size_t)F>=sizeof(p)){
printf("*** result string too large to print");
cV=1;
}
else{
if(!ET){
printf("%s",p);
}

if(mc.EV){
if((size_t)F+mc.CU<sizeof(mc.p)){
strcpy(mc.p+mc.CU,p);
mc.CU+=(size_t)F;
#if __SC__==0x700

mc.p[mc.CU]='\0';
#endif
assert(mc.p[mc.CU]=='\0');
}
else{
printf("*** output too long to compare\n");
}
}
}
}

int xo(void)
{
int q=0;
if(ET){
q='q';
}
if(da){
q='v';
}
return q;
}
