/* Copyright (c) Bullseye Testing Technology */








#include "fgq.h"

#if _DEBUG
#include "fxGtrcg.h"
static void ac(void);
static Z op(ac);
static void ac()
{
assert(fnmatch("","",0)==0);
assert(fnmatch("","a",0)==FNM_NOMATCH);
assert(fnmatch("/","/",0)==0);
assert(fnmatch("/","a",0)==FNM_NOMATCH);
assert(fnmatch("a","",0)==FNM_NOMATCH);
assert(fnmatch("a","a",0)==0);
assert(fnmatch("a","aa",0)==FNM_NOMATCH);
assert(fnmatch("a","b",0)==FNM_NOMATCH);
assert(fnmatch("a","/",0)==FNM_NOMATCH);
assert(fnmatch("aa","a",0)==FNM_NOMATCH);
assert(fnmatch("ab","ab",0)==0);

assert(fnmatch("?","",0)==FNM_NOMATCH);
assert(fnmatch("?","a",0)==0);
assert(fnmatch("?","ab",0)==FNM_NOMATCH);
assert(fnmatch("?b","ab",0)==0);
assert(fnmatch("?b","abc",0)==FNM_NOMATCH);
assert(fnmatch("?b","b",0)==FNM_NOMATCH);
assert(fnmatch("a?","a",0)==FNM_NOMATCH);
assert(fnmatch("a?","ab",0)==0);
assert(fnmatch("a?","abc",0)==FNM_NOMATCH);
assert(fnmatch("a?c","abc",0)==0);
assert(fnmatch("??","ab",0)==0);

assert(fnmatch("*","",0)==0);
assert(fnmatch("*","a",0)==0);
assert(fnmatch("*","abc",0)==0);
assert(fnmatch("*b","a",0)==FNM_NOMATCH);
assert(fnmatch("*b","ab",0)==0);
assert(fnmatch("*b","abc",0)==FNM_NOMATCH);
assert(fnmatch("*b","b",0)==0);
assert(fnmatch("*b*","",0)==FNM_NOMATCH);
assert(fnmatch("*b*","a",0)==FNM_NOMATCH);
assert(fnmatch("*b*","aabcc",0)==0);
assert(fnmatch("*b*","ab",0)==0);
assert(fnmatch("*b*","abc",0)==0);
assert(fnmatch("*b*","b",0)==0);
assert(fnmatch("*b*","bc",0)==0);
assert(fnmatch("a*","a",0)==0);
assert(fnmatch("a*","abc",0)==0);
assert(fnmatch("a*","b",0)==FNM_NOMATCH);
assert(fnmatch("a**b","ab",0)==0);
assert(fnmatch("a*b","a",0)==FNM_NOMATCH);
assert(fnmatch("a*b","ab",0)==0);
assert(fnmatch("a*b","b",0)==FNM_NOMATCH);
assert(fnmatch("a*c","abc",0)==0);

assert(fnmatch("[","",0)==FNM_NOMATCH);
assert(fnmatch("[","[",0)==0);
assert(fnmatch("[!]","[!]",0)==0);
assert(fnmatch("[!a]","a",0)==FNM_NOMATCH);
assert(fnmatch("[!a]","b",0)==0);
assert(fnmatch("[!!]","!",0)==FNM_NOMATCH);
assert(fnmatch("[-]","-",0)==0);
assert(fnmatch("[-b]","a",0)==FNM_NOMATCH);
assert(fnmatch("[]","",0)==FNM_NOMATCH);
assert(fnmatch("[]","[]",0)==0);
assert(fnmatch("[a-","a",0)==FNM_NOMATCH);
assert(fnmatch("[a]","a",0)==0);
assert(fnmatch("[ab]","a",0)==0);
assert(fnmatch("[ab]","b",0)==0);
assert(fnmatch("[ab]","c",0)==FNM_NOMATCH);
assert(fnmatch("[b-d]","a",0)==FNM_NOMATCH);
assert(fnmatch("[b-d]","b",0)==0);
assert(fnmatch("[b-d]","c",0)==0);
assert(fnmatch("[b-d]","d",0)==0);
assert(fnmatch("[b-d]","e",0)==FNM_NOMATCH);
assert(fnmatch("a[\\!]b","a!b",0)==0);
assert(fnmatch("a[\\!]b","a\\b",0)==FNM_NOMATCH);
assert(fnmatch("a[\\]]b","a]b",0)==0);
assert(fnmatch("a[\\]]b","a\\b",0)==FNM_NOMATCH);
assert(fnmatch("a[b","a[b",0)==0);
assert(fnmatch("a[b/c]d","abc",0)==FNM_NOMATCH);
assert(fnmatch("a[b]c","abc",0)==0);

assert(fnmatch("a\\*b","a*b",0)==0);
assert(fnmatch("a\\?b","a?b",0)==0);
assert(fnmatch("a\\[b]","a[b]",0)==0);

assert(fnmatch("*","",0)==0);
assert(fnmatch("*/","/",0)==0);
assert(fnmatch("*/*","a/b",0)==0);
assert(fnmatch("*/*b","a/b",0)==0);
assert(fnmatch("*/b*","a/b",0)==0);
assert(fnmatch("*a/*","a/b",0)==0);
assert(fnmatch("/*","/",0)==0);
assert(fnmatch("a*/*","a/b",0)==0);
assert(fnmatch("a*b","ab",0)==0);

assert(fnmatch("*","",FNM_PATHNAME)==0);
assert(fnmatch("*/","/",FNM_PATHNAME)==0);
assert(fnmatch("*/","a/",FNM_PATHNAME)==0);
assert(fnmatch("*/*","a/b",FNM_PATHNAME)==0);
assert(fnmatch("*/*b","a/b",FNM_PATHNAME)==0);
assert(fnmatch("*/a","/a",FNM_PATHNAME)==0);
assert(fnmatch("*/b*","a/b",FNM_PATHNAME)==0);
assert(fnmatch("*a/*","a/b",FNM_PATHNAME)==0);
assert(fnmatch("/*","/",FNM_PATHNAME)==0);
assert(fnmatch("/*","/a",FNM_PATHNAME)==0);
assert(fnmatch("a**/","a/",FNM_PATHNAME)==0);
assert(fnmatch("a*/","a/",FNM_PATHNAME)==0);
assert(fnmatch("a*/*","a/b",FNM_PATHNAME)==0);
assert(fnmatch("a*b","ab",FNM_PATHNAME)==0);
#if !SYS_UNIX
assert(fnmatch("*/","\\",FNM_PATHNAME)==0);
#endif

assert(fnmatch("*","/",0)==0);
assert(fnmatch("?","/",0)==0);
assert(fnmatch("[!/]","a",0)==0);
assert(fnmatch("[/]","/",0)==0);
assert(fnmatch("a","A",0)==FNM_NOMATCH);
assert(fnmatch("/","\\",0)==FNM_NOMATCH);

assert(fnmatch("*","/",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("?","/",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("[/]","/",FNM_PATHNAME)==FNM_NOMATCH);

#if SYS_UNIX
assert(fnmatch("*","\\",FNM_PATHNAME)==0);
assert(fnmatch("/","\\",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("?","\\",FNM_PATHNAME)==0);
assert(fnmatch("a","A",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("a\\*","a/b",FNM_PATHNAME)==FNM_NOMATCH);
#else
assert(fnmatch("*","\\",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("/","\\",FNM_PATHNAME)==0);
assert(fnmatch("?","\\",FNM_PATHNAME)==FNM_NOMATCH);
assert(fnmatch("a","A",FNM_PATHNAME)==0);
assert(fnmatch("a\\*","a/b",FNM_PATHNAME)==FNM_NOMATCH);
#endif
}
#endif

#define NF 0x4000
#if NF==FNM_NOESCAPE||\
NF==FNM_PATHNAME||\
NF==FNM_PERIOD
#error Non-unique value
#endif

static int r(bool NG,int pz,int pB)
{
int z;
#if SYS_UNIX
z=pz -pB;
NG=NG;
#else
if(NG){
if(pz=='\\'){
pz='/';
}
if(pB=='\\'){
pB='/';
}
z=tolower(pz) -tolower(pB);
}else{
z=pz -pB;
}
#endif
return z;
}

static bool NH(char q)
{
#if SYS_UNIX
return q=='/';
#else
return q=='/'||q=='\\';
#endif
}

extern "C"
int fnmatch(const char*B8,const char*U,int NI)
{
int T=0;
unsigned N;
unsigned Q;
const bool NG=(unsigned(NI)&FNM_PATHNAME)!=0;

for(N=0,Q=0;
B8[N]!='\0'&&U[Q]!='\0'&&T==0&&
B8[N]!='*';
N++)
{
switch(B8[N]){
case'?':
if(NG&&NH(U[Q])){
T=FNM_NOMATCH;
}
Q++;
break;
case'[':
if(NG&&NH(U[Q])){
T=FNM_NOMATCH;
}else{
bool V=1;
bool NJ=0;
unsigned z;
char H[128];
const unsigned NK=N;
N++;
if(B8[N]=='!'){
NJ=1;
N++;
}
for(z=0;
V&&B8[N]!=']'&&z<sizeof(H);
z++,N++)
{
switch(B8[N]){
case'\0':
V=0;
break;
case'/':
if(NG){
V=0;
}else{
H[z]=B8[N];
}
break;
case'\\':
N++;
H[z]=B8[N];
break;
case'-':
assert(N>0);
{
const char vW=B8[N -1];
const char NL=B8[N+1];

if(z>0&&vW<=NL){
char q;

z--;

for(q=vW;q<=NL;q++){
H[z]=q;
z++;
}

z--;
N++;
}else{
H[z]=B8[N];
}
}
break;
default:
H[z]=B8[N];
break;
}
}
H[z]='\0';
if(V&&z>0){
if((strchr(H,U[Q])==NULL)!=NJ){
T=FNM_NOMATCH;
}
}else{
N=NK;
if(r(NG,B8[N],U[Q])!=0){
T=FNM_NOMATCH;
}
}
Q++;
}
break;
case'\\':
N++;
if(r(NG,B8[N],U[Q])!=0){
T=FNM_NOMATCH;
}
Q++;
break;
default:
if(r(NG,B8[N],U[Q])!=0){
T=FNM_NOMATCH;
}
Q++;
break;
}
}
if(T==0&&B8[N]=='*'){
N++;
T=FNM_NOMATCH;
for(;;){
T=fnmatch(B8+N,U+Q,
(int)(unsigned(NI)|NF));
if(T==0||U[Q]=='\0'){
break;
}
if(NG&&NH(U[Q])){
break;
}
Q++;
}
}else{

if(B8[N]!='\0'||U[Q]!='\0'){
T=FNM_NOMATCH;
}
}
return T;
}
