/* Copyright (c) Bullseye Testing Technology */


#include "fgq.h"

#if EOF!=-1||UCHAR_MAX!=255
error: not consistent with EOF or UCHAR_MAX
#endif

#if _Ctype_bullseye

#define NP _CN
#define NQ _WS
#define NR _SP
#define NS _PU
#define NT _DI
#define NU _XD
#define NV _LO
#define NW _UP
#else

#define NP 0x01
#define NQ 0x02
#define NR 0x04
#define NS 0x08
#define NT 0x10
#define NU 0x20
#define NV 0x40
#define NW 0x80
#endif

#define NX (_Libc_ctype+1)
unsigned char _Libc_ctype[257]={

0,


NP,NP,NP,NP,NP,NP,NP,NP,NP,


NP|NQ,NP|NQ,NP|NQ,NP|NQ,NP|NQ,


NP,NP,NP,NP,NP,NP,NP,NP,NP,


NP,NP,NP,NP,NP,NP,NP,NP,NP,


NR|NQ,


NS,NS,NS,NS,NS,NS,NS,


NS,NS,NS,NS,NS,NS,NS,NS,


NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,NT|NU,


NS,NS,NS,NS,NS,NS,NS,


NW|NU,NW|NU,NW|NU,NW|NU,NW|NU,NW|NU,


NW,NW,NW,NW,NW,NW,NW,NW,NW,NW,


NW,NW,NW,NW,NW,NW,NW,NW,NW,NW,


NS,NS,NS,NS,NS,NS,


NV|NU,NV|NU,NV|NU,NV|NU,NV|NU,NV|NU,


NV,NV,NV,NV,NV,NV,NV,NV,NV,NV,


NV,NV,NV,NV,NV,NV,NV,NV,NV,NV,


NS,NS,NS,NS,


NP,

0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

#undef tolower
#undef toupper
#undef isalnum
#undef isalpha
#undef iscntrl
#undef isdigit
#undef isgraph
#undef islower
#undef isprint
#undef ispunct
#undef isspace
#undef isupper
#undef isxdigit

int isalnum(int q){return NX[q]&(NT|NV|NW);}
int isalpha(int q){return NX[q]&(NV|NW);}
int iscntrl(int q){return NX[q]&(NP);}
int isdigit(int q){return NX[q]&(NT);}
int isgraph(int q){return NX[q]&(NS|NT|NV|NW);}
int islower(int q){return NX[q]&(NV);}
int isprint(int q){return NX[q]&(NR|NS|NT|NV|NW);}
int ispunct(int q){return NX[q]&(NS);}
int isspace(int q){return NX[q]&(NQ);}
int isupper(int q){return NX[q]&(NW);}
int isxdigit(int q){return NX[q]&(NU);}

int tolower(int q){return isupper(q)?q+('a' -'A'):q;}
int toupper(int q){return islower(q)?q -('a' -'A'):q;}
