/* Copyright (c) Bullseye Testing Technology */


#include "fgq.h"
#include "rnrnaVgitwe.h"
#include "yxStvcr.h"

#if _DEBUG
#include "fxGtrcg.h"
static Z aa[]={
Z(ad::ac,aS::ac),
Z(ad::ac,Gx::ac),
Z(ad::ac,i::ac),
};
void ad::ac()
{

bool V=0;
try{
remove("tmp.pkgFile");
ad x("tmp.pkgFile",O_RDONLY);
}
catch (const Jl&zi){
V=1;
assert(zi.aU().v(
"File open error: tmp.pkgFile: No such file or directory"));
}
assert(V);


ad x("tmp.pkgFile",O_RDWR|O_CREAT);


assert(x.R()==0);
x.write("data",4);
x.aA(0,SEEK_SET);
char p[4];
assert(x.read(p,4)==4);
assert(strncmp(p,"data",4)==0);
assert(x.R()==4);

assert(x.read(p,1)==0);
x.aA(0,SEEK_SET);
p[0]='\0';
x.Jm(p,4);
assert(strncmp(p,"data",4)==0);


V=0;
try{
x.aA(0,SEEK_SET);
x.Jm(p,5);
}
catch (const Jn&zi){
const i U="File fixed-length read error: tmp.pkgFile at 4";
assert(zi.aU().Ht(0,U.F()).v(U));
V=1;
}
assert(V);


try{
{
Jo Jp(x,0);
}
{
Jo Jp(x,Jo::read,0,1);
}
}
catch (const aS&){
assert(0);
}


x.close();
x.Jq= -2;


V=0;
try{
x.fcntl(F_WRLCK,0x123,1);
}
catch (const Jr&zi){
V=1;
const i U="File lock error: tmp.pkgFile at 123, write lock";
assert(zi.aU().Ht(0,U.F()).v(U));
}
assert(V);


V=0;
try{
assert(x.read(p,4)==4);
}
catch (const aS&zi){
V=1;
const i U="File read error: tmp.pkgFile at ffffffff";
assert(zi.aU().Ht(0,U.F()).v(U));
}
assert(V);


V=0;
try{
x.aA(0x10,SEEK_SET);
}
catch (const aS&zi){
V=1;
const i U="File seek error: tmp.pkgFile at 10";
assert(zi.aU().Ht(0,U.F()).v(U));
}
assert(V);


V=0;
try{
x.write("data",4);
}
catch (const Js&zi){
V=1;
const i U="File write error: tmp.pkgFile at ffffffff";
assert(zi.aU().Ht(0,U.F()).v(U));
}
assert(V);


remove("tmp.pkgFile");

}
#endif

ad::ad()
{
Jq= -1;
}

ad::ad(const i&O,int Jt)
{
if(!open(O,Jt)){
if((Jt&(O_CREAT|O_TRUNC))!=0){
throw Ju(O);
}else{
throw Jl(O);
}
}
}

ad::ad(int Jq,const i&O)
{
assert(Jq>=0);
this->Jq=Jq;
this->O=O;
}

void ad::close()
{
if(Jq>=0){
::close(Jq);
Jq= -1;
}
}

i ad::Jv(unsigned jS) const
{
if(jS==unsigned(-1)){
const int aT=errno;
assert(Jq!=-1);
jS=unsigned(lseek(Jq,0,SEEK_CUR));
errno=aT;
}
i U=O;
U+=" at ";
U+=Gx::Hb(jS);
return U;
}

void ad::fcntl(int w_,unsigned jS,unsigned F)
{
assert(Jq!=-1);
struct flock Af;
Af.l_type=short(w_);
Af.l_whence=SEEK_SET;
Af.l_start=off_t(jS);
Af.l_len=off_t(F);
if(::fcntl(Jq,F_SETLKW,&Af)==-1){
const char*W;
switch(w_){
case F_WRLCK:W=", write lock";break;
case F_RDLCK:W=", read lock";break;
case F_UNLCK:W=", unlock";break;
default:
assert(0);
W=NULL;
break;
}
throw Jr(Jv(jS)+W);
}
}

bool ad::gets(i&U)
{
U="";
char q;
unsigned I;
for(;;){
I=read(&q,1);
if(I!=1||q=='\n'){
break;
}
U+=i::ha(q);
}
return I==1;
}

bool ad::open(const i&O,int Jt)
{
assert(!rX());
Jq=::open(O,Jt,
S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
this->O=O;
return Jq>=0;
}

unsigned ad::read(void*p,unsigned I)
{
const int nv=::read(Jq,p,I);
if(nv<0){
throw Jw(Jv());
}
return unsigned(nv);
}



void ad::Jm(void*p,unsigned I)
{
assert(Jq!=-1);
char*N=static_cast<char*>(p);
unsigned nv=0;
unsigned Jx;
do{
Jx=read(N+nv,I -nv);
if(Jx==0){
throw Jn(Jv());
}
nv+=Jx;
N+=Jx;
}while(nv<I);
}

void ad::aA(unsigned jS,int Jy)
{
assert(Jq!=-1);
if(lseek(Jq,off_t(jS),Jy)==-1){
throw Jz(Jv(jS));
}
}

unsigned ad::R() const
{
struct stat aM;
if(fstat(Jq,&aM)!=0){
aM.st_size=0;
}
assert(aM.st_size>=0);
return unsigned(aM.st_size);
}

void ad::write(const void*p,unsigned I)
{
assert(Jq!=-1);
unsigned JA=I;
do{
int JB=::write(Jq,p,JA);
if(JB<0){
throw Js(Jv());
}
JA -=unsigned(JB);
}while(JA>0);
}
