/* Copyright (c) Bullseye Testing Technology */


#include "fgq.h"
#include "nnanynPriqwe.h"
#include "gxNNneelthcb.h"
#include "fxrYvptacr.h"
#include "rxfFltgcz.h"

#if !_DEBUG&&_MSC_VER
#pragma optimize("s", on)
#endif

#if _DEBUG
#include "fxGtrcg.h"
static Z aa[]={
Z(y7::ac,__FILE__),
Z(y7::ac,FD::ac),
};
void y7::ac()
{
i U;

{
const unsigned JJ=0;
y7 JK(JJ,1234u,0,JL);
assert(JK.aU().v("Serial 1234"));
assert(!JK.JM());
assert(JK.y_(U));
assert(U.F()==0);
}



FD FU=FD::FG();
{
y7 JK(FU,1234,1,JL);
assert(JK.JM());
assert(!JK.y_(U));
assert(U.v("Serial 1234\r\nLicense expired 1 day ago"));
}

FU.FI(FD::FQ,1);
{
y7 JK(FU,1234,1,JL);
assert(JK.y_(U));
assert(U.v("Serial 1234\r\nLicense expires in 1 day"));
}

FU.FI(FD::FQ,29);
{
y7 JK(FU,1234,1,JL);
assert(JK.y_(U));
assert(U.F()==0);
}

{
y7 JK(FU,1234,1,JL);
JK.JN=1;
assert(!JK.y_(U));
assert(U.v("Serial 1234\r\nLicense manipulation detected"));
}

{
y7 JK(19981103u,4321u,0,JL);
const h&D3=vx::JO();
const h O=D3+".tmp";
D3.JP(O);
JK.JQ(O);
O.an();


FILE*x=fopen("pkgLicense.tmp","w");
assert(x!=NULL);
fputs("<html>@serial@\n",x);
fclose(x);
JK.JQ("pkgLicense.tmp");
x=fopen("pkgLicense.tmp","r");
assert(x!=NULL);
char p[32];
memset(p,0,sizeof(p));
fread(p,sizeof(p),1,x);
fclose(x);
assert(strcmp(p,"<html>    4321\n")==0);


remove("pkgLicense.tmp");
bool V=0;
try{
JK.JQ("pkgLicense.tmp");
}
catch (const aS&zi){
V=1;
assert(zi.aU().v(
"License error: cannot access file: pkgLicense.tmp"));
}
assert(V);

{
FILE*x=fopen("pkgLicense.tmp","w");
fputs("hello",x);
fclose(x);
}
V=0;
try{
JK.JQ("pkgLicense.tmp");
}
catch (const aS&zi){
V=1;
assert(zi.aU().v(
"License error: text file pkgLicense.tmp (5): found 0 licenses"));
}
assert(V);
remove("pkgLicense.tmp");
}

{
assert(JR("Jan 12 1998")==19980112);
assert(JR("Feb  2 1998")==19980202);
assert(JR("Mar  2 1998")==19980302);
assert(JR("Apr  2 1998")==19980402);
assert(JR("May  2 1998")==19980502);
assert(JR("Jun  2 1998")==19980602);
assert(JR("Jul  2 1998")==19980702);
assert(JR("Aug  2 1998")==19980802);
assert(JR("Sep  2 1998")==19980902);
assert(JR("Oct  2 1998")==19981002);
assert(JR("Nov  2 1998")==19981102);
assert(JR("Dec  2 1998")==19981202);
}

{
y7 JS(19990108u,1234u,0,JL);
y7 JT(19990108u,299999u,1,JU);
y7 JV(JS.as());
y7 JW(JT.as());
assert(JS.JX==JV.JX);
assert(JS.JY==JV.JY);
assert(JS.JZ==JV.JZ);
assert(JS.J0==JV.J0);
assert(JT.JX==JW.JX);
assert(JT.JY==JW.JY);
assert(JT.JZ==JW.JZ);
assert(JT.J0==JW.J0);
}

{
y7 JV("1234 5678 1234 567");
assert(!JV.J1(U));
assert(U.v("Invalid license key"));
y7 JW("z234-5678-1234-567");
assert(!JW.J1(U));
assert(U.v("Invalid license key"));
}
#if SYS_UNIX
J2 J3=JU;
#else
J2 J3=JL;
#endif

{
y7 JK(20100304u,1234u,0,J3);
y7 JV(JK.as());
assert(JV.J1(U));
assert(U.F()==0);
const i U=JV.J4();
assert(
U.v("\r\nUpdates available at no cost until 04 Mar 2010"));
}

{
y7 JK(19990108u,1234u,0,J3);
y7 JV(JK.as());
assert(JV.y_(U));
assert(U.F()==0);
assert(!JV.J1(U));
assert(U.v(
"Serial 1234\r\nUpdating this license requires a fee."
"\r\nContact sales@bullseye.com"));
}

FU=FD::FG();
{
y7 JK(FU,1234u,1,J3);
y7 JV(JK.as());
assert(!JV.y_(U));
assert(U.v("Serial 1234\r\nLicense expired 1 day ago"));
assert(!JV.J1(U));
assert(U.v("Serial 1234\r\nLicense expired 1 day ago"));
}

FU.FI(FD::FQ,1);
{
y7 JK(FU,1234u,1,J3);
y7 JV(JK.as());
assert(JV.y_(U));
assert(U.v("Serial 1234\r\nLicense expires in 1 day"));
assert(JV.J1(U));
assert(U.v("Serial 1234\r\nLicense expires in 1 day"));
}
}
#endif



const y7::J5 y7::J6={
{0xababbcbc,0xdedeefef},{{0xdd,0x98,0x0b,0xcd,0x8d,0x9a,0x10,0x21}}
};
aq::ar y7::J7={1234567890u,3141592653u,0xf0e1d2c3,987654321u};
aq y7::IF(y7::J7);
y7 y7::cl;

y7::y7()
{

Da(J6.t);


J8=0;

#if SYS_UNIX

J9=JY==1;
#else
J9=0;
#endif
}

y7::y7(const char*as)
{
J_(as);
if(JN){
JX=0;
JY=0;
}
J9=0;
}

y7::y7(unsigned Ka,unsigned oy,bool JM,J2 J3)
{
JX=Ka;
JY=oy;
JZ=JM;
J0=J3;
JN=0;
J8=1;
J9=0;
}

y7::y7(FD&FU,unsigned oy,bool JM,J2 J3)
{
JX=
FU.az(FD::FN)*10000+
(FU.az(FD::FP)+1)*100+
FU.az(FD::FQ);
JY=oy;
JZ=JM;
J0=J3;
JN=0;
J8=1;
J9=0;
}


bool y7::Kb(i&U)
{
bool V=1;
J9=0;
const h Kc=
static_cast<const h&>(vx::JO()).Kd();
h O=Kc+"../ccoverLicense.txt";
O=O.b1();
ad x;
if(!x.open(O,O_RDONLY)){
const h Ke=O;
O=Kc+"ccoverLicense.txt";
if(!x.open(O,O_RDONLY)){
V=0;
U="License file ";
U+=Ke;
U+=" not found";
}
}
if(V){
const unsigned Kf=x.R();
IE<char>p(Kf+1);
x.read(p,Kf);
p[Kf+1]='\0';
char*N=strstr(p,"LicenseKey=");
if(N==NULL){
N=p;
}else{
N+=sizeof("LicenseKey=") -1;
}
N[strspn(N,"0123456789abcdefABCDEF")]='\0';
J_(N);
V=J1(U);
}
return V;
}


void y7::J_(const char*as)
{
aq::IG A;
A.t[0]=0;
const unsigned I=strlen(as);
unsigned z=0;
unsigned D=sizeof(A);



for(;z+1<I&&D>0;z+=2){
char p[3]={as[z],as[z+1],'\0'};
unsigned gk;
if(sscanf(p,"%x",&gk)!=1){
break;
}
A.t[--D]=Hj(gk);
}

if(z!=I||D!=0){
JN=1;
}else{

Hj g2[4];
memcpy(g2,&A,sizeof(g2));
memcpy(&A,&A.t[sizeof(g2)],sizeof(g2));
memcpy(&A.t[sizeof(g2)],g2,sizeof(g2));

Da(A);
JN=!Kg();
}
J8=1;
}


unsigned y7::JR(const char*Kh)
{
static const char Ki[]="JanFebMarAprMayJunJulAugSepOctNovDec";
char Kj[4];
memcpy(Kj,Kh,3);
Kj[3]='\0';
const char*N=strstr(Ki,Kj);
assert(N!=NULL);
const unsigned Kk=unsigned(N -Ki)/3+1;
unsigned Kl;
unsigned Km;
sscanf(Kh+4," %u %u",&Kl,&Km);
assert(Kl>0&&Kl<32);
assert(Km>1997&&Km<2030);
return Km*10000+Kk*100+Kl;
}




int y7::Kn() const
{

FD FU=FD::FG();
FU.oF(FD::FN,JX/10000);
FU.oF(FD::FP,(JX/100) % 100 -1);
FU.oF(FD::FQ,JX % 100);
FU.oF(FD::FR,23);
FU.oF(FD::FS,59);
FU.oF(FD::FJ,59);

const int Ko=
int(difftime(FU.FT(),time(NULL)));
return Ko/(24*60*60);
}


void y7::Da(const aq::IG&A)
{
aq::IG M;
IF.IK(A,M);
JX=(M.t[3]<<24)+(M.t[2]<<16)+(M.t[1]<<8)+M.t[0];
JY=(M.t[7]<<24)+(M.t[6]<<16)+(M.t[5]<<8)+M.t[4];
const unsigned version=JY>>28;
switch(version){
case 0:
JZ=(JY&1)!=0;
JY>>=1;
J0=JL;
break;
case 1:
JZ=(JY&0x2000000)!=0;
J0=J2((JY>>26)&0x3);
JY&=0x1ffffff;
break;
default:
JZ=0;
J0=Kp;
JY&=0x1ffffff;
break;
}
}


void y7::jz(aq::IG&M) const
{
aq::IG A;
A.t[0]=Hj(JX);
A.t[1]=Hj(JX>>8);
A.t[2]=Hj(JX>>16);
A.t[3]=Hj(JX>>24);
const unsigned version=1;
unsigned g2=(version<<28)|(J0<<26)|JY;
if(JM()){
g2|=0x2000000;
}
A.t[4]=Hj(g2);
A.t[5]=Hj(g2>>8);
A.t[6]=Hj(g2>>16);
A.t[7]=Hj(g2>>24);
IF.IJ(A,M);
}



i y7::as() const
{
char p[sizeof(aq::IG)*2+1];
p[0]='\0';
if(Kg()){
aq::IG M;
jz(M);
sprintf(p,"%02x%02x%02x%02x%02x%02x%02x%02x",
M.t[3],M.t[2],M.t[1],M.t[0],
M.t[7],M.t[6],M.t[5],M.t[4]);
}
return p;
}

bool y7::Kq()
{
if(!J8){

JN=0;
struct stat hv;
hv.st_mtime=0;

if(JM()&&
static_cast<const h&>(vx::JO()).T(hv))
{




JN=
difftime(time(NULL),hv.st_mtime)<-24*60*60;
}
J8=1;
}
return JN;
}

bool y7::Kg() const
{
const unsigned Kl=JX % 100;
const unsigned Kk=(JX/100) % 100;
return
JX>19990101&&JX<20300000&&
Kk>0&&Kk<=12&&
Kl>0&&Kl<=31&&
JY>1000&&JY<300000;
}



bool y7::J1(i&U)
{
bool bx=1;
#if SYS_UNIX

if(J9&&!Kb(U)){
bx=0;
}
#endif
if(bx&&Kq()){
bx=0;
U="Invalid license key";
}

if(bx&&J0==Kp){
bx=0;
U="Invalid license key or software outdated";
}
#if SYS_UNIX
if(bx&&(J0&JU)==0){
bx=0;
U=aU();
U+="\nLicense not valid for Unix";
}
#else
if(bx&&(J0&JL)==0){
bx=0;
U=aU();
U+="\r\nLicense not valid for Windows";
}
#endif
if(bx&&!y_(U)){
bx=0;
}
if(bx){


static eM Kh[]={0x48,0x6A,0x29,0xE8,0x74,0x6E,0x4C,0x00,0x78,0x9B,0x73,0x41,0x9D,0x8E,0xFC,0x22};
#if SYS_UNIX
static bool Kr=1;
if(Kr){
Kr=0;
aq IF;
aq::IG A;
aq::IG M;

memcpy(&A,Kh,sizeof(A));
IF.IK(A,M);
memcpy(Kh,&M,sizeof(A));

memcpy(&A,Kh+sizeof(A),sizeof(A));
IF.IK(A,M);
memcpy(Kh+sizeof(A),&M,sizeof(A));
}
#endif
if(JR(reinterpret_cast<char*>(Kh))>JX){
bx=0;
U=aU();
U+="\r\nUpdating this license requires a fee."
"\r\nContact sales@bullseye.com";
}
}
return bx;
}

bool y7::y_(i&U)
{
bool bx=1;
U="";
#if SYS_UNIX
if(J9&&!Kb(U)){
bx=0;
}
#endif
if(bx&&Kq()){
bx=0;
U=aU();
U+="\r\nLicense manipulation detected";
}
if(bx&&JM()&&Kn()<4){
U=aU();
U+=y8();
if(Kn()<1){
bx=0;
}
}
return bx;
}


void y7::JQ(const h&O) const
{
struct stat hv;
if(O.T(hv)){
const unsigned R=unsigned(hv.st_size);
IE<char>p(R+1);
ad x(O,O_RDWR);
x.Jm(p,R);

unsigned I=256;
if(I>R){
I=R;
}
unsigned z;
for(z=0;z<I;z++){
if(static_cast<Hj>(p[z])<9||static_cast<Hj>(p[z])>127){
break;
}
}
unsigned s;

i E;

if(z<I){
E="binary";
s=Ks(x,p,R);
}else{
p[R]='\0';

if(strncmp(p,"// ",3)==0||strncmp(p,"/* ",3)==0){
E="source";
s=Kt(x,p);
}else{
E="text";
s=Ku(x,p);
}
}
if(s!=1){
i U=E;
U+=" file ";
U+=O;
U+=" (";
U+=i::ha(R);
U+="): found ";
U+=i::ha(s);
U+=" licenses";
throw aS(U);
}
}else{
throw aS("cannot access file: "+O);
}
}

unsigned y7::Ks(ad&x,char*p,unsigned R) const
{
aq::IG M;
jz(M);

unsigned s=0;
for(unsigned z=0;z<R;z++){
if(memcmp(p+z,
J6.Kv,sizeof(J6.Kv))==0)
{
x.aA(z+sizeof(J6.Kv),SEEK_SET);
x.write(reinterpret_cast<char*>(&M),8);
s++;
}
}
#if _DEBUG

if(s>1){
s=1;
}
#endif
return s;
}

unsigned y7::Ku(ad&x,char*p) const
{
unsigned s=0;
const char Kw[]="@serial@";
char g2[16];
sprintf(g2,"%*u",unsigned(sizeof(Kw)) -1,JY);
char*N=p;
while((N=strstr(N,Kw))!=NULL){
x.aA(unsigned(N -p),SEEK_SET);
x.write(g2,sizeof(Kw) -1);
N+=sizeof(Kw);
s++;
}
return s;
}


unsigned y7::Kt(ad&x,char*p) const
{
unsigned s=0;

aq::IG M;
jz(M);

char Kx[sizeof(M)*5+2];
for(unsigned z=0;z<sizeof(M);z++){
sprintf(Kx+z*5,"0x%02x,",M.t[z]);
}

char Kv[9];
sprintf(Kv,"%x",J6.Kv[1]);

char*N=p;
while((N=strstr(N,Kv))!=NULL){

N=strchr(N,'x');
assert(N!=NULL);
N--;
const char*ho=N;

x.aA(unsigned(ho -p),SEEK_SET);
x.write(Kx,strlen(Kx) -1);
s++;
}
return s;
}

i y7::aU() const
{
i U="Serial ";
U+=i::ha(JY);
return U;
}


i y7::y8() const
{
i U;
if(JM()){
int I=Kn();

if(I<=0){
I--;
}
const char*Ky=I==1||I==-1?"day":"days";
if(I<=0){
U="\r\nLicense expired ";
U+=i::ha(-I);
U+=" ";
U+=Ky;
U+=" ago";
}else{
U="\r\nLicense expires in ";
U+=i::ha(I);
U+=" ";
U+=Ky;
}
}
return U;
}


i y7::J4() const
{
i U;
if(JX!=0&&!JM()){
FD FU=FD::FG();
const unsigned rI=
FU.az(FD::FN)*10000+
(FU.az(FD::FP)+1)*100+
FU.az(FD::FQ);
if(rI<JX){
struct tm F9;
memset(&F9,0,sizeof(F9));
F9.tm_year=int(JX/10000 -1900);
F9.tm_mon=int((JX/100) % 100 -1);
F9.tm_mday=int(JX % 100);
char p[12];

strftime(p,sizeof(p),"%d %b %Y",&F9);
U="\r\nUpdates available at no cost until ";
U+=p;
}
}
return U;
}
