/* $Id: ctype.h,v 1.11 1999/02/08 22:29:04 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 */
#if !_Ctype_bullseye
#define _Ctype_bullseye 1

#include "libcdef.h"

#if __cplusplus
extern "C" {
#endif

/* functions */
int isalnum(int);
int isalpha(int);
int iscntrl(int);
int isdigit(int);
int isgraph(int);
int islower(int);
int isprint(int);
int ispunct(int);
int isspace(int);
int isupper(int);
int isxdigit(int);
int tolower(int);
int toupper(int);

/* macros */
extern unsigned char _Libc_ctype[];
#define _Ctype1 (_Libc_ctype + 1)

#define _CN 0x01 /* control */
#define _WS 0x02 /* white-space */
#define _SP 0x04 /* the space ' ' */
#define _PU 0x08 /* punctuation */
#define _DI 0x10 /* digit */
#define _XD 0x20 /* hex digit */
#define _LO 0x40 /* alpha lower case */
#define _UP 0x80 /* alpha upper case */

#define isalnum(c)  (_Ctype1[(int)(c)] & (_DI | _LO | _UP))
#define isalpha(c)  (_Ctype1[(int)(c)] & (_LO | _UP))
#define iscntrl(c)  (_Ctype1[(int)(c)] & (_CN))
#define isdigit(c)  (_Ctype1[(int)(c)] & (_DI))
#define isgraph(c)  (_Ctype1[(int)(c)] & (_PU | _DI | _LO | _UP))
#define islower(c)  (_Ctype1[(int)(c)] & (_LO))
#define isprint(c)  (_Ctype1[(int)(c)] & (_SP | _PU | _DI | _LO | _UP))
#define ispunct(c)  (_Ctype1[(int)(c)] & (_PU))
#define isspace(c)  (_Ctype1[(int)(c)] & (_WS))
#define isupper(c)  (_Ctype1[(int)(c)] & (_UP))
#define isxdigit(c) (_Ctype1[(int)(c)] & (_XD))

#if __cplusplus
}
#endif

#endif
