/* Copyright (c) Bullseye Testing Technology */

























#include "fgq.h"

#include "ccoverLibVersion.h"
#include "vbrizpg.h"
#include "gbcinpu.h"
#include "rbiipe.h"
#include "gncu.h"

#if _MSC_VER&&!_DEBUG
#pragma optimize("s", on)
#endif




#define nH(m) #m
#define nI(m) nH(m)
static const char nJ[]=nI(VERSION_symbol);












static const unsigned nK=1;
static const unsigned nL=2;
static const unsigned nM=4;
static const unsigned nN=8;



const char**nO;

static bool nP=0;









static bool fW;

static bool fX=0;

static bool nQ=1;

#if SYS_UNIX
static const char*nR="";
#else
static const char*nR="cov_link_";
#endif





static bz*nS;






static bool nT;
static bool nU;
static bool nV;









static void nW(void)
{
a("#ifdef __cplusplus\n");
a("extern \"C\" {\n");
a("#endif\n");

#if SYS_UNIX
a("#if defined(__STDC__) || defined(__cplusplus)\n");
#endif
a("int %s cov_file(const char*);\n",nR);
#if SYS_UNIX
a("#else\n");
a("int cov_file();\n");
a("#endif\n");
#endif



#if SYS_UNIX
a("#if defined(__STDC__) && !defined(__cplusplus)\n");
#endif
a("void %s cov_init(void);\n",nR);
a("void %s cov_reset(void);\n",nR);
a("int %s cov_write(void);\n",nR);
#if SYS_UNIX
a("#else\n");
a("void cov_init();\n");
a("void cov_reset();\n");
a("int cov_write();\n");
a("#endif\n");
#endif

a("#ifdef __cplusplus\n");
a("}\n");
a("#endif\n");
}







static void nX g(const char*,Q)
{
nS->aR('"');
while(*Q!='\0'){
if(*Q=='\\'||*Q=='"'){
nS->aR('\\');
}
nS->aR(*Q);
Q++;
}
nS->aR('"');
}

#if !SYS_UNIX






static void nY(void)
{
if(nQ){

char nZ[PATH_MAX];
char n0[PATH_MAX];
n1(nZ);
unsigned D=0;
for(unsigned z=0;nZ[z]!='\0';z++){
if(nZ[z]=='/'||nZ[z]=='\\'){
n0[D++]='\\';
n0[D++]='\\';
}else{
n0[D++]=nZ[z];
}
}
n0[D]='\0';
a(
"#if __BORLANDC__ && __WIN32__\n"
"\t#pragma comment(lib, \"%s\\\\covntb.lib\")\n",
n0);
a(
"#elif __IBMC__ + __IBMCPP__ >= 300 && _WIN32\n"
"\t#pragma library(\"covnti.lib\")\n"
"#elif _MSC_VER && _WIN32\n"
"\t#pragma comment(lib, \"covntm.lib\")\n"
"#elif __SC__ && _WIN32\n"
"\t#pragma comment(lib, \"covnts.lib\")\n"
"#elif __WATCOMC__ && defined(__NT__) && defined(__SW_3R)\n"
"\t#pragma library (\"covntwr.lib\")\n"
"#elif __WATCOMC__ && defined(__NT__) && defined(__SW_3S)\n"
"\t#pragma library (\"covntws.lib\")\n"
"#endif\n"
);
}
}
#endif







static void n2(void)
{
#if !SYS_UNIX
a(
"#if _MSC_VER || __BORLANDC__ || __SC__\n"
"\t#define cov_link_ __cdecl\n"
"#endif\n");

a(
"#if __IBMC__ || __IBMCPP__\n"
"\t#define cov_link_ _Optlink\n"
"#endif\n");

a(
"#if !defined(cov_link_)\n"

"\t#define cov_link_\n"
"#endif\n");
#endif
}



void g9(const char*n3[])
{
nO=n3;
}


void n4(void)
{
#if !SYS_UNIX



a(

"\n"
"#if _MSC_VER\n"
"\t#pragma warning(disable:4505)\n"
"#endif\n");
#endif
}







void n5(void)
{
nT=0;
nU=0;
nV=0;
nS=NULL;
}

void n6()
{
n2();

a("#ifdef __cplusplus\n");
a("extern \"C\" void %s cov_count();\n",nR);
a("extern \"C\" void %s cov_term();\n",nR);
#if SYS__HPUX



a("#include <stddef.h>\n");
#endif
a("class cov_class_ { public:\n");
a("cov_class_() { cov_count(); }\n");
a("~cov_class_() { cov_term(); }\n");
#if SYS__HPUX



a("void* operator new(size_t) { static char c; return &c; }\n");
a("void operator delete(void*) { }\n");
#endif
a("};\n");

a("static cov_class_ cov_static_;\n");
a("#endif\n");
}








void n7 bE(
const char*,x,
X,G)
{

if(G!=0&&G<=32767){
a("#line %u ",G);
if(x!=NULL){
nX(x);
}
a("\n");
}
}

void ia(n8 lf,bool Y)
{
switch(lf){
case n9:nP=Y;break;
case ib:fW=Y;break;
case ic:fX=Y;break;
case id:nQ=Y;break;
default:assert(0);
}
}

void n_(bz&d7)
{
nS= &d7;
}










void oa(
unsigned d3,
unsigned et,
const char*L)
{
unsigned z;
unsigned ob;
char gp[256];
char oc[PATH_MAX];
char od[PATH_MAX];


oe(gp,"definitions",80 -sizeof("/*  */"));
a("/* %s */\n",gp);
a("/* ");
for(z=0;nO[z]!=NULL;z++){
a("%s ",nO[z]);
}
a("*/\n");

#if !SYS_UNIX

a(
"#if __BORLANDC__ && __STDC__\n"
"#pragma warn -nak\n"
"#endif\n");
#endif

nW();

#if !SYS_UNIX
nY();
#endif

if(et>0){
bK(L,NULL,oc,od);
strcat(oc,od);


a(
"#if !__SUNPRO_CC\n"
"static\n"
"#endif\n");
a("struct {\n\t");
#if SYS_UNIX
a("char * next;\n\t");
#else
assert(sizeof(long)>=sizeof(void*));
a("long next;\n\t");
#endif
a("unsigned id;\n\t");

a("short signature_;\n\t");
a("short data_n;\n\t");
a("char is_linked;\n\t");
a("char is_changed;\n\t");
a("char is_found;\n\t");
a("char delay_io;\n\t");
a("char data[%u];\n\t",et);
a("char base[%u];\n",strlen(oc)+1);

a(
"#if __SUNPRO_CC\n"
"#define cov_o_ cov_object_%x\n"
"#endif\n",d3);
a("} cov_o_ = {\n\t");

#if SYS_UNIX
a("(char *)0, ");
#else
a("0L, ");
#endif
a("%u, ",d3);
a("0x5a6b, ");
a("%u, ",et);
a("0, ");
a("0, ");
a("0, ");
a("%d, ",fX);

a("{\n\t");

for(ob=1;ob<et;ob++){
a("0,");
if(ob % 32==0){
a("\n\t");
}
}
assert(ob==et);
a("0 },\n\t");
a("\"%s\"\n",oc);

a("};\n");

a("#ifdef __cplusplus\n");
a("extern \"C\" {\n");
a("#endif\n");


#if SYS_UNIX
a("#if defined(__STDC__) || defined(__cplusplus)\n");
#endif
a(
"int %s %s(void*, int, int);\n",
nR,nJ);
#if SYS_UNIX
a("#else\n");
a("int %s();\n",nJ);
a("#endif\n");
#endif

a("#ifdef __cplusplus\n");
a("}\n");
a("#endif\n");






if(!fW&&nV){
#if SYS_UNIX

a("#if defined(__STDC__) || defined(__cplusplus)\n");

a("#if __SUNPRO_CC\n");
a("inline\n");
a("#endif\n");
#endif
a("static void cov_f_(int probe)\n");
#if SYS_UNIX
a("#else\n");
a("static void cov_f_(probe)\n");

a("int probe;\n");
a("#endif\n");
#endif
a("{\n");
a("  if ((cov_o_.data[probe] & %u) == 0) {\n",
nN);
a("    %s(&cov_o_, probe, %u);\n",
nJ,
nN -1);
a("  }\n");
a("}\n");
}
if(!fW&&nU){
#if SYS_UNIX

a("#if defined(__STDC__) || defined(__cplusplus)\n");

a("#if __SUNPRO_CC\n");
a("inline\n");
a("#endif\n");
#endif
a("static void cov_h_(int probe)\n");
#if SYS_UNIX
a("#else\n");
a("static void cov_h_(probe)\n");
a("int probe;\n");
a("#endif\n");
#endif
a("{\n");
a("  if ((cov_o_.data[probe] & %u) == 0)\n",
nM);
a("    %s(&cov_o_, probe, %u);\n",
nJ,
nM -1);
a("}\n");
}
if(!fW&&nT){
#if SYS_UNIX

a("#if defined(__STDC__) || defined(__cplusplus)\n");

a("#if __SUNPRO_CC\n");
a("inline\n");
a("#endif\n");
#endif
a("static int cov_c_(int probe, int event)\n");
#if SYS_UNIX
a("#else\n");
a("static int cov_c_(probe, event)\n");
a("int probe;\n");
a("int event;\n");
a("#endif\n");
#endif
a("{\n");


a("  unsigned data = (unsigned)cov_o_.data[probe];\n");
a("  if ((data & (unsigned)(event + 1)) == 0 ||");
a(" (data & 0xf0) != 0)\n");
a("    event = %s(&cov_o_, probe, event);\n",nJ);
a("  return event;\n");
a("}\n");
}






a("#ifdef __cplusplus\n");
#if !SYS_UNIX
if(nP){

a("#if _MSC_VER >= 900\n");
a("extern \"C\" int __cdecl atexit(void (__cdecl *)(void));\n");
a("#endif\n");
}
#endif
a("#endif\n");
}

#if SYS_NT
a("#if _MSC_VER\n");
a("\t#undef DONT_RESOLVE_DLL_REFERENCES\n");
a("\t#define DONT_RESOLVE_DLL_REFERENCES 0\n");
a("#endif\n");
#endif

#if !SYS_UNIX
a(
"#if __BORLANDC__ && __STDC__\n"
"#pragma warn .nak\n"
"#endif\n");
#endif

a("/* C-Cover end of definitions */\n");
}

void of()
{
nU=1;
}

void of(unsigned P)
{
assert(P!=(unsigned)UINT_MAX);
if(fW){
a(" %s(&cov_o_, %u, %u);",
nJ,
P,nM -1);
}else{
a(" cov_h_(%u);",P);
}
nU=1;
}

void og bE(
unsigned,P,
unsigned,oh)
{
assert(P!=(unsigned)UINT_MAX);
assert(oh==1||oh==2);
if(fW){
a("(%s(&cov_o_, %u, %u),",
nJ,
P,2 -oh);
}
else{
a("(cov_c_(%u, %u),",
P,2 -oh);
}
nT=1;
}

void oi g(unsigned,P)
{
assert(P!=(unsigned)UINT_MAX);
if(fW){
a("%s(&cov_o_, %u, (",
nJ,
P);
}
else{
a("cov_c_(%u, (",
P);
}
nT=1;
}

void oj(void)
{
a(") ? %u : %u)",nL -1,nK -1);
}

void ok g(unsigned,P)
{
assert(P!=(unsigned)UINT_MAX);
if(fW){
a(
" %s(&cov_o_, %u, %u); {",
nJ,
P,nN -1);


}
else{
a(" cov_f_(%u); {",
P);

}
nV=1;
}

void bd a(const char*kn,...)
{
va_list ff;

va_start(ff,kn);
assert(nS!=NULL);
nS->vprintf(kn,ff);
va_end(ff);
}
