/* Copyright (c) Bullseye Testing Technology */


#include "fgq.h"
#include "rxcPvtuce.h"

#if _DEBUG
#include "fxGtrcg.h"
static Z op(aq::ac);
void aq::ac()
{
aq IF;
IG A={{1,2,3,4,0x90,0xa1,0xb2,0xc3}};
IG IH;
IG II;
IF.IJ(A,IH);
IF.IK(IH,II);
assert(memcmp(&A,&II,sizeof(IG))==0);
}
#endif


aq::ar aq::IL=
{0x10e26b2a,0xa9f8c74e,0x79fa7a20,0xe89dba09};

aq::aq()
{
memcpy(&as,&IL,sizeof(as));
}

aq::aq(const ar&as)
{
memcpy(&this->as,&as,sizeof(this->as));
}




void aq::IJ(const IG&A,IG&M) const
{
unsigned IM=(A.t[3]<<24)+(A.t[2]<<16)+(A.t[1]<<8)+A.t[0];
unsigned IN=(A.t[7]<<24)+(A.t[6]<<16)+(A.t[5]<<8)+A.t[4];
unsigned IO=0;
unsigned IP=0x9E3779B9;
unsigned I=32;

while(I-->0){
IO+=IP;
IM+=(IN<<4)+as.aB ^ IN+IO ^ (IN>>5)+as.kK;
IN+=(IM<<4)+as.kL ^ IM+IO ^ (IM>>5)+as.IQ;
}
M.t[0]=Hj(IM);
M.t[1]=Hj(IM>>8);
M.t[2]=Hj(IM>>16);
M.t[3]=Hj(IM>>24);
M.t[4]=Hj(IN);
M.t[5]=Hj(IN>>8);
M.t[6]=Hj(IN>>16);
M.t[7]=Hj(IN>>24);
}




void aq::IK(const IG&A,IG&M) const
{
unsigned IM=(A.t[3]<<24)+(A.t[2]<<16)+(A.t[1]<<8)+A.t[0];
unsigned IN=(A.t[7]<<24)+(A.t[6]<<16)+(A.t[5]<<8)+A.t[4];
unsigned IO=0xC6EF3720;
unsigned IP=0x9E3779B9;
unsigned I=32;

while(I-->0){
IN -=(IM<<4)+as.kL ^ IM+IO ^ (IM>>5)+as.IQ;
IM -=(IN<<4)+as.aB ^ IN+IO ^ (IN>>5)+as.kK;
IO -=IP;
}
M.t[0]=Hj(IM);
M.t[1]=Hj(IM>>8);
M.t[2]=Hj(IM>>16);
M.t[3]=Hj(IM>>24);
M.t[4]=Hj(IN);
M.t[5]=Hj(IN>>8);
M.t[6]=Hj(IN>>16);
M.t[7]=Hj(IN>>24);
}
