/* Copyright (c) Bullseye Testing Technology */



















#include "fgq.h"
#include "ybfabpr.h"
#include "gbqinpn.h"
#include "rbifpy.h"
#include "rbiipe.h"
#include "yvsr.h"
#include "bcg.h"
#include "gncu.h"
#include "fercf.h"
#include "gz.h"

#if _MSC_VER&&!_DEBUG
#pragma optimize("s", on)
#endif







static dw cF;
static dw dx;
static dw dz;
static int q8;
static int cG;
static int rw;
static int cH;

static cI e[]={
{"-",NULL,"Actions:"},
{"?",(int*)&cF,NULL},
{"a:autosave",(int*)&cF,"N Automatically save data older than N seconds"},
{"h help",(int*)&cF,"Display this usage summary"},
{"l list",(int*)&cF,"List coverage data file contents"},
{"m compact",(int*)&cF,"Compact the file"},
{"r remove",(int*)&cF,"Remove coverage structure of specified sources"},
{"s rmsub",(int*)&cF,"Remove substitution list"},

{"-",NULL,"Options:"},
{"c create",&q8,"Create coverage data file if it does not exist"},
{"d:srcdir",(int*)&dz,"Dir Source file directory is Dir"},
{"f:file",(int*)&dx,"Path Coverage data file is Path"},
{"q quiet",&cH,"Quiet"},
{"v verbose",&cH,"Verbose"},
{"  no-banner",&cG,"Suppress startup banner"},
{"  probe",&rw,NULL},
};










static void rx g(const char**,ry)
{
if(ry[0]!=NULL&&cH!='q'){
cT(ja);
}
}







static void rz g(X,lU)
{
if(lU==0){
printf("autosave disabled\n");
}else if(lU==0xffffffff){
printf("autosave interval set to default (1 second)\n");
}else{
printf("autosave interval set to %lu second",lU);
if(lU!=1){
printf("s");
}
printf("\n");
}
}







static bool rA g(const char**,ry)
{
bool V;
char*kf=NULL;
X lU=strtoul(cF.n,&kf,0);
rx(ry);
if(kf==cF.n){
V=0;
cT(rB);
}else{

V=lT(lU);

if(V&&cH!='q'){
rz(lU);
}
}
return V;
}







static bool lQ(const char**rC)
{
bool V;
if(rC[0]==NULL){
cT(oH);
V=0;
}else{
unsigned z;
typedef fi rD;
rD*m=(rD*)malloc(sizeof(rD));
unsigned I=0;
fi L;
fi S;
L.J[0]='\0';

V=nr(rC,1);
if(V){
V=d5(m);
}
while(V&&i7(&L)){
bool rE=nj(L.J);
while(i8(&S)){
if(nj(S.J)){
rE=1;
}
}
if(rE){

unsigned D;
for(D=0;D<I;D++){
if(el(L.J,m[D].J)==0){
break;
}
}

if(D==I){
I++;
V=kR((void**)&m,I*(X)sizeof(m[0]));
if(V){
m[I -1]=L;
}else{
cT(rF);
}
}
}
}
for(z=0;z<I;z++){
fi nk;
nk=m[z];
if(!lB(&nk,1)){
V=0;
}
}
if(m!=d){
dk(m);
}
if(V){
V=im(ns);
}
}
return V;
}










static const char*rG g(struct tm*,rH)
{
static char p[sizeof("Mmm dd hh:mm:ss")];
if(rH->tm_year==0){

sprintf(p,"%-*s",(int)sizeof(p) -1,"");
}else{
time_t rI=time(NULL);
time_t rJ=fr(rH);
const char*bG;
assert(rI!=(time_t)-1);
assert(rJ!=(time_t)-1);
bG=asctime(rK(rJ));


sprintf(p,"%.6s ",bG+4);

if(p[4]=='0'){
p[4]=' ';
}

if(fq(rI,rJ)>365L/2*24*60*60||
fq(rI,rJ)<0)
{

sprintf(p+7,"%.4s    ",bG+20);
}else{

sprintf(p+7,"%.8s",bG+11);
}
}
assert(strlen(p)==sizeof(p) -1);
return p;
}








static void rL bE(
char*,p,
const char*,Q)
{
unsigned z;
for(z=0;Q[z]!='\0';z++){
if(Q[z]=='\\'){
p[z]='/';
}else{
p[z]=(char)tolower(Q[z]);
}
}
p[z]='\0';
}









static void rM(
fi*x,
bool rN,
const char**ry)
{
bool rO;
if(ry[0]==NULL){
rO=1;
}else{
unsigned z;
char rP[PATH_MAX];
char rQ[PATH_MAX];
rO=0;
rL(rP,x->kt);
for(z=0;ry[z]!=NULL;z++){
rL(rQ,ry[z]);
if(strstr(rP,rQ)!=NULL){
rO=1;
break;
}
}
}
if(rO){
if(cH=='v'){
const char*W;

if(rN){
W=rG(&x->ctime);
printf("%8lx  ",x->ej);
}else{
W=rG(&x->bc);
printf("          ");
}
printf("%s  ",W);
}
printf("%s\n",x->kt);
}
}







static bool H g(const char**,ry)
{
bool V=1;
fi L;
fi S;

if(cH=='v'){
printf("Id        ");
printf("Modify Time      File\n");
printf("--------  ");
printf("------------     ------\n");
}

while(i7(&L)){
rM(&L,1,ry);
while(i8(&S)){

rM(&S,0,ry);
if(rw){

d_ P;
while(lr(&P)){
const char*E;
switch(P.E){
case e7:E="catch";break;
case e9:E="function";break;
case e8:E="label";break;
case ea:E="condition";break;
case ee:E="constant";break;
case eb:E="decision";break;
case ef:E="function not measured";break;
default:E="unknown";break;
}
printf("%u:%u(%u) %s %c%c %s\n",
P.G,P.eG.I,P.eG.eJ,
E,
P.ec,P.ed,
P.y);
}
}
}
}
if(V&&cH=='v'){
unsigned rR;
unsigned rS;
rz(lV());
rT(rR,rS);
printf("Free blocks: %u, bytes: %u\n",rR,rS);

{
X l9;
X mc;
rU(&l9,&mc);
if(mc!=0){
printf("Compression: %lu/%lu=%lu%%\n",
mc -l9,mc,100*(mc -l9)/mc);
}
}
}
return V;
}



int rV(unsigned,const char**o)
{
bool V=1;
ERR w;
char cL[cM];
unsigned cK=0;
fy t;
t.w[0]='\0';
bool rW=0;

fz();
hZ();
cO();
w=cP(e,cQ(e),o,&cK,cL);
cR(cH);
if(cH!='q'&&!cG){
cS(stderr,"Manager");
}

if(w!=0){
V=0;
cT(w,cL);
}
if((V&&cF.e0=='\0')||
cF.e0=='?'||
cF.e0=='h')
{
fprintf(stderr,"Usage: %s -aN|--autosave N [options]\n",cr());
fprintf(stderr,"       %s -h|--help\n",cr());
fprintf(stderr,"       %s -l|--list [options] [sub-string ...]\n",
cr());
fprintf(stderr,"       %s -m|--compact\n",cr());
fprintf(stderr,"       %s -r|--remove [options] source ...\n",
cr());
fprintf(stderr,"       %s -s|--rmsub [options]\n",
cr());
cU(e,cQ(e));
V=0;
}


bool rX=0;

const char*x=ii(dx.n);
if(V&&cF.e0!='m'){

if(q8&&!e2(x)){
cT(ik,x);
V=il(&t,x,dz.n);
}else{
int k3=O_RDWR;
if(cF.e0=='l'&&!q8){
k3=O_RDONLY;
}
V=fF(&t,x,k3,dz.n);
}
rW=1;
rX=V;
}
if(V){
const char**ry=o+cK;
switch(cF.e0){
case'a':V=rA(ry);break;
case'l':V=H (ry);break;
case'm':V=k9(x,t.w);break;
case'r':V=lQ (ry);break;
case's':V=kz('s',NULL);break;
default:
assert(0);
break;
}
}
if(rX){
fI(&t);
}
if(rW&&fJ(&t)!=NULL){
V=0;
cq(fJ(&t));
}
if(V&&ferror(stdout)){
cT(fc,strerror(errno));
V=0;
}
fM();
ip();
c0(e,cQ(e));
c1();
return V?0:1;
}
