/***********************************************************************
 * $Id: covrtunx.h,v 1.30 1998/07/29 17:00:30 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *    C-Cover run-time definitions for Unix or POSIX.
 *
 * Platform Support
 *    error_write_screen
 */

/*========== POSIX.1 Interface =======================================*/

#include <errno.h>
#include <unistd.h>

#if defined(KERNEL)
#	undef errno
#	define errno COVRTUNX_errno
	static int errno = 0;
#endif

#if !defined(SEEK_SET)
#	define SEEK_SET 0
#	define SEEK_CUR 1
#endif

#if defined(Include_time_bullseye)
	#if !defined(timestruc)
		struct timespec {
			unsigned tv_sec;
			long tv_nsec;
		};
	#endif
	#if __convex__
		int nanosleep(const struct timespec* rqt, struct timespec* rmt)
		{
			cnx_thread_block(rqt->tv_sec * 1000000 + rqt->tv_nsec / 1000);
			rmt = rmt;
			return 0;
		}
	#else
		unsigned sleep(unsigned);
		int nanosleep(const struct timespec* rqt, struct timespec* rmt)
		{
			unsigned seconds = rqt->tv_sec;
			if (rqt->tv_nsec > 0) {
				seconds++;
			}
			sleep(seconds);
			rmt = rmt;
			return 0;
		}
	#endif
#endif

static void error_write_file(int fd, const char* s);
static void error_write_screen(const char* s)
{
	error_write_file(2, s);     /* write to stderr */
}
