/* $Id: covrt-user.c,v 1.6 1999/06/04 00:37:07 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *    C-Cover run-time definitions for user-defined operating system
 *
 *    C-Cover only requires a subset of the functionality of these
 *    functions.  See covrt.c for actual parameters.
 *
 *    Unless otherwise specified, section numbers are for POSIX.1:
 *      ISO/IEC 9945-1
 *      ANSI/IEEE Std 1003.1
 */

/* If you do not implement this, use -DCOVRT_NOATX=1 */
/* Otherwise, a successful return value from this function is REQUIRED. */
/* ANSI X3.159-1989 Section 4.10.4.2 */
int atexit(void (* function)(void))
{
	/* Successful return is 0 */
	return 1;
}

/* A definition of this name is REQUIRED. */
/* ANSI X3.159-1989 Section 4.1.3 */
#define errno Covrt_errno
int errno = 0;

/* A declaration of this name is REQUIRED. */
/* Section 2.4 */
#define EBUSY 16

/* An implementation of these names is NOT REQUIRED. */
/* If you do not implement this, use -DCOVRT_NOFCNTL=1 */
/* Section 6.5.2 */
struct flock {
	short l_type;
	short l_whence;
	long l_start;
	long l_len;
};
#define F_SETLKW 0
#define F_RDLCK 0
#define F_UNLCK 1
#define F_WRLCK 2
#define EINVAL 22
/* Successful return value from this function is NOT REQUIRED. */
int fcntl(int fildes, int cmd, struct flock* arg)
{
	/* Successful return is 0 */
	return -1;
}

/* Successful return value from this function is NOT REQUIRED. */
/* Section 4.6.1 */
#define getenv Covrt_getenv
char* getenv(const char* name)
{
	/* Successful return is not NULL */
	return NULL;
}

/* Successful return value from this function is REQUIRED. */
/* Section 5.3.1 */
#undef S_IRUSR
#undef S_IWUSR
#define S_IRUSR 0
#define S_IWUSR 0
int open(const char* path, int oflag, int mode)
{
	/* Successful return is >= 0 */
	return -1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.3.1 */
int close(int fildes)
{
	/* Successful return is 0 */
	return 1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.4.1 */
int read(int fildes, void* buf, unsigned nbyte)
{
	/* Successful return is number of bytes read >= 0 */
	return -1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.4.2 */
int write(int fildes, const void* buf, unsigned nbyte)
{
	/* Successful return is number of bytes written >= 0 */
	return -1;
}

/* A declaration of this name is REQUIRED. */
/* Section 2.5 */
#if !defined(off_t)
	typedef long off_t;
#endif

/* Successful return value from this function is REQUIRED. */
/* Section 6.5.3 */
off_t lseek(int fildes, off_t offset, int whence)
{
	/* Successful return is >= 0 */
	return -1;
}

/* A declaration of this name is REQUIRED. */
/* Section 14.1.1 */
struct timespec {
	long tv_sec;
	long tv_nsec;
};

/* Successful return value from this function is NOT REQUIRED. */
/* Section 14.2.5 */
int nanosleep(const struct timespec* rqt, struct timespec* rmt)
{
	/* Successful return is 0 */
	return -1;
}

/* Section 2.5 */
typedef int pthread_t;

/* Successful return value from this function is NOT REQUIRED. */
/* Section 16.2.2 */
int pthread_create(
	pthread_t* thread,
	const void* attr,
	void* (* start_routine)(void*),
	void* arg)
{
	/* Successful return is 0 */
	return 1;
}

/* Section 16.2.5 */
void pthread_exit(void* value_ptr)
{
}

/* Successful return value from this function is NOT REQUIRED. */
/* Section 16.2.3 */
int pthread_join(pthread_t thread, void** value_ptr)
{
	/* Successful return is 0 */
	return 1;
}

/* This mutex implementation is unsafe, since it simulates a test-and-set.
 * But it is better than nothing.
 */
/* Section 2.5 */
/* Use a struct to contain the volatile modifier */
typedef struct {
	volatile unsigned is_taken;
} pthread_mutex_t;

/* Section 11.3.2 */
#define PTHREAD_MUTEX_INITIALIZER { 0 }

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
int pthread_mutex_lock(pthread_mutex_t* mutex)
{
	for (;;) {
		/* fake a "test and set" operation */
		if (mutex->is_taken == 0) {
			mutex->is_taken = 1;
			break;
		}
	}
	/* Successful return is 0 */
	return 0;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
int pthread_mutex_trylock(pthread_mutex_t* mutex)
{
	int status = 0;
	/* fake a "test and set" operation */
	if (mutex->is_taken == 0) {
		mutex->is_taken = 1;
	} else {
		status = EBUSY;
	}
	/* Successful return is 0 or EBUSY */
	return status;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
int pthread_mutex_unlock(pthread_mutex_t* mutex)
{
	mutex->is_taken = 0;
	/* Successful return is 0 */
	return 0;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.2 */
int pthread_mutex_destroy(pthread_mutex_t* mutex)
{
	/* Successful return is 0 */
	return 0;
}

/* C-Cover uses function error_write_screen to report an error to the screen */
static void error_write_screen(const char* s)
{
}
