/* $Id: covrt-memfile.h,v 1.2 1997/07/17 19:11:42 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *    C-Cover run-time definitions for simulated file i/o with whole
 *    file stored raw in target system memory.  This is useful if it is
 *    only possible to download or upload a whole file all at once.
 *
 * Platform Support
 *    memfile_cov_init
 *    memfile_cov_write
 *
 * POSIX Functions
 *    open, close, read, write, lseek
 */

/* The user provides the functions declared below. */

/* Get the size of the coverage file. */
unsigned long User_parse_arg(void);

/* Read the next byte from the coverage file. */
char User_get_byte(void);

/* Write the next byte to the coverage file. */
void User_put_byte(char byte);

/* The memfile */
static struct {
	unsigned long size;
	unsigned long next;
	char* memory;
} memfile;

/* Read coverage file from the host into memfile and call cov_init.
 * The test program calls this as soon as possible after startup.
 */
void memfile_cov_init()
{
	memfile.size = User_parse_arg();
	memfile.memory = malloc(memfile.size);
	if (memfile.memory != NULL) {
		unsigned long i;
		for (i = 0; i < memfile.size; i++) {
			memfile.memory[i] = User_get_byte();
		}
	}
	cov_init();
}

/* Write coverage file from memfile to the host.
 */
int memfile_cov_write()
{
	int status = cov_write();
	if (status == 0 && memfile.memory != NULL) {
		unsigned long i;
		for (i = 0; i < memfile.size; i++) {
			User_get_byte(memfile.memory[i]);
		}
	}
	return status;
}

#undef open
#define open(p,o,m) ((memfile.size > 0) ? 0 : -1)

#undef close
#define close(f) (memfile.seek = 0)

#undef read
#define read COVRT_read
static int read(int fildes, void* buf, unsigned nbyte)
{
	int n;
	char* b = buf;

	if (memfile.memory == NULL) {
		n = -1;
	} else {
		for (n = 0; (unsigned)n < nbyte && memfile.next < memfile.size; n++) {
			b[n] = memfile.memory[memfile.next++];
		}
	}
	return n;
}

#undef write
#define write COVRT_write
static int write(int fildes, const void* buf, unsigned nbyte)
{
	int n;
	char* b = buf;

	if (memfile.memory == NULL) {
		n = -1;
	} else {
		for (n = 0; (unsigned)n < nbyte && memfile.next < memfile.size; n++) {
			memfile.memory[memfile.next++] = b[n];
		}
	}
	return n;
}

#undef lseek
#define lseek COVRT_lseek
static off_t lseek(int fildes, off_t offset, int whence)
{
	if ((unsigned long)offset > memfile.size) {
		offset = (off_t)-1;
	} else {
		memfile.next = (unsigned long)offset;
	}
	return offset;
}
