/* $Id: covrt-hpKernel.c,v 1.3 1998/12/23 00:57:52 steve Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *    C-Cover run-time definitions for HP-UX kernel
 */

#define COVRT_NOATX 1
#define COVRT_NOENV 1
#define COVRT_NOFCNTL 1

/* A definition of this name is REQUIRED. */
/* ANSI X3.159-1989 Section 4.1.3 */
#undef errno
#define errno Covrt_errno
static int errno = 0;

/* A declaration of this name is REQUIRED. */
/* Section 2.4 */
#define EBUSY 16

/* Successful return value from this function is REQUIRED. */
/* Section 5.3.1 */
#undef S_IRUSR
#undef S_IWUSR
#define S_IRUSR 0
#define S_IWUSR 0
#define open Covrt_open
static int open(const char* path, int oflag, int mode) 
{
	/* Successful return is >= 0 */
	return -1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.3.1 */
#define close Covrt_close
static int close(int fildes)
{
	/* Successful return is 0 */
	return 1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.4.1 */
#define read Covrt_read
static int read(int fildes, void* buf, unsigned nbyte)
{
	/* Successful return is number of bytes read >= 0 */
	return -1;
}

/* Successful return value from this function is REQUIRED. */
/* Section 6.4.2 */
#define write Covrt_write
static int write(int fildes, const void* buf, unsigned nbyte)
{
	/* Successful return is number of bytes written >= 0 */
	return -1;
}

/* A declaration of this name is REQUIRED. */
/* Section 2.5 */
#if !defined(off_t)
	typedef long off_t;
#endif

/* Successful return value from this function is REQUIRED. */
/* Section 6.5.3 */
#define lseek Covrt_lseek
static off_t lseek(int fildes, off_t offset, int whence)
{
	/* Successful return is >= 0 */
	return -1;
}

/* A declaration of this name is REQUIRED. */
/* Section 14.1.1 */
#define timespec Covrt_timespec
struct timespec {
	long tv_sec;
	long tv_nsec;
};

/* Successful return value from this function is NOT REQUIRED. */
/* Section 14.2.5 */
#define nanosleep Covrt_nanosleep
static int nanosleep(const struct timespec* rqt, struct timespec* rmt)
{
	/* Successful return is 0 */
	return -1;
}

/* Section 2.5 */
typedef int pthread_t;

/* Successful return value from this function is NOT REQUIRED. */
/* Section 16.2.2 */
static int pthread_create(
	pthread_t* thread,
	const void* attr,
	void* (* start_routine)(void*),
	void* arg)
{
	/* Successful return is 0 */
	return 1;
}

/* Section 16.2.5 */
static void pthread_exit(void* value_ptr)
{
}

/* Successful return value from this function is NOT REQUIRED. */
/* Section 16.2.3 */
static int pthread_join(pthread_t thread, void** value_ptr)
{
	/* Successful return is 0 */
	return 1;
}

/* Section 2.5 */
typedef struct {
	volatile unsigned is_taken;
} pthread_mutex_t;

/* Section 11.3.2 */
#define PTHREAD_MUTEX_INITIALIZER { 0 }

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
static int pthread_mutex_lock(pthread_mutex_t* mutex)
{
	for (;;) {
		/* fake a "test and set" operation */
		if (mutex->is_taken == 0) {
			mutex->is_taken = 1;
			break;
		}
	}
	return 0;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
static int pthread_mutex_trylock(pthread_mutex_t* mutex)
{
	int status = 0;
	/* fake a "test and set" operation */
	if (mutex->is_taken == 0) {
		mutex->is_taken = 1;
	} else {
		status = EBUSY;
	}
	return status;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.3 */
static int pthread_mutex_unlock(pthread_mutex_t* mutex)
{
	mutex->is_taken = 0;
	return 0;
}

/* Successful return value from this function is REQUIRED. */
/* Section 11.3.2 */
static int pthread_mutex_destroy(pthread_mutex_t* mutex)
{
	/* Successful return is 0 */
	return 0;
}

/* C-Cover uses function error_write_screen to report an error to the screen */
static void error_write_screen(const char* s)
{
}
