/***********************************************************************
 * $Id: config.c,v 1.83 2000/05/12 22:01:05 paul Exp $
 * Copyright (c) Bullseye Testing Technology
 *
 * Purpose
 *      Compiler and library configuration tests.
 *      This file contains a set of independent programs that check for
 *      features of the compiler and library.  Select a specific program
 *      by defining its conditional macro.  Some programs indicate
 *      feature availability by a successfully compile or link.  Other
 *      programs are run and return a status code.
 *
 * Usage
 *      cc -DCONFIG_xxx=1 -c config.c
 *      cc -DCONFIG_xxx=1 -o config config.c
 *
 * Implementation Notes
 *      Do not use the symbols stdin, stdout, stderr since these are
 *      functions on VxWorks.
 */

#define SYS_UNIX 1

#if SYS__IRIX64
#	define __EXTENSIONS__ 1
#endif
#if SYS__OSF1
#	define _XOPEN_SOURCE 1
#endif
#define _POSIX_C_SOURCE 199506
#if __GNUC__
#   define __USE_FIXED_PROTOTYPES__ 1
#endif
#if (__hpux || SYS__HPUX) && !defined(_HPUX_SOURCE)
#	define _HPUX_SOURCE 1
#endif

#if CONFIG_convex
/* Compile */
#if !__convex__
	error
#endif
#define DONE
#undef CONFIG_fail
#endif

#if Config_bool
/* compile */
int main() {
 	bool b;
	b = false;
	b = true;
	return 0;
}
#define DONE
#endif

#if CONFIG_defect
/* compile and run */
#if __STDC__
	/* check for AIX defect in compiler xlc/xlC */
#	include <stdio.h>
	int status =  0;
	int defect(const char * s) {
		printf("defect %s\n", s);
		status = 1;
		return 0;
	}
	void f(const char *c)
	{
#		if 0
			/* C-Cover does not use this anymore */
			((void)((c != ((void *)0)) || (defect("1"),0)));
#		endif
		((void)((c != ((void *)0)) || defect("2")));
	}
	int main(void)
	{
		f(__FILE__);
		return status;
	}
#else
	int main(void) { return 0; }
#endif
#define DONE
#undef CONFIG_fail
#endif

#if Config_exceptions
static void f() { throw 0; }
int main() {
	int status = 1;
	try { f(); } catch (int i) { status = i; }
	return status;
}
#define DONE
#undef CONFIG_fail
#endif

#if Config_gnu
int main() {
	#if __GNUC__
		return 0;
	#else
		return 1;
	#endif
}
#define DONE
#endif

#if CONFIG_mode_C
/* compile and run */
#if __cplusplus
	#error C++ mode
#endif
int main() { return 0; }
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_mode_Cpp
/* compile and run */
#if !__cplusplus
	#error C mode
#endif
int main() { return 0; }
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_exemplar
/* compile */
#define PTHREAD_exemplar 1
#include "libc0/pthread.h"
int main(void) { return 0; }
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_pSOS
/* compile */
#include <errno.h>
#if EPHILE
#else
	error: not pSOS
#endif
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_include
/* compile */
#include <stdio.h>
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_link
/* link */
#include <stdio.h>
int main(void) { printf("\n"); return 0; }
#define DONE
#endif

#if CONFIG_VxWorks
/* compile */
#include <stdio.h>
#if \
	defined(VXWORKS) || \
	defined(_EXTENSION_WRS) || \
	defined(__VXWORKS__) || \
	defined(__vxworks)
#else
error: not VxWorks
#endif
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_fnmatch
/* run */
#include <fnmatch.h>
int main(void)
{
	int success;
	success = fnmatch("/", "/", FNM_PATHNAME) == 0;
	if (success)
		success = fnmatch("*", "/", FNM_PATHNAME) != 0;
	return success ? 0 : 1;
}
#define DONE
#endif

#if CONFIG_stdarg
/* run */
#include <stdarg.h>
int f(const char* a, ...)
{
	int i;
	va_list ap;
	va_start(ap, a);
	i = va_arg(ap, int);
	va_end(ap);
	return i;
}
int main(void) { return (f("", 123) == 123) ? 0 : 1; }
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_limits
/* compile */
#include <limits.h>
int int_max = INT_MAX;
unsigned uint_max = UINT_MAX;
unsigned long ulong_max = ULONG_MAX;
#if INT_MAX > UINT_MAX
	#error "INT_MAX > UINT_MAX"
#endif
#if LONG_MAX > ULONG_MAX
	#error "LONG_MAX > ULONG_MAX"
#endif
#if INT_MAX > LONG_MAX
	#error "INT_MAX > LONG_MAX"
#endif
#if UINT_MAX > ULONG_MAX
	#error "UINT_MAX > ULONG_MAX"
#endif
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_pthread
/* run */
#include <signal.h>     /* For SGI IRIX */
#include <stdio.h>
#include <pthread.h>
#ifdef __cplusplus
extern "C"
#endif
void* f(void* arg) { return arg; }
int main(void) {
	static pthread_mutex_t m = PTHREAD_MUTEX_INITIALIZER;
	pthread_t t;
	int status1 = pthread_mutex_lock(&m);
	int status2 = pthread_mutex_unlock(&m);
	int status3 = pthread_mutex_destroy(&m);
	/* Do not use NULL below */
	int status4 = pthread_create(&t, 0, f, 0);
	return status1 | status2 | status3 | status4;
}
#define DONE
#endif

#if CONFIG_stddef
/* compile */
/* sys/types.h might define size_t so we include it to verify its
 * definition is compatible with stddef.h */
#include <sys/types.h>
#include <stddef.h>
size_t size;
char * null = NULL;
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_stdlib
/* compile */
#include <stdlib.h>
int main(void) {
	div_t div;
	void* p = malloc(1);
	free(p);
	div.quot = 0;
	div.rem = div.quot;
	return 0;
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_stdtypes
/* compile */
#include <sys/stdtypes.h>
size_t size;    /* necessary for Convergent */
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_nanosleep
#include <time.h>
int main()
{
	struct timespec rqt;
	rqt.tv_sec = 0;
	/* 0.01 seconds */
	rqt.tv_nsec = 10000000;
	return nanosleep(&rqt, 0);
}
#define DONE
#endif

#if CONFIG_unistd
/* compile */
#include <unistd.h>
/* F_OK and SEEK_SET may be defined elsewhere */
#define DONE
#undef CONFIG_fail   /* too much touble under Solaris */
#endif

#if CONFIG_wait
#include <sys/types.h>
#include <sys/wait.h>
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_cplusplus
int main(void) {
#if __cplusplus
	return 0; /* true */
#else
	return 1; /* false */
#endif
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_cpp
/* compile with -E */
#include <stdio.h>
int main(void) { printf("cpp_check\n"); return 0; }
/* comment_check */
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_compile
/* compile */
int main(void) {
	return 0;
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_ascii
/* run */
int main(void) {
	if (' ' == 32)
		return 0; /* true */
	else
		return 1; /* false */
}
#define DONE
#endif

#if CONFIG_atexit
/* run */
#include <stdio.h>
#include <stdlib.h>
#ifdef __cplusplus
extern "C"
#endif
void f(void) { }
int main(void) {
	return atexit(f);
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_onexit
#include <stdio.h>
/* run */
#ifdef __cplusplus
extern "C"
#endif
void f(void) {
	printf("ok\n");
}
int main(void) {
	on_exit(f);
	return 0;
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_ctype
/* run */
#include <ctype.h>
#include <stdio.h>
char dig[] = "0123456789";
char pun[] = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
char lwr[] = "abcdefghijklmnopqrstuvwxyz";
char upr[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
char xdg[] = "0123456789abcdefABCDEF";
int status = 0;
#undef verify
#define verify(expr) { if (!(expr)) { printf("ctype %u\n", __LINE__); status = 1; } }
int in(char * set, int c)
{
	int i;
	for (i = 0; set[i] != '\0'; i++)
		if (c == set[i])
			break;
	return set[i] != '\0';
}
int main(void) {
	int c;
	verify(tolower(EOF) == EOF);
	verify(toupper(EOF) == EOF);
	verify(!isalnum(EOF));
	verify(!isalpha(EOF));
	verify(!iscntrl(EOF));
	verify(!isdigit(EOF));
	verify(!isgraph(EOF));
	verify(!islower(EOF));
	verify(!isprint(EOF));
	verify(!ispunct(EOF));
	verify(!isspace(EOF));
	verify(!isupper(EOF));
	verify(!isxdigit(EOF));
	verify(tolower('A') == 'a');
	verify(tolower('a') == 'a');
	verify(tolower('1') == '1');
	verify(toupper('A') == 'A');
	verify(toupper('a') == 'A');
	verify(toupper('1') == '1');
	verify(isspace('\t'));
	verify(isspace('\n'));
	verify(isspace('\r'));
	verify(isspace(' '));
	for (c = EOF; c < 0x100; c++) {
		if (isalpha(c))  verify(in(lwr, c) || in(upr, c));
		if (in(lwr, c))  verify(isalpha(c) && islower(c));
		if (in(upr, c))  verify(isalpha(c) && isupper(c));
		if (isdigit(c))  verify(in(dig, c));
		if (in(dig, c))  verify(isdigit(c));
		if (ispunct(c))  verify(in(pun, c));
		if (in(pun, c))  verify(ispunct(c));
		if (isxdigit(c)) verify(in(xdg, c));
		if (in(xdg, c))  verify(isxdigit(c));
		if (in(lwr, c))  verify(in(upr, toupper(c)));
		if (in(upr, c))  verify(in(lwr, tolower(c)));
	}
	return status;
}
#define DONE
#endif

#if CONFIG_fcntl
/* run to see if fcntl working */
/* compile to see if flock declared */
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

int f(int mode)
{
	int s1 = 0;
	int s2 = 0;
	int e1 = 0;
	int e2 = 0;
	struct flock l;
	int f = open(__FILE__, mode, 0);
	if (f == -1) {
		printf("cannot open %s: %s\n", __FILE__, strerror(errno));
		exit(1);
	}
	l.l_whence = 0;
	l.l_start = 0;
	l.l_len = 1;
	alarm(4);   /* avoid hanging as on DEC OSF */
	errno = 0;
	l.l_type = F_RDLCK;
	if (fcntl(f, F_SETLKW, &l) == -1) {
		e1 = errno;
		s1 = 1;
	} else {
		l.l_type = F_UNLCK;
		if (fcntl(f, F_SETLKW, &l) == -1) {
			e1 = errno;
			s1 = 2;
		}
	}
	if (mode == O_RDWR) {
		l.l_type = F_WRLCK;
		if (fcntl(f, F_SETLKW, &l) == -1) {
			e2 = errno;
			s2 = 1;
		} else {
			l.l_type = F_UNLCK;
			if (fcntl(f, F_SETLKW, &l) == -1) {
				e2 = errno;
				s2 = 2;
			}
		}
	}
	if (s1 + s2 != 0) {
		printf("mode %s\n", mode == O_RDWR ? "O_RDWR" : "O_RDONLY");
		printf("status %d %d\n", s1, s2);
		printf("%s, %s\n", strerror(e1), strerror(e2));
	}
	return s1 + s2;
}
int main(void) {
	int s = f(O_RDWR);
	s += f(O_RDONLY);
	return s;
}
#define DONE
#endif

#if CONFIG_getenv
/* link and optionally run */
#include <stdlib.h>
int main(void) {
	char * a = getenv("a");
	a = a;
	return 0;
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_io
/* run */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#if !defined(S_IRUSR) || !defined(S_IWUSR)
#	define S_IRUSR S_IREAD
#	define S_IWUSR S_IWRITE
#endif
#if !defined(S_IRGRP) || !defined(S_IWGRP)
#	define S_IRGRP S_IREAD
#	define S_IWGRP S_IWRITE
#endif
#if !defined(S_IROTH) || !defined(S_IWOTH)
#	define S_IROTH S_IREAD
#	define S_IWOTH S_IWRITE
#endif

int main(void)
{
	char status = 0;
	char * path = "configio.tmp";
	char buf[99];
	int fd = open(path, O_WRONLY | O_CREAT,
		S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
	if (fd == -1) {
		status = '1';
	}
	if (lseek(fd, 0L, SEEK_END) != 0) {
		status = '2';
	}
	if (status == 0 && write(fd, "hello world\n", 12) <= 0) {
		status = '3';
	}
	if (status == 0 && close(fd) != 0) {
		status = '4';
	}
	if (status == 0) {
		fd = open(path, O_RDWR, 0);
		if (fd == -1) {
			status = '5';
		}
	}
	if (status == 0 && read(fd, buf, 11) <= 0) {
		status = '6';
	}
	if (lseek(fd, 0L, SEEK_SET) != 0) {
		status = '7';
	}
	if (status == 0 && write(fd, "12345", 5) <= 0) {
		status = '8';
	}
	if (status == 0 && close(fd) != 0) {
		status = '9';
	}
	if (status == 0) {
		remove(path);
		fd = open(path, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR);
		if (fd == -1) {
			status = 'a';
		}
	}
	if (status == 0 && close(fd) != 0) {
		status = 'b';
	}
	if (status == 0) {
		remove(path);
	} else {
		write(2, "status ", 7);
		write(2, &status, 1);
		write(2, "\n", 1);
	}
	return status;
}
#define DONE
#endif

#if CONFIG_lwp
/* run */
#include <synch.h>
#include <sys/lwp.h>
int main(void)
{
	static lwp_mutex_t mutex;
	_lwp_mutex_lock(&mutex);
	_lwp_mutex_unlock(&mutex);
	return 0;
}
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_off
/* compile */
#include <sys/types.h>
off_t off;
int main(void) { return 0; }
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_pid
/* compile */
#include <sys/types.h>
pid_t pid;
#define DONE
#undef CONFIG_fail
#endif

#if CONFIG_remove
/* link */
#include <stdio.h>
#include <stdlib.h>
int main(void) { remove(""); return 0; }
#define DONE
#endif

#if CONFIG_time
#include <time.h>
int main() { return 0; }
#define DONE
#endif

#if Config_typename
template <typename T> class C {
public:
	T* m;
	T* f();
};
C<int> c;
#define DONE
#undef CONFIG_fail
#endif

#ifndef DONE
	error: no configuration check selected
#endif

#if CONFIG_fail
	error: configuration failure forced
#endif
