#include <assert.h>
#include <stdio.h>
#include "calc3stk.h"

stack::~stack()
{
	stack_node * p = top;
	while (p != 0) {
		stack_node * plink = p->link;
		delete(p);
		p = plink;
	}
}

void stack::selftest()
{
	stack s;
	s.push(0);
	int n = s.pop();
	assert(n == 0);
	s.push(1);
	n = s.pop();
	assert(n == 1);
	s.push(2);
	s.push(3);
	n = s.pop();
	assert(n == 3);
	n = s.pop();
	assert(n == 2);
	#if 0
		/* test underflow */
		n = s.pop();
	#endif
}
