// simple postfix calculator, in C++

#include <ctype.h>
#include <stdio.h>
#include "calc3stk.h"
#undef isdigit
int main()
{
	int c = 0;
	int temp;
	int quit;
	stack stk;

	stk.selftest();
	printf("Enter reverse-polish expressions, q to quit\n");
	quit = 0;
	while (!quit &&
		(c = fgetc(stdin)) != EOF)
	{
		switch (c) {
		case ' ':
		case '\n':
			break;
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			temp = 0;
			for (; isdigit(c); c = fgetc(stdin)) {
				temp = temp * 10 + (c - '0');
			}
			ungetc(c, stdin);
			stk.push(temp);
			break;
		case '+':
			stk.push(stk.pop() + stk.pop());
			break;
		case '*':
			stk.push(stk.pop() * stk.pop());
			break;
		case '-':
			temp = stk.pop();
			stk.push(stk.pop() - temp);
			break;
		case '/':
			temp = stk.pop();
			if (temp == 0)
				printf("division by zero\n");
			else
				stk.push(stk.pop() / temp);
			break;
		case '=':
			temp = stk.pop();
			stk.push(temp);
			printf("%d\n", temp);
			break;
		case 'q':
			quit = 1;
			break;
		default:
			printf("unrecognized: %c\n", c);
			break;
		}
	}
	return 0;
}
