/* simple reverse-polish calculator */
/* This program can be compiled with K&R C */
#include <ctype.h>
#include <stdio.h>
#undef isdigit
static int stack[100];
static int top = 0;

#if __STDC__ || __cplusplus || _MSC_VER || __BORLANDC__ || __IBMC__
#define Pvoid void
static void push(int data)
#else
#define Pvoid
static void push(data)
	int data;
#endif
{
	stack[top++] = data;
}

static int pop(Pvoid)
{
	return (top > 0) ? stack[--top] : 0;
}

static int Input(Pvoid)
{
	return getchar();
}

int main()
{
	int c = 0;
	int temp;
	int quit;

	printf("Enter reverse-polish expressions, q to quit\n");
	quit = 0;
	while (!quit &&
		(c = Input()) != EOF)
	{
		switch (c) {

		case ' ':
		case '\n':
			break;

		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			temp = 0;
			for (; isdigit(c); c = Input()) {
				temp = temp * 10 + (c - '0');
			}
			ungetc(c, stdin);
			push(temp);
			break;

		case '+': push(pop() + pop()); break;

		case '*': push(pop() * pop()); break;

		case '-': temp = pop(); push(pop() - temp); break;

		case '/':
			temp = pop();
			if (temp == 0)
				printf("division by zero\n");
			else
				push(pop() / temp);
			break;

		case '=':
			temp = pop();
			push(temp);
			printf("%d\n", temp);
			break;

		case 's':
			if (top != 0) {
				temp = 0;
				do {
					printf("%d ", stack[temp]);
					temp++;
				} while (temp < top);
				printf("\n");
			}
			break;

		case 'q':
			quit = 1;
			break;

		default:
			printf("unrecognized: %c\n", c);
			break;
		}
	}

	return 0;
}
