#
# Makefile to build C-Cover text mode sample programs.
# To build with C-Cover, run "cov01 -1" before building
#

o = .obj
e = .exe
o = .o                      
e =                         
CC = gcc                    
LIBS = -lg++                
#LIBS = -lg++ -liostream

default: calc1$e calc2$e    
all: calc1$e calc2$e calc3$e

# Generate some coverage data
data: calc1$e calc2$e
	echo 123 456 + 2 / = | calc1
	echo 123 + 456 / 2   | calc2
data3: calc3$e
	echo 123 456 + 2 / = | calc3

calc1$e: calc1$o
	$(CC) calc1$o
	mv a.out $@     
calc2$e: calc2$o
	$(CC) calc2$o
	mv a.out $@     
calc3$e: calc3$o calc3stk$o
	$(CC) calc3$o calc3stk$o $(LIBS)
	mv a.out $@     

calc1$o:    calc1.c
calc2$o:    calc2.c
calc3$o:    calc3.cpp calc3stk.h
	$(CC) -c $*.cpp
calc3stk$o: calc3stk.cpp calc3stk.h
	$(CC) -c $*.cpp

clean:
	rm -f calc*$o calc*.exe calc1 calc2 calc3
