#if defined( sun )                    /* Newer Sparc's */
#  define BF_PTR
#elif defined( __ultrix )     /* Older MIPS */
#  define BF_PTR
#elif defined( __osf1__ )     /* Alpha */
  /* None */
#elif defined ( _AIX )                /* RS6000 */
  /* Unknown */
#elif defined( __hpux )               /* HP-PA */
  /* None */
#elif defined( __aux )                /* 68K */
  /* Unknown */
#elif defined( __dgux )               /* 88K (but P6 in latest boxes) */
  /* Unknown */
#elif defined( __sgi )                /* Newer MIPS */
#  define BF_PTR
#elif defined( i386 )         /* x86 boxes, should be gcc */
#elif defined( _MSC_VER )     /* x86 boxes, Visual C */
#endif /* Systems-specific speed defines */

#undef c2l
#define c2l(c,l)	(l =((unsigned long)(*((c)++)))    , \
			 l|=((unsigned long)(*((c)++)))<< 8L, \
			 l|=((unsigned long)(*((c)++)))<<16L, \
			 l|=((unsigned long)(*((c)++)))<<24L)

/* NOTE - c is not incremented as per c2l */
#undef c2ln
#define c2ln(c,l1,l2,n)	{ \
			c+=n; \
			l1=l2=0; \
			switch (n) { \
			case 8: l2 =((unsigned long)(*(--(c))))<<24L; \
			case 7: l2|=((unsigned long)(*(--(c))))<<16L; \
			case 6: l2|=((unsigned long)(*(--(c))))<< 8L; \
			case 5: l2|=((unsigned long)(*(--(c))));     \
			case 4: l1 =((unsigned long)(*(--(c))))<<24L; \
			case 3: l1|=((unsigned long)(*(--(c))))<<16L; \
			case 2: l1|=((unsigned long)(*(--(c))))<< 8L; \
			case 1: l1|=((unsigned long)(*(--(c))));     \
				} \
			}

#undef l2c
#define l2c(l,c)	(*((c)++)=(unsigned char)(((l)     )&0xff), \
			 *((c)++)=(unsigned char)(((l)>> 8L)&0xff), \
			 *((c)++)=(unsigned char)(((l)>>16L)&0xff), \
			 *((c)++)=(unsigned char)(((l)>>24L)&0xff))

/* NOTE - c is not incremented as per l2c */
#undef l2cn
#define l2cn(l1,l2,c,n)	{ \
			c+=n; \
			switch (n) { \
			case 8: *(--(c))=(unsigned char)(((l2)>>24L)&0xff); \
			case 7: *(--(c))=(unsigned char)(((l2)>>16L)&0xff); \
			case 6: *(--(c))=(unsigned char)(((l2)>> 8L)&0xff); \
			case 5: *(--(c))=(unsigned char)(((l2)     )&0xff); \
			case 4: *(--(c))=(unsigned char)(((l1)>>24L)&0xff); \
			case 3: *(--(c))=(unsigned char)(((l1)>>16L)&0xff); \
			case 2: *(--(c))=(unsigned char)(((l1)>> 8L)&0xff); \
			case 1: *(--(c))=(unsigned char)(((l1)     )&0xff); \
				} \
			}

/* NOTE - c is not incremented as per n2l */
#define n2ln(c,l1,l2,n)	{ \
			c+=n; \
			l1=l2=0; \
			switch (n) { \
			case 8: l2 =((unsigned long)(*(--(c))))    ; \
			case 7: l2|=((unsigned long)(*(--(c))))<< 8; \
			case 6: l2|=((unsigned long)(*(--(c))))<<16; \
			case 5: l2|=((unsigned long)(*(--(c))))<<24; \
			case 4: l1 =((unsigned long)(*(--(c))))    ; \
			case 3: l1|=((unsigned long)(*(--(c))))<< 8; \
			case 2: l1|=((unsigned long)(*(--(c))))<<16; \
			case 1: l1|=((unsigned long)(*(--(c))))<<24; \
				} \
			}

/* NOTE - c is not incremented as per l2n */
#define l2nn(l1,l2,c,n)	{ \
			c+=n; \
			switch (n) { \
			case 8: *(--(c))=(unsigned char)(((l2)    )&0xff); \
			case 7: *(--(c))=(unsigned char)(((l2)>> 8)&0xff); \
			case 6: *(--(c))=(unsigned char)(((l2)>>16)&0xff); \
			case 5: *(--(c))=(unsigned char)(((l2)>>24)&0xff); \
			case 4: *(--(c))=(unsigned char)(((l1)    )&0xff); \
			case 3: *(--(c))=(unsigned char)(((l1)>> 8)&0xff); \
			case 2: *(--(c))=(unsigned char)(((l1)>>16)&0xff); \
			case 1: *(--(c))=(unsigned char)(((l1)>>24)&0xff); \
				} \
			}

#undef n2l
#define n2l(c,l)        (l =((unsigned long)(*((c)++)))<<24L, \
                         l|=((unsigned long)(*((c)++)))<<16L, \
                         l|=((unsigned long)(*((c)++)))<< 8L, \
                         l|=((unsigned long)(*((c)++))))

#undef l2n
#define l2n(l,c)        (*((c)++)=(unsigned char)(((l)>>24L)&0xff), \
                         *((c)++)=(unsigned char)(((l)>>16L)&0xff), \
                         *((c)++)=(unsigned char)(((l)>> 8L)&0xff), \
                         *((c)++)=(unsigned char)(((l)     )&0xff))

/* This is actually a big endian algorithm, the most significate byte
 * is used to lookup array 0 */

/* use BF_PTR2 for intel boxes,
 * BF_PTR for sparc and MIPS/SGI
 * use nothing for Alpha and HP.
 */
#if !defined(BF_PTR) && !defined(BF_PTR2)
#undef BF_PTR
#endif

#define BF_M	0x3fc
#define BF_0	22L
#define BF_1	14L
#define BF_2	 6L
#define BF_3	 2L /* left shift */

#if defined(BF_PTR2)

/* This is basically a special pentium verson */
#define BF_ENC(LL,R,S,P) \
	{ \
	BF_LONG t,u,v; \
	u=R>>BF_0; \
	v=R>>BF_1; \
	u&=BF_M; \
	v&=BF_M; \
	t=  *(BF_LONG *)((unsigned char *)&(S[  0])+u); \
	u=R>>BF_2; \
	t+= *(BF_LONG *)((unsigned char *)&(S[256])+v); \
	v=R<<BF_3; \
	u&=BF_M; \
	v&=BF_M; \
	t^= *(BF_LONG *)((unsigned char *)&(S[512])+u); \
	LL^=P; \
	t+= *(BF_LONG *)((unsigned char *)&(S[768])+v); \
	LL^=t; \
	}

#elif defined(BF_PTR)

/* This is normally very good */

#define BF_ENC(LL,R,S,P) \
	LL^=P; \
	LL^= (((*(BF_LONG *)((unsigned char *)&(S[  0])+((R>>BF_0)&BF_M))+ \
		*(BF_LONG *)((unsigned char *)&(S[256])+((R>>BF_1)&BF_M)))^ \
		*(BF_LONG *)((unsigned char *)&(S[512])+((R>>BF_2)&BF_M)))+ \
		*(BF_LONG *)((unsigned char *)&(S[768])+((R<<BF_3)&BF_M)));
#else

/* This will always work, even on 64 bit machines and strangly enough,
 * on the Alpha it is faster than the pointer versions (both 32 and 64
 * versions of BF_LONG) */

#define BF_ENC(LL,R,S,P) \
	LL^=P; \
	LL^=(((	S[        (int)(R>>24L)      ] + \
		S[0x0100+((int)(R>>16L)&0xff)])^ \
		S[0x0200+((int)(R>> 8L)&0xff)])+ \
		S[0x0300+((int)(R     )&0xff)])&0xffffffffL;
#endif
