#include "blowfish.h"
#include "bf_locl.h"

/* Blowfish as implemented from 'Blowfish: Springer-Verlag paper'
 * (From LECTURE NOTES IN COIMPUTER SCIENCE 809, FAST SOFTWARE ENCRYPTION,
 * CAMBRIDGE SECURITY WORKSHOP, CAMBRIDGE, U.K., DECEMBER 9-11, 1993)
 */

char *BF_version="BlowFish part of SSLeay 0.9.0b 29-Jun-1998";

char *BF_options()
	{
#ifdef BF_PTR
	return("blowfish(ptr)");
#elif defined(BF_PTR2)
	return("blowfish(ptr2)");
#else
	return("blowfish(idx)");
#endif
	}

void BF_ecb_encrypt(in, out, ks, encrypt)
unsigned char *in;
unsigned char *out;
BF_KEY *ks;
int encrypt;
	{
	BF_LONG l,d[2];

	n2l(in,l); d[0]=l;
	n2l(in,l); d[1]=l;
	if (encrypt)
		BF_encrypt(d,ks);
	else
		BF_decrypt(d,ks);
	l=d[0]; l2n(l,out);
	l=d[1]; l2n(l,out);
	l=d[0]=d[1]=0;
	}

