/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  "Pointer Array" class			File: PTRARRAY.C	**
   **									**
   **  This is the "C" version of the CPtrArray class in MFC.		**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "ptrarray.h"

static void PtrArrayReset(PTRARRAY *p);
static int PtrArrayGrow(PTRARRAY *p);

PTRARRAY *PtrArrayCreate(void)
{
    PTRARRAY *p;

    p = calloc(1,sizeof(PTRARRAY));

    if (p) {
	PtrArrayReset(p);
	}

    return p;
}


void PtrArrayDestroy(PTRARRAY *p)
{
    if (p->ptrs) free(p->ptrs);
    free(p);
}


void PtrArrayReset(PTRARRAY *p)
{
    p->ptrs = (void **) calloc(16,sizeof(void *));
    p->size = 0;
    p->realsize = 16;
}


int PtrArrayGrow(PTRARRAY *p)
{
    void **newptrs;
    int newsize = p->realsize * 2;

    newptrs = (void **) calloc(newsize,sizeof(void *));

    if (newptrs) {
	memcpy(newptrs,p->ptrs,p->realsize*sizeof(void *));
        free(p->ptrs);
	p->ptrs = newptrs;
	p->realsize = newsize;
	return 1;
	}

    return 0;
}


void * PtrArrayGetAt(PTRARRAY *p,int idx)
{
    return  ((idx >= p->size) ? NULL : p->ptrs[idx]);
}

int PtrArrayGetSize(PTRARRAY *p)
{
    return p->size;
}

void PtrArrayRemoveAll(PTRARRAY *p)
{
    if (p->ptrs) free(p->ptrs);

    p->ptrs = NULL;
    p->size = 0;
    p->realsize = 0;

    PtrArrayReset(p);
}

void PtrArrayInsertAt(PTRARRAY *p,int idx,void *ptr)
{
    int t;

    if (idx > p->size) return;

    if (p->size == p->realsize) {
	PtrArrayGrow(p);
	}

    for (t = p->size+1; t > idx; t--) {
	p->ptrs[t] = p->ptrs[t-1];
	}

    p->ptrs[idx] = ptr;

    p->size++;
}

void PtrArrayRemoveAt(PTRARRAY *p,int idx)
{
    int t;

    if (idx >= p->size) return;

    for (t = idx; t < p->size-1; t++) {
	p->ptrs[t] = p->ptrs[t+1];
	}

    p->size--;
}



