/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  switch parser defs			File: SWPARSE.H		**
   **									**
   **  include file for the ugly switch parser				**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

/*  *********************************************************************
    *  Constants							*
    ********************************************************************* */


#define MAXARGS 10                      /* total number of parameters     */
#define MAXSWITCH 32                    /* total number of switches       */
#define LINELEN 200                     /* max length of input line       */


/*  *********************************************************************
    *  Structures							*
    ********************************************************************* */

typedef struct PSwitch{
        char * def;                 /* Switch definition                  */
        } PARSESWITCH;

typedef struct PItem{
        int               value;    /* return value to indicate this item */
        char            * def;      /* The parser pattern                 */
        int               count;    /* Number of switches                 */
        unsigned int    * pswitch;  /* List of switches                   */
        } PARSEITEM;

typedef struct PSet{
        int               count;        /* Number of Parse Items        */
        PARSEITEM       * objects;      /* The parse Items              */
        PARSESWITCH     * switchtab;    /* switch table pointer         */
        unsigned int   (**functions)(); /* Table of function ptrs       */
        } PARSESET;

int    swparse( char *, PARSESET * , char **);/* parse the line passed  */
int    switchset( int );                /* check for switch used        */
char * getarg( int , char * );          /* return argument number N     */
char * getswitch( int , char * );       /* return switch value          */
char * getrawargs();

#define SWPERROR -1
#define SWPDIGITS -2
#define SWPBLANK -3

