/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  command switch parser			File: SWPARSE.C		**
   **									**
   **  this is an old, old, old piece of that code that has found	**
   **  its way into way too many programs.  But, it works for me.	**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "swparse.h"

#ifdef __linux__
#define memicmp strncasecmp
#endif

/*  *********************************************************************
    *  Constants							*
    ********************************************************************* */


#define TRUE 1
#define FALSE 0

/*  *********************************************************************
    *  Structures							*
    ********************************************************************* */

typedef struct SwResult {
        int swnum;
        char *value;
        } SWRESULT;

typedef struct ArgResult {
        char *value;
        } ARGRESULT;

/*  *********************************************************************
    *  Globals								*
    ********************************************************************* */

static char outsw[LINELEN];             /* output line, just switches     */
static char outarg[LINELEN];            /* output line, no switches       */
static char errormsg[64];               /* error message from parser      */
static char *oldline = NULL;            /* last command we parsed         */
static SWRESULT swresult[MAXSWITCH] = {0}; /* result of switch parsing    */
static ARGRESULT argresult[MAXARGS] = {0}; /* result of argument parsing  */
static int numswitches = 0;
static char promptline[LINELEN];

PARSESET *curpset;                      /* current parse set              */

static int number = 0;

#ifdef TESTPROG
char inline[LINELEN];
#endif


static int isamatch(char *temp,char *str)
{
    char *x;
    int len2;
    int len1;

    x = strchr(temp,'*');
    if (x) len1 = x-temp;
    else len1 = strlen(temp);

    len2 = strlen(str);

    if (len2 < len1) return FALSE;          /* too short! */

    if (memicmp(str,temp,len1) == 0) {
	if (!x) return TRUE;
	if (memicmp(x+1,str+len1,strlen(str+len1)) == 0) return TRUE;
	}

    return FALSE;
}


static int lookupcmd(PARSESET *pset,char *cmdlin)
{
    char hacktemp[60];
    char *ptr;
    int item;
    int i,j;
    char *tok;
    int found;

    char *inargs[MAXARGS];
    int inargscnt;

    memset(&inargs[0],0,sizeof(inargs));
    memset(&argresult[0],0,sizeof(argresult));

    ptr = cmdlin;
    inargs[0] = ptr;
    inargscnt = 1;
    while (*ptr) {
	if (*ptr == ' ') {
	    *ptr++ = '\0';
	    if (!*ptr) break;
	    inargs[inargscnt] = ptr;
	    inargscnt++;
	    continue;
	    }
	if (*ptr == '"') {
	    if (inargs[inargscnt-1] == ptr) {
		inargs[inargscnt-1]++;
		ptr = strchr(ptr+1,'"');
		if (ptr && *ptr) *ptr++ = '\0';
		else break;
		continue;
		}
	    else {
		ptr++;
		while (*ptr && (*ptr != '"')) ptr++;
		if (*ptr == '"') ptr++;
		continue;
		}
	    }
	ptr++;
	}

    if (!pset) {
	for (i=0; i<inargscnt; i++) argresult[i].value = inargs[i];
	return 0;
	}

    item = -1;
    for (i=0; i<pset->count; i++) {
	if (!pset->objects[i].def) continue;
	strcpy(hacktemp,pset->objects[i].def);
	tok = strtok(hacktemp," ");
	j = 0;
	found = TRUE;
	while (tok && (*tok != '%')) {
	    if (j >= inargscnt) {
		found = FALSE;
		break;
		}
	    if (!isamatch(tok,inargs[j])) {
		found = FALSE;
		break;
		}
	    tok = strtok(NULL," ");
	    j++;
	    }
	if (!found) continue;
	if (item == -1) {
	    while (tok) {
		while (*tok && !isdigit(*tok)) tok++;
		if (!*tok) break;
		argresult[(*tok)-'0'].value = inargs[j];
		j++;
		tok = strtok(NULL," ");
		}
	    item = i;
	    }
	else {
	    sprintf(errormsg,"Ambiguous command: %s",cmdlin);
	    return -1;
	    }
	}

    if (item == -1) sprintf(errormsg,"Unrecognized command: %s",cmdlin);

    return item;
}

static int saveswitch(PARSESET *pset,PARSEITEM *pitem,char *sw)
{
    char *swname;
    char *swval;
    char *swtext;
    int swnum = -1;
    int matchlen;
    int i;

    swname = sw;
    while (*sw) {
	if (*sw == '=') break;
	if (*sw == ':') break;
	sw++;
	}

    if (!*sw) swval = NULL;
    else {
	*sw = '\0';
	sw++;
	swval = sw;
	if (*sw == '"') {
	    swval++;
	    if (sw = strchr(swval,'"')) *sw = '\0';
	    }
	}

    for (i = 0; i<pitem->count; i++) {
	swtext = pset->switchtab[pitem->pswitch[i]].def;

	if (isamatch(swtext,swname)) {
	    if (swnum == -1) swnum = pitem->pswitch[i];
	    else {
		sprintf(errormsg,"Switch is ambiguous: %s",swname);
		return FALSE;
		}
	    }
	}

    if (swnum == -1) {
	sprintf(errormsg,"Invalid switch: %s",swname);
	return FALSE;
	}
    else {
	if (numswitches >= MAXSWITCH) {
	    sprintf(errormsg,"Too many switches: %s",swname);
	    return FALSE;
	    }
	errormsg[0] = '\0';
	swresult[numswitches].swnum = swnum;
	swresult[numswitches].value = swval;
	numswitches++;
	return TRUE;
	}


}

static int getswitches(PARSESET *pset,PARSEITEM *pitem,char *swline)
{
    char *swname;
    int inquote;
    int found = FALSE;

    while (*swline) {
	inquote = FALSE;
	if (!found) {
	    while (*swline && (*swline != '/')) swline++;
	    if (!*swline) return TRUE;
	    swline++;
	    }
	swname = swline;
	while (*swline) {
	    if (*swline == '"') inquote = !inquote;
	    if (!inquote && (*swline == '/')) break;
	    swline++;
	    }
	found = TRUE;
	if (*swline) *swline++ = '\0';
	if (!saveswitch(pset,pitem,swname)) return FALSE;
	}

    return TRUE;
}


static int isalldigits(char *str)
{
    int res = TRUE;
    int digit = FALSE;

    if (!str) return FALSE;

    while (*str) {
	if (!isspace(*str)) {
	    if (!isdigit(*str)) res = FALSE;
	    else digit = TRUE;
	    }
	str++;
	}

    return (res && digit);
}


static void removeswitch(char *inp,char *cmdout,char *swout)
{
    int inswitch = FALSE;
    char *originp;
    char *origoutp;
    char *origswout;

    originp = inp;
    origoutp = cmdout;
    origswout = swout;

    while (*inp && (isspace(*inp))) {
	inp++;
	}

    while (*inp) {

	if (isspace(*inp) && (inp != originp) && (*(inp-1) == ' ')) { 
	    inp++; continue;
	    }

	if (*inp == '"') {
	    do {
		if (inswitch) *swout++ = *inp++;
		else *cmdout++ = *inp++;
		} while (*inp && (*inp != '"'));

	    if (*inp) {
		if (inswitch) *swout++ = *inp++;
		else *cmdout++ = *inp++;
		}
	    continue;
	    }

	if (!inswitch) {
	    if (*inp == '/') inswitch = TRUE;
	    }
	else {
	    if (isspace(*inp)) inswitch = FALSE;
	    }

	if (inswitch) {
	    *swout++ = *inp++;
	    }
	else {
	    if ((cmdout != origoutp) && (*(cmdout-1) == ' ') 
		&& isspace(*inp)) {
		inp++;
		continue;
		}
	    *cmdout++ = *inp++;
	    }
	}

    *swout = '\0';
    *cmdout = '\0';         
}

char *getrawargs(void)
{
    char *x;

    x = oldline;
    if (!x) return NULL;

    while (*x && isspace(*x)) x++;
    while (*x && !isspace(*x)) x++;         /* skip first part of command */
    while (*x && isspace(*x)) x++;          /* skip blanks before args */
                
    return x;
}


int swparse(char *line,PARSESET *pset,char **errorptr)
{
    int item;

    number = 0;

    if (errorptr) *errorptr = errormsg;

    numswitches = 0;
    oldline = line;
    curpset = pset;

    removeswitch(line,outarg,outsw);

#ifdef TESTPROG
    printf("Commands: %s\n",outarg);
    printf("Switches: %s\n",outsw);
#endif

    if (isalldigits(outarg)) {
	number = atoi(outarg);
	if (pset->objects[0].value == -2) {
	    getswitches(pset,&(pset->objects[0]),outsw);
	    }
	return -2;                      /* numbers */
	}

    if (strlen(outarg) == 0) {
	return -3;
	}

    item = lookupcmd(pset,outarg);

    if (item < 0) return item;

    if (!getswitches(pset,&(pset->objects[item]),outsw)) return -1;

    return item;
}


int switchset(int swnum)
{
    int i;

    for (i=0; i<numswitches; i++) {
	if (swresult[i].swnum == swnum) return TRUE;
	}

    return FALSE;
}


int swgetnumber(void)
{
    return number;
}

int swgetnumswitchset(void)
{
    return numswitches;
}

char *getswitch(int swnum,char *prompt)
{
    int i;
    char *tmp;

    for (i=0; i<numswitches; i++) {
	if (swresult[i].swnum == swnum) break;
	}

    if (i >= numswitches) return NULL;
    if (swresult[i].value) return swresult[i].value;
    if (!prompt) return NULL;

    printf("%s",prompt);
    fgets(promptline,sizeof(promptline),stdin);
    if (tmp = strchr(promptline,'\n')) *tmp = '\0';
    return promptline;
}

int setswitch(int swnum,char *value)
{
    int i;

    for (i=0; i<numswitches; i++) {
	if (swresult[i].swnum == swnum) {
	    swresult[i].value = value;
	    return TRUE;
	    }
	}

    if (i < MAXSWITCH) {
	swresult[i].swnum = swnum;
	swresult[i].value = value;
	numswitches++;
	return TRUE;
	}
    return FALSE;
}

char *getarg(int swnum,char *prompt)
{
    int i;
    char *tmp;

    if (argresult[swnum].value) return argresult[swnum].value;

    if (!prompt) return NULL;

    printf("%s",prompt);
    fgets(promptline,sizeof(promptline),stdin);
    if (tmp = strchr(promptline,'\n')) *tmp = '\0';
    return promptline;
}

char *getargd(int swnum,char *prompt,char *deflt)
{
    int i;
    char *tmp;

    if (argresult[swnum].value) return argresult[swnum].value;

    if (!prompt) return NULL;

    printf("%s [%s]:",prompt,deflt);
    fgets(promptline,sizeof(promptline),stdin);
    if (tmp = strchr(promptline,'\n')) *tmp = '\0';
    if (!promptline[0]) strcpy(promptline,deflt);
    return promptline;
}



#ifdef TESTPROG
int main(int argc,char *argv[])
{
    int item;
    char *errortext;
    int res;
    int i;
    extern PARSESET cmdtab;

    for (;;) {
	printf("> "); gets(inline);

	res = swparse(inline,&cmdtab,&errortext);

	if (res == -1) printf("Error: %s\n",errortext);
	else {
	    printf("Command = %d (%s)\n",res,
		   (res >= 0) ? cmdtab.objects[res].def : "unknown");

	    for (i=0; i<10; i++) {
		if (argresult[i].value) printf("Arg[%d] = [%s]\n",i,argresult[i].value);
		}

	    for (i=0; i<numswitches; i++) {
		printf("Switch %d (%s) -> %s\n",
		       swresult[i].swnum,
		       cmdtab.switchtab[swresult[i].swnum].def,
		       swresult[i].value ? swresult[i].value : "no value");
		}
	    }
	}

}
#endif

