/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Simple switch parser			File: SWITCH.C		**
   **									**
   **  this file eats switches off an arg,argv command line		**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>

#ifdef __linux__
#include <string.h>
#define strcmpi strcasecmp
#endif

/******************************************************************************
*
*	DEFINES
*	
******************************************************************************/

#define TRUE   		1
#define FALSE  		0

#define MAXSWITCH	32

/******************************************************************************
*
*	STRUCTURE DEFINITIONS
*	
******************************************************************************/

struct switch_arg {
	int	  type;
	char     *s;
	char 	 *value;
	};

/******************************************************************************
*
*	LOCAL VARIABLES
*	
******************************************************************************/

static int max_sarg = 0;

static struct switch_arg sarg[MAXSWITCH];

static void xtoken();

/******************************************************************************
*
*	SCAN_SWITCH( argc, argv )
*	
******************************************************************************/

int
scan_switch( argc, argv )
int   argc;
char *argv[];
{
    int i, k, l;

    max_sarg = 0;
    for( i = 0 ; i < argc ; ){
	if( (*argv[i] == '-') || (*argv[i] == '/') ){
	    xtoken( max_sarg, argv[i] );
	    for( k = i, l = i + 1 ; l < argc ; k++, l++ ){
		argv[k] = argv[l];
		}
	    max_sarg++;
	    argc--;
	    }
	else{
	    i++;
	    }
	}
    return( argc );
}

/******************************************************************************
*
*	SWITCH_SET( switch )
*	
******************************************************************************/

switch_set( s )
char *s;
{
    int i;

    for( i = 0 ; i < max_sarg ; i++ ){
	if( !strcmpi( s, sarg[i].s ) ){
	    return( TRUE );
	    }
	}
    return( FALSE );
}

/******************************************************************************
*
*	SWITCH_VALUE
*	
******************************************************************************/

switch_value( s, pval )
char *s;
char **pval;
{
    int i;

    for( i = 0 ; i < max_sarg ; i++ ){
	if( !strcmpi( s, sarg[i].s )  && sarg[i].type ){
	    *pval = sarg[i].value;
	    return( TRUE );
	    }
	}
    return( FALSE );
}

/******************************************************************************
*
*	XTOKEN
*	
******************************************************************************/

static
void
xtoken( num, string )
int num;
char *string;
{
    char *rest, *strtok();
    long strtol();

    sarg[num].s = strtok( string+1, "=" );
    rest = strtok( NULL, "=" );
  
    if( rest != NULL ){
	sarg[num].type  = TRUE;
	sarg[num].value = rest;
	}    
    else
	sarg[num].type = FALSE;
}
